/*
 * Decompiled with CFR 0.152.
 */
package org.uqbar.xtrest.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JSONUtils {
    private final ObjectMapper mapper = (ObjectMapper)ObjectExtensions.operator_doubleArrow((Object)new ObjectMapper(), (Procedures.Procedure1)new Procedures.Procedure1<ObjectMapper>(){

        public void apply(ObjectMapper it) {
            it.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            it.configure(SerializationFeature.INDENT_OUTPUT, true);
        }
    });

    public String toJson(Object obj) {
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public <T> T fromJson(String json, Class<T> expectedType) {
        try {
            return (T)this.mapper.readValue(json, expectedType);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Map<String, String> getProperties(String json) {
        try {
            return (Map)this.mapper.readValue(json, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String getPropertyValue(String json, String property) {
        Map<String, String> _properties = this.getProperties(json);
        return _properties.get(property);
    }

    public Integer getPropertyAsInteger(String json, String property) {
        Integer _xblockexpression = null;
        Integer result = null;
        try {
            Integer _integer;
            String _propertyValue = this.getPropertyValue(json, property);
            result = _integer = new Integer(_propertyValue);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException numberFormatException = (NumberFormatException)_t;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public BigDecimal getPropertyAsDecimal(String json, String property) {
        BigDecimal _xblockexpression = null;
        BigDecimal result = null;
        try {
            BigDecimal _bigDecimal;
            String _propertyValue = this.getPropertyValue(json, property);
            result = _bigDecimal = new BigDecimal(_propertyValue);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException numberFormatException = (NumberFormatException)_t;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public LocalDate getPropertyAsDate(String json, String property) {
        return this.getPropertyAsDate(json, property, "dd/MM/yyyy");
    }

    public LocalDate getPropertyAsDate(String json, String property, String dateFormat) {
        LocalDate _xblockexpression = null;
        LocalDate result = null;
        try {
            LocalDate _parse;
            String _propertyValue = this.getPropertyValue(json, property);
            DateTimeFormatter _ofPattern = DateTimeFormatter.ofPattern(dateFormat);
            result = _parse = LocalDate.parse(_propertyValue, _ofPattern);
        }
        catch (Throwable _t) {
            if (_t instanceof DateTimeParseException) {
                DateTimeParseException dateTimeParseException = (DateTimeParseException)_t;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }
}

