/*
 * Decompiled with CFR 0.152.
 */
package org.uqbar.xtrest.result;

import com.google.common.base.Objects;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.uqbar.xtrest.api.Result;
import org.uqbar.xtrest.api.XTRest;
import org.uqbar.xtrest.result.ResultCombinators;

public abstract class ResultFactory
extends AbstractHandler {
    public static Result ok() {
        Procedures.Procedure1<HttpServletResponse> _function = new Procedures.Procedure1<HttpServletResponse>(){

            public void apply(HttpServletResponse it) {
                it.setStatus(200);
            }
        };
        return ResultCombinators.result((Procedures.Procedure1<? super HttpServletResponse>)_function);
    }

    public static Result ok(String content) {
        Result _ok = ResultFactory.ok();
        Result _body = ResultFactory.body(content);
        return ResultCombinators.operator_doubleGreaterThan(_ok, _body);
    }

    public static Result badRequest() {
        Procedures.Procedure1<HttpServletResponse> _function = new Procedures.Procedure1<HttpServletResponse>(){

            public void apply(HttpServletResponse it) {
                it.setStatus(400);
            }
        };
        return ResultCombinators.result((Procedures.Procedure1<? super HttpServletResponse>)_function);
    }

    public static Result badRequest(String content) {
        Result _badRequest = ResultFactory.badRequest();
        Result _body = ResultFactory.body(content);
        return ResultCombinators.operator_doubleGreaterThan(_badRequest, _body);
    }

    public static Result forbidden() {
        Procedures.Procedure1<HttpServletResponse> _function = new Procedures.Procedure1<HttpServletResponse>(){

            public void apply(HttpServletResponse it) {
                it.setStatus(403);
            }
        };
        return ResultCombinators.result((Procedures.Procedure1<? super HttpServletResponse>)_function);
    }

    public static Result forbidden(String content) {
        Result _forbidden = ResultFactory.forbidden();
        Result _body = ResultFactory.body(content);
        return ResultCombinators.operator_doubleGreaterThan(_forbidden, _body);
    }

    public static Result notFound() {
        Procedures.Procedure1<HttpServletResponse> _function = new Procedures.Procedure1<HttpServletResponse>(){

            public void apply(HttpServletResponse it) {
                it.setStatus(404);
            }
        };
        return ResultCombinators.result((Procedures.Procedure1<? super HttpServletResponse>)_function);
    }

    public static Result notFound(String content) {
        Result _notFound = ResultFactory.notFound();
        Result _body = ResultFactory.body(content);
        return ResultCombinators.operator_doubleGreaterThan(_notFound, _body);
    }

    public static Result internalServerError() {
        Procedures.Procedure1<HttpServletResponse> _function = new Procedures.Procedure1<HttpServletResponse>(){

            public void apply(HttpServletResponse it) {
                it.setStatus(500);
            }
        };
        return ResultCombinators.result((Procedures.Procedure1<? super HttpServletResponse>)_function);
    }

    public static Result internalServerError(final String content) {
        Result _internalServerError = ResultFactory.internalServerError();
        Result _function = new Result(){

            @Override
            public void process(HttpServletResponse it) {
                try {
                    PrintWriter _writer = it.getWriter();
                    _writer.write(content);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return ResultCombinators.operator_doubleGreaterThan(_internalServerError, _function);
    }

    public static Result body(final String content) {
        Procedures.Procedure1<HttpServletResponse> _function = new Procedures.Procedure1<HttpServletResponse>(){

            public void apply(HttpServletResponse it) {
                try {
                    PrintWriter _writer = it.getWriter();
                    _writer.write(content);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return ResultCombinators.result((Procedures.Procedure1<? super HttpServletResponse>)_function);
    }

    public static Result header(final String name, final String value) {
        Procedures.Procedure1<HttpServletResponse> _function = new Procedures.Procedure1<HttpServletResponse>(){

            public void apply(HttpServletResponse it) {
                it.setHeader(name, value);
            }
        };
        return ResultCombinators.result((Procedures.Procedure1<? super HttpServletResponse>)_function);
    }

    public static Result render(final String templatePath, final Object data) {
        Result _ok = ResultFactory.ok();
        Result _function = new Result(){

            @Override
            public void process(HttpServletResponse response) {
                try {
                    String _resourcePath = XTRest.getResourcePath();
                    String _plus = _resourcePath + "/";
                    String _plus_1 = _plus + templatePath;
                    Resource _newResource = Resource.newResource((String)_plus_1);
                    ReadableByteChannel reader = _newResource.getReadableByteChannel();
                    Mustache.Compiler _compiler = Mustache.compiler();
                    Reader _newReader = Channels.newReader(reader, "UTF-8");
                    Template template = _compiler.compile(_newReader);
                    PrintWriter _writer = response.getWriter();
                    template.execute(data, (Writer)_writer);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return ResultCombinators.operator_doubleGreaterThan(_ok, _function);
    }

    public String readBodyAsString(HttpServletRequest request) {
        try {
            String _xblockexpression = null;
            StringBuilder buffer = new StringBuilder();
            BufferedReader reader = request.getReader();
            String line = reader.readLine();
            while (!Objects.equal((Object)line, null)) {
                String _readLine;
                buffer.append(line);
                line = _readLine = reader.readLine();
            }
            _xblockexpression = buffer.toString();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

