/*
 * Decompiled with CFR 0.152.
 */
package org.v2u.stupidql;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StupidQL {
    public static final String IGNORE = "*IGNORE";
    public static final String FIELDS = "*FIELDS";
    private static final Pattern FORMAT_PH_PATTERN = Pattern.compile("([#@]?)\\{([^}]+?)}");
    private static final Pattern INT_PATTERN = Pattern.compile("^\\d+$");
    private static final Pattern ABBR_TO_WORD = Pattern.compile("([A-Z]+)([A-Z][a-z])");
    private static final Pattern CAMEL_TO_SNAKE = Pattern.compile("([a-z\\d])([A-Z])");
    private static final Map<Class<?>, Map<String, Info>> CLASS_INFO_CACHE = new ConcurrentHashMap();
    private static final Logger log = LoggerFactory.getLogger(StupidQL.class);
    protected final List<String> queryParts = new ArrayList<String>();
    protected final List<List<Object>> bindValues = new ArrayList<List<Object>>();
    protected Object[][] batchBindValues = null;
    protected final Map<String, Integer> marks = new HashMap<String, Integer>();
    protected Connection txConn = null;
    protected Function<String, String> quoter = StupidQL.makeQuoter("`");
    private Function<String, String> namingStrategy = StupidQL::toSnake;
    protected QueryRunner runner;

    public static StupidQL init(DataSource ds) {
        return new StupidQL(ds);
    }

    protected StupidQL init(Connection conn) {
        StupidQL stupidQL = this.copy();
        stupidQL.runner = new QueryRunner();
        stupidQL.txConn = conn;
        return stupidQL;
    }

    protected StupidQL(DataSource ds) {
        this.runner = new QueryRunner(ds);
    }

    public String getSql() {
        return String.join((CharSequence)" ", this.queryParts);
    }

    public Object[] getParams() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (List<Object> vals : this.bindValues) {
            result.addAll(vals);
        }
        return result.toArray();
    }

    public StupidQL reset() {
        StupidQL stupidQL = this.copy();
        stupidQL.queryParts.clear();
        stupidQL.bindValues.clear();
        stupidQL.marks.clear();
        stupidQL.batchBindValues = null;
        return stupidQL;
    }

    public Connection getTxConn() {
        if (this.txConn == null) {
            throw new StupidException("Not in a transaction context");
        }
        return this.txConn;
    }

    protected Connection selectConn() throws SQLException {
        if (this.txConn != null) {
            return this.txConn;
        }
        if (this.runner.getDataSource() != null) {
            return this.runner.getDataSource().getConnection();
        }
        throw new StupidException("Unable to obtain database connection");
    }

    private <T> T execute(ConnectionCallback<T> action) {
        Connection conn = null;
        try {
            conn = this.selectConn();
            T t = action.execWithConn(conn);
            return t;
        }
        catch (SQLException cause) {
            throw new StupidException(cause);
        }
        finally {
            if (conn != null && conn != this.txConn) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    log.warn("Failed to close connection: {}", (Object)ex.getMessage());
                }
            }
        }
    }

    public <T> T fetch(ResultSetHandler<T> rst) {
        this.debug();
        return (T)this.execute(conn -> this.runner.query(conn, this.getSql(), rst, this.getParams()));
    }

    public <T> List<T> fetchBeans(Class<T> beanType) {
        BasicRowProcessor rowProcessor = new BasicRowProcessor((BeanProcessor)new StupidBeanProcessor(beanType));
        BeanListHandler handler = new BeanListHandler(beanType, (RowProcessor)rowProcessor);
        return (List)this.fetch((ResultSetHandler<T>)handler);
    }

    public <T> T fetchBean(Class<T> beanType) {
        List<T> result = this.fetchBeans(beanType);
        if (result.size() > 1) {
            String error = String.format("Non-unique result: query returned %d rows when expecting exactly one row", result.size());
            throw new StupidException(error);
        }
        return result.isEmpty() ? null : (T)result.get(0);
    }

    public <K, V> Map<K, V> fetchBeanMap(Class<V> type, Function<V, K> keyExtractor) {
        return this.fetchBeans(type).stream().collect(Collectors.toMap(keyExtractor, v -> v, (a, b) -> {
            throw new StupidException("duplicate key in map: " + keyExtractor.apply(a));
        }));
    }

    public <K, V> Map<K, List<V>> fetchBeanGroup(Class<V> type, Function<V, K> keyExtractor) {
        return this.fetchBeans(type).stream().collect(Collectors.groupingBy(keyExtractor));
    }

    public List<Map<String, Object>> fetchMaps() {
        MapListHandler handler = new MapListHandler();
        return (List)this.fetch((ResultSetHandler)handler);
    }

    public Map<String, Object> fetchMap() {
        MapHandler handler = new MapHandler();
        return (Map)this.fetch((ResultSetHandler)handler);
    }

    public <T> T fetchScalar(Class<T> retType) {
        ScalarHandler handler = new ScalarHandler();
        return this.fetch((ResultSetHandler<T>)handler);
    }

    public StupidQL select(String table, String where, Object ... v) {
        return this.select(table).add("where " + where, v);
    }

    public StupidQL select(String table) {
        return this.addRaw("select", new Object[0]).mark(FIELDS, "*", new Object[0]).addRaw("from " + this.quote(table), new Object[0]);
    }

    public StupidQL fields(String ... fields) {
        if (!this.marks.containsKey(FIELDS)) {
            throw new StupidException("no fields mark!");
        }
        return this.mark(FIELDS, String.join((CharSequence)", ", fields), new Object[0]);
    }

    public int update() {
        this.debug();
        return this.execute(conn -> this.runner.update(conn, this.getSql(), this.getParams()));
    }

    public int update(Object bean, String where, Object ... v) {
        return this.update(this.getTableName(bean), bean, where, v);
    }

    public int update(String table, Object bean, String where, Object ... v) {
        Map<String, Object> params = this.beanToColumnMap(bean, true, false);
        AbstractMap.SimpleEntry<List<String>, List<Object>> kv = this.pair(params);
        String fields = kv.getKey().stream().map(k -> String.format("%s = ?", k)).collect(Collectors.joining(", "));
        String sql = String.format("update %s set %s", this.quote(table), fields);
        return this.addRaw(sql, kv.getValue().toArray()).add("where " + where, v).update();
    }

    public int delete() {
        return this.update();
    }

    public int delete(String table, String where, Object ... v) {
        return this.addRaw("delete from " + this.quote(table), new Object[0]).add("where " + where, v).delete();
    }

    public <T> T insert(Class<T> pkType) {
        this.debug();
        return (T)this.execute(conn -> this.runner.insert(conn, this.getSql(), (ResultSetHandler)new ScalarHandler(), this.getParams()));
    }

    public Long insert() {
        Number pk = this.insert(Number.class);
        return pk == null ? null : Long.valueOf(pk.longValue());
    }

    public Long insert(Object bean) {
        return this.addInsert(bean).insert();
    }

    public Long insert(String table, Object bean) {
        return this.addInsert(table, bean).insert();
    }

    public StupidQL addInsert(Object bean) {
        return this.addInsert(this.getTableName(bean), bean);
    }

    public StupidQL addInsert(String table, Object bean) {
        Map<String, Object> params = this.beanToColumnMap(bean, false, true);
        AbstractMap.SimpleEntry<List<String>, List<Object>> kv = this.pair(params);
        String fields = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)kv.getKey());
        String sql = String.format("into %s (%s) values (?)", this.quote(table), fields);
        return this.addRaw("insert", new Object[0]).mark(IGNORE, "", new Object[0]).addRaw(sql, kv.getValue());
    }

    public StupidQL addInsertBatch(List<?> batch) {
        if (batch == null || batch.isEmpty()) {
            throw new StupidException("Batch params empty");
        }
        return this.addInsertBatch(this.getTableName(batch.get(0)), batch);
    }

    public StupidQL addInsertBatch(String table, List<?> batch) {
        if (table == null || table.trim().isEmpty()) {
            throw new StupidException("table name required");
        }
        if (batch == null || batch.isEmpty()) {
            throw new StupidException("Batch params empty");
        }
        StupidQL query = this.reset();
        ArrayList rows = new ArrayList();
        batch.forEach(it -> rows.add(this.beanToColumnMap(it, false, true)));
        ArrayList keys = new ArrayList(((Map)rows.get(0)).keySet());
        String fieldStr = keys.stream().map(this::quote).collect(Collectors.joining(", "));
        String placeholders = String.join((CharSequence)", ", Collections.nCopies(keys.size(), "?"));
        String sql = String.format("into %s (%s) values (%s)", this.quote(table), fieldStr, placeholders);
        query = query.addRaw("insert", new Object[0]).mark(IGNORE, "", new Object[0]);
        query.appendSqlAndArgs(sql, new ArrayList<Object>());
        Object[][] batchArgs = new Object[rows.size()][keys.size()];
        for (int i = 0; i < rows.size(); ++i) {
            Map params = (Map)rows.get(i);
            for (int j = 0; j < keys.size(); ++j) {
                batchArgs[i][j] = params.get(keys.get(j));
            }
        }
        query.batchBindValues = batchArgs;
        return query;
    }

    public <R> List<R> insertBatch(Class<R> pkType) {
        if (this.batchBindValues == null) {
            throw new StupidException("not a batch operation");
        }
        this.debug();
        return this.execute(conn -> (List)this.runner.insertBatch(conn, this.getSql(), (ResultSetHandler)new ColumnListHandler(), this.batchBindValues));
    }

    public List<Long> insertBatch() {
        return this.insertBatch(Number.class).stream().map(Number::longValue).collect(Collectors.toList());
    }

    public <R> R transaction(Function<StupidQL, R> action) {
        if (this.txConn != null) {
            throw new StupidException("Nested transactions are not allowed");
        }
        Connection conn = null;
        Boolean isAutoCommit = null;
        Integer isolationLevel = null;
        try {
            conn = this.runner.getDataSource().getConnection();
            isAutoCommit = conn.getAutoCommit();
            isolationLevel = conn.getTransactionIsolation();
            conn.setAutoCommit(false);
            StupidQL tx = this.init(conn);
            R result = action.apply(tx);
            conn.commit();
            R r = result;
            return r;
        }
        catch (Throwable e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new StupidException("Failed to rollback transaction", ex);
            }
            throw new StupidException("Transaction failed", e);
        }
        finally {
            try {
                if (conn != null) {
                    if (isAutoCommit != null) {
                        conn.setAutoCommit(isAutoCommit);
                    }
                    if (isolationLevel != null) {
                        conn.setTransactionIsolation(isolationLevel);
                    }
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.warn("Failed to close connection", (Throwable)e);
            }
        }
    }

    public String getTableName(Object bean) {
        Class<?> beanClass = bean.getClass();
        Info info = beanClass.getAnnotation(Info.class);
        if (info == null) {
            return this.namingStrategy.apply(beanClass.getSimpleName());
        }
        return info.name();
    }

    protected StupidQL copy() {
        StupidQL query = new StupidQL(this.runner.getDataSource());
        query.txConn = this.txConn;
        query.queryParts.addAll(this.queryParts);
        query.bindValues.addAll(this.bindValues);
        query.marks.putAll(this.marks);
        query.quoter = this.quoter;
        query.batchBindValues = this.batchBindValues;
        return query;
    }

    public StupidQL setQuoter(Function<String, String> quoter) {
        StupidQL query = this.copy();
        query.quoter = quoter;
        return query;
    }

    public static Function<String, String> makeQuoter(String quote) {
        return identifier -> {
            if (identifier == null) {
                throw new StupidException("Identifier cannot be null");
            }
            if (identifier.trim().isEmpty()) {
                throw new StupidException("Identifier cannot be empty");
            }
            return Arrays.stream(identifier.split("\\.")).map(part -> quote + part.replace(quote, quote + quote) + quote).collect(Collectors.joining("."));
        };
    }

    public String quote(String identity) {
        return this.quoter.apply(identity);
    }

    public StupidQL add(boolean yes, String tpl, Object ... v) {
        if (yes) {
            return this.add(tpl, v);
        }
        return this;
    }

    public AbstractMap.SimpleEntry<String, List<Object>> parseText(String tpl, Object ... v) {
        Matcher m = FORMAT_PH_PATTERN.matcher(tpl);
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        AtomicReference<Object> namedArgs = new AtomicReference<Object>(null);
        Runnable namedArgsInit = () -> {
            if (namedArgs.get() != null) {
                return;
            }
            if (v.length <= 0) {
                throw new IllegalArgumentException("Named argument required at latest position");
            }
            Object arg = v[v.length - 1];
            namedArgs.set(StupidQL.beanToMap(arg));
        };
        boolean find = false;
        while (m.find()) {
            String identity;
            Object arg;
            find = true;
            String key = m.group(2).trim();
            if (INT_PATTERN.matcher(key).find()) {
                int idx = Integer.parseInt(key);
                if (idx < 1 || idx > v.length) {
                    throw new IllegalArgumentException("Index " + idx + " out of range");
                }
                arg = v[idx - 1];
            } else {
                namedArgsInit.run();
                if (!((Map)namedArgs.get()).containsKey(key)) {
                    throw new IllegalArgumentException("Named argument '" + key + "' not found");
                }
                arg = ((Map)namedArgs.get()).get(key);
            }
            switch (identity = m.group(1)) {
                case "": {
                    if (arg == null) {
                        throw new IllegalArgumentException("null not allowed: " + key);
                    }
                    m.appendReplacement(sb, Matcher.quoteReplacement(arg.toString()));
                    break;
                }
                case "@": {
                    if (arg == null) {
                        throw new IllegalArgumentException("null not allowed: " + key);
                    }
                    m.appendReplacement(sb, Matcher.quoteReplacement(this.quote(arg.toString())));
                    break;
                }
                case "#": {
                    sqlParams.add(arg);
                    m.appendReplacement(sb, "?");
                }
            }
        }
        m.appendTail(sb);
        if (!find) {
            return new AbstractMap.SimpleEntry<String, List<Object>>(sb.toString(), Arrays.asList(v));
        }
        return new AbstractMap.SimpleEntry<String, List<Object>>(sb.toString(), sqlParams);
    }

    public StupidQL add(String tpl, Object ... v) {
        AbstractMap.SimpleEntry<String, List<Object>> parsed = this.parseText(tpl, v);
        return this.addRaw(parsed.getKey(), parsed.getValue().toArray());
    }

    public StupidQL addRaw(boolean yes, String sql, Object ... v) {
        if (yes) {
            return this.addRaw(sql, v);
        }
        return this;
    }

    public StupidQL addRaw(String sql, Object ... v) {
        StupidQL query = this.copy();
        query.appendParams(sql, v);
        return query;
    }

    public StupidQL namingStrategy(Function<String, String> fn) {
        StupidQL query = this.copy();
        query.namingStrategy = fn;
        return query;
    }

    public StupidQL mark(String name, String sql, Object ... v) {
        StupidQL query = this.copy();
        AbstractMap.SimpleEntry<String, List<Object>> parsed = this.parseText(sql, v);
        if (query.marks.containsKey(name)) {
            Integer idx = query.marks.get(name);
            query.queryParts.set(idx, parsed.getKey());
            query.bindValues.set(idx, parsed.getValue());
        } else {
            query.appendSqlAndArgs(sql, parsed.getValue());
            query.marks.put(name, query.queryParts.size() - 1);
        }
        return query;
    }

    protected void appendParams(String sql, Object[] args) {
        String[] parts = (sql + " ").split("\\?");
        if (parts.length != args.length + 1) {
            String msg = String.format("Placeholders length (%d) doesn't match parameters length (%d)", parts.length - 1, args.length);
            throw new StupidException(msg);
        }
        ArrayList<String> localParts = new ArrayList<String>();
        ArrayList<Object> localArgs = new ArrayList<Object>();
        for (int i = 0; i < parts.length; ++i) {
            List<Object> listArgs;
            if (args.length <= i) {
                localParts.add(parts[i]);
                continue;
            }
            Object arg = args[i];
            if (arg == null) {
                localParts.add(parts[i] + '?');
                localArgs.add(null);
                continue;
            }
            if (arg instanceof Collection) {
                listArgs = (List<Object>)arg;
                localParts.add(parts[i] + this.makeArrayPlaceHolders(listArgs.size()));
                localArgs.addAll(listArgs);
                continue;
            }
            if (arg.getClass().isArray()) {
                listArgs = Arrays.asList((Object[])arg);
                localParts.add(parts[i] + this.makeArrayPlaceHolders(listArgs.size()));
                localArgs.addAll(listArgs);
                continue;
            }
            localParts.add(parts[i] + '?');
            localArgs.add(arg);
        }
        this.appendSqlAndArgs(String.join((CharSequence)" ", localParts), localArgs);
    }

    protected void appendSqlAndArgs(String sql, List<Object> args) {
        this.queryParts.add(sql);
        this.bindValues.add(args);
    }

    public String makeArrayPlaceHolders(int len) {
        StringBuilder marks = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                marks.append(',');
            }
            marks.append('?');
        }
        return marks.toString();
    }

    protected void debug() {
        if (log.isDebugEnabled()) {
            log.debug(this.toString());
        }
    }

    public String toString() {
        String sql = this.getSql().replaceAll("(#|--)[^\\n]*", "").replace("\n", " ").trim();
        return "SQL: " + sql + " #" + Arrays.toString(this.getParams());
    }

    public static String toSnake(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String s = ABBR_TO_WORD.matcher(input).replaceAll("$1_$2");
        s = CAMEL_TO_SNAKE.matcher(s).replaceAll("$1_$2");
        return s.toLowerCase();
    }

    public static Map<String, Object> mapOf(Object ... v) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (v.length % 2 != 0) {
            throw new IllegalArgumentException("argument length must be even");
        }
        for (int i = 0; i < v.length; i += 2) {
            String prefix = v[i].toString();
            result.put(prefix, v[i + 1]);
            Map<String, Object> temp = StupidQL.beanToMap(v[i + 1]);
            if (temp.isEmpty()) continue;
            for (Map.Entry<String, Object> kv : temp.entrySet()) {
                result.put(prefix + "." + kv.getKey(), kv.getValue());
            }
        }
        return result;
    }

    public static Map<String, Object> beanToMap(Object bean) {
        if (bean instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            ((Map)bean).forEach((k, v) -> result.put(k.toString(), v));
            return result;
        }
        try {
            PropertyDescriptor[] props;
            HashMap<String, Object> result = new HashMap<String, Object>();
            Class<?> clazz = bean.getClass();
            for (PropertyDescriptor pd : props = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                int modifiers;
                Method getter = pd.getReadMethod();
                if (getter == null || getter.getDeclaringClass().getName().startsWith("java.") || !Modifier.isPublic(modifiers = getter.getModifiers()) || Modifier.isStatic(modifiers)) continue;
                result.put(pd.getName(), getter.invoke(bean, new Object[0]));
            }
            return result;
        }
        catch (Exception ex) {
            throw new StupidException(ex);
        }
    }

    protected Map<String, Object> beanToColumnMap(Object bean, boolean isUpdate, boolean isInsert) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (bean instanceof Map) {
            ((Map)bean).forEach((k, v) -> {
                if (v != null) {
                    result.put(this.namingStrategy.apply(k.toString()), v);
                }
            });
            return result;
        }
        Map<String, Object> source = StupidQL.beanToMap(bean);
        Map<String, Info> infoMap = StupidQL.getCachedClassInfo(bean.getClass());
        for (Map.Entry<String, Info> kv : infoMap.entrySet()) {
            boolean ignoreNull = true;
            String fieldName = kv.getKey();
            String columnName = this.namingStrategy.apply(fieldName);
            Info info = kv.getValue();
            if (info != null) {
                if (!info.exists() || isUpdate && !info.update() || isInsert && !info.insert()) continue;
                ignoreNull = info.ignoreNull();
                String annoColumnName = info.name();
                if (annoColumnName != null && !annoColumnName.trim().isEmpty()) {
                    columnName = annoColumnName;
                }
            }
            Object fieldValue = source.get(fieldName);
            if (ignoreNull && fieldValue == null) continue;
            result.put(columnName, fieldValue);
        }
        return result;
    }

    public AbstractMap.SimpleEntry<List<String>, List<Object>> pair(Map<String, Object> data) {
        ArrayList<String> keys = new ArrayList<String>(data.size());
        ArrayList<Object> values = new ArrayList<Object>(data.size());
        int index = 0;
        for (Map.Entry<String, Object> kv : data.entrySet()) {
            String key = this.quote(kv.getKey());
            keys.add(index, key);
            values.add(index, kv.getValue());
            ++index;
        }
        return new AbstractMap.SimpleEntry<List<String>, List<Object>>(keys, values);
    }

    public static Map<String, Info> getCachedClassInfo(Class<?> type) {
        return CLASS_INFO_CACHE.computeIfAbsent(type, t -> {
            Class superClass = type.getSuperclass();
            HashMap<String, Info> fieldInfoMap = new HashMap<String, Info>();
            if (superClass != null && !superClass.getName().startsWith("java.")) {
                Map<String, Info> superFieldInfoMap = StupidQL.getCachedClassInfo(superClass);
                fieldInfoMap.putAll(superFieldInfoMap);
            }
            for (Field field : t.getDeclaredFields()) {
                Info info = field.getAnnotation(Info.class);
                fieldInfoMap.put(field.getName(), info);
            }
            return fieldInfoMap;
        });
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Info {
        public String name() default "";

        public boolean exists() default true;

        public boolean update() default true;

        public boolean insert() default true;

        public boolean ignoreNull() default true;
    }

    public static class StupidException
    extends RuntimeException {
        public StupidException(String message) {
            super(message);
        }

        public StupidException(Throwable cause) {
            super(cause);
        }

        public StupidException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class StupidBeanProcessor
    extends BeanProcessor {
        private final Map<String, Info> infoMap;

        public StupidBeanProcessor(Class<?> type) {
            this.infoMap = StupidQL.getCachedClassInfo(type);
        }

        protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
            int cols = rsmd.getColumnCount();
            int[] columnToProperty = new int[cols + 1];
            Arrays.fill(columnToProperty, -1);
            block0: for (int col = 1; col <= cols; ++col) {
                String columnName = rsmd.getColumnLabel(col);
                if (null == columnName || columnName.isEmpty()) {
                    columnName = rsmd.getColumnName(col);
                }
                String generousColumnName = columnName.replace("_", "").replace(" ", "");
                for (int i = 0; i < props.length; ++i) {
                    String propName = props[i].getName();
                    Info info = this.infoMap.get(propName);
                    if (info != null && !info.name().isEmpty()) {
                        propName = info.name();
                    }
                    if (!columnName.equalsIgnoreCase(propName) && !generousColumnName.equalsIgnoreCase(propName)) continue;
                    columnToProperty[col] = i;
                    continue block0;
                }
            }
            return columnToProperty;
        }
    }

    @FunctionalInterface
    static interface ConnectionCallback<T> {
        public T execWithConn(Connection var1) throws SQLException;
    }
}

