/*
 * Decompiled with CFR 0.152.
 */
package org.v2u.toy;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class Doge {
    public static <T extends Exchange> Server<T> create(Function<HttpExchange, T> contextFactory) {
        return new Server<T>(contextFactory);
    }

    public static Server<Exchange> create() {
        return new Server<Exchange>(Exchange::new);
    }

    public static class SseEmitter {
        private final PrintWriter writer;

        public SseEmitter(PrintWriter writer) {
            this.writer = writer;
        }

        public void send(String data) throws IOException {
            if (this.writer.checkError()) {
                throw new IOException("Client disconnected");
            }
            this.writer.println("data: " + data);
            this.writer.println();
            this.writer.flush();
        }

        public void send(String event, String data) throws IOException {
            if (this.writer.checkError()) {
                throw new IOException("Client disconnected");
            }
            this.writer.println("event: " + event);
            this.writer.println("data: " + data);
            this.writer.println();
            this.writer.flush();
        }
    }

    protected static class RouteFilter<T> {
        String pathPrefix;
        BiConsumer<T, Consumer<T>> filter;

        RouteFilter(String pathPrefix, BiConsumer<T, Consumer<T>> filter) {
            this.pathPrefix = pathPrefix;
            this.filter = filter;
        }
    }

    public static class Server<T extends Exchange> {
        private final HttpServer server;
        private final Function<HttpExchange, T> exchangeFactory;
        private BiConsumer<T, Exception> errorHandler = this::defaultErrorHandler;
        private int maxRequestBodySize = 0x200000;
        private final Deque<String> routeStack = new ArrayDeque<String>();
        private final List<RouteFilter<T>> routeFilters = new ArrayList<RouteFilter<T>>();

        public Server(Function<HttpExchange, T> exchangeFactory) {
            try {
                this.server = HttpServer.create();
                this.exchangeFactory = exchangeFactory;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create HttpServer", e);
            }
        }

        public Server<T> start(int port) throws IOException {
            return this.start(port, 0);
        }

        public Server<T> start(int port, int backlog) {
            try {
                this.server.bind(new InetSocketAddress(port), backlog);
                this.server.start();
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException("start server error", e);
            }
        }

        public Server<T> maxRequestBodySize(int size) {
            this.maxRequestBodySize = size;
            return this;
        }

        public Server<T> error(BiConsumer<T, Exception> handler) {
            this.errorHandler = handler;
            return this;
        }

        public Server<T> executor(Executor executor) {
            this.server.setExecutor(executor);
            return this;
        }

        public void stop() {
            this.server.stop(0);
        }

        public void filter(String pathPrefix, BiConsumer<T, Consumer<T>> filter) {
            this.routeFilters.add(new RouteFilter<T>(pathPrefix, filter));
        }

        public HttpContext route(String path, Consumer<T> handler) {
            String fullPath = this.buildFullPath(path);
            return this.server.createContext(fullPath, httpExchange -> {
                try (Exchange exchange = null;){
                    exchange = (Exchange)this.exchangeFactory.apply(httpExchange);
                    exchange.maxRequestBodySize(this.maxRequestBodySize);
                    this.applyFilters(exchange, handler, 0);
                }
            });
        }

        public void group(String path, Runnable groupRoutes) {
            this.routeStack.push(path);
            try {
                groupRoutes.run();
            }
            finally {
                this.routeStack.pop();
            }
        }

        private String buildFullPath(String path) {
            StringBuilder fullPath = new StringBuilder();
            for (String part : this.routeStack) {
                fullPath.insert(0, part);
            }
            fullPath.append(path);
            return fullPath.toString();
        }

        private void applyFilters(T exchange, Consumer<T> handler, int index) {
            if (index < this.routeFilters.size()) {
                RouteFilter<T> routeFilter = this.routeFilters.get(index);
                if (((Exchange)exchange).path().startsWith(routeFilter.pathPrefix)) {
                    routeFilter.filter.accept(exchange, ex -> this.applyFilters(ex, handler, index + 1));
                } else {
                    this.applyFilters(exchange, handler, index + 1);
                }
            } else {
                handler.accept(exchange);
            }
        }

        private void defaultErrorHandler(T ctx, Exception e) {
            String message;
            int status;
            if (e instanceof IllegalArgumentException) {
                status = 400;
                message = "Bad Request";
            } else if (e instanceof SecurityException) {
                status = 403;
                message = "Forbidden";
            } else if (e instanceof FileNotFoundException) {
                status = 404;
                message = "Not Found";
            } else if (e instanceof UnsupportedOperationException) {
                status = 501;
                message = "Not Implemented";
            } else if (e instanceof IOException) {
                status = 503;
                message = "Service Unavailable";
            } else {
                status = 500;
                message = "Internal Server Error";
                e.printStackTrace();
            }
            message = message + ": " + e.getMessage();
            ((Exchange)ctx).status(status).result(message);
        }
    }

    public static class Exchange {
        public final HttpExchange inner;
        protected final Map<String, Object> attributes = new HashMap<String, Object>();
        protected int statusCode = 200;
        protected int maxRequestBodySize = Integer.MAX_VALUE;
        protected byte[] cachedBody;
        protected Map<String, String> cachedQueryParams;
        protected static final int DEFAULT_BUFFER_SIZE = 8192;
        private boolean headersSent = false;
        private boolean closed = false;

        public Exchange(HttpExchange inner) {
            this.inner = inner;
        }

        public String path() {
            return this.inner.getRequestURI().getPath();
        }

        public String method() {
            return this.inner.getRequestMethod();
        }

        public Headers headers() {
            return this.inner.getRequestHeaders();
        }

        public void json(Object obj) {
            throw new UnsupportedOperationException("JSON serialization not implemented");
        }

        public Exchange status(int code) {
            this.statusCode = code;
            return this;
        }

        public Exchange contentType(String type) {
            this.inner.getResponseHeaders().set("Content-Type", type);
            return this;
        }

        public void download(File file, String filename) {
            if (!file.exists() || !file.isFile()) {
                this.status(404).result("File not found");
                return;
            }
            this.contentType("application/octet-stream").header("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            try {
                byte[] data = Files.readAllBytes(file.toPath());
                this.result(data);
            }
            catch (IOException e) {
                throw new RuntimeException("File read failed", e);
            }
        }

        public void redirect(String location) {
            this.status(302).header("Location", location).result("");
        }

        public Exchange attr(String name, Object value) {
            this.attributes.put(name, value);
            return this;
        }

        public <T> T attr(String name) {
            return (T)this.attributes.get(name);
        }

        public <T> T attr(String name, Class<T> type) {
            T value = this.attr(name);
            if (value == null) {
                throw new IllegalStateException(type.getSimpleName() + " not found in context");
            }
            return value;
        }

        public void sse(Consumer<SseEmitter> handler) {
            this.contentType("text/event-stream").header("Cache-Control", "no-cache").header("Connection", "keep-alive");
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.inner.getResponseBody()));){
                SseEmitter emitter = new SseEmitter(writer);
                this.inner.sendResponseHeaders(200, 0L);
                handler.accept(emitter);
            }
            catch (IOException e) {
                throw new RuntimeException("SSE failed", e);
            }
        }

        public void close() {
            if (this.closed) {
                return;
            }
            try {
                this.inner.close();
            }
            finally {
                this.closed = true;
            }
        }

        public static String urlDecode(String str) {
            try {
                return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public Map<String, String> params() {
            if (this.cachedQueryParams != null) {
                return this.cachedQueryParams;
            }
            String query = this.inner.getRequestURI().getQuery();
            this.cachedQueryParams = new LinkedHashMap<String, String>();
            if (query == null || query.trim().equals("")) {
                return this.cachedQueryParams;
            }
            for (String param : query.split("&")) {
                int idx = param.indexOf(61);
                if (idx > 0) {
                    String key = Exchange.urlDecode(param.substring(0, idx));
                    String value = Exchange.urlDecode(param.substring(idx + 1));
                    this.cachedQueryParams.put(key, value);
                    continue;
                }
                if (param.length() <= 0) continue;
                this.cachedQueryParams.put(Exchange.urlDecode(param), "");
            }
            return this.cachedQueryParams;
        }

        public String body() {
            return new String(this.bytes(), StandardCharsets.UTF_8);
        }

        /*
         * Exception decompiling
         */
        public byte[] bytes() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Exchange header(String name, String value) {
            this.inner.getResponseHeaders().set(name, value);
            return this;
        }

        public String header(String name) {
            return this.inner.getRequestHeaders().getFirst(name);
        }

        public Exchange cookie(String name, String value, int maxAge) {
            String cookie = String.format("%s=%s; Max-Age=%d; Path=/", name, value, maxAge);
            this.inner.getResponseHeaders().add("Set-Cookie", cookie);
            return this;
        }

        public String cookie(String name) {
            Object cookies = this.inner.getRequestHeaders().get("Cookie");
            if (cookies != null) {
                Iterator iterator = cookies.iterator();
                while (iterator.hasNext()) {
                    String cookie = (String)iterator.next();
                    for (String pair : cookie.split(";")) {
                        String[] keyValue = pair.trim().split("=");
                        if (keyValue.length != 2 || !keyValue[0].equals(name)) continue;
                        return keyValue[1];
                    }
                }
            }
            return null;
        }

        public void html(String htmlContent) {
            this.contentType("text/html; charset=UTF-8");
            this.result(htmlContent);
        }

        public void staticFile(File root, String path) {
            File file = new File(root, path);
            try {
                if (!file.exists() || !file.isFile()) {
                    this.status(404).result("File not found: " + file);
                    return;
                }
                if (!file.getCanonicalPath().startsWith(root.getCanonicalPath())) {
                    this.status(403).result("Forbidden: " + file);
                    return;
                }
                byte[] fileBytes = Files.readAllBytes(file.toPath());
                String contentType = Files.probeContentType(file.toPath());
                this.contentType(contentType != null ? contentType : "application/octet-stream");
                this.result(fileBytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Read file error: " + file, e);
            }
            finally {
                this.close();
            }
        }

        public void result(Object obj) {
            String response = obj != null ? obj.toString() : "null";
            byte[] responseBytes = response.getBytes(StandardCharsets.UTF_8);
            this.result(responseBytes);
        }

        public void result(byte[] responseBytes) {
            try {
                this.sendHeaders(responseBytes.length);
                this.inner.getResponseBody().write(responseBytes);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to send response", e);
            }
            finally {
                this.close();
            }
        }

        public void result(InputStream inputStream) {
            try {
                int nRead;
                int availableBytes = inputStream.available();
                if (availableBytes > 0) {
                    this.sendHeaders(availableBytes);
                } else {
                    this.inner.getResponseHeaders().set("Transfer-Encoding", "chunked");
                    this.sendHeaders(0L);
                }
                byte[] data = new byte[1024];
                OutputStream os = this.inner.getResponseBody();
                while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                    os.write(data, 0, nRead);
                }
                os.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to send response from InputStream", e);
            }
            finally {
                this.close();
            }
        }

        public Exchange maxRequestBodySize(int size) {
            this.maxRequestBodySize = size;
            return this;
        }

        private void sendHeaders(long length) throws IOException {
            if (this.headersSent) {
                return;
            }
            this.inner.sendResponseHeaders(this.statusCode, length);
            this.headersSent = true;
        }
    }
}

