/*
 * Decompiled with CFR 0.152.
 */
package org.v2u.toy;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.GenerousBeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.BeanMapHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class Duck {
    private static final Logger logger = Logger.getLogger(Duck.class.getName());
    protected final List<String> queryParts = new ArrayList<String>();
    protected final List<Object> bindValues = new ArrayList<Object>();
    protected final Map<String, Integer> marks = new HashMap<String, Integer>();
    protected Connection txConn = null;
    protected Function<String, String> escaper = this.makeEscaper("`");
    protected boolean isSnakeCase = true;
    protected final QueryRunner queryRunner;

    protected Duck(DataSource dataSource) {
        this.queryRunner = new QueryRunner(dataSource);
    }

    protected Duck(Connection conn) {
        this.queryRunner = new QueryRunner();
        this.txConn = conn;
    }

    public static Duck init(DataSource dataSource_) {
        return new Duck(dataSource_);
    }

    public String getSql() {
        return String.join((CharSequence)" ", this.queryParts);
    }

    public Object[] getParams() {
        return this.bindValues.toArray();
    }

    public Duck reset() {
        this.queryParts.clear();
        this.bindValues.clear();
        this.marks.clear();
        return this;
    }

    public Connection getTxConn() {
        if (this.txConn == null) {
            throw new DuckException("Not in a transaction context");
        }
        return this.txConn;
    }

    protected Connection selectConnection() throws SQLException {
        if (this.txConn != null) {
            return this.txConn;
        }
        if (this.queryRunner.getDataSource() != null) {
            return this.queryRunner.getDataSource().getConnection();
        }
        throw new DuckException("Unable to obtain database connection");
    }

    private <T> T executeInConnection(ConnectionCallback<T> action) {
        Connection conn = null;
        try {
            conn = this.selectConnection();
            T t = action.doInConnection(conn);
            return t;
        }
        catch (SQLException cause) {
            throw new DuckException(cause);
        }
        finally {
            if (conn != null && conn != this.txConn) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    logger.warning("Failed to close connection: " + ex.getMessage());
                }
            }
        }
    }

    public <T> T fetch(ResultSetHandler<T> rst) {
        return (T)this.executeInConnection(conn -> this.queryRunner.query(conn, this.getSql(), rst, this.getParams()));
    }

    public <T> List<T> fetchBeanList(Class<T> tClass) {
        BasicRowProcessor rowProcessor = new BasicRowProcessor((BeanProcessor)new GenerousBeanProcessor());
        BeanListHandler handler = new BeanListHandler(tClass, (RowProcessor)rowProcessor);
        return (List)this.fetch((ResultSetHandler<T>)handler);
    }

    public <T> T fetchBean(Class<T> tClass) {
        List<T> result = this.fetchBeanList(tClass);
        if (result.size() > 1) {
            String errmsg = String.format("Non-unique result: query returned %d rows when expecting exactly one row", result.size());
            throw new DuckException(errmsg);
        }
        return result.isEmpty() ? null : (T)result.get(0);
    }

    public <K, V> Map<K, V> fetchBeanMap(String columnName, Class<V> vClass) {
        BeanMapHandler handler = new BeanMapHandler(vClass, columnName);
        return (Map)this.fetch((ResultSetHandler)handler);
    }

    public List<Map<String, Object>> fetchMapList() {
        MapListHandler handler = new MapListHandler();
        return (List)this.fetch((ResultSetHandler)handler);
    }

    public Map<String, Object> fetchMap() {
        MapHandler handler = new MapHandler();
        return (Map)this.fetch((ResultSetHandler)handler);
    }

    public <T> T fetchScalar(Class<T> tClass) {
        ScalarHandler handler = new ScalarHandler();
        return this.fetch((ResultSetHandler<T>)handler);
    }

    public Duck select(String table, String where, Object ... params) {
        return this.add("select", new Object[0]).mark("F", "*").add("from " + this.escape(table), new Object[0]).add("where " + where, params);
    }

    public int update() {
        return this.executeInConnection(conn -> this.queryRunner.update(conn, this.getSql(), this.getParams()));
    }

    public int updateMap(String tableName, Map<String, Object> params, String where, Object ... whereParams) {
        AbstractMap.SimpleEntry<String, Object[]> paramsKv = this.pairUpdate(params);
        String sql = String.format("update %s set %s", this.escape(tableName), paramsKv.getKey());
        return this.add(sql, paramsKv.getValue()).add("where " + where, whereParams).update();
    }

    public int updateBean(String tableName, Object bean, String where, Object ... whereParams) {
        Map<String, Object> params = this.beanToMap(bean, true, false);
        return this.updateMap(tableName, params, where, whereParams);
    }

    public int delete() {
        return this.update();
    }

    public int delete(String tableName, String where, Object ... whereParams) {
        return this.add("delete from " + this.escape(tableName), new Object[0]).add("where " + where, whereParams).delete();
    }

    public <T> T insert(Class<T> tClass) {
        return (T)this.executeInConnection(conn -> this.queryRunner.insert(conn, this.getSql(), (ResultSetHandler)new ScalarHandler(), this.getParams()));
    }

    public BigInteger insert() {
        return this.insert(BigInteger.class);
    }

    public BigInteger insertMap(String tableName, Map<String, Object> params) {
        return this.insertMap(tableName, params, BigInteger.class);
    }

    public <T> T insertMap(String tableName, Map<String, Object> params, Class<T> tClass) {
        AbstractMap.SimpleEntry<String, List<Object>> kv = this.pairInsert(params);
        String sql = String.format("insert into %s (%s) values (?)", this.escape(tableName), kv.getKey());
        return this.add(sql, kv.getValue()).insert(tClass);
    }

    public BigInteger insertBean(String tableName, Object bean) {
        Map<String, Object> params = this.beanToMap(bean, false, true);
        return this.insertMap(tableName, params);
    }

    public <T> List<T> insertBatch(String tableName, List<Map<String, Object>> paramsList, Class<T> tClass) {
        if (paramsList == null || paramsList.isEmpty()) {
            throw new DuckException("Batch params empty");
        }
        Map<String, Object> firstMap = paramsList.get(0);
        ArrayList<String> keys = new ArrayList<String>(firstMap.keySet());
        String fieldStr = keys.stream().map(this::escape).collect(Collectors.joining(", "));
        String placeholders = String.join((CharSequence)", ", Collections.nCopies(keys.size(), "?"));
        String sql = String.format("insert into %s (%s) values (%s)", this.escape(tableName), fieldStr, placeholders);
        Object[][] batchArgs = new Object[paramsList.size()][];
        for (int i = 0; i < paramsList.size(); ++i) {
            Map<String, Object> params = paramsList.get(i);
            Object[] values = new Object[keys.size()];
            for (int j = 0; j < keys.size(); ++j) {
                values[j] = params.get(keys.get(j));
            }
            batchArgs[i] = values;
        }
        return this.executeInConnection(conn -> (List)this.queryRunner.insertBatch(sql, (ResultSetHandler)new ColumnListHandler(), batchArgs));
    }

    public List<BigInteger> insertBatch(String tableName, List<Map<String, Object>> paramsList) {
        return this.insertBatch(tableName, paramsList, BigInteger.class);
    }

    public <R> R transaction(Function<Duck, R> action) {
        if (this.txConn != null) {
            throw new DuckException("Nested transactions are not allowed");
        }
        Connection conn = null;
        try {
            conn = this.queryRunner.getDataSource().getConnection();
            conn.setAutoCommit(false);
            Duck tx = new Duck(conn);
            R result = action.apply(tx);
            conn.commit();
            R r = result;
            return r;
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new DuckException("Failed to rollback transaction", ex);
            }
            throw new DuckException("Transaction failed", e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.setAutoCommit(true);
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.warning("Failed to close connection: " + e.getMessage());
            }
        }
    }

    protected Duck copy() {
        Duck query = new Duck(this.queryRunner.getDataSource());
        query.txConn = this.txConn;
        query.queryParts.addAll(this.queryParts);
        query.bindValues.addAll(this.bindValues);
        query.marks.putAll(this.marks);
        query.escaper = this.escaper;
        query.isSnakeCase = this.isSnakeCase;
        return query;
    }

    public Duck escaper(Function<String, String> escaper_) {
        Duck query = this.copy();
        query.escaper = escaper_;
        return query;
    }

    public Function<String, String> makeEscaper(String quote) {
        return identifier -> {
            if (identifier == null) {
                throw new DuckException("Identifier cannot be null");
            }
            if (identifier.trim().isEmpty()) {
                throw new DuckException("Identifier cannot be empty");
            }
            return Arrays.stream(identifier.split("\\.")).map(part -> quote + part.replace(quote, quote + quote) + quote).collect(Collectors.joining("."));
        };
    }

    public String escape(String ident) {
        return this.escaper.apply(ident);
    }

    public Duck add(String sql, Object ... params) {
        Duck query = this.copy();
        query.appendParams(sql, params);
        return query;
    }

    public Duck snakeCase(boolean yes) {
        Duck duck = this.copy();
        duck.isSnakeCase = yes;
        return duck;
    }

    public Duck mark(String name, String sql) {
        Duck query = this.copy();
        if (query.marks.containsKey(name)) {
            query.queryParts.set(query.marks.get(name), sql);
        } else {
            query.queryParts.add(sql);
            query.marks.put(name, query.queryParts.size() - 1);
        }
        return query;
    }

    protected void appendParams(String sql, Object[] args) {
        String[] parts = (sql + " ").split("\\?");
        if (parts.length != args.length + 1) {
            String errmsg = String.format("Placeholders length (%d) doesn't match parameters length (%d)", parts.length - 1, args.length);
            throw new DuckException(errmsg);
        }
        for (int i = 0; i < parts.length; ++i) {
            if (args.length <= i) {
                this.queryParts.add(parts[i]);
                return;
            }
            Object arg = args[i];
            if (arg == null) {
                this.queryParts.add(parts[i] + '?');
                this.bindValues.add(null);
                continue;
            }
            if (arg instanceof Collection) {
                this.appendArray(parts[i], ((Collection)arg).toArray());
                continue;
            }
            if (arg.getClass().isArray()) {
                this.appendArray(parts[i], (Object[])arg);
                continue;
            }
            this.queryParts.add(parts[i] + '?');
            this.bindValues.add(arg);
        }
    }

    protected void appendArray(String sql, Object[] arrayArg) {
        StringBuilder marks = new StringBuilder();
        for (int i = 0; i < arrayArg.length; ++i) {
            if (i > 0) {
                marks.append(',');
            }
            marks.append('?');
        }
        this.queryParts.add(sql + marks);
        this.bindValues.addAll(Arrays.asList(arrayArg));
    }

    public Duck debug() {
        logger.info("{" + Duck.class.getSimpleName() + "}\n" + this);
        return this;
    }

    public String toString() {
        return "SQL: " + this.getSql() + "\nParams: " + Arrays.toString(this.getParams());
    }

    public String toSnakeCase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String res = str.replaceAll("([A-Z]+)", "_$1").toLowerCase();
        if (res.startsWith("_") && !str.startsWith("_")) {
            res = res.substring(1);
        }
        return res;
    }

    public Map<String, Object> beanToMap(Object bean, boolean isUpdate, boolean isInsert) {
        try {
            PropertyDescriptor[] props;
            HashMap<String, Object> result = new HashMap<String, Object>();
            Class<?> clazz = bean.getClass();
            for (PropertyDescriptor pd : props = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                Method getter = pd.getReadMethod();
                if (getter == null) continue;
                boolean ignoreNull = true;
                String fieldName = pd.getName();
                java.lang.reflect.Field reflectField = clazz.getDeclaredField(fieldName);
                Field fieldConf = reflectField.getAnnotation(Field.class);
                if (fieldConf != null) {
                    if (isUpdate && fieldConf.ignoreUpdate() || isInsert && fieldConf.ignoreInsert()) continue;
                    ignoreNull = fieldConf.ignoreNull();
                    String dbFieldName = fieldConf.value();
                    if (dbFieldName != null && !dbFieldName.trim().isEmpty()) {
                        fieldName = dbFieldName;
                    }
                } else if (this.isSnakeCase) {
                    fieldName = this.toSnakeCase(fieldName);
                }
                Object value = getter.invoke(bean, new Object[0]);
                if (value == null && ignoreNull) continue;
                result.put(fieldName, value);
            }
            return result;
        }
        catch (Exception ex) {
            throw new DuckException(ex);
        }
    }

    public AbstractMap.SimpleEntry<String, List<Object>> pairInsert(Map<String, Object> params) {
        AbstractMap.SimpleEntry<List<String>, List<Object>> kv = this.pair(params);
        String sql = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)kv.getKey());
        return new AbstractMap.SimpleEntry<String, List<Object>>(sql, kv.getValue());
    }

    public AbstractMap.SimpleEntry<String, Object[]> pairUpdate(Map<String, Object> params) {
        AbstractMap.SimpleEntry<List<String>, List<Object>> kv = this.pair(params);
        String sql = kv.getKey().stream().map(k -> String.format("%s = ?", k)).collect(Collectors.joining(", "));
        return new AbstractMap.SimpleEntry<String, Object[]>(sql, kv.getValue().toArray());
    }

    public AbstractMap.SimpleEntry<List<String>, List<Object>> pair(Map<String, Object> params) {
        ArrayList<String> keys = new ArrayList<String>(params.size());
        ArrayList<Object> values = new ArrayList<Object>(params.size());
        int index = 0;
        for (Map.Entry<String, Object> kv : params.entrySet()) {
            String key = this.escape(kv.getKey());
            keys.add(index, key);
            values.add(index, kv.getValue());
            ++index;
        }
        return new AbstractMap.SimpleEntry<List<String>, List<Object>>(keys, values);
    }

    public static class DuckException
    extends RuntimeException {
        public DuckException(String message) {
            super(message);
        }

        public DuckException(Throwable cause) {
            super(cause);
        }

        public DuckException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Field {
        public String value() default "";

        public boolean ignoreUpdate() default false;

        public boolean ignoreInsert() default false;

        public boolean ignoreNull() default true;
    }

    @FunctionalInterface
    protected static interface ConnectionCallback<T> {
        public T doInConnection(Connection var1) throws SQLException;
    }
}

