/*
 * Decompiled with CFR 0.152.
 */
package org.v2u.toy;

import com.google.gson.Gson;
import com.sun.net.httpserver.HttpExchange;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.v2u.toy.Doge;

public class Exchange
extends Doge.BaseExchange {
    private final Validator validator;
    private final Gson gson;

    public Exchange(HttpExchange inner, Validator validator) {
        super(inner);
        this.validator = validator;
        this.gson = new Gson();
    }

    @Override
    public void json(Object data) {
        this.contentType("application/json");
        this.result(this.gson.toJson(data).getBytes(StandardCharsets.UTF_8));
    }

    public <T> T checkedParam(Class<T> targetClass) {
        Map<String, String> params = this.params();
        String json = this.gson.toJson(params);
        Object bean = this.gson.fromJson(json, targetClass);
        return (T)this.check(bean, targetClass);
    }

    public <T> T checkedBody(Class<T> targetClass) {
        Object body = this.gson.fromJson(this.body(), targetClass);
        return (T)this.check(body, targetClass);
    }

    public <T> T check(T bean, Class<T> targetClass) {
        Set errors = this.validator.validate(bean, new Class[0]);
        ArrayList<String> errList = new ArrayList<String>();
        if (!errors.isEmpty()) {
            for (ConstraintViolation err : errors) {
                errList.add(err.getPropertyPath() + ":" + err.getMessage());
            }
            throw new IllegalArgumentException(String.join((CharSequence)"\n", errList));
        }
        try {
            Method vm = targetClass.getMethod("validate", new Class[0]);
            vm.invoke(bean, new Object[0]);
        }
        catch (NoSuchMethodException vm) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() != null) {
                throw new IllegalArgumentException(e.getCause().getMessage());
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        return bean;
    }
}

