/*
 * Decompiled with CFR 0.152.
 */
package org.v2u.toy;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Duck {
    public static final String IGNORE = "*IGNORE";
    public static final String FIELDS = "*FIELDS";
    private static final Pattern FORMAT_PH_PATTERN = Pattern.compile("([#@]?)\\{(\\d+)}");
    private static final Map<String, Optional<Info>> annotationCache = new ConcurrentHashMap<String, Optional<Info>>();
    private static final Logger log = LoggerFactory.getLogger(Duck.class);
    protected final List<String> queryParts = new ArrayList<String>();
    protected final List<Object> bindValues = new ArrayList<Object>();
    protected final Map<String, Integer> marks = new HashMap<String, Integer>();
    protected Connection txConn = null;
    protected Function<String, String> quoter = this.makeQuoter("`");
    protected boolean isSnake = true;
    protected QueryRunner runner;

    public static Duck init(DataSource ds) {
        return new Duck(ds);
    }

    protected Duck init(Connection conn) {
        Duck duck = this.copy();
        duck.runner = new QueryRunner();
        duck.txConn = conn;
        return duck;
    }

    protected Duck(DataSource ds) {
        this.runner = new QueryRunner(ds);
    }

    public String getSql() {
        return String.join((CharSequence)" ", this.queryParts);
    }

    public Object[] getParams() {
        return this.bindValues.toArray();
    }

    public Duck reset() {
        this.queryParts.clear();
        this.bindValues.clear();
        this.marks.clear();
        return this;
    }

    public Connection getTxConn() {
        if (this.txConn == null) {
            throw new DuckException("Not in a transaction context");
        }
        return this.txConn;
    }

    protected Connection selectConn() throws SQLException {
        if (this.txConn != null) {
            return this.txConn;
        }
        if (this.runner.getDataSource() != null) {
            return this.runner.getDataSource().getConnection();
        }
        throw new DuckException("Unable to obtain database connection");
    }

    private <T> T execute(ConnectionCallback<T> action) {
        Connection conn = null;
        try {
            conn = this.selectConn();
            T t = action.execWithConn(conn);
            return t;
        }
        catch (SQLException cause) {
            throw new DuckException(cause);
        }
        finally {
            if (conn != null && conn != this.txConn) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    log.warn("Failed to close connection: " + ex.getMessage());
                }
            }
        }
    }

    public <T> T fetch(ResultSetHandler<T> rst) {
        log.debug(this.toString());
        return (T)this.execute(conn -> this.runner.query(conn, this.getSql(), rst, this.getParams()));
    }

    public <T> List<T> fetchBeans(Class<T> tClass) {
        BasicRowProcessor rowProcessor = new BasicRowProcessor((BeanProcessor)new DuckBeanProcessor());
        BeanListHandler handler = new BeanListHandler(tClass, (RowProcessor)rowProcessor);
        return (List)this.fetch((ResultSetHandler<T>)handler);
    }

    public <T> T fetchBean(Class<T> tClass) {
        List<T> result = this.fetchBeans(tClass);
        if (result.size() > 1) {
            String errmsg = String.format("Non-unique result: query returned %d rows when expecting exactly one row", result.size());
            throw new DuckException(errmsg);
        }
        return result.isEmpty() ? null : (T)result.get(0);
    }

    public <K, V> Map<K, V> fetchBeanMap(Class<V> vClass, Function<V, K> keyExtractor) {
        return this.fetchBeans(vClass).stream().collect(Collectors.toMap(keyExtractor, v -> v, (a, b) -> {
            throw new DuckException("duplicate key in map: " + keyExtractor.apply(a));
        }));
    }

    public <K, V> Map<K, List<V>> fetchBeanGroup(Class<V> vClass, Function<V, K> keyExtractor) {
        return this.fetchBeans(vClass).stream().collect(Collectors.groupingBy(keyExtractor));
    }

    public List<Map<String, Object>> fetchMaps() {
        MapListHandler handler = new MapListHandler();
        return (List)this.fetch((ResultSetHandler)handler);
    }

    public Map<String, Object> fetchMap() {
        MapHandler handler = new MapHandler();
        return (Map)this.fetch((ResultSetHandler)handler);
    }

    public <T> T fetchScalar(Class<T> tClass) {
        ScalarHandler handler = new ScalarHandler();
        return this.fetch((ResultSetHandler<T>)handler);
    }

    public Duck select(String table, String where, Object ... params) {
        return this.rawAdd("select", new Object[0]).mark(FIELDS, "*").rawAdd("from " + this.quote(table), new Object[0]).add("where " + where, params);
    }

    public Duck select(Object bean) {
        Info info = this.getTableConfig(bean);
        Map<String, Object> cond = this.beanToMap(bean, false, false);
        AbstractMap.SimpleEntry<List<String>, List<Object>> pair = this.pair(cond);
        String where = pair.getKey().stream().map(k -> String.format("%s = ?", k)).collect(Collectors.joining(" and "));
        return this.select(info.name(), where, pair.getValue().toArray());
    }

    public int update() {
        log.debug(this.toString());
        return this.execute(conn -> this.runner.update(conn, this.getSql(), this.getParams()));
    }

    public int updateMap(String tableName, Map<String, Object> params, String where, Object ... whereParams) {
        AbstractMap.SimpleEntry<String, Object[]> paramsKv = this.pairUpdate(params);
        String sql = String.format("update %s set %s", this.quote(tableName), paramsKv.getKey());
        return this.rawAdd(sql, paramsKv.getValue()).add("where " + where, whereParams).update();
    }

    public int updateBean(Object bean, String where, Object ... params) {
        Info info = this.getTableConfig(bean);
        return this.updateBean(info.name(), bean, where, params);
    }

    public int updateBean(String tableName, Object bean, String where, Object ... whereParams) {
        Map<String, Object> params = this.beanToMap(bean, true, false);
        return this.updateMap(tableName, params, where, whereParams);
    }

    public int delete() {
        return this.update();
    }

    public int delete(String tableName, String where, Object ... whereParams) {
        return this.rawAdd("delete from " + this.quote(tableName), new Object[0]).add("where " + where, whereParams).delete();
    }

    public <T> T insert(Class<T> tClass) {
        log.debug(this.toString());
        return (T)this.execute(conn -> this.runner.insert(conn, this.getSql(), (ResultSetHandler)new ScalarHandler(), this.getParams()));
    }

    public Long insert() {
        BigInteger pk = this.insert(BigInteger.class);
        return pk == null ? null : Long.valueOf(pk.longValue());
    }

    public Duck onDuplicateIgnore() {
        if (!this.marks.containsKey(IGNORE)) {
            throw new DuckException("no ignore mark!");
        }
        return this.mark(IGNORE, "ignore");
    }

    public Duck addInsertMap(String tableName, Map<String, Object> params) {
        AbstractMap.SimpleEntry<String, List<Object>> kv = this.pairInsert(params);
        String sql = String.format("into %s (%s) values (?)", this.quote(tableName), kv.getKey());
        return this.rawAdd("insert", new Object[0]).mark(IGNORE, "").rawAdd(sql, kv.getValue());
    }

    public Duck addInsertBean(Object bean) {
        Info info = this.getTableConfig(bean);
        return this.addInsertBean(info.name(), bean);
    }

    public Duck addInsertBean(String tableName, Object bean) {
        Map<String, Object> params = this.beanToMap(bean, false, true);
        return this.addInsertMap(tableName, params);
    }

    public List<Long> insertBeans(List<?> beans, boolean ignoreDuplicate) {
        Info info = this.getTableConfig(beans.get(0));
        return this.insertMaps(info.name(), this.processBatchInsertBeans(beans), ignoreDuplicate);
    }

    public <T> List<T> insertBeans(List<?> beans, boolean ignoreDuplicate, Class<T> tClass) {
        Info info = this.getTableConfig(beans.get(0));
        return this.insertMaps(info.name(), this.processBatchInsertBeans(beans), ignoreDuplicate, tClass);
    }

    public <T> List<T> insertBeans(String tableName, List<?> beans, boolean ignoreDuplicate, Class<T> tClass) {
        return this.insertMaps(tableName, this.processBatchInsertBeans(beans), ignoreDuplicate, tClass);
    }

    public List<Long> insertBeans(String tableName, List<?> beans, boolean ignoreDuplicate) {
        return this.insertMaps(tableName, this.processBatchInsertBeans(beans), ignoreDuplicate);
    }

    public List<Long> insertMaps(String tableName, List<Map<String, Object>> paramsList, boolean ignoreDuplicate) {
        List<BigInteger> ids = this.insertMaps(tableName, paramsList, ignoreDuplicate, BigInteger.class);
        ArrayList<Long> results = new ArrayList<Long>();
        for (BigInteger id : ids) {
            results.add(id == null ? null : Long.valueOf(id.longValue()));
        }
        return results;
    }

    public <T> List<T> insertMaps(String tableName, List<Map<String, Object>> maps, boolean ignoreDuplicate, Class<T> tClass) {
        if (maps == null || maps.isEmpty()) {
            throw new DuckException("Batch params empty");
        }
        Map<String, Object> firstMap = maps.get(0);
        ArrayList<String> keys = new ArrayList<String>(firstMap.keySet());
        String ignore = ignoreDuplicate ? "ignore" : "";
        String fieldStr = keys.stream().map(this::quote).collect(Collectors.joining(", "));
        String placeholders = String.join((CharSequence)", ", Collections.nCopies(keys.size(), "?"));
        String sql = String.format("insert %s into %s (%s) values (%s)", ignore, this.quote(tableName), fieldStr, placeholders);
        Object[][] batchArgs = new Object[maps.size()][];
        for (int i = 0; i < maps.size(); ++i) {
            Map<String, Object> params = maps.get(i);
            Object[] values = new Object[keys.size()];
            for (int j = 0; j < keys.size(); ++j) {
                values[j] = params.get(keys.get(j));
            }
            batchArgs[i] = values;
        }
        log.debug("Batch: " + sql + " #Size: " + batchArgs.length);
        return this.execute(conn -> (List)this.runner.insertBatch(conn, sql, (ResultSetHandler)new ColumnListHandler(), batchArgs));
    }

    public <R> R transaction(Function<Duck, R> action) {
        if (this.txConn != null) {
            throw new DuckException("Nested transactions are not allowed");
        }
        Connection conn = null;
        Boolean isAutoCommit = null;
        try {
            conn = this.runner.getDataSource().getConnection();
            isAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            Duck tx = this.init(conn);
            R result = action.apply(tx);
            conn.commit();
            R r = result;
            return r;
        }
        catch (Throwable e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new DuckException("Failed to rollback transaction", ex);
            }
            throw new DuckException("Transaction failed", e);
        }
        finally {
            try {
                if (conn != null) {
                    if (isAutoCommit != null) {
                        conn.setAutoCommit(isAutoCommit);
                    }
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.warn("Failed to close connection: " + e.getMessage());
            }
        }
    }

    private List<Map<String, Object>> processBatchInsertBeans(List<?> beans) {
        return beans.stream().map(it -> this.beanToMap(it, false, true)).collect(Collectors.toList());
    }

    private Info getTableConfig(Object bean) {
        Info info = bean.getClass().getAnnotation(Info.class);
        if (info == null) {
            throw new DuckException("table config required");
        }
        return info;
    }

    protected Duck copy() {
        Duck query = new Duck(this.runner.getDataSource());
        query.txConn = this.txConn;
        query.queryParts.addAll(this.queryParts);
        query.bindValues.addAll(this.bindValues);
        query.marks.putAll(this.marks);
        query.quoter = this.quoter;
        query.isSnake = this.isSnake;
        return query;
    }

    public Duck setQuoter(Function<String, String> escaper) {
        Duck query = this.copy();
        query.quoter = escaper;
        return query;
    }

    public Function<String, String> makeQuoter(String quote) {
        return identifier -> {
            if (identifier == null) {
                throw new DuckException("Identifier cannot be null");
            }
            if (identifier.trim().isEmpty()) {
                throw new DuckException("Identifier cannot be empty");
            }
            return Arrays.stream(identifier.split("\\.")).map(part -> quote + part.replace(quote, quote + quote) + quote).collect(Collectors.joining("."));
        };
    }

    public String quote(String ident) {
        return this.quoter.apply(ident);
    }

    public Duck add(String template, Object ... args) {
        Matcher m = FORMAT_PH_PATTERN.matcher(template);
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        boolean find = false;
        while (m.find()) {
            find = true;
            int idx = Integer.parseInt(m.group(2));
            if (idx < 0 || idx >= args.length) {
                throw new IllegalArgumentException("Index " + idx + " out of range");
            }
            String ident = m.group(1);
            String argStr = args[idx] == null ? "null" : args[idx].toString();
            switch (ident) {
                case "": {
                    m.appendReplacement(sb, Matcher.quoteReplacement(argStr));
                    break;
                }
                case "@": {
                    m.appendReplacement(sb, Matcher.quoteReplacement(this.quote(argStr)));
                    break;
                }
                case "#": {
                    sqlParams.add(args[idx]);
                    m.appendReplacement(sb, "?");
                }
            }
        }
        m.appendTail(sb);
        if (!find) {
            return this.rawAdd(sb.toString(), args);
        }
        return this.rawAdd(sb.toString(), sqlParams.toArray());
    }

    public Duck rawAdd(String sql, Object ... params) {
        Duck query = this.copy();
        query.appendParams(sql, params);
        return query;
    }

    public Duck isSnake(boolean yes) {
        Duck duck = this.copy();
        duck.isSnake = yes;
        return duck;
    }

    public Duck mark(String name, String sql) {
        Duck query = this.copy();
        if (query.marks.containsKey(name)) {
            query.queryParts.set(query.marks.get(name), sql);
        } else {
            query.queryParts.add(sql);
            query.marks.put(name, query.queryParts.size() - 1);
        }
        return query;
    }

    protected void appendParams(String sql, Object[] args) {
        String[] parts = (sql + " ").split("\\?");
        if (parts.length != args.length + 1) {
            String errmsg = String.format("Placeholders length (%d) doesn't match parameters length (%d)", parts.length - 1, args.length);
            throw new DuckException(errmsg);
        }
        for (int i = 0; i < parts.length; ++i) {
            if (args.length <= i) {
                this.queryParts.add(parts[i]);
                return;
            }
            Object arg = args[i];
            if (arg == null) {
                this.queryParts.add(parts[i] + '?');
                this.bindValues.add(null);
                continue;
            }
            if (arg instanceof Collection) {
                this.appendArray(parts[i], ((Collection)arg).toArray());
                continue;
            }
            if (arg.getClass().isArray()) {
                this.appendArray(parts[i], (Object[])arg);
                continue;
            }
            this.queryParts.add(parts[i] + '?');
            this.bindValues.add(arg);
        }
    }

    protected void appendArray(String sql, Object[] arrayArg) {
        StringBuilder marks = new StringBuilder();
        for (int i = 0; i < arrayArg.length; ++i) {
            if (i > 0) {
                marks.append(',');
            }
            marks.append('?');
        }
        this.queryParts.add(sql + marks);
        this.bindValues.addAll(Arrays.asList(arrayArg));
    }

    public String toString() {
        String sql = this.getSql().replaceAll("(#|--)[^\\n]*", "").replace("\n", " ").trim();
        return "SQL: " + sql + " #" + Arrays.toString(this.getParams());
    }

    public static String toSnake(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String res = str.replaceAll("([A-Z]+)", "_$1").toLowerCase();
        if (res.startsWith("_") && !str.startsWith("_")) {
            res = res.substring(1);
        }
        return res;
    }

    public Map<String, Object> beanToMap(Object bean, boolean isUpdate, boolean isInsert) {
        try {
            PropertyDescriptor[] props;
            HashMap<String, Object> result = new HashMap<String, Object>();
            Class<?> clazz = bean.getClass();
            for (PropertyDescriptor pd : props = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                Object value;
                Method getter = pd.getReadMethod();
                if (getter == null) continue;
                boolean ignoreNull = true;
                String fieldName = pd.getName();
                String columnName = this.isSnake ? Duck.toSnake(fieldName) : fieldName;
                Optional<Info> optInfo = Duck.getCachedInfo(clazz, fieldName);
                if (optInfo.isPresent()) {
                    Info info = optInfo.get();
                    if (!info.exists() || isUpdate && !info.update() || isInsert && !info.insert()) continue;
                    ignoreNull = info.ignoreNull();
                    String annoColumnName = info.name();
                    if (annoColumnName != null && !annoColumnName.trim().isEmpty()) {
                        columnName = annoColumnName;
                    }
                }
                if ((value = getter.invoke(bean, new Object[0])) == null && ignoreNull) continue;
                result.put(columnName, value);
            }
            return result;
        }
        catch (Exception ex) {
            throw new DuckException(ex);
        }
    }

    public AbstractMap.SimpleEntry<String, List<Object>> pairInsert(Map<String, Object> params) {
        AbstractMap.SimpleEntry<List<String>, List<Object>> kv = this.pair(params);
        String sql = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)kv.getKey());
        return new AbstractMap.SimpleEntry<String, List<Object>>(sql, kv.getValue());
    }

    public AbstractMap.SimpleEntry<String, Object[]> pairUpdate(Map<String, Object> params) {
        AbstractMap.SimpleEntry<List<String>, List<Object>> kv = this.pair(params);
        String sql = kv.getKey().stream().map(k -> String.format("%s = ?", k)).collect(Collectors.joining(", "));
        return new AbstractMap.SimpleEntry<String, Object[]>(sql, kv.getValue().toArray());
    }

    public AbstractMap.SimpleEntry<List<String>, List<Object>> pair(Map<String, Object> params) {
        ArrayList<String> keys = new ArrayList<String>(params.size());
        ArrayList<Object> values = new ArrayList<Object>(params.size());
        int index = 0;
        for (Map.Entry<String, Object> kv : params.entrySet()) {
            String key = this.quote(kv.getKey());
            keys.add(index, key);
            values.add(index, kv.getValue());
            ++index;
        }
        return new AbstractMap.SimpleEntry<List<String>, List<Object>>(keys, values);
    }

    protected static Optional<Info> getCachedInfo(Class<?> type, String fieldName) {
        String key = type.getName() + "#" + fieldName;
        return annotationCache.computeIfAbsent(key, k -> {
            try {
                Field field = type.getDeclaredField(fieldName);
                return Optional.ofNullable(field.getAnnotation(Info.class));
            }
            catch (NoSuchFieldException e) {
                return Optional.empty();
            }
        });
    }

    public static class DuckBeanProcessor
    extends BeanProcessor {
        private Class<?> type;

        public <T> List<T> toBeanList(ResultSet resultSet, Class<? extends T> type) throws SQLException {
            this.type = type;
            return super.toBeanList(resultSet, type);
        }

        protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
            int cols = rsmd.getColumnCount();
            int[] columnToProperty = new int[cols + 1];
            Arrays.fill(columnToProperty, -1);
            block0: for (int col = 1; col <= cols; ++col) {
                String columnName = rsmd.getColumnLabel(col);
                if (null == columnName || columnName.isEmpty()) {
                    columnName = rsmd.getColumnName(col);
                }
                String generousColumnName = columnName.replace("_", "").replace(" ", "");
                for (int i = 0; i < props.length; ++i) {
                    String propName = props[i].getName();
                    Optional<Info> optInfo = Duck.getCachedInfo(this.type, propName);
                    if (optInfo.isPresent() && !optInfo.get().name().isEmpty()) {
                        propName = optInfo.get().name();
                    }
                    if (!columnName.equalsIgnoreCase(propName) && !generousColumnName.equalsIgnoreCase(propName)) continue;
                    columnToProperty[col] = i;
                    continue block0;
                }
            }
            return columnToProperty;
        }
    }

    public static class DuckException
    extends RuntimeException {
        public DuckException(String message) {
            super(message);
        }

        public DuckException(Throwable cause) {
            super(cause);
        }

        public DuckException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Info {
        public String name() default "";

        public boolean exists() default true;

        public boolean update() default true;

        public boolean insert() default true;

        public boolean ignoreNull() default true;
    }

    @FunctionalInterface
    protected static interface ConnectionCallback<T> {
        public T execWithConn(Connection var1) throws SQLException;
    }
}

