package org.v2u.toy;

import com.google.gson.Gson;
import com.sun.net.httpserver.HttpExchange;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Exchange extends Doge.BaseExchange {
    private final Validator validator;
    private final Gson gson;

    public Exchange(HttpExchange inner, Validator validator) {
        super(inner);
        this.validator = validator;
        this.gson = new Gson();
    }

    public void json(Object data) {
        contentType("application/json");
        result(gson.toJson(data).getBytes(StandardCharsets.UTF_8));
    }

    public <T> T checkedParam(Class<T> targetClass) {
        return checkedParam(targetClass, new Class[]{});
    }

    public <T> T checkedParam(Class<T> targetClass, Class<?>... groups) {
        Map<String, String> params = params();
        String json = gson.toJson(params);
        T bean = gson.fromJson(json, targetClass);
        return check(bean, targetClass, groups);
    }

    public <T> T checkedBody(Class<T> targetClass) {
        return checkedBody(targetClass, new Class[]{});
    }

    public <T> T checkedBody(Class<T> targetClass, Class<?>... groups) {
        T body = gson.fromJson(body(), targetClass);
        return check(body, targetClass, groups);
    }

    public <T> T check(T bean, Class<T> targetClass, Class<?>... groups) {
        Set<ConstraintViolation<T>> errors = validator.validate(bean, groups);

        List<String> errList = new ArrayList<>();
        if (!errors.isEmpty()) {
            for (ConstraintViolation<T> err : errors) {
                errList.add(err.getMessage());
            }

            throw new IllegalArgumentException(String.join("\n", errList));
        }

        try {
            Method vm = targetClass.getMethod("validate");
            vm.invoke(bean);
        } catch (NoSuchMethodException e) {
            //pass
        } catch (InvocationTargetException | IllegalAccessException e) {
            if (e.getCause() != null) {
                throw new IllegalArgumentException(e.getCause().getMessage());
            } else {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        return bean;
    }
}