/*
 * Decompiled with CFR 0.152.
 */
package org.v2u.toy;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Duck {
    public static final String IGNORE = "*IGNORE";
    public static final String FIELDS = "*FIELDS";
    private static final Pattern FORMAT_PH_PATTERN = Pattern.compile("([#@]?)\\{([^}]+?)}");
    private static final Pattern INT_PATTERN = Pattern.compile("^\\d+$");
    private static final Map<String, Optional<Info>> INFO_CACHE = new ConcurrentHashMap<String, Optional<Info>>();
    private static final Logger log = LoggerFactory.getLogger(Duck.class);
    protected final List<String> queryParts = new ArrayList<String>();
    protected final List<Object> bindValues = new ArrayList<Object>();
    protected final Map<String, Integer> marks = new HashMap<String, Integer>();
    protected Connection txConn = null;
    protected Function<String, String> quoter = Duck.makeQuoter("`");
    protected boolean isSnake = true;
    protected QueryRunner runner;

    public static Duck init(DataSource ds) {
        return new Duck(ds);
    }

    protected Duck init(Connection conn) {
        Duck duck = this.copy();
        duck.runner = new QueryRunner();
        duck.txConn = conn;
        return duck;
    }

    protected Duck(DataSource ds) {
        this.runner = new QueryRunner(ds);
    }

    public String getSql() {
        return String.join((CharSequence)" ", this.queryParts);
    }

    public Object[] getParams() {
        return this.bindValues.toArray();
    }

    public Duck reset() {
        this.queryParts.clear();
        this.bindValues.clear();
        this.marks.clear();
        return this;
    }

    public Connection getTxConn() {
        if (this.txConn == null) {
            throw new DuckException("Not in a transaction context");
        }
        return this.txConn;
    }

    protected Connection selectConn() throws SQLException {
        if (this.txConn != null) {
            return this.txConn;
        }
        if (this.runner.getDataSource() != null) {
            return this.runner.getDataSource().getConnection();
        }
        throw new DuckException("Unable to obtain database connection");
    }

    private <T> T execute(ConnectionCallback<T> action) {
        Connection conn = null;
        try {
            conn = this.selectConn();
            T t = action.execWithConn(conn);
            return t;
        }
        catch (SQLException cause) {
            throw new DuckException(cause);
        }
        finally {
            if (conn != null && conn != this.txConn) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    log.warn("Failed to close connection: " + ex.getMessage());
                }
            }
        }
    }

    public <T> T fetch(ResultSetHandler<T> rst) {
        this.debug();
        return (T)this.execute(conn -> this.runner.query(conn, this.getSql(), rst, this.getParams()));
    }

    public <T> List<T> fetchBeans(Class<T> beanType) {
        BasicRowProcessor rowProcessor = new BasicRowProcessor((BeanProcessor)new DuckBeanProcessor());
        BeanListHandler handler = new BeanListHandler(beanType, (RowProcessor)rowProcessor);
        return (List)this.fetch((ResultSetHandler<T>)handler);
    }

    public <T> T fetchBean(Class<T> beanType) {
        List<T> result = this.fetchBeans(beanType);
        if (result.size() > 1) {
            String errmsg = String.format("Non-unique result: query returned %d rows when expecting exactly one row", result.size());
            throw new DuckException(errmsg);
        }
        return result.isEmpty() ? null : (T)result.get(0);
    }

    public <K, V> Map<K, V> fetchBeanMap(Class<V> type, Function<V, K> keyExtractor) {
        return this.fetchBeans(type).stream().collect(Collectors.toMap(keyExtractor, v -> v, (a, b) -> {
            throw new DuckException("duplicate key in map: " + keyExtractor.apply(a));
        }));
    }

    public <K, V> Map<K, List<V>> fetchBeanGroup(Class<V> type, Function<V, K> keyExtractor) {
        return this.fetchBeans(type).stream().collect(Collectors.groupingBy(keyExtractor));
    }

    public List<Map<String, Object>> fetchMaps() {
        MapListHandler handler = new MapListHandler();
        return (List)this.fetch((ResultSetHandler)handler);
    }

    public Map<String, Object> fetchMap() {
        MapHandler handler = new MapHandler();
        return (Map)this.fetch((ResultSetHandler)handler);
    }

    public <T> T fetchScalar(Class<T> retType) {
        ScalarHandler handler = new ScalarHandler();
        return this.fetch((ResultSetHandler<T>)handler);
    }

    public Duck select(String table) {
        return this.rawAdd("select", new Object[0]).mark(FIELDS, "*").rawAdd("from " + this.quote(table), new Object[0]);
    }

    public Duck select(String table, String where, Object ... args) {
        return this.select(table).add("where " + where, args);
    }

    public int update() {
        this.debug();
        return this.execute(conn -> this.runner.update(conn, this.getSql(), this.getParams()));
    }

    public int updateMap(String tableName, Map<String, Object> data, String where, Object ... args) {
        AbstractMap.SimpleEntry<String, Object[]> paramsKv = this.pairUpdate(data);
        String sql = String.format("update %s set %s", this.quote(tableName), paramsKv.getKey());
        return this.rawAdd(sql, paramsKv.getValue()).add("where " + where, args).update();
    }

    public int updateBean(Object bean, String where, Object ... args) {
        Info info = this.getTableConfig(bean);
        return this.updateBean(info.name(), bean, where, args);
    }

    public int updateBean(String tableName, Object bean, String where, Object ... args) {
        Map<String, Object> params = Duck.beanToMap(bean, this.isSnake, true, false);
        return this.updateMap(tableName, params, where, args);
    }

    public int delete() {
        return this.update();
    }

    public int delete(String table, String where, Object ... args) {
        return this.rawAdd("delete from " + this.quote(table), new Object[0]).add("where " + where, args).delete();
    }

    public <T> T insert(Class<T> pkType) {
        this.debug();
        return (T)this.execute(conn -> this.runner.insert(conn, this.getSql(), (ResultSetHandler)new ScalarHandler(), this.getParams()));
    }

    public Long insert() {
        BigInteger pk = this.insert(BigInteger.class);
        return pk == null ? null : Long.valueOf(pk.longValue());
    }

    public Duck onDuplicateIgnore() {
        if (!this.marks.containsKey(IGNORE)) {
            throw new DuckException("no ignore mark!");
        }
        return this.mark(IGNORE, "ignore");
    }

    public Duck addInsertMap(String table, Map<String, Object> data) {
        AbstractMap.SimpleEntry<String, List<Object>> kv = this.pairInsert(data);
        String sql = String.format("into %s (%s) values (?)", this.quote(table), kv.getKey());
        return this.rawAdd("insert", new Object[0]).mark(IGNORE, "").rawAdd(sql, kv.getValue());
    }

    public Duck addInsertBean(Object bean) {
        Info info = this.getTableConfig(bean);
        return this.addInsertBean(info.name(), bean);
    }

    public Duck addInsertBean(String table, Object bean) {
        Map<String, Object> params = Duck.beanToMap(bean, this.isSnake, false, true);
        return this.addInsertMap(table, params);
    }

    public List<Long> insertBeans(List<?> beans, boolean ignoreDuplicate) {
        Info info = this.getTableConfig(beans.get(0));
        return this.insertMaps(info.name(), this.processBatchInsertBeans(beans), ignoreDuplicate);
    }

    public <T> List<T> insertBeans(List<?> beans, boolean ignoreDuplicate, Class<T> pkType) {
        Info info = this.getTableConfig(beans.get(0));
        return this.insertMaps(info.name(), this.processBatchInsertBeans(beans), ignoreDuplicate, pkType);
    }

    public <T> List<T> insertBeans(String table, List<?> beans, boolean ignoreDuplicate, Class<T> pkType) {
        return this.insertMaps(table, this.processBatchInsertBeans(beans), ignoreDuplicate, pkType);
    }

    public List<Long> insertBeans(String table, List<?> beans, boolean ignoreDuplicate) {
        return this.insertMaps(table, this.processBatchInsertBeans(beans), ignoreDuplicate);
    }

    public List<Long> insertMaps(String table, List<Map<String, Object>> paramsList, boolean ignoreDuplicate) {
        List<BigInteger> ids = this.insertMaps(table, paramsList, ignoreDuplicate, BigInteger.class);
        ArrayList<Long> results = new ArrayList<Long>();
        for (BigInteger id : ids) {
            results.add(id == null ? null : Long.valueOf(id.longValue()));
        }
        return results;
    }

    public <T> List<T> insertMaps(String table, List<Map<String, Object>> maps, boolean ignoreDuplicate, Class<T> pkType) {
        if (maps == null || maps.isEmpty()) {
            throw new DuckException("Batch params empty");
        }
        Map<String, Object> firstMap = maps.get(0);
        ArrayList<String> keys = new ArrayList<String>(firstMap.keySet());
        String ignore = ignoreDuplicate ? "ignore" : "";
        String fieldStr = keys.stream().map(this::quote).collect(Collectors.joining(", "));
        String placeholders = String.join((CharSequence)", ", Collections.nCopies(keys.size(), "?"));
        String sql = String.format("insert %s into %s (%s) values (%s)", ignore, this.quote(table), fieldStr, placeholders);
        Object[][] batchArgs = new Object[maps.size()][];
        for (int i = 0; i < maps.size(); ++i) {
            Map<String, Object> params = maps.get(i);
            Object[] values = new Object[keys.size()];
            for (int j = 0; j < keys.size(); ++j) {
                values[j] = params.get(keys.get(j));
            }
            batchArgs[i] = values;
        }
        if (log.isDebugEnabled()) {
            ArrayList<String> args = new ArrayList<String>();
            for (Object[] arg : batchArgs) {
                args.add("  |> " + Arrays.toString(arg));
            }
            log.debug("SQL: " + sql + "\n" + String.join((CharSequence)"\n", args));
        }
        return this.execute(conn -> (List)this.runner.insertBatch(conn, sql, (ResultSetHandler)new ColumnListHandler(), batchArgs));
    }

    public <R> R transaction(Function<Duck, R> action) {
        if (this.txConn != null) {
            throw new DuckException("Nested transactions are not allowed");
        }
        Connection conn = null;
        Boolean isAutoCommit = null;
        try {
            conn = this.runner.getDataSource().getConnection();
            isAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            Duck tx = this.init(conn);
            R result = action.apply(tx);
            conn.commit();
            R r = result;
            return r;
        }
        catch (Throwable e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new DuckException("Failed to rollback transaction", ex);
            }
            throw new DuckException("Transaction failed", e);
        }
        finally {
            try {
                if (conn != null) {
                    if (isAutoCommit != null) {
                        conn.setAutoCommit(isAutoCommit);
                    }
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.warn("Failed to close connection: " + e.getMessage());
            }
        }
    }

    private List<Map<String, Object>> processBatchInsertBeans(List<?> beans) {
        return beans.stream().map(it -> Duck.beanToMap(it, this.isSnake, false, true)).collect(Collectors.toList());
    }

    private Info getTableConfig(Object bean) {
        Info info = bean.getClass().getAnnotation(Info.class);
        if (info == null) {
            throw new DuckException("table config required");
        }
        return info;
    }

    protected Duck copy() {
        Duck query = new Duck(this.runner.getDataSource());
        query.txConn = this.txConn;
        query.queryParts.addAll(this.queryParts);
        query.bindValues.addAll(this.bindValues);
        query.marks.putAll(this.marks);
        query.quoter = this.quoter;
        query.isSnake = this.isSnake;
        return query;
    }

    public Duck setQuoter(Function<String, String> quoter) {
        Duck query = this.copy();
        query.quoter = quoter;
        return query;
    }

    public static Function<String, String> makeQuoter(String quote) {
        return identifier -> {
            if (identifier == null) {
                throw new DuckException("Identifier cannot be null");
            }
            if (identifier.trim().isEmpty()) {
                throw new DuckException("Identifier cannot be empty");
            }
            return Arrays.stream(identifier.split("\\.")).map(part -> quote + part.replace(quote, quote + quote) + quote).collect(Collectors.joining("."));
        };
    }

    public String quote(String identity) {
        return this.quoter.apply(identity);
    }

    public Duck add(boolean yes, String template, Object ... args) {
        if (yes) {
            return this.add(template, args);
        }
        return this;
    }

    public Duck add(String template, Object ... args) {
        Matcher m = FORMAT_PH_PATTERN.matcher(template);
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        AtomicReference<Object> namedArgs = new AtomicReference<Object>(null);
        Runnable namedArgsInit = () -> {
            if (namedArgs.get() != null) {
                return;
            }
            if (args.length <= 0) {
                throw new IllegalArgumentException("Named argument required at latest position");
            }
            Object arg = args[args.length - 1];
            namedArgs.set(Duck.beanToMap(arg, this.isSnake, false, false));
        };
        boolean find = false;
        while (m.find()) {
            String ident;
            find = true;
            Object arg = null;
            String key = m.group(2).trim();
            if (INT_PATTERN.matcher(key).find()) {
                int idx = Integer.parseInt(key);
                if (idx < 1 || idx > args.length) {
                    throw new IllegalArgumentException("Index " + idx + " out of range");
                }
                arg = args[idx - 1];
            } else {
                namedArgsInit.run();
                if (!((Map)namedArgs.get()).containsKey(key)) {
                    throw new IllegalArgumentException("Named argument '" + key + "' not found");
                }
                arg = ((Map)namedArgs.get()).get(key);
            }
            switch (ident = m.group(1)) {
                case "": {
                    if (arg == null) {
                        throw new IllegalArgumentException("null not allowed: " + key);
                    }
                    m.appendReplacement(sb, Matcher.quoteReplacement(arg.toString()));
                    break;
                }
                case "@": {
                    if (arg == null) {
                        throw new IllegalArgumentException("null not allowed: " + key);
                    }
                    m.appendReplacement(sb, Matcher.quoteReplacement(this.quote(arg.toString())));
                    break;
                }
                case "#": {
                    sqlParams.add(arg);
                    m.appendReplacement(sb, "?");
                }
            }
        }
        m.appendTail(sb);
        if (!find) {
            return this.rawAdd(sb.toString(), args);
        }
        return this.rawAdd(sb.toString(), sqlParams.toArray());
    }

    public Duck rawAdd(boolean yes, String sql, Object ... args) {
        if (yes) {
            return this.rawAdd(sql, args);
        }
        return this;
    }

    public Duck rawAdd(String sql, Object ... args) {
        Duck query = this.copy();
        query.appendParams(sql, args);
        return query;
    }

    public Duck isSnake(boolean yes) {
        Duck duck = this.copy();
        duck.isSnake = yes;
        return duck;
    }

    public Duck mark(String name, String sql) {
        Duck query = this.copy();
        if (query.marks.containsKey(name)) {
            query.queryParts.set(query.marks.get(name), sql);
        } else {
            query.queryParts.add(sql);
            query.marks.put(name, query.queryParts.size() - 1);
        }
        return query;
    }

    protected void appendParams(String sql, Object[] args) {
        String[] parts = (sql + " ").split("\\?");
        if (parts.length != args.length + 1) {
            String errmsg = String.format("Placeholders length (%d) doesn't match parameters length (%d)", parts.length - 1, args.length);
            throw new DuckException(errmsg);
        }
        for (int i = 0; i < parts.length; ++i) {
            if (args.length <= i) {
                this.queryParts.add(parts[i]);
                return;
            }
            Object arg = args[i];
            if (arg == null) {
                this.queryParts.add(parts[i] + '?');
                this.bindValues.add(null);
                continue;
            }
            if (arg instanceof Collection) {
                this.appendArray(parts[i], ((Collection)arg).toArray());
                continue;
            }
            if (arg.getClass().isArray()) {
                this.appendArray(parts[i], (Object[])arg);
                continue;
            }
            this.queryParts.add(parts[i] + '?');
            this.bindValues.add(arg);
        }
    }

    protected void appendArray(String sql, Object[] args) {
        StringBuilder marks = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                marks.append(',');
            }
            marks.append('?');
        }
        this.queryParts.add(sql + marks);
        this.bindValues.addAll(Arrays.asList(args));
    }

    protected void debug() {
        if (log.isDebugEnabled()) {
            log.debug(this.toString());
        }
    }

    public String toString() {
        String sql = this.getSql().replaceAll("(#|--)[^\\n]*", "").replace("\n", " ").trim();
        return "SQL: " + sql + "\n  |> " + Arrays.toString(this.getParams());
    }

    public static String toSnake(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String res = str.replaceAll("([A-Z]+)", "_$1").toLowerCase();
        if (res.startsWith("_") && !str.startsWith("_")) {
            res = res.substring(1);
        }
        return res;
    }

    public static Map<String, Object> mapOf(Object ... v) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (v.length % 2 != 0) {
            throw new IllegalArgumentException("argument length must be even");
        }
        for (int i = 0; i < v.length; i += 2) {
            String prefix = v[i].toString();
            result.put(v[i].toString(), v[i + 1]);
            Map<String, Object> temp = Duck.beanToMap(v[i + 1], false);
            if (temp.isEmpty()) continue;
            for (Map.Entry<String, Object> kv : temp.entrySet()) {
                result.put(prefix + "." + kv.getKey().toString(), kv.getValue());
            }
        }
        return result;
    }

    public static Map<String, Object> beanToMap(Object bean, boolean toSnake) {
        return Duck.beanToMap(bean, toSnake, false, false);
    }

    protected static Map<String, Object> beanToMap(Object bean, boolean toSnake, boolean isUpdate, boolean isInsert) {
        if (bean instanceof Map) {
            return (Map)bean;
        }
        try {
            PropertyDescriptor[] props;
            HashMap<String, Object> result = new HashMap<String, Object>();
            Class<?> clazz = bean.getClass();
            for (PropertyDescriptor pd : props = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors()) {
                Object value;
                Method getter = pd.getReadMethod();
                if (getter == null || getter.getDeclaringClass().equals(Object.class)) continue;
                boolean ignoreNull = true;
                String fieldName = pd.getName();
                String columnName = toSnake ? Duck.toSnake(fieldName) : fieldName;
                Optional<Info> optInfo = Duck.getCachedInfo(clazz, fieldName);
                if (optInfo.isPresent()) {
                    Info info = optInfo.get();
                    if (!info.exists() || isUpdate && !info.update() || isInsert && !info.insert()) continue;
                    ignoreNull = info.ignoreNull();
                    String annoColumnName = info.name();
                    if (annoColumnName != null && !annoColumnName.trim().isEmpty()) {
                        columnName = annoColumnName;
                    }
                }
                if ((value = getter.invoke(bean, new Object[0])) == null && ignoreNull) continue;
                result.put(columnName, value);
            }
            return result;
        }
        catch (Exception ex) {
            throw new DuckException(ex);
        }
    }

    public AbstractMap.SimpleEntry<String, List<Object>> pairInsert(Map<String, Object> data) {
        AbstractMap.SimpleEntry<List<String>, List<Object>> kv = this.pair(data);
        String sql = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)kv.getKey());
        return new AbstractMap.SimpleEntry<String, List<Object>>(sql, kv.getValue());
    }

    public AbstractMap.SimpleEntry<String, Object[]> pairUpdate(Map<String, Object> data) {
        AbstractMap.SimpleEntry<List<String>, List<Object>> kv = this.pair(data);
        String sql = kv.getKey().stream().map(k -> String.format("%s = ?", k)).collect(Collectors.joining(", "));
        return new AbstractMap.SimpleEntry<String, Object[]>(sql, kv.getValue().toArray());
    }

    public AbstractMap.SimpleEntry<List<String>, List<Object>> pair(Map<String, Object> data) {
        ArrayList<String> keys = new ArrayList<String>(data.size());
        ArrayList<Object> values = new ArrayList<Object>(data.size());
        int index = 0;
        for (Map.Entry<String, Object> kv : data.entrySet()) {
            String key = this.quote(kv.getKey());
            keys.add(index, key);
            values.add(index, kv.getValue());
            ++index;
        }
        return new AbstractMap.SimpleEntry<List<String>, List<Object>>(keys, values);
    }

    protected static Optional<Info> getCachedInfo(Class<?> type, String fieldName) {
        String key = type.getName() + "#" + fieldName;
        return INFO_CACHE.computeIfAbsent(key, k -> {
            try {
                Field field = type.getDeclaredField(fieldName);
                return Optional.ofNullable(field.getAnnotation(Info.class));
            }
            catch (NoSuchFieldException e) {
                return Optional.empty();
            }
        });
    }

    public static class DuckBeanProcessor
    extends BeanProcessor {
        private Class<?> type;

        public <T> List<T> toBeanList(ResultSet resultSet, Class<? extends T> type) throws SQLException {
            this.type = type;
            return super.toBeanList(resultSet, type);
        }

        protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
            int cols = rsmd.getColumnCount();
            int[] columnToProperty = new int[cols + 1];
            Arrays.fill(columnToProperty, -1);
            block0: for (int col = 1; col <= cols; ++col) {
                String columnName = rsmd.getColumnLabel(col);
                if (null == columnName || columnName.isEmpty()) {
                    columnName = rsmd.getColumnName(col);
                }
                String generousColumnName = columnName.replace("_", "").replace(" ", "");
                for (int i = 0; i < props.length; ++i) {
                    String propName = props[i].getName();
                    Optional<Info> optInfo = Duck.getCachedInfo(this.type, propName);
                    if (optInfo.isPresent() && !optInfo.get().name().isEmpty()) {
                        propName = optInfo.get().name();
                    }
                    if (!columnName.equalsIgnoreCase(propName) && !generousColumnName.equalsIgnoreCase(propName)) continue;
                    columnToProperty[col] = i;
                    continue block0;
                }
            }
            return columnToProperty;
        }
    }

    public static class DuckException
    extends RuntimeException {
        public DuckException(String message) {
            super(message);
        }

        public DuckException(Throwable cause) {
            super(cause);
        }

        public DuckException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Info {
        public String name() default "";

        public boolean exists() default true;

        public boolean update() default true;

        public boolean insert() default true;

        public boolean ignoreNull() default true;
    }

    @FunctionalInterface
    protected static interface ConnectionCallback<T> {
        public T execWithConn(Connection var1) throws SQLException;
    }
}

