//package org.v2u.toy.jdk;
//
//import com.google.gson.Gson;
//import com.sun.net.httpserver.Headers;
//import com.sun.net.httpserver.HttpExchange;
//import jakarta.validation.ConstraintViolation;
//import jakarta.validation.Validation;
//import jakarta.validation.Validator;
//
//import java.io.*;
//import java.lang.reflect.InvocationTargetException;
//import java.lang.reflect.Method;
//import java.net.URLDecoder;
//import java.nio.charset.StandardCharsets;
//import java.nio.file.Files;
//import java.util.*;
//import java.util.function.Consumer;
//
//public class Exchange {
//    public final HttpExchange inner;
//    protected final Map<String, Object> attributes = new HashMap<>();
//    protected int statusCode = 200; // 默认状态码
//    protected int maxRequestBodySize = Integer.MAX_VALUE; // 默认无限制
//    protected byte[] cachedBody;
//    protected Map<String, String> cachedQueryParams;
//    protected static final int DEFAULT_BUFFER_SIZE = 8192;
//    private boolean headersSent = false;
//    private boolean closed = false;
//
//    private final Validator validator;
//    private final Gson gson;
//
//    public Exchange(HttpExchange inner) {
//        this.inner = inner;
//        this.validator = Validation.buildDefaultValidatorFactory().getValidator();
//        this.gson = new Gson();
//    }
//
//    public String path() {
//        return inner.getRequestURI().getPath();
//    }
//
//    public String method() {
//        return inner.getRequestMethod();
//    }
//
//    public Headers headers() {
//        return inner.getRequestHeaders();
//    }
//
//    public Exchange status(int code) {
//        this.statusCode = code; // 仅设置状态码，不发送响应头
//        return this;
//    }
//
//    public Exchange contentType(String type) {
//        inner.getResponseHeaders().set("Content-Type", type);
//        return this;
//    }
//
//    public void download(File file, String filename) {
//        if (!file.exists() || !file.isFile()) {
//            status(404).result("File not found");
//            return;
//        }
//
//        contentType("application/octet-stream")
//          .header("Content-Disposition", "attachment; filename=\"" + filename + "\"");
//
//        try {
//            byte[] data = Files.readAllBytes(file.toPath());
//            result(data);
//        } catch (IOException e) {
//            throw new RuntimeException("File read failed", e);
//        }
//    }
//
//    public void redirect(String location) {
//        status(302)
//          .header("Location", location)
//          .result("");
//    }
//
//    public Exchange attr(String name, Object value) {
//        attributes.put(name, value);
//        return this;
//    }
//
//    @SuppressWarnings("unchecked")
//    public <T> T attr(String name) {
//        return (T) attributes.get(name);
//    }
//
//    public <T> T attr(String name, Class<T> type) {
//        T value = attr(name);
//        if (value == null) {
//            throw new IllegalStateException(type.getSimpleName() + " not found in context");
//        }
//        return value;
//    }
//
//    public void sse(Consumer<Doge.SseEmitter> handler) {
//        contentType("text/event-stream")
//          .header("Cache-Control", "no-cache")
//          .header("Connection", "keep-alive");
//
//        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(inner.getResponseBody()))) {
//            Doge.SseEmitter emitter = new Doge.SseEmitter(writer);
//            inner.sendResponseHeaders(200, 0);
//            handler.accept(emitter);
//        } catch (IOException e) {
//            throw new RuntimeException("SSE failed", e);
//        }
//    }
//
//    public void close() {
//        if (closed) {
//            return;
//        }
//        try {
//            inner.close();
//        } finally {
//            closed = true;
//        }
//    }
//
//    public static String urlDecode(String str) {
//        try {
//            return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
//        } catch (UnsupportedEncodingException e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//    // 获取查询参数
//    public Map<String, String> params() {
//        if (cachedQueryParams != null) {
//            return cachedQueryParams;
//        }
//
//        String query = inner.getRequestURI().getQuery();
//        cachedQueryParams = new LinkedHashMap<>();
//
//        if (query == null || query.trim().equals("")) {
//            return cachedQueryParams;
//        }
//
//        for (String param : query.split("&")) {
//            int idx = param.indexOf('=');
//            if (idx > 0) {
//                String key = urlDecode(param.substring(0, idx));
//                String value = urlDecode(param.substring(idx + 1));
//                cachedQueryParams.put(key, value);
//            } else if (!param.isEmpty()) {
//                cachedQueryParams.put(urlDecode(param), "");
//            }
//        }
//
//        return cachedQueryParams;
//    }
//
//    // 获取请求体为字符串
//    public String body() {
//        return new String(bytes(), StandardCharsets.UTF_8);
//    }
//
//    public byte[] bytes() {
//        if (cachedBody != null) {
//            return cachedBody;
//        }
//
//        try (InputStream is = inner.getRequestBody();
//             ByteArrayOutputStream result = new ByteArrayOutputStream()) {
//            byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
//            int totalRead = 0;
//            int length;
//
//            while ((length = is.read(buffer)) != -1) {
//                totalRead += length;
//                if (totalRead > maxRequestBodySize) {
//                    throw new IOException("Request body too large");
//                }
//                result.write(buffer, 0, length);
//            }
//
//            cachedBody = result.toByteArray();
//            return cachedBody;
//        } catch (IOException e) {
//            throw new RuntimeException("Failed to read request body", e);
//        }
//    }
//
//    // 设响应头
//    public Exchange header(String name, String value) {
//        inner.getResponseHeaders().set(name, value);
//        return this;
//    }
//
//    // 获取单个请求头
//    public String header(String name) {
//        return inner.getRequestHeaders().getFirst(name);
//    }
//
//    // 设置Cookie
//    public Exchange cookie(String name, String value, int maxAge) {
//        String cookie = String.format("%s=%s; Max-Age=%d; Path=/", name, value, maxAge);
//        inner.getResponseHeaders().add("Set-Cookie", cookie);
//        return this;
//    }
//
//    // 获取Cookie
//    public String cookie(String name) {
//        List<String> cookies = inner.getRequestHeaders().get("Cookie");
//        if (cookies != null) {
//            for (String cookie : cookies) {
//                for (String pair : cookie.split(";")) {
//                    String[] keyValue = pair.trim().split("=");
//                    if (keyValue.length == 2 && keyValue[0].equals(name)) {
//                        return keyValue[1];
//                    }
//                }
//            }
//        }
//        return null;
//    }
//
//    public void html(String htmlContent) {
//        contentType("text/html; charset=UTF-8");
//        result(htmlContent);
//    }
//
//    public void staticFile(File root, String path) {
//        File file = new File(root, path);
//        try {
//            if (!file.exists() || !file.isFile()) {
//                status(404).result("File not found: " + file);
//                return;
//            }
//
//            if (!file.getCanonicalPath().startsWith(root.getCanonicalPath())) {
//                status(403).result("Forbidden: " + file);
//                return;
//            }
//
//            byte[] fileBytes = Files.readAllBytes(file.toPath());
//            String contentType = Files.probeContentType(file.toPath());
//            contentType(contentType != null ? contentType : "application/octet-stream");
//            result(fileBytes);
//        } catch (IOException e) {
//            throw new RuntimeException("Read file error: " + file, e);
//        } finally {
//            close();
//        }
//    }
//
//    public void result(Object obj) {
//        String response = obj != null ? obj.toString() : "null";
//        byte[] responseBytes = response.getBytes(StandardCharsets.UTF_8);
//        result(responseBytes);
//    }
//
//    public void result(byte[] responseBytes) {
//        try {
//            sendHeaders(responseBytes.length);
//            inner.getResponseBody().write(responseBytes);
//        } catch (IOException e) {
//            throw new RuntimeException("Failed to send response", e);
//        } finally {
//            close();
//        }
//    }
//
//    public void result(InputStream inputStream) {
//        try {
//            int availableBytes = inputStream.available();
//            if (availableBytes > 0) {
//                sendHeaders(availableBytes);
//            } else {
//                inner.getResponseHeaders().set("Transfer-Encoding", "chunked");
//                sendHeaders(0); // 使用分块传输编码
//            }
//
//            byte[] data = new byte[1024];
//            int nRead;
//            OutputStream os = inner.getResponseBody();
//            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
//                os.write(data, 0, nRead);
//            }
//            os.flush();
//        } catch (IOException e) {
//            e.printStackTrace();
//            throw new RuntimeException("Failed to send response from InputStream", e);
//        } finally {
//            close();
//        }
//    }
//
//    // 设置请求体大小限制
//    public Exchange maxRequestBodySize(int size) {
//        this.maxRequestBodySize = size;
//        return this;
//    }
//
//    private void sendHeaders(long length) throws IOException {
//        if (headersSent) {
//            return;
//        }
//        inner.sendResponseHeaders(statusCode, length);
//        headersSent = true;
//    }
//
//    public void json(Object data) {
//        contentType("application/json");
//        result(gson.toJson(data).getBytes(StandardCharsets.UTF_8));
//    }
//
//    public <T> T checkedParam(Class<T> targetClass) {
//        return checkedParam(targetClass, new Class[]{});
//    }
//
//    public <T> T checkedParam(Class<T> targetClass, Class<?>... groups) {
//        Map<String, String> params = params();
//        String json = gson.toJson(params);
//        T bean = gson.fromJson(json, targetClass);
//        return check(bean, targetClass, groups);
//    }
//
//    public <T> T checkedBody(Class<T> targetClass) {
//        return checkedBody(targetClass, new Class[]{});
//    }
//
//    public <T> T checkedBody(Class<T> targetClass, Class<?>... groups) {
//        T body = gson.fromJson(body(), targetClass);
//        return check(body, targetClass, groups);
//    }
//
//    public <T> T check(T bean, Class<T> targetClass, Class<?>... groups) {
//        Set<ConstraintViolation<T>> errors = validator.validate(bean, groups);
//
//        List<String> errList = new ArrayList<>();
//        if (!errors.isEmpty()) {
//            for (ConstraintViolation<T> err : errors) {
//                errList.add(err.getMessage());
//            }
//
//            throw new IllegalArgumentException(String.join("\n", errList));
//        }
//
//        try {
//            Method vm = targetClass.getMethod("validate", Class[].class);
//            vm.invoke(bean, (Object) groups);
//        } catch (NoSuchMethodException e) {
//            //pass
//        } catch (InvocationTargetException | IllegalAccessException e) {
//            if (e.getCause() != null) {
//                throw new IllegalArgumentException(e.getCause().getMessage());
//            } else {
//                throw new IllegalArgumentException(e.getMessage());
//            }
//        }
//
//        return bean;
//    }
//}