//package org.v2u.toy.jdk;
//
//import com.sun.net.httpserver.HttpContext;
//import com.sun.net.httpserver.HttpExchange;
//import com.sun.net.httpserver.HttpServer;
//
//import java.io.FileNotFoundException;
//import java.io.IOException;
//import java.io.PrintWriter;
//import java.net.InetSocketAddress;
//import java.util.ArrayDeque;
//import java.util.ArrayList;
//import java.util.Deque;
//import java.util.List;
//import java.util.concurrent.Executor;
//import java.util.function.BiConsumer;
//import java.util.function.Consumer;
//import java.util.function.Function;
//
//public class Doge {
//    // 核心服务器实现类
//    public static class Server<T extends Exchange> {
//        private final HttpServer server;
//        private final Function<HttpExchange, T> exchangeFactory;
//        private BiConsumer<T, Exception> errorHandler = this::defaultErrorHandler;
//        private int maxRequestBodySize = 2 * 1024 * 1024; // 默认请求体大小限制为2MB
//        private final Deque<String> routeStack = new ArrayDeque<>(); // 路由栈
//        private final List<RouteFilter<T>> routeFilters = new ArrayList<>(); // 保存带路径的过滤器
//
//        public Server(Function<HttpExchange, T> exchangeFactory) {
//            try {
//                this.server = HttpServer.create(); // 初始化为空的HttpServer
//                this.exchangeFactory = exchangeFactory;
//            } catch (IOException e) {
//                throw new RuntimeException("Failed to create HttpServer", e);
//            }
//        }
//
//        public Server<T> start(int port) throws IOException {
//            return start(port, 0);
//        }
//
//        public Server<T> start(int port, int backlog) {
//            try {
//                this.server.bind(new InetSocketAddress(port), backlog);
//                this.server.start();
//                return this;
//            } catch (IOException e) {
//                throw new RuntimeException("start server error", e);
//            }
//        }
//
//        public Server<T> maxRequestBodySize(int size) {
//            this.maxRequestBodySize = size;
//            return this;
//        }
//
//        public Server<T> error(BiConsumer<T, Exception> handler) {
//            this.errorHandler = handler;
//            return this;
//        }
//
//        public Server<T> executor(Executor executor) {
//            server.setExecutor(executor);
//            return this;
//        }
//
//        public void stop() {
//            server.stop(0);
//        }
//
//        public void filter(String pathPrefix, BiConsumer<T, Consumer<T>> filter) {
//            routeFilters.add(new RouteFilter<>(pathPrefix, filter));
//        }
//
//        public HttpContext route(String path, Consumer<T> handler) {
//            String fullPath = buildFullPath(path);
//            return server.createContext(fullPath, httpExchange -> {
//                T exchange = null;
//                try {
//                    exchange = exchangeFactory.apply(httpExchange);
//                    exchange.maxRequestBodySize(maxRequestBodySize);
//                    applyFilters(exchange, handler, 0);
//                } catch (Exception e) {
//                    if (exchange != null) {
//                        try {
//                            errorHandler.accept(exchange, e);
//                        } catch (Exception ex) {
//                            // 记录错误处理器的异常，但不抛出
//                            ex.printStackTrace();
//                        }
//                    }
//                } finally {
//                    if (exchange != null) {
//                        exchange.close();
//                    }
//                }
//            });
//        }
//
//        public void group(String path, Runnable groupRoutes) {
//            routeStack.push(path);
//            try {
//                groupRoutes.run();
//            } finally {
//                routeStack.pop();
//            }
//        }
//
//        private String buildFullPath(String path) {
//            StringBuilder fullPath = new StringBuilder();
//            for (String part : routeStack) {
//                fullPath.insert(0, part);
//            }
//            fullPath.append(path);
//            return fullPath.toString().replaceAll("/{2,}", "/");
//        }
//
//        private void applyFilters(T exchange, Consumer<T> handler, int index) {
//            if (index < routeFilters.size()) {
//                RouteFilter<T> routeFilter = routeFilters.get(index);
//                if (exchange.path().startsWith(routeFilter.pathPrefix)) {
//                    routeFilter.filter.accept(exchange, ex -> applyFilters(ex, handler, index + 1));
//                } else {
//                    applyFilters(exchange, handler, index + 1);
//                }
//            } else {
//                handler.accept(exchange);
//            }
//        }
//
//        private void defaultErrorHandler(T ctx, Exception e) {
//            int status;
//            String message;
//
//            if (e instanceof IllegalArgumentException) {
//                status = 400;
//                message = "Bad Request";
//            } else if (e instanceof SecurityException) {
//                status = 403;
//                message = "Forbidden";
//            } else if (e instanceof FileNotFoundException) {
//                status = 404;
//                message = "Not Found";
//            } else if (e instanceof UnsupportedOperationException) {
//                status = 501;
//                message = "Not Implemented";
//            } else if (e instanceof IOException) {
//                status = 503;
//                message = "Service Unavailable";
//            } else {
//                status = 500;
//                message = "Internal Server Error";
//                e.printStackTrace();
//            }
//
//            message += ": " + e.getMessage();
//            ctx.status(status).result(message);
//        }
//    }
//
//    protected static class RouteFilter<T> {
//        String pathPrefix;
//        BiConsumer<T, Consumer<T>> filter;
//
//        RouteFilter(String pathPrefix, BiConsumer<T, Consumer<T>> filter) {
//            this.pathPrefix = pathPrefix;
//            this.filter = filter;
//        }
//    }
//
//    public static class SseEmitter {
//        private final PrintWriter writer;
//
//        public SseEmitter(PrintWriter writer) {
//            this.writer = writer;
//        }
//
//        public void send(String data) throws IOException {
//            if (writer.checkError()) {  // 检查writer状态
//                throw new IOException("Client disconnected");
//            }
//            writer.println("data: " + data);
//            writer.println();
//            writer.flush();
//        }
//
//        public void send(String event, String data) throws IOException {
//            if (writer.checkError()) {  // 检查writer状态
//                throw new IOException("Client disconnected");
//            }
//            writer.println("event: " + event);
//            writer.println("data: " + data);
//            writer.println();
//            writer.flush();
//        }
//    }
//
//    // 工厂方法
//    public static <T extends Exchange> Server<T> create(Function<HttpExchange, T> contextFactory) {
//        return new Server<>(contextFactory);
//    }
//
//    public static Server<Exchange> create() {
//        return new Server<>(Exchange::new);
//    }
//}