/*
 * Decompiled with CFR 0.152.
 */
package org.valiktor.i18n.formatters;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Currency;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.valiktor.i18n.Formatter;
import org.valiktor.i18n.MessageBundle;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/valiktor/i18n/formatters/MonetaryAmountFormatter;", "Lorg/valiktor/i18n/Formatter;", "Ljavax/money/MonetaryAmount;", "()V", "format", "", "value", "messageBundle", "Lorg/valiktor/i18n/MessageBundle;", "valiktor-javamoney"})
public final class MonetaryAmountFormatter
implements Formatter<MonetaryAmount> {
    public static final MonetaryAmountFormatter INSTANCE;

    @NotNull
    public String format(@NotNull MonetaryAmount value, @NotNull MessageBundle messageBundle) {
        NumberFormat numberFormat;
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)messageBundle, (String)"messageBundle");
        BigDecimal bigNum = ((BigDecimal)value.getNumber().numberValueExact(BigDecimal.class)).stripTrailingZeros();
        int it = n2 = bigNum.precision() - bigNum.scale();
        boolean bl = false;
        int integerDigits = it <= 0 ? 1 : it;
        int it2 = it = bigNum.scale();
        boolean bl2 = false;
        it2 = it = it2 < 0 ? 0 : it2;
        boolean bl3 = false;
        CurrencyUnit currencyUnit = value.getCurrency();
        Intrinsics.checkExpressionValueIsNotNull((Object)currencyUnit, (String)"value.currency");
        if (it2 < currencyUnit.getDefaultFractionDigits()) {
            CurrencyUnit currencyUnit2 = value.getCurrency();
            Intrinsics.checkExpressionValueIsNotNull((Object)currencyUnit2, (String)"value.currency");
            n = currencyUnit2.getDefaultFractionDigits();
        } else {
            n = it2;
        }
        int fractionDigits = n;
        NumberFormat numberFormat2 = numberFormat = NumberFormat.getCurrencyInstance(messageBundle.getLocale());
        Intrinsics.checkExpressionValueIsNotNull((Object)numberFormat2, (String)"numberFormat");
        CurrencyUnit currencyUnit3 = value.getCurrency();
        Intrinsics.checkExpressionValueIsNotNull((Object)currencyUnit3, (String)"value.currency");
        numberFormat2.setCurrency(Currency.getInstance(currencyUnit3.getCurrencyCode()));
        numberFormat.setMinimumIntegerDigits(integerDigits);
        numberFormat.setMaximumIntegerDigits(integerDigits);
        numberFormat.setMinimumFractionDigits(fractionDigits);
        numberFormat.setMaximumFractionDigits(fractionDigits);
        String string = numberFormat.format(bigNum);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"numberFormat.format(bigNum)");
        return string;
    }

    private MonetaryAmountFormatter() {
    }

    static {
        MonetaryAmountFormatter monetaryAmountFormatter;
        INSTANCE = monetaryAmountFormatter = new MonetaryAmountFormatter();
    }
}

