/*
 * Decompiled with CFR 0.152.
 */
package org.valiktor.springframework.web.reactive;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import org.valiktor.ConstraintViolationException;
import org.valiktor.springframework.config.ValiktorConfiguration;
import org.valiktor.springframework.web.payload.UnprocessableEntityKt;
import org.valiktor.springframework.web.reactive.ReactiveConstraintViolationExceptionHandler;
import reactor.core.publisher.Mono;

@Order(value=-10)
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b*\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/valiktor/springframework/web/reactive/ReactiveConstraintViolationExceptionHandler;", "Lorg/springframework/web/server/WebExceptionHandler;", "config", "Lorg/valiktor/springframework/config/ValiktorConfiguration;", "codecConfigurer", "Lorg/springframework/http/codec/CodecConfigurer;", "(Lorg/valiktor/springframework/config/ValiktorConfiguration;Lorg/springframework/http/codec/CodecConfigurer;)V", "handle", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "exchange", "Lorg/springframework/web/server/ServerWebExchange;", "ex", "", "valiktor-spring"})
public final class ReactiveConstraintViolationExceptionHandler
implements WebExceptionHandler {
    private final ValiktorConfiguration config;
    private final CodecConfigurer codecConfigurer;

    @NotNull
    public Mono<Void> handle(@NotNull ServerWebExchange exchange, @NotNull Throwable ex) {
        Intrinsics.checkParameterIsNotNull((Object)exchange, (String)"exchange");
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        Mono mono = this.handle(ex, exchange);
        if (mono == null) {
            Mono mono2 = Mono.error((Throwable)ex);
            mono = mono2;
            Intrinsics.checkExpressionValueIsNotNull((Object)mono2, (String)"Mono.error(ex)");
        }
        return mono;
    }

    private final Mono<Void> handle(@NotNull Throwable $this$handle, ServerWebExchange exchange) {
        Mono mono;
        Throwable throwable = $this$handle;
        if (throwable instanceof ConstraintViolationException) {
            ServerResponse.BodyBuilder bodyBuilder = ServerResponse.unprocessableEntity();
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)$this$handle;
            String string = this.config.getBaseBundleName();
            LocaleContext localeContext = exchange.getLocaleContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)localeContext, (String)"exchange.localeContext");
            Locale locale = localeContext.getLocale();
            if (locale == null) {
                Locale locale2 = Locale.getDefault();
                locale = locale2;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.getDefault()");
            }
            mono = bodyBuilder.body(BodyInserters.fromObject((Object)UnprocessableEntityKt.toUnprocessableEntity(constraintViolationException, string, locale))).flatMap(new Function<T, Mono<? extends R>>(this, exchange){
                final /* synthetic */ ReactiveConstraintViolationExceptionHandler this$0;
                final /* synthetic */ ServerWebExchange $exchange;

                public final Mono<Void> apply(ServerResponse it) {
                    return it.writeTo(this.$exchange, new ServerResponse.Context(this){
                        final /* synthetic */ handle.1 this$0;

                        public List<HttpMessageWriter<?>> messageWriters() {
                            return ReactiveConstraintViolationExceptionHandler.access$getCodecConfigurer$p(this.this$0.this$0).getWriters();
                        }

                        @NotNull
                        public List<ViewResolver> viewResolvers() {
                            return CollectionsKt.emptyList();
                        }
                        {
                            this.this$0 = $outer;
                        }
                    });
                }
                {
                    this.this$0 = reactiveConstraintViolationExceptionHandler;
                    this.$exchange = serverWebExchange;
                }
            }).flatMap((Function)handle.2.INSTANCE);
        } else {
            Throwable throwable2 = $this$handle.getCause();
            mono = throwable2 != null ? this.handle(throwable2, exchange) : null;
        }
        return mono;
    }

    public ReactiveConstraintViolationExceptionHandler(@NotNull ValiktorConfiguration config, @NotNull CodecConfigurer codecConfigurer) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)codecConfigurer, (String)"codecConfigurer");
        this.config = config;
        this.codecConfigurer = codecConfigurer;
    }

    public static final /* synthetic */ CodecConfigurer access$getCodecConfigurer$p(ReactiveConstraintViolationExceptionHandler $this) {
        return $this.codecConfigurer;
    }
}

