/*
 * Decompiled with CFR 0.152.
 */
package org.vatplanner.commons.fileaccess.jgit_adapter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vatplanner.commons.fileaccess.AccessPath;
import org.vatplanner.commons.fileaccess.FileAccessProvider;
import org.vatplanner.commons.fileaccess.FileHolder;
import org.vatplanner.commons.fileaccess.FileInfo;
import org.vatplanner.commons.vcs.VCSRepositoryConfiguration;
import org.vatplanner.commons.vcs.jgit_adapter.JGitVCSRepositoryControl;

public class JGitFileAccessProvider
implements FileAccessProvider.RandomAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitFileAccessProvider.class);
    private final Repository repository;
    private final RevTree revTree;
    private static final Collection<Predicate<File>> META_DATA_DIRECTORY_REQUIREMENTS = Arrays.asList(item -> "index".equals(item.getName()) && item.isFile(), item -> "HEAD".equals(item.getName()) && item.isFile(), item -> "logs".equals(item.getName()) && item.isDirectory(), item -> "objects".equals(item.getName()) && item.isDirectory(), item -> "refs".equals(item.getName()) && item.isDirectory());

    public JGitFileAccessProvider(File repositoryPath) {
        this(JGitFileAccessProvider.findRepository(repositoryPath));
    }

    public JGitFileAccessProvider(File repositoryPath, String refString) {
        this.repository = JGitFileAccessProvider.findRepository(repositoryPath);
        this.revTree = this.findTreeForCommit(refString);
    }

    public JGitFileAccessProvider(VCSRepositoryConfiguration configuration) {
        if (!"git".equals(configuration.getSystem())) {
            throw new IllegalArgumentException("VCS repository is not configured for system 'git'");
        }
        File repositoryPath = configuration.getStorage();
        this.repository = JGitFileAccessProvider.findRepository(repositoryPath);
        RevTree revTree = null;
        String refString = configuration.getBranch().orElse("HEAD");
        try {
            revTree = this.findTreeForCommit(refString);
        }
        catch (Exception ex) {
            LOGGER.debug("\"{}\" does not exist in repository {}, trying with default remote name", new Object[]{refString, repositoryPath, ex});
        }
        if (revTree == null) {
            try {
                revTree = this.findTreeForCommit("remotes/" + JGitVCSRepositoryControl.DEFAULT_REMOTE_NAME + "/" + refString);
            }
            catch (Exception ex) {
                throw new RepositoryAccessFailed("\"" + refString + "\" does not exist in repository " + repositoryPath, ex);
            }
        }
        this.revTree = revTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JGitFileAccessProvider(Repository repository) {
        Repository repository2 = this.repository = repository;
        synchronized (repository2) {
            boolean hasRefs;
            try {
                hasRefs = !repository.getRefDatabase().getRefs().isEmpty();
            }
            catch (IOException ex) {
                throw new RepositoryAccessFailed("Repository at " + repository.getDirectory() + " could not be accessed", ex);
            }
            if (!hasRefs) {
                throw new RepositoryAccessFailed("Repository at " + repository.getDirectory() + " is empty (check path; this also happens if no repository is present at the specified location)");
            }
        }
        try {
            this.revTree = this.findTreeForCommit("HEAD");
        }
        catch (Exception ex) {
            throw new RepositoryAccessFailed("Failed to find HEAD revision; check if the repository exists. In case it is bare, direct specification of a refString may be required.", ex);
        }
    }

    private JGitFileAccessProvider(Repository repository, RevTree revTree) {
        this.repository = repository;
        this.revTree = revTree;
    }

    public JGitFileAccessProvider atCommit(String refString) {
        return new JGitFileAccessProvider(this.repository, this.findTreeForCommit(refString));
    }

    public Stream<FileHolder> streamFiles() {
        Stream.Builder streamBuilder = Stream.builder();
        this.forEach((fileInfo, objectLoader) -> streamBuilder.accept(new FileHolder(fileInfo, objectLoader.getBytes())));
        return streamBuilder.build();
    }

    public Stream<FileHolder> streamFiles(Predicate<FileInfo> filter) {
        Stream.Builder<FileHolder> streamBuilder = Stream.builder();
        this.forEach(filter, streamBuilder);
        return streamBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<FileHolder> getFile(AccessPath path) {
        String treePath = String.join((CharSequence)"/", path.getPathSegments());
        Repository repository = this.repository;
        synchronized (repository) {
            try {
                ObjectId objectId;
                try (TreeWalk treeWalk = TreeWalk.forPath((Repository)this.repository, (String)treePath, (RevTree)this.revTree);){
                    if (treeWalk == null) {
                        Optional<FileHolder> optional = Optional.empty();
                        return optional;
                    }
                    objectId = treeWalk.getObjectId(0);
                }
                ObjectLoader objectLoader = this.repository.open((AnyObjectId)objectId);
                return Optional.of(new FileHolder(FileInfo.builder().setSize(objectLoader.getSize()).setPath(path).build(), objectLoader.getBytes()));
            }
            catch (IOException ex) {
                throw new RepositoryAccessFailed("Failed to look up " + path + " (" + treePath + ")", ex);
            }
        }
    }

    public Set<FileInfo> listFiles() {
        HashSet<FileInfo> out = new HashSet<FileInfo>();
        this.forEach((fileInfo, objectLoader) -> out.add(fileInfo));
        return out;
    }

    public void forEach(Predicate<FileInfo> filter, Consumer<FileHolder> consumer) {
        this.forEach((fileInfo, objectLoader) -> {
            if (filter.test(fileInfo)) {
                consumer.accept(new FileHolder(fileInfo, objectLoader.getBytes()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEach(TreeWalkVisitor visitor) {
        Repository repository = this.repository;
        synchronized (repository) {
            try (TreeWalk treeWalk = new TreeWalk(this.repository);){
                treeWalk.addTree((AnyObjectId)this.revTree);
                treeWalk.setRecursive(true);
                while (treeWalk.next()) {
                    boolean isFile;
                    int fileModeBits = treeWalk.getFileMode().getBits();
                    boolean bl = isFile = (fileModeBits & 0x8000) != 0;
                    if (!isFile) continue;
                    String[] pathSegments = treeWalk.getPathString().split("/");
                    AccessPath accessPath = new AccessPath(Arrays.asList(pathSegments), AccessPath.Type.FILE);
                    ObjectLoader objectLoader = this.repository.open((AnyObjectId)treeWalk.getObjectId(0));
                    FileInfo fileInfo = FileInfo.builder().setPath(accessPath).setSize(objectLoader.getSize()).build();
                    visitor.visit(fileInfo, objectLoader);
                }
            }
            catch (IOException ex) {
                throw new RepositoryAccessFailed("Failed to walk tree on repository " + this.repository.getDirectory() + " (ObjectId: " + this.revTree.toObjectId() + ")", ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RevTree findTreeForCommit(String refString) {
        Repository repository = this.repository;
        synchronized (repository) {
            ObjectId objectId;
            Ref ref;
            try {
                ref = this.repository.findRef(refString);
            }
            catch (IOException ex) {
                throw new RepositoryAccessFailed("Ref string \"" + refString + "\" search failed on repository " + this.repository.getDirectory(), ex);
            }
            ObjectId objectId2 = objectId = ref != null ? ref.getObjectId() : ObjectId.fromString((String)refString);
            if (objectId == null) {
                throw new RepositoryAccessFailed("No object ID found for ref string \"" + refString + "\" on repository " + this.repository.getDirectory());
            }
            try (RevWalk revWalk = new RevWalk(this.repository);){
                RevTree revTree = revWalk.parseCommit((AnyObjectId)objectId).getTree();
                return revTree;
            }
            catch (IOException ex) {
                throw new RepositoryAccessFailed("No commit found for ref string \"" + refString + "\" on repository " + this.repository.getDirectory() + " (ObjectId: " + objectId + ")", ex);
            }
        }
    }

    private static Repository findRepository(File directory) {
        if (!directory.exists()) {
            throw new RepositoryAccessFailed("Not found: " + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new RepositoryAccessFailed("Not a directory: " + directory.getAbsolutePath());
        }
        File metaDataDirectory = JGitFileAccessProvider.findMetaDataDirectory(directory);
        if (metaDataDirectory == null) {
            LOGGER.warn("Directory does not seem to hold repository meta data but will be tried regardless: {}", (Object)directory.getAbsolutePath());
            metaDataDirectory = directory;
        }
        try {
            return ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(metaDataDirectory)).readEnvironment()).findGitDir()).build();
        }
        catch (IOException ex) {
            throw new RepositoryAccessFailed("No repository found in " + directory, ex);
        }
    }

    private static File findMetaDataDirectory(File directory) {
        if (JGitFileAccessProvider.isMetaDataDirectory(directory)) {
            return directory;
        }
        for (File item : JGitFileAccessProvider.listDirectory(directory)) {
            if (!item.isDirectory() || !JGitFileAccessProvider.isMetaDataDirectory(item)) continue;
            return item;
        }
        return null;
    }

    private static boolean isMetaDataDirectory(File directory) {
        ArrayList<Predicate<File>> unfulfilledRequirements = new ArrayList<Predicate<File>>(META_DATA_DIRECTORY_REQUIREMENTS);
        for (File item : JGitFileAccessProvider.listDirectory(directory)) {
            unfulfilledRequirements.removeIf(requirement -> requirement.test(item));
            if (!unfulfilledRequirements.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static List<File> listDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Unable to list directory at " + directory.getAbsolutePath());
        }
        return Arrays.asList(files);
    }

    private static class RepositoryAccessFailed
    extends RuntimeException {
        private RepositoryAccessFailed(String msg) {
            super(msg);
        }

        private RepositoryAccessFailed(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static interface TreeWalkVisitor {
        public void visit(FileInfo var1, ObjectLoader var2) throws IOException;
    }
}

