/*
 * Decompiled with CFR 0.152.
 */
package org.vatplanner.commons.vcs.jgit_adapter;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vatplanner.commons.vcs.Revision;
import org.vatplanner.commons.vcs.RevisionVisitor;
import org.vatplanner.commons.vcs.VCSRepositoryConfiguration;
import org.vatplanner.commons.vcs.VCSRepositoryControl;
import org.vatplanner.commons.vcs.VCSRepositoryControlFactory;
import org.vatplanner.commons.vcs.jgit_adapter.LoggingProgressMonitor;

public class JGitVCSRepositoryControl
extends VCSRepositoryControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitVCSRepositoryControl.class);
    private static final String SYSTEM = "git";
    public static final String DEFAULT_REMOTE_NAME = "_" + JGitVCSRepositoryControl.class.getSimpleName();
    private final URIish upstreamLocation;
    private final Repository repo;
    private final Git git;
    private final String remoteName;
    private final CredentialsProvider credentialsProvider;
    private final String branchName;

    private JGitVCSRepositoryControl(VCSRepositoryConfiguration config) {
        if (!SYSTEM.equals(config.getSystem())) {
            throw new IllegalArgumentException("Wrong system: '" + config.getSystem() + "'");
        }
        this.remoteName = DEFAULT_REMOTE_NAME;
        boolean isBareRepository = true;
        this.branchName = config.getBranch().orElse(null);
        try {
            this.upstreamLocation = this.toUriish(config.getUrl()).orElse(null);
            File storage = config.getStorage();
            if (!storage.exists() && !storage.mkdirs()) {
                throw new VCSRepositoryControl.ConfigurationFailed("Unable to create directory: " + storage);
            }
            String username = config.getUsername().orElse(null);
            char[] password = config.getPassword().orElse(new char[0]);
            this.credentialsProvider = this.upstreamLocation == null || username == null ? null : new UsernamePasswordProvider(this.upstreamLocation, username, password);
            RepositoryBuilder repoBuilder = (RepositoryBuilder)new RepositoryBuilder().setGitDir(storage);
            if (isBareRepository) {
                repoBuilder.setBare();
            }
            this.repo = repoBuilder.build();
            if (!this.repo.getObjectDatabase().exists()) {
                String[] list = storage.list();
                if (list == null) {
                    throw new VCSRepositoryControl.ConfigurationFailed("Storage directory does not appear to contain a Git repository, contents could not be listed: " + storage);
                }
                if (list.length != 0) {
                    throw new VCSRepositoryControl.ConfigurationFailed("Storage directory is not empty but does not contain a Git repository either: " + storage);
                }
                this.repo.create(isBareRepository);
            }
            this.git = new Git(this.repo);
        }
        catch (IOException ex) {
            throw new VCSRepositoryControl.ConfigurationFailed("Failed to configure VCS control", (Throwable)ex);
        }
    }

    private Optional<URIish> toUriish(Optional<String> url) {
        if (!url.isPresent()) {
            return Optional.empty();
        }
        try {
            return Optional.of(new URIish(url.get()));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("invalid URI: '" + url.get() + "'", ex);
        }
    }

    public void syncDown(Duration timeout) {
        if (this.upstreamLocation == null) {
            LOGGER.warn("no upstream location has been configured, repository only exists locally");
            return;
        }
        try {
            this.ensureRemoteUri(this.remoteName, this.upstreamLocation);
            LOGGER.info("fetching from {}", (Object)this.upstreamLocation);
            ((FetchCommand)((FetchCommand)this.git.fetch().setRemote(this.remoteName).setCredentialsProvider(this.credentialsProvider)).setProgressMonitor((ProgressMonitor)new LoggingProgressMonitor(LOGGER, "[fetch " + this.upstreamLocation + "] ")).setTimeout(Math.max(1, (int)timeout.getSeconds()))).call();
            LOGGER.info("fetch from {} completed", (Object)this.upstreamLocation);
        }
        catch (GitAPIException ex) {
            throw new VCSRepositoryControl.OperationFailed("failed to fetch from remote location (sync down) at " + this.upstreamLocation, (Throwable)ex);
        }
    }

    private ObjectId findBranchObjectId(String expectedName) {
        List matched;
        String expectedRefName = "refs/" + expectedName;
        try {
            matched = this.git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call().stream().filter(ref -> expectedRefName.equals(ref.getName())).map(Ref::getObjectId).collect(Collectors.toList());
        }
        catch (GitAPIException ex) {
            throw new VCSRepositoryControl.OperationFailed("failed to list branches of repository at " + this.repo.getDirectory(), (Throwable)ex);
        }
        if (matched.isEmpty()) {
            throw new IllegalArgumentException("branch '" + expectedName + "' not found in repository at " + this.repo.getDirectory());
        }
        if (matched.size() != 1) {
            throw new IllegalArgumentException("branch '" + expectedName + "' is ambiguous in repository at " + this.repo.getDirectory());
        }
        return (ObjectId)matched.iterator().next();
    }

    public void walkLog(RevisionVisitor visitor) {
        Iterable commits;
        String wantedBranchName;
        LogCommand command = this.git.log();
        ObjectId startRef = null;
        String string = wantedBranchName = this.branchName != null ? this.branchName : "";
        if (this.remoteName != null) {
            if (this.branchName == null) {
                throw new VCSRepositoryControl.OperationFailed("branches of remotes/bare repositories can only be located if a branch name is set");
            }
            wantedBranchName = "remotes/" + this.remoteName + "/" + wantedBranchName;
        }
        if (!wantedBranchName.isEmpty()) {
            startRef = this.findBranchObjectId(wantedBranchName);
        }
        try {
            if (startRef != null) {
                command.add((AnyObjectId)startRef);
            }
        }
        catch (IncorrectObjectTypeException | MissingObjectException ex) {
            throw new VCSRepositoryControl.OperationFailed("invalid branch: '" + this.branchName + "' resolved to object ID " + startRef + " failed lookup in repository at " + this.repo.getDirectory(), ex);
        }
        try {
            commits = command.call();
        }
        catch (GitAPIException ex) {
            throw new VCSRepositoryControl.OperationFailed("failed to retrieve log (walk history) of repository at " + this.repo.getDirectory() + " " + (wantedBranchName.isEmpty() ? "(no branch)" : "(branch " + wantedBranchName + " => " + startRef + ")"), (Throwable)ex);
        }
        for (RevCommit commit : commits) {
            RevisionVisitor.Action action;
            Revision.Builder builder = Revision.builder().setId(commit.getName()).setParentIds((Collection)Arrays.stream(commit.getParents()).map(AnyObjectId::getName).collect(Collectors.toList())).setTimestamp(Instant.ofEpochSecond(commit.getCommitTime()));
            String message = commit.getFullMessage();
            if (message != null) {
                builder.setMessage(message.trim());
            }
            if ((action = visitor.visit(builder.build())) == RevisionVisitor.Action.ABORT_WALK) break;
            if (action == RevisionVisitor.Action.CONTINUE_WALK) continue;
            throw new IllegalArgumentException("Unhandled walker action: " + action);
        }
    }

    private void ensureRemoteUri(String remoteName, URIish uri) throws GitAPIException {
        boolean remoteExists = this.git.remoteList().call().stream().map(RemoteConfig::getName).anyMatch(remoteName::equals);
        if (remoteExists) {
            this.git.remoteSetUrl().setRemoteName(remoteName).setRemoteUri(uri).call();
        } else {
            this.git.remoteAdd().setName(remoteName).setUri(uri).call();
        }
    }

    public void close() throws IOException {
        this.git.close();
    }

    @AutoService(value={VCSRepositoryControlFactory.class})
    public static class Factory
    implements VCSRepositoryControlFactory {
        public String getSupportedSystem() {
            return JGitVCSRepositoryControl.SYSTEM;
        }

        public VCSRepositoryControl createFromConfiguration(VCSRepositoryConfiguration config) {
            return new JGitVCSRepositoryControl(config);
        }
    }

    private static class UsernamePasswordProvider
    extends CredentialsProvider {
        private final URIish location;
        private final String username;
        private final char[] password;

        UsernamePasswordProvider(URIish location, String username, char[] password) {
            this.location = location;
            this.username = username;
            this.password = password;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean supports(CredentialItem ... items) {
            LOGGER.debug("backend checks credential support");
            return this.supportsInternally(items);
        }

        public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
            LOGGER.debug("backend wants credentials for {}", (Object)uri);
            if (!Objects.equals(uri, this.location)) {
                LOGGER.warn("backend requested credentials for unexpected location {}", (Object)uri);
                return false;
            }
            if (!this.supportsInternally(items)) {
                LOGGER.warn("backend requested unsupported authentication method for {}: {}", (Object)uri, (Object)items);
                return false;
            }
            for (CredentialItem item : items) {
                if (item instanceof CredentialItem.Username) {
                    ((CredentialItem.Username)item).setValue(this.username);
                    continue;
                }
                if (!(item instanceof CredentialItem.Password)) continue;
                ((CredentialItem.Password)item).setValue(this.password);
            }
            return true;
        }

        private boolean supportsInternally(CredentialItem[] items) {
            boolean wantsUsername = false;
            boolean wantsPassword = false;
            boolean wantsOther = false;
            for (CredentialItem item : items) {
                if (item instanceof CredentialItem.Username) {
                    LOGGER.debug("backend wants username: {}", (Object)item);
                    wantsUsername = true;
                    continue;
                }
                if (item instanceof CredentialItem.Password) {
                    LOGGER.debug("backend wants password: {}", (Object)item);
                    wantsPassword = true;
                    continue;
                }
                LOGGER.debug("backend wants unsupported credential type: {}", (Object)item);
                wantsOther = true;
            }
            if (!wantsUsername || !wantsPassword) {
                LOGGER.debug("only username and password are implemented for authentication, backend asked for something else");
                return false;
            }
            if (wantsOther) {
                LOGGER.debug("something else was requested in addition to username and password, blocking");
                return false;
            }
            return true;
        }
    }
}

