/*
 * Decompiled with CFR 0.152.
 */
package org.vatplanner.commons.vcs.jgit_adapter;

import java.time.Duration;
import java.time.Instant;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.slf4j.Logger;

class LoggingProgressMonitor
implements ProgressMonitor {
    private final Logger logger;
    private final String logPrefix;
    private final Duration progressUpdateCooldown;
    private static final String DEFAULT_TITLE = "<unknown>";
    private String totalTaskLogPrefix = "";
    private int task = 0;
    private int totalTasks = 0;
    private int totalWork = 0;
    private int workCompleted = 0;
    private String title = null;
    private Instant nextProgressUpdateWanted = Instant.EPOCH;

    LoggingProgressMonitor(Logger logger, String logPrefix) {
        this(logger, logPrefix, Duration.ofSeconds(5L));
    }

    LoggingProgressMonitor(Logger logger, String logPrefix, Duration progressUpdateCooldown) {
        this.logger = logger;
        this.logPrefix = logPrefix;
        this.progressUpdateCooldown = progressUpdateCooldown;
    }

    public void start(int totalTasks) {
        this.totalTasks = totalTasks;
    }

    public void beginTask(String title, int totalWork) {
        this.title = title;
        this.totalWork = totalWork;
        ++this.task;
        this.workCompleted = 0;
        this.nextProgressUpdateWanted = Instant.EPOCH;
        this.totalTaskLogPrefix = this.totalTasks <= 0 || this.task > this.totalTasks ? "" : String.format("[%d/%d] ", this.task, this.totalTasks);
        this.logger.info("{}{}[{}] task started", new Object[]{this.logPrefix, this.totalTaskLogPrefix, title});
    }

    public void update(int completed) {
        if (completed == 0) {
            return;
        }
        this.workCompleted += completed;
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        if (Instant.now().isBefore(this.nextProgressUpdateWanted)) {
            return;
        }
        this.nextProgressUpdateWanted = Instant.now().plus(this.progressUpdateCooldown);
        if (this.totalWork <= 0) {
            this.logger.info("{}{}[{}] progress: {}", new Object[]{this.logPrefix, this.totalTaskLogPrefix, this.title, this.workCompleted});
        } else {
            this.logger.info("{}{}[{}] progress: {}", new Object[]{this.logPrefix, this.totalTaskLogPrefix, this.title, String.format("%.1f%%", (double)this.workCompleted / (double)this.totalWork * 100.0)});
        }
    }

    public void endTask() {
        this.logger.info("{}{}[{}] task finished", new Object[]{this.logPrefix, this.totalTaskLogPrefix, this.title});
        this.nextProgressUpdateWanted = Instant.EPOCH;
        this.totalTaskLogPrefix = "";
        this.title = DEFAULT_TITLE;
        this.totalWork = 0;
        this.workCompleted = 0;
    }

    public boolean isCancelled() {
        return false;
    }
}

