/*
 * Decompiled with CFR 0.152.
 */
package org.vatplanner.commons.amqp;

import java.util.Objects;
import java.util.Properties;
import org.vatplanner.commons.utils.PropertiesHelper;

public class ExchangeParameters {
    private final String name;
    private final boolean declare;
    private final String defaultRoutingKey;
    private final boolean durable;
    private final String type;
    private static final String PREFIX = "amqp.exchanges.";
    private static final String DECLARE_SUFFIX = ".declare";
    private static final String DEFAULT_ROUTING_KEY_SUFFIX = ".defaultRoutingKey";
    private static final String DURABLE_SUFFIX = ".durable";
    private static final String NAME_SUFFIX = ".name";
    private static final String TYPE_SUFFIX = ".type";

    private ExchangeParameters(String name, boolean declare, String defaultRoutingKey, boolean durable, String type) {
        this.name = name;
        this.declare = declare;
        this.defaultRoutingKey = defaultRoutingKey;
        this.durable = durable;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldDeclare() {
        return this.declare;
    }

    public String getDefaultRoutingKey() {
        return this.defaultRoutingKey;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "ExchangeParameters(name=\"" + this.name + "\", type=\"" + this.type + "\", declare=" + this.declare + ", durable=" + this.durable + ", defaultRoutingKey=\"" + this.defaultRoutingKey + "\")";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String defaultName;
        private boolean defaultDeclare = true;
        private String defaultDefaultRoutingKey = "";
        private boolean defaultDurable = true;
        private String defaultType = "direct";

        public Builder defaultingToName(String name) {
            this.defaultName = name;
            return this;
        }

        public Builder defaultingToDeclare(boolean declare) {
            this.defaultDeclare = declare;
            return this;
        }

        public Builder defaultingToDefaultRoutingKey(String defaultRoutingKey) {
            this.defaultDefaultRoutingKey = defaultRoutingKey;
            return this;
        }

        public Builder defaultingToDurable(boolean durable) {
            this.defaultDurable = durable;
            return this;
        }

        public Builder defaultingToType(String type) {
            this.defaultType = type;
            return this;
        }

        public ExchangeParameters build(Properties config, String exchangeKeyName) {
            Objects.requireNonNull(this.defaultName, "default name must be set");
            return new ExchangeParameters(PropertiesHelper.getNonEmpty((Properties)config, (String)(ExchangeParameters.PREFIX + exchangeKeyName + ExchangeParameters.NAME_SUFFIX)).orElse(this.defaultName), PropertiesHelper.getNonEmpty((Properties)config, (String)(ExchangeParameters.PREFIX + exchangeKeyName + ExchangeParameters.DECLARE_SUFFIX)).map(Boolean::parseBoolean).orElse(this.defaultDeclare), PropertiesHelper.getNonEmpty((Properties)config, (String)(ExchangeParameters.PREFIX + exchangeKeyName + ExchangeParameters.DEFAULT_ROUTING_KEY_SUFFIX)).orElse(this.defaultDefaultRoutingKey), PropertiesHelper.getNonEmpty((Properties)config, (String)(ExchangeParameters.PREFIX + exchangeKeyName + ExchangeParameters.DURABLE_SUFFIX)).map(Boolean::parseBoolean).orElse(this.defaultDurable), PropertiesHelper.getNonEmpty((Properties)config, (String)(ExchangeParameters.PREFIX + exchangeKeyName + ExchangeParameters.TYPE_SUFFIX)).orElse(this.defaultType));
        }
    }
}

