/*
 * Decompiled with CFR 0.152.
 */
package org.vatplanner.commons.amqp;

import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonKey;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import com.rabbitmq.client.AMQP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vatplanner.commons.amqp.Message;

public class MessageCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageCodec.class);
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String PGP_ENCRYPTED_CONTENT_TYPE = "application/pgp-encrypted";
    private static final int CURRENT_FORMAT_VERSION = 1;
    private final Map<String, Message.Parser<?>> parsersByMessageType = new HashMap();

    public MessageCodec() {
        for (Message.Parser parser : ServiceLoader.load(Message.Parser.class)) {
            Message.Parser previousParser = this.parsersByMessageType.put(parser.getMessageType(), parser);
            if (previousParser == null) continue;
            throw new AmbiguousParsers(previousParser, parser);
        }
    }

    public byte[] serialize(AMQP.BasicProperties.Builder propertiesBuilder, Message message) {
        byte[] bytes;
        String messageType = message.getMessageType();
        JsonObject out = message.toJson();
        this.requireNotSet(out, ContainerKey.MESSAGE_TYPE, "Message type blocks container key " + (Object)((Object)ContainerKey.MESSAGE_TYPE) + "; unable to serialize.");
        this.requireNotSet(out, ContainerKey.FORMAT_VERSION, "Message type blocks container key " + (Object)((Object)ContainerKey.FORMAT_VERSION) + "; unable to serialize.");
        out.put((JsonKey)ContainerKey.MESSAGE_TYPE, (Object)messageType);
        out.put((JsonKey)ContainerKey.FORMAT_VERSION, (Object)1);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);){
            out.toJson((Writer)osw);
            osw.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to serialize " + message, ex);
        }
        propertiesBuilder.contentType(JSON_CONTENT_TYPE);
        return bytes;
    }

    private void requireNotSet(JsonObject out, JsonKey key, String msg) {
        if (out.containsKey((Object)key.getKey())) {
            throw new IllegalArgumentException(msg);
        }
    }

    public Optional<Message> deserialize(AMQP.BasicProperties properties, byte[] body) {
        JsonObject json;
        String contentType = properties.getContentType();
        if (contentType != null && !JSON_CONTENT_TYPE.equals(contentType) && !PGP_ENCRYPTED_CONTENT_TYPE.equals(contentType)) {
            LOGGER.warn("Message received from AMQP with unhandled content type \"{}\"", (Object)contentType);
            return Optional.empty();
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(body);
             InputStreamReader isr = new InputStreamReader((InputStream)bais, StandardCharsets.UTF_8);){
            json = (JsonObject)Jsoner.deserialize((Reader)isr);
        }
        catch (JsonException | IOException | ClassCastException ex) {
            LOGGER.warn("Failed to read JSON message", ex);
            return Optional.empty();
        }
        try {
            json.requireKeys(new JsonKey[]{ContainerKey.FORMAT_VERSION, ContainerKey.MESSAGE_TYPE});
            int actualFormatVersion = json.getInteger((JsonKey)ContainerKey.FORMAT_VERSION);
            if (actualFormatVersion != 1) {
                LOGGER.warn("Received message indicates format version {} but this implementation only supports {}", (Object)actualFormatVersion, (Object)1);
                return Optional.empty();
            }
            String messageType = json.getString((JsonKey)ContainerKey.MESSAGE_TYPE);
            Message.Parser<?> parser = this.parsersByMessageType.get(messageType);
            if (parser == null) {
                LOGGER.warn("Unhandled message type \"{}\"", (Object)messageType);
                return Optional.empty();
            }
            return Optional.of(parser.fromJson(json));
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to process JSON message", (Throwable)ex);
            return Optional.empty();
        }
    }

    private static class AmbiguousParsers
    extends RuntimeException {
        AmbiguousParsers(Message.Parser ... parsers) {
            super("Multiple parsers are present for message type \"" + parsers[0].getMessageType() + "\": " + Arrays.stream(parsers).map(Object::getClass).map(Class::getCanonicalName).collect(Collectors.joining(", ")));
        }
    }

    private static enum ContainerKey implements JsonKey
    {
        FORMAT_VERSION("_containerFormatVersion"),
        MESSAGE_TYPE("_messageType");

        private final String key;

        private ContainerKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return null;
        }
    }
}

