/*
 * Decompiled with CFR 0.152.
 */
package org.vatplanner.commons.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class MessageSupplements {
    private final Envelope amqpEnvelope;
    private final AMQP.BasicProperties amqpProperties;
    private final Set<Long> verifiedKeyIds;
    private final byte[] payload;
    private final Supplier<Boolean> acknowledge;

    private MessageSupplements(Envelope amqpEnvelope, AMQP.BasicProperties amqpProperties, Set<Long> verifiedKeyIds, byte[] payload, Supplier<Boolean> acknowledge) {
        this.amqpEnvelope = amqpEnvelope;
        this.amqpProperties = amqpProperties;
        this.verifiedKeyIds = new HashSet<Long>(verifiedKeyIds);
        this.payload = payload;
        this.acknowledge = acknowledge;
    }

    public Envelope getAmqpEnvelope() {
        return this.amqpEnvelope;
    }

    public AMQP.BasicProperties getAmqpProperties() {
        return this.amqpProperties;
    }

    public Set<Long> getVerifiedKeyIds() {
        return Collections.unmodifiableSet(this.verifiedKeyIds);
    }

    public Optional<byte[]> getPayload() {
        return Optional.ofNullable(this.payload);
    }

    public boolean acknowledgeMessage() {
        return this.acknowledge.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Envelope amqpEnvelope;
        private AMQP.BasicProperties amqpProperties;
        private Set<Long> verifiedKeyIds;
        private byte[] payload;
        private Supplier<Boolean> acknowledge;

        private Builder() {
        }

        public Builder setAmqpEnvelope(Envelope amqpEnvelope) {
            this.amqpEnvelope = amqpEnvelope;
            return this;
        }

        public Builder setAmqpProperties(AMQP.BasicProperties amqpProperties) {
            this.amqpProperties = amqpProperties;
            return this;
        }

        public Builder setPayload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        public Builder setVerifiedKeyIds(Set<Long> verifiedKeyIds) {
            this.verifiedKeyIds = new HashSet<Long>(verifiedKeyIds);
            return this;
        }

        public Builder onAcknowledge(Supplier<Boolean> acknowledge) {
            this.acknowledge = acknowledge;
            return this;
        }

        public MessageSupplements build() {
            return new MessageSupplements(this.amqpEnvelope, this.amqpProperties, this.verifiedKeyIds, this.payload, this.acknowledge);
        }
    }
}

