/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.Indexer;
import org.vechain.indexer.Status;
import org.vechain.indexer.exception.BlockNotFoundException;
import org.vechain.indexer.exception.ReorgException;
import org.vechain.indexer.thor.client.ThorClient;
import org.vechain.indexer.thor.model.Block;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\"\u001a\u00020#H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0011\u0010%\u001a\u00020#H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0011\u0010&\u001a\u00020'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0019\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\u0005H&J\b\u0010,\u001a\u00020#H\u0002J\b\u0010-\u001a\u00020#H\u0002J\b\u0010.\u001a\u00020#H\u0002J\b\u0010/\u001a\u000200H\u0002J\u001b\u00101\u001a\u00020#2\b\b\u0002\u0010)\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0019\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020#2\u0006\u00103\u001a\u00020'H&J\u0011\u00106\u001a\u00020#H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0010\u00107\u001a\u00020#2\u0006\u0010)\u001a\u00020\u0005H&J\u0011\u00108\u001a\u00020#H\u0082P\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u001d\u00109\u001a\u00020#2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0017\u0010<\u001a\u00020#2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010=R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006>"}, d2={"Lorg/vechain/indexer/Indexer;", "", "thorClient", "Lorg/vechain/indexer/thor/client/ThorClient;", "startBlock", "", "syncLoggerInterval", "(Lorg/vechain/indexer/thor/client/ThorClient;JJ)V", "backoffPeriod", "<set-?>", "currentBlockNumber", "getCurrentBlockNumber", "()J", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "name", "", "getName", "()Ljava/lang/String;", "previousBlockId", "remainingIterations", "Ljava/lang/Long;", "Lorg/vechain/indexer/Status;", "status", "getStatus", "()Lorg/vechain/indexer/Status;", "getThorClient", "()Lorg/vechain/indexer/thor/client/ThorClient;", "Ljava/time/LocalDateTime;", "timeLastProcessed", "getTimeLastProcessed", "()Ljava/time/LocalDateTime;", "backoffDelay", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ensureFullySynced", "getBestBlockFromChain", "Lorg/vechain/indexer/thor/model/Block;", "getBlockFromChain", "blockNumber", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastSyncedBlockNumber", "handleError", "handleFullySynced", "handleReorg", "hasNoRemainingIterations", "", "initialise", "postProcessBlock", "block", "(Lorg/vechain/indexer/thor/model/Block;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processBlock", "restart", "rollback", "run", "start", "iterations", "(Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startInCoroutine", "(Ljava/lang/Long;)V", "indexer-core"})
public abstract class Indexer {
    @NotNull
    private final ThorClient thorClient;
    private final long startBlock;
    private final long syncLoggerInterval;
    @Nullable
    private String previousBlockId;
    @Nullable
    private Long remainingIterations;
    @NotNull
    private final Logger logger;
    @NotNull
    private Status status;
    private long currentBlockNumber;
    @NotNull
    private LocalDateTime timeLastProcessed;
    private long backoffPeriod;

    public Indexer(@NotNull ThorClient thorClient, long startBlock, long syncLoggerInterval) {
        Intrinsics.checkNotNullParameter((Object)thorClient, (String)"thorClient");
        this.thorClient = thorClient;
        this.startBlock = startBlock;
        this.syncLoggerInterval = syncLoggerInterval;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
        this.status = Status.SYNCING;
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(ZoneOffset.UTC)");
        this.timeLastProcessed = localDateTime;
    }

    public /* synthetic */ Indexer(ThorClient thorClient, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = 1000L;
        }
        this(thorClient, l, l2);
    }

    @NotNull
    protected ThorClient getThorClient() {
        return this.thorClient;
    }

    @NotNull
    public final String getName() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.simpleName");
        return string;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    public final long getCurrentBlockNumber() {
        return this.currentBlockNumber;
    }

    @NotNull
    public final LocalDateTime getTimeLastProcessed() {
        return this.timeLastProcessed;
    }

    /*
     * Unable to fully structure code
     */
    private final Object initialise(long var1_1, Continuation<? super Unit> var3_2) {
        if (!(var3_2 instanceof initialise.1)) ** GOTO lbl-1000
        var6_3 = var3_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ Indexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Indexer.access$initialise(this.this$0, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.rollback((long)blockNumber);
                this.currentBlockNumber = blockNumber;
                this.status = Status.SYNCING;
                var4_6 = this;
                $continuation.L$0 = var4_6;
                $continuation.label = 1;
                v0 = this.getBlockFromChain(Math.max(var1_1 - 1L, 0L), (Continuation<? super Block>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                var4_6 = (Indexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var4_6.previousBlockId = ((Block)v0).getId();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object initialise$default(Indexer indexer, long l, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialise");
        }
        if ((n & 1) != 0) {
            l = Math.max(indexer.getLastSyncedBlockNumber(), indexer.startBlock);
        }
        return indexer.initialise(l, (Continuation<? super Unit>)continuation);
    }

    public final void startInCoroutine(@Nullable Long iterations) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, iterations, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Indexer this$0;
            final /* synthetic */ Long $iterations;
            {
                this.this$0 = $receiver;
                this.$iterations = $iterations;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        Object object3 = this.this$0.start(this.$iterations, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            this.this$0.getLogger().error("Error starting indexer " + $this$launch.getClass().getSimpleName() + ": ", (Throwable)e);
                            throw new Exception(e.getMessage(), e);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void startInCoroutine$default(Indexer indexer, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startInCoroutine");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        indexer.startInCoroutine(l);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object start(@Nullable Long var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof start.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ Indexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.start(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.remainingIterations = iterations;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = Indexer.initialise$default(this, 0L, (Continuation)$continuation, 1, null);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (Indexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                this.logger.info("Starting @ Block: " + this.currentBlockNumber);
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this.run((Continuation<? super Unit>)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl33
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object start$default(Indexer indexer, Long l, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        return indexer.start(l, (Continuation<? super Unit>)continuation);
    }

    /*
     * Exception decompiling
     */
    private final Object restart(Continuation<? super Unit> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object run(Continuation<? super Unit> var1_1) {
        block29: {
            if (!(var1_1 instanceof run.1)) ** GOTO lbl-1000
            var4_2 = var1_1;
            if ((var4_2.label & -2147483648) != 0) {
                var4_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Indexer this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Indexer.access$run(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
lbl12:
                    // 2 sources

                    while (true) {
                        if (this.hasNoRemainingIterations()) {
                            return Unit.INSTANCE;
                        }
                        $continuation.L$0 = this;
                        $continuation.label = 1;
                        v0 = this.backoffDelay((Continuation<? super Unit>)$continuation);
                        ** if (v0 != var5_4) goto lbl22
lbl21:
                        // 1 sources

                        return var5_4;
lbl22:
                        // 1 sources

                        ** GOTO lbl29
                        break;
                    }
                }
                case 1: {
                    this = (Indexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    if (this.status != Status.ERROR && this.status != Status.REORG) ** GOTO lbl42
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v1 = this.restart((Continuation<? super Unit>)$continuation);
                    ** if (v1 != var5_4) goto lbl35
lbl34:
                    // 1 sources

                    return var5_4;
lbl35:
                    // 1 sources

                    ** GOTO lbl42
                }
                case 2: {
                    this = (Indexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl42:
                    // 3 sources

                    $continuation.L$0 = this;
                    $continuation.label = 3;
                    v2 = this.getBlockFromChain(this.currentBlockNumber, (Continuation<? super Block>)$continuation);
                    ** if (v2 != var5_4) goto lbl47
lbl46:
                    // 1 sources

                    return var5_4;
lbl47:
                    // 1 sources

                    ** GOTO lbl54
                }
                case 3: {
                    this = (Indexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl54:
                    // 2 sources

                    block = (Block)v2;
                    if (this.currentBlockNumber > this.startBlock && !Intrinsics.areEqual((Object)this.previousBlockId, (Object)block.getParentID())) {
                        throw new ReorgException("Chain re-organization detected @ Block " + this.currentBlockNumber + " with parent block ID " + block.getParentID());
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Processing @ Block " + this.currentBlockNumber + " (" + (Object)this.status + ')');
                    } else if (this.status != Status.SYNCING || this.currentBlockNumber % this.syncLoggerInterval == 0L) {
                        this.logger.info("Processing @ Block " + this.currentBlockNumber + " (" + (Object)this.status + ')');
                    }
                    this.processBlock(block);
                    $continuation.L$0 = this;
                    $continuation.label = 4;
                    v3 = this.postProcessBlock(block, (Continuation<? super Unit>)$continuation);
                    ** if (v3 != var5_4) goto lbl68
lbl67:
                    // 1 sources

                    return var5_4;
lbl68:
                    // 1 sources

                    break block29;
                }
                case 4: {
                    this = (Indexer)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                    }
                    catch (BlockNotFoundException block) {
                        this.logger.info("Block " + this.currentBlockNumber + " not found. Indexer may be fully synchronised.");
                        this.handleFullySynced();
                        $continuation.L$0 = this;
                        $continuation.label = 5;
                        v4 = this.ensureFullySynced((Continuation<? super Unit>)$continuation);
                        if (v4 == var5_4) {
                            return var5_4;
                        }
                        break block29;
                    }
                }
                case 5: {
                    this = (Indexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
                    break block29;
                }
            }
            catch (ReorgException block) {
                this.logger.error("REORG @ Block " + this.currentBlockNumber);
                this.handleReorg();
                break block29;
            }
            catch (Exception e) {
                this.logger.error("Error while processing block " + this.currentBlockNumber, (Throwable)e);
                this.handleError();
            }
        }
        ** while (true)
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean hasNoRemainingIterations() {
        if (this.remainingIterations != null) {
            Long l = this.remainingIterations;
            Intrinsics.checkNotNull((Object)l);
            if (l <= 0L) {
                this.logger.info("Indexer finished at block " + this.currentBlockNumber);
                return true;
            }
            Long l2 = this.remainingIterations;
            this.remainingIterations = l2 != null ? Long.valueOf(l2 + -1L) : null;
        }
        return false;
    }

    private final void handleFullySynced() {
        this.backoffPeriod = 4000L;
        this.status = Status.FULLY_SYNCED;
    }

    private final void handleError() {
        this.backoffPeriod = 10000L;
        this.status = Status.ERROR;
    }

    private final void handleReorg() {
        this.backoffPeriod = 10000L;
        this.status = Status.REORG;
    }

    /*
     * Unable to fully structure code
     */
    private final Object postProcessBlock(Block var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof postProcessBlock.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ Indexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Indexer.access$postProcessBlock(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.status == Status.FULLY_SYNCED && this.currentBlockNumber % (long)20 == 0L) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = block;
                    $continuation.label = 1;
                    v0 = this.ensureFullySynced((Continuation<? super Unit>)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                }
                ** GOTO lbl25
            }
            case 1: {
                block = (Block)$continuation.L$1;
                this = (Indexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (this.status == Status.FULLY_SYNCED) {
                    currentEpoch = LocalDateTime.now(ZoneOffset.UTC).toInstant(ZoneOffset.UTC).toEpochMilli();
                    timeSinceLastBlock = Math.max(currentEpoch - block.getTimestamp() * (long)1000, 0L);
                    this.backoffPeriod = Math.max(0L, 10000L - timeSinceLastBlock) + (long)100;
                    this.logger.info("Success @ Block " + this.currentBlockNumber + " (" + timeSinceLastBlock + " ms since mine)");
                }
                var3_6 = this.currentBlockNumber;
                this.currentBlockNumber = var3_6 + 1L;
                this.previousBlockId = block.getId();
                v1 = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"now(ZoneOffset.UTC)");
                this.timeLastProcessed = v1;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object ensureFullySynced(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof ensureFullySynced.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ Indexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Indexer.access$ensureFullySynced(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.status != Status.FULLY_SYNCED) ** GOTO lbl26
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.getBestBlockFromChain((Continuation<? super Block>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (Indexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if ((latestBlock = (Block)v0).getNumber() > this.currentBlockNumber) {
                    this.logger.info(this.getName() + " - Changing status to SYNCING (indexerBlock=" + this.currentBlockNumber + ", latestBlock=" + latestBlock.getNumber() + ')');
                    this.status = Status.SYNCING;
                }
lbl26:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object backoffDelay(Continuation<? super Unit> $completion) {
        if (this.status != Status.SYNCING) {
            Object object = DelayKt.delay((long)this.backoffPeriod, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Object getBlockFromChain(long blockNumber, Continuation<? super Block> $completion) {
        return this.getThorClient().getBlock(blockNumber, $completion);
    }

    private final Object getBestBlockFromChain(Continuation<? super Block> $completion) {
        return this.getThorClient().getBestBlock($completion);
    }

    public abstract long getLastSyncedBlockNumber();

    public abstract void rollback(long var1);

    public abstract void processBlock(@NotNull Block var1);

    public static final /* synthetic */ Object access$initialise(Indexer $this, long blockNumber, Continuation $completion) {
        return $this.initialise(blockNumber, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$restart(Indexer $this, Continuation $completion) {
        return $this.restart((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$run(Indexer $this, Continuation $completion) {
        return $this.run((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$postProcessBlock(Indexer $this, Block block, Continuation $completion) {
        return $this.postProcessBlock(block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$ensureFullySynced(Indexer $this, Continuation $completion) {
        return $this.ensureFullySynced((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$backoffDelay(Indexer $this, Continuation $completion) {
        return $this.backoffDelay((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$getBlockFromChain(Indexer $this, long blockNumber, Continuation $completion) {
        return $this.getBlockFromChain(blockNumber, (Continuation<? super Block>)$completion);
    }

    public static final /* synthetic */ Object access$getBestBlockFromChain(Indexer $this, Continuation $completion) {
        return $this.getBestBlockFromChain((Continuation<? super Block>)$completion);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.REORG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

