/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.Indexer;
import org.vechain.indexer.Status;
import org.vechain.indexer.event.AbiManager;
import org.vechain.indexer.event.BusinessEventManager;
import org.vechain.indexer.event.BusinessEventProcessor;
import org.vechain.indexer.event.GenericEventIndexer;
import org.vechain.indexer.event.model.generic.FilterCriteria;
import org.vechain.indexer.event.model.generic.GenericEventParameters;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.exception.BlockNotFoundException;
import org.vechain.indexer.exception.ReorgException;
import org.vechain.indexer.thor.client.ThorClient;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.BlockIdentifier;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b&\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010+\u001a\u00020,H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0011\u0010.\u001a\u00020,H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0011\u0010/\u001a\u000200H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0019\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\n\u00104\u001a\u0004\u0018\u00010\u001eH&J\b\u00105\u001a\u00020,H\u0002J\b\u00106\u001a\u00020,H\u0002J\b\u00107\u001a\u00020,H\u0002J\b\u00108\u001a\u000209H\u0002J\u0019\u0010:\u001a\u00020,2\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010;J\u0019\u0010<\u001a\u00020,2\u0006\u0010=\u001a\u000200H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J,\u0010?\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C0A0@2\u0006\u0010=\u001a\u0002002\b\b\u0002\u0010D\u001a\u00020EH\u0014J\u0010\u0010F\u001a\u00020,2\u0006\u0010=\u001a\u000200H&J>\u0010G\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C0A0@2\u0018\u0010H\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C0A0@2\b\b\u0002\u0010D\u001a\u00020EH\u0014J,\u0010I\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C0A0@2\u0006\u0010=\u001a\u0002002\b\b\u0002\u0010D\u001a\u00020EH\u0014JS\u0010J\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C0A0@2\u0018\u0010H\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C0A0@2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001a0@2\n\b\u0002\u0010L\u001a\u0004\u0018\u000109H\u0002\u00a2\u0006\u0002\u0010MJ\u0011\u0010N\u001a\u00020,H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0010\u0010O\u001a\u00020,2\u0006\u00102\u001a\u00020\u0005H&J\u0011\u0010P\u001a\u00020,H\u0082P\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u001d\u0010Q\u001a\u00020,2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010SJ\u0017\u0010T\u001a\u00020,2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010;J\u0010\u0010U\u001a\u00020E2\u0006\u0010D\u001a\u00020EH\u0002R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001e\u0010(\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006V"}, d2={"Lorg/vechain/indexer/Indexer;", "", "thorClient", "Lorg/vechain/indexer/thor/client/ThorClient;", "startBlock", "", "syncLoggerInterval", "abiManager", "Lorg/vechain/indexer/event/AbiManager;", "businessEventManager", "Lorg/vechain/indexer/event/BusinessEventManager;", "(Lorg/vechain/indexer/thor/client/ThorClient;JJLorg/vechain/indexer/event/AbiManager;Lorg/vechain/indexer/event/BusinessEventManager;)V", "getAbiManager", "()Lorg/vechain/indexer/event/AbiManager;", "backoffPeriod", "getBusinessEventManager", "()Lorg/vechain/indexer/event/BusinessEventManager;", "<set-?>", "currentBlockNumber", "getCurrentBlockNumber", "()J", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "name", "", "getName", "()Ljava/lang/String;", "previousBlock", "Lorg/vechain/indexer/thor/model/BlockIdentifier;", "remainingIterations", "Ljava/lang/Long;", "Lorg/vechain/indexer/Status;", "status", "getStatus", "()Lorg/vechain/indexer/Status;", "getThorClient", "()Lorg/vechain/indexer/thor/client/ThorClient;", "Ljava/time/LocalDateTime;", "timeLastProcessed", "getTimeLastProcessed", "()Ljava/time/LocalDateTime;", "backoffDelay", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ensureFullySynced", "getBestBlockFromChain", "Lorg/vechain/indexer/thor/model/Block;", "getBlockFromChain", "blockNumber", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastSyncedBlock", "handleError", "handleFullySynced", "handleReorg", "hasNoRemainingIterations", "", "initialise", "(Ljava/lang/Long;)V", "postProcessBlock", "block", "(Lorg/vechain/indexer/thor/model/Block;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processAllEvents", "", "Lkotlin/Pair;", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "Lorg/vechain/indexer/event/model/generic/GenericEventParameters;", "criteria", "Lorg/vechain/indexer/event/model/generic/FilterCriteria;", "processBlock", "processBlockBusinessEvents", "decodedEvents", "processBlockGenericEvents", "processBusinessEvents", "businessEventNames", "removeDuplicates", "(Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;)Ljava/util/List;", "restart", "rollback", "run", "start", "iterations", "(Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startInCoroutine", "updateCriteriaWithBusinessEvents", "indexer-core"})
public abstract class Indexer {
    @NotNull
    private final ThorClient thorClient;
    private final long startBlock;
    private final long syncLoggerInterval;
    @Nullable
    private final AbiManager abiManager;
    @Nullable
    private final BusinessEventManager businessEventManager;
    @Nullable
    private BlockIdentifier previousBlock;
    @Nullable
    private Long remainingIterations;
    @NotNull
    private final Logger logger;
    @NotNull
    private Status status;
    private long currentBlockNumber;
    @NotNull
    private LocalDateTime timeLastProcessed;
    private long backoffPeriod;

    public Indexer(@NotNull ThorClient thorClient, long startBlock, long syncLoggerInterval, @Nullable AbiManager abiManager, @Nullable BusinessEventManager businessEventManager) {
        Intrinsics.checkNotNullParameter((Object)thorClient, (String)"thorClient");
        this.thorClient = thorClient;
        this.startBlock = startBlock;
        this.syncLoggerInterval = syncLoggerInterval;
        this.abiManager = abiManager;
        this.businessEventManager = businessEventManager;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
        this.status = Status.SYNCING;
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(ZoneOffset.UTC)");
        this.timeLastProcessed = localDateTime;
    }

    public /* synthetic */ Indexer(ThorClient thorClient, long l, long l2, AbiManager abiManager, BusinessEventManager businessEventManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = 1000L;
        }
        if ((n & 8) != 0) {
            abiManager = null;
        }
        if ((n & 0x10) != 0) {
            businessEventManager = null;
        }
        this(thorClient, l, l2, abiManager, businessEventManager);
    }

    @NotNull
    protected ThorClient getThorClient() {
        return this.thorClient;
    }

    @Nullable
    protected AbiManager getAbiManager() {
        return this.abiManager;
    }

    @Nullable
    protected BusinessEventManager getBusinessEventManager() {
        return this.businessEventManager;
    }

    @NotNull
    public final String getName() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.simpleName");
        return string;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    public final long getCurrentBlockNumber() {
        return this.currentBlockNumber;
    }

    @NotNull
    public final LocalDateTime getTimeLastProcessed() {
        return this.timeLastProcessed;
    }

    private final void initialise(Long blockNumber) {
        BlockIdentifier lastBlock;
        long l;
        Long l2 = blockNumber;
        if (l2 != null) {
            l = l2;
        } else {
            BlockIdentifier blockIdentifier = this.getLastSyncedBlock();
            Long l3 = blockIdentifier != null ? Long.valueOf(blockIdentifier.getNumber()) : null;
            l = l3 != null ? l3 : this.startBlock;
        }
        long lastSyncedBlockNumber = l;
        this.rollback(lastSyncedBlockNumber);
        this.currentBlockNumber = lastSyncedBlockNumber;
        this.status = Status.SYNCING;
        BlockIdentifier blockIdentifier = lastBlock = this.getLastSyncedBlock();
        this.previousBlock = (blockIdentifier != null ? blockIdentifier.getNumber() == lastSyncedBlockNumber - 1L : false) ? lastBlock : null;
    }

    static /* synthetic */ void initialise$default(Indexer indexer, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialise");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        indexer.initialise(l);
    }

    public final void startInCoroutine(@Nullable Long iterations) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, iterations, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Indexer this$0;
            final /* synthetic */ Long $iterations;
            {
                this.this$0 = $receiver;
                this.$iterations = $iterations;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        Object object3 = this.this$0.start(this.$iterations, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            this.this$0.getLogger().error("Error starting indexer " + $this$launch.getClass().getSimpleName() + ": ", (Throwable)e);
                            throw new Exception(e.getMessage(), e);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void startInCoroutine$default(Indexer indexer, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startInCoroutine");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        indexer.startInCoroutine(l);
    }

    @Nullable
    public final Object start(@Nullable Long iterations, @NotNull Continuation<? super Unit> $completion) {
        this.remainingIterations = iterations;
        Indexer.initialise$default(this, null, 1, null);
        this.logger.info("Starting @ Block: " + this.currentBlockNumber);
        Object object = this.run($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object start$default(Indexer indexer, Long l, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        return indexer.start(l, (Continuation<? super Unit>)continuation);
    }

    private final Object restart(Continuation<? super Unit> $completion) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.status.ordinal()]) {
            case 1: {
                this.initialise(Boxing.boxLong((long)this.currentBlockNumber));
                break;
            }
            case 2: {
                this.initialise(Boxing.boxLong((long)(this.currentBlockNumber - 1L)));
                break;
            }
            default: {
                Indexer.initialise$default(this, null, 1, null);
            }
        }
        this.logger.info("Restarting indexer @ Block: " + this.currentBlockNumber);
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object run(Continuation<? super Unit> var1_1) {
        block31: {
            if (!(var1_1 instanceof run.1)) ** GOTO lbl-1000
            var6_2 = var1_1;
            if ((var6_2.label & -2147483648) != 0) {
                var6_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Indexer this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Indexer.access$run(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
lbl12:
                    // 2 sources

                    while (true) {
                        if (this.hasNoRemainingIterations()) {
                            return Unit.INSTANCE;
                        }
                        $continuation.L$0 = this;
                        $continuation.label = 1;
                        v0 = this.backoffDelay((Continuation<? super Unit>)$continuation);
                        ** if (v0 != var7_4) goto lbl22
lbl21:
                        // 1 sources

                        return var7_4;
lbl22:
                        // 1 sources

                        ** GOTO lbl29
                        break;
                    }
                }
                case 1: {
                    this = (Indexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    if (this.status != Status.ERROR && this.status != Status.REORG) ** GOTO lbl42
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v1 = this.restart((Continuation<? super Unit>)$continuation);
                    ** if (v1 != var7_4) goto lbl35
lbl34:
                    // 1 sources

                    return var7_4;
lbl35:
                    // 1 sources

                    ** GOTO lbl42
                }
                case 2: {
                    this = (Indexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl42:
                    // 3 sources

                    $continuation.L$0 = this;
                    $continuation.label = 3;
                    v2 = this.getBlockFromChain(this.currentBlockNumber, (Continuation<? super Block>)$continuation);
                    ** if (v2 != var7_4) goto lbl47
lbl46:
                    // 1 sources

                    return var7_4;
lbl47:
                    // 1 sources

                    ** GOTO lbl54
                }
                case 3: {
                    this = (Indexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl54:
                    // 2 sources

                    block = (Block)v2;
                    if (this.currentBlockNumber > this.startBlock) {
                        v3 = this.previousBlock;
                        if (v3 != null && (v3 = v3.getId()) != null) {
                            it = v3;
                            $i$a$-let-Indexer$run$2 = false;
                            v4 = !Intrinsics.areEqual((Object)it, (Object)block.getParentID());
                        } else {
                            v4 = false;
                        }
                        if (v4) {
                            throw new ReorgException("Chain re-organization detected @ Block " + this.currentBlockNumber + " with parent block ID " + block.getParentID());
                        }
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Processing @ Block " + this.currentBlockNumber + " (" + (Object)this.status + ')');
                    } else if (this.status != Status.SYNCING || this.currentBlockNumber % this.syncLoggerInterval == 0L) {
                        this.logger.info("Processing @ Block " + this.currentBlockNumber + " (" + (Object)this.status + ')');
                    }
                    this.processBlock(block);
                    $continuation.L$0 = this;
                    $continuation.label = 4;
                    v5 = this.postProcessBlock(block, (Continuation<? super Unit>)$continuation);
                    if (v5 != var7_4) break block31;
                    return var7_4;
                }
                case 4: {
                    this = (Indexer)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
                    }
                    catch (BlockNotFoundException block) {
                        this.logger.info("Block " + this.currentBlockNumber + " not found. Indexer may be fully synchronised.");
                        this.handleFullySynced();
                        $continuation.L$0 = this;
                        $continuation.label = 5;
                        v6 = this.ensureFullySynced((Continuation<? super Unit>)$continuation);
                        if (v6 == var7_4) {
                            return var7_4;
                        }
                        break block31;
                    }
                }
                case 5: {
                    this = (Indexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
                    break block31;
                }
            }
            catch (ReorgException block) {
                this.logger.error("REORG @ Block " + this.currentBlockNumber);
                this.handleReorg();
                break block31;
            }
            catch (Exception e) {
                this.logger.error("Error while processing block " + this.currentBlockNumber, (Throwable)e);
                this.handleError();
            }
        }
        ** while (true)
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean hasNoRemainingIterations() {
        if (this.remainingIterations != null) {
            Long l = this.remainingIterations;
            Intrinsics.checkNotNull((Object)l);
            if (l <= 0L) {
                this.logger.info("Indexer finished at block " + this.currentBlockNumber);
                return true;
            }
            Long l2 = this.remainingIterations;
            this.remainingIterations = l2 != null ? Long.valueOf(l2 + -1L) : null;
        }
        return false;
    }

    private final void handleFullySynced() {
        this.backoffPeriod = 4000L;
        this.status = Status.FULLY_SYNCED;
    }

    private final void handleError() {
        this.backoffPeriod = 10000L;
        this.status = Status.ERROR;
    }

    private final void handleReorg() {
        this.backoffPeriod = 10000L;
        this.status = Status.REORG;
    }

    /*
     * Unable to fully structure code
     */
    private final Object postProcessBlock(Block var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof postProcessBlock.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ Indexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Indexer.access$postProcessBlock(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.status == Status.FULLY_SYNCED && this.currentBlockNumber % (long)20 == 0L) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = block;
                    $continuation.label = 1;
                    v0 = this.ensureFullySynced((Continuation<? super Unit>)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                }
                ** GOTO lbl25
            }
            case 1: {
                block = (Block)$continuation.L$1;
                this = (Indexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (this.status == Status.FULLY_SYNCED) {
                    currentEpoch = LocalDateTime.now(ZoneOffset.UTC).toInstant(ZoneOffset.UTC).toEpochMilli();
                    timeSinceLastBlock = Math.max(currentEpoch - block.getTimestamp() * (long)1000, 0L);
                    this.backoffPeriod = Math.max(0L, 10000L - timeSinceLastBlock) + (long)100;
                    this.logger.info("Success @ Block " + this.currentBlockNumber + " (" + timeSinceLastBlock + " ms since mine)");
                }
                var3_6 = this.currentBlockNumber;
                this.currentBlockNumber = var3_6 + 1L;
                this.previousBlock = new BlockIdentifier(block.getNumber(), block.getId());
                v1 = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"now(ZoneOffset.UTC)");
                this.timeLastProcessed = v1;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object ensureFullySynced(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof ensureFullySynced.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ Indexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Indexer.access$ensureFullySynced(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.status != Status.FULLY_SYNCED) ** GOTO lbl26
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.getBestBlockFromChain((Continuation<? super Block>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (Indexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if ((latestBlock = (Block)v0).getNumber() > this.currentBlockNumber) {
                    this.logger.info(this.getName() + " - Changing status to SYNCING (indexerBlock=" + this.currentBlockNumber + ", latestBlock=" + latestBlock.getNumber() + ')');
                    this.status = Status.SYNCING;
                }
lbl26:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object backoffDelay(Continuation<? super Unit> $completion) {
        if (this.status != Status.SYNCING) {
            Object object = DelayKt.delay((long)this.backoffPeriod, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Object getBlockFromChain(long blockNumber, Continuation<? super Block> $completion) {
        return this.getThorClient().getBlock(blockNumber, $completion);
    }

    private final Object getBestBlockFromChain(Continuation<? super Block> $completion) {
        return this.getThorClient().getBestBlock($completion);
    }

    @Nullable
    public abstract BlockIdentifier getLastSyncedBlock();

    public abstract void rollback(long var1);

    public abstract void processBlock(@NotNull Block var1);

    @NotNull
    protected List<Pair<IndexedEvent, GenericEventParameters>> processAllEvents(@NotNull Block block, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        FilterCriteria updatedCriteria = this.updateCriteriaWithBusinessEvents(criteria);
        List<Pair<IndexedEvent, GenericEventParameters>> decodedEvents = this.processBlockGenericEvents(block, updatedCriteria);
        return this.processBusinessEvents(decodedEvents, updatedCriteria.getBusinessEventNames(), updatedCriteria.getRemoveDuplicates());
    }

    public static /* synthetic */ List processAllEvents$default(Indexer indexer, Block block, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processAllEvents");
        }
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return indexer.processAllEvents(block, filterCriteria);
    }

    @NotNull
    protected List<Pair<IndexedEvent, GenericEventParameters>> processBlockGenericEvents(@NotNull Block block, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (this.getAbiManager() == null) {
            this.logger.warn("ABI Manager is not configured. Skipping generic event processing.");
            return CollectionsKt.emptyList();
        }
        AbiManager abiManager = this.getAbiManager();
        Intrinsics.checkNotNull((Object)abiManager);
        GenericEventIndexer eventIndexer = new GenericEventIndexer(abiManager);
        return eventIndexer.getEventsByFilters(block, criteria.getAbiNames(), criteria.getEventNames(), criteria.getContractAddresses(), criteria.getVetTransfers());
    }

    public static /* synthetic */ List processBlockGenericEvents$default(Indexer indexer, Block block, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBlockGenericEvents");
        }
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return indexer.processBlockGenericEvents(block, filterCriteria);
    }

    @NotNull
    protected List<Pair<IndexedEvent, GenericEventParameters>> processBlockBusinessEvents(@NotNull List<Pair<IndexedEvent, GenericEventParameters>> decodedEvents, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter(decodedEvents, (String)"decodedEvents");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (this.getBusinessEventManager() == null) {
            this.logger.warn("Business Event Manager is not configured. Skipping business event processing.");
            return CollectionsKt.emptyList();
        }
        FilterCriteria filteredCriteria = this.updateCriteriaWithBusinessEvents(criteria);
        BusinessEventManager businessEventManager = this.getBusinessEventManager();
        Intrinsics.checkNotNull((Object)businessEventManager);
        BusinessEventProcessor processor = new BusinessEventProcessor(businessEventManager);
        return processor.getOnlyBusinessEvents(decodedEvents, filteredCriteria.getBusinessEventNames());
    }

    public static /* synthetic */ List processBlockBusinessEvents$default(Indexer indexer, List list, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBlockBusinessEvents");
        }
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return indexer.processBlockBusinessEvents(list, filterCriteria);
    }

    private final FilterCriteria updateCriteriaWithBusinessEvents(FilterCriteria criteria) {
        if (!((Collection)criteria.getBusinessEventNames()).isEmpty() && this.getBusinessEventManager() != null) {
            BusinessEventManager businessEventManager = this.getBusinessEventManager();
            Intrinsics.checkNotNull((Object)businessEventManager);
            List<String> names = businessEventManager.getBusinessGenericEventNames(criteria.getBusinessEventNames());
            return criteria.addBusinessEventNames(names);
        }
        return criteria;
    }

    private final List<Pair<IndexedEvent, GenericEventParameters>> processBusinessEvents(List<Pair<IndexedEvent, GenericEventParameters>> decodedEvents, List<String> businessEventNames, Boolean removeDuplicates) {
        if (this.getBusinessEventManager() != null) {
            BusinessEventManager businessEventManager = this.getBusinessEventManager();
            Intrinsics.checkNotNull((Object)businessEventManager);
            BusinessEventProcessor processor = new BusinessEventProcessor(businessEventManager);
            Boolean bl = removeDuplicates;
            return processor.processEvents(decodedEvents, businessEventNames, bl != null ? bl : true);
        }
        this.logger.debug("Skipping business event processing as manager is missing.");
        return decodedEvents;
    }

    static /* synthetic */ List processBusinessEvents$default(Indexer indexer, List list, List list2, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBusinessEvents");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return indexer.processBusinessEvents(list, list2, bl);
    }

    public static final /* synthetic */ Object access$restart(Indexer $this, Continuation $completion) {
        return $this.restart((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$run(Indexer $this, Continuation $completion) {
        return $this.run((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$postProcessBlock(Indexer $this, Block block, Continuation $completion) {
        return $this.postProcessBlock(block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$ensureFullySynced(Indexer $this, Continuation $completion) {
        return $this.ensureFullySynced((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$backoffDelay(Indexer $this, Continuation $completion) {
        return $this.backoffDelay((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$getBlockFromChain(Indexer $this, long blockNumber, Continuation $completion) {
        return $this.getBlockFromChain(blockNumber, (Continuation<? super Block>)$completion);
    }

    public static final /* synthetic */ Object access$getBestBlockFromChain(Indexer $this, Continuation $completion) {
        return $this.getBestBlockFromChain((Continuation<? super Block>)$completion);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.REORG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

