/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.model.business.BusinessEventDefinition;
import org.vechain.indexer.event.model.business.Event;
import org.vechain.indexer.utils.JsonUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\nJ \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rJ\u001a\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\nR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/vechain/indexer/event/BusinessEventManager;", "", "()V", "businessEvents", "", "", "Lorg/vechain/indexer/event/model/business/BusinessEventDefinition;", "logger", "Lorg/slf4j/Logger;", "getAllBusinessEvents", "", "getBusinessEventsByNames", "names", "", "getBusinessGenericEventNames", "loadBusinessEvents", "", "eventFiles", "Ljava/io/InputStream;", "indexer-core"})
public final class BusinessEventManager {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<String, BusinessEventDefinition> businessEvents;

    public BusinessEventManager() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
        this.businessEvents = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadBusinessEvents(@NotNull Map<String, ? extends InputStream> eventFiles) {
        Intrinsics.checkNotNullParameter(eventFiles, (String)"eventFiles");
        Map<String, ? extends InputStream> $this$forEach$iv = eventFiles;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends InputStream>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends InputStream> element$iv;
            Map.Entry<String, ? extends InputStream> entry = element$iv = iterator.next();
            boolean bl = false;
            String eventName = entry.getKey();
            InputStream inputStream = entry.getValue();
            try {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream stream = (InputStream)closeable;
                    boolean bl2 = false;
                    BusinessEventDefinition businessEventDefinition2 = (BusinessEventDefinition)JsonUtils.INSTANCE.getMapper().readValue(stream, (TypeReference)new TypeReference<BusinessEventDefinition>(){});
                    Intrinsics.checkNotNullExpressionValue((Object)businessEventDefinition2, (String)"businessEventDefinition");
                    this.businessEvents.put(eventName, businessEventDefinition2);
                    this.logger.info("Loaded business event: " + eventName);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to load business event from " + eventName + ": " + e.getMessage());
            }
        }
    }

    @NotNull
    public final Map<String, BusinessEventDefinition> getAllBusinessEvents() {
        return this.businessEvents;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, BusinessEventDefinition> getBusinessEventsByNames(@NotNull List<String> names) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Iterable $this$mapNotNull$iv = names;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String name = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.businessEvents.get(name) != null) {
                BusinessEventDefinition it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)name, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getBusinessGenericEventNames(@NotNull List<String> names) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Map<String, BusinessEventDefinition> $this$flatMap$iv = this.getBusinessEventsByNames(names);
        boolean $i$f$flatMap = false;
        Map<String, BusinessEventDefinition> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            BusinessEventDefinition businessEventDefinition2 = (BusinessEventDefinition)entry.getValue();
            Iterable $this$map$iv = businessEventDefinition2.getEvents();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Event event = (Event)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

