/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.BusinessEventManager;
import org.vechain.indexer.event.model.business.BusinessEventDefinition;
import org.vechain.indexer.event.model.generic.GenericEventParameters;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.event.utils.BusinessEventUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\b2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J<\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u001e\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J@\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u000e2\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJJ\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u000e2\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u0018JB\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u000e2\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/vechain/indexer/event/BusinessEventProcessor;", "", "businessEventManager", "Lorg/vechain/indexer/event/BusinessEventManager;", "(Lorg/vechain/indexer/event/BusinessEventManager;)V", "logger", "Lorg/slf4j/Logger;", "checkAllCombinations", "", "", "Lkotlin/Pair;", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "Lorg/vechain/indexer/event/model/generic/GenericEventParameters;", "group", "", "definition", "Lorg/vechain/indexer/event/model/business/BusinessEventDefinition;", "createBusinessEvent", "eventsForAlias", "getOnlyBusinessEvents", "events", "businessEventNames", "processEvents", "removeDuplicates", "", "processTransactionForBusinessEvents", "txEvents", "indexer-core"})
public final class BusinessEventProcessor {
    @NotNull
    private final BusinessEventManager businessEventManager;
    @NotNull
    private final Logger logger;

    public BusinessEventProcessor(@NotNull BusinessEventManager businessEventManager) {
        Intrinsics.checkNotNullParameter((Object)businessEventManager, (String)"businessEventManager");
        this.businessEventManager = businessEventManager;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<IndexedEvent, GenericEventParameters>> processEvents(@NotNull List<Pair<IndexedEvent, GenericEventParameters>> events, @NotNull List<String> businessEventNames, boolean removeDuplicates) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(businessEventNames, (String)"businessEventNames");
        List businessEvents = new ArrayList();
        List remainingEvents = new ArrayList();
        Object $this$groupBy$iv = events;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = ((IndexedEvent)it.getFirst()).getTxId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            List transactionEvents = (List)entry.getValue();
            try {
                List<Pair<IndexedEvent, GenericEventParameters>> matchedEvents = this.processTransactionForBusinessEvents(transactionEvents, businessEventNames);
                businessEvents.addAll((Collection)matchedEvents);
                if (removeDuplicates && !matchedEvents.isEmpty()) continue;
                remainingEvents.addAll(transactionEvents);
            }
            catch (Exception e) {
                this.logger.error("Failed to process transaction events: " + transactionEvents, (Throwable)e);
                remainingEvents.addAll(transactionEvents);
            }
        }
        return CollectionsKt.plus((Collection)remainingEvents, (Iterable)businessEvents);
    }

    public static /* synthetic */ List processEvents$default(BusinessEventProcessor businessEventProcessor, List list, List list2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return businessEventProcessor.processEvents(list, list2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<IndexedEvent, GenericEventParameters>> getOnlyBusinessEvents(@NotNull List<Pair<IndexedEvent, GenericEventParameters>> events, @NotNull List<String> businessEventNames) {
        void $this$flatMapTo$iv$iv;
        Object list$iv$iv;
        boolean bl;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(businessEventNames, (String)"businessEventNames");
        Iterable $this$groupBy$iv = events;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object t = iterator.next();
            Pair it = (Pair)t;
            bl = false;
            String key$iv$iv = ((IndexedEvent)it.getFirst()).getTxId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Map $this$flatMap$iv = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Map.Entry entry : $this$flatMapTo$iv$iv.entrySet()) {
            list$iv$iv = entry;
            bl = false;
            List transactionEvents = (List)list$iv$iv.getValue();
            list$iv$iv = this.processTransactionForBusinessEvents(transactionEvents, businessEventNames);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<IndexedEvent, GenericEventParameters>> processTransactionForBusinessEvents(List<Pair<IndexedEvent, GenericEventParameters>> txEvents, List<String> businessEventNames) {
        Map<String, BusinessEventDefinition> businessEvents = businessEventNames.isEmpty() ? this.businessEventManager.getAllBusinessEvents() : this.businessEventManager.getBusinessEventsByNames(businessEventNames);
        List matchedBusinessEvents = new ArrayList();
        Iterator<Map.Entry<String, BusinessEventDefinition>> iterator = businessEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map map;
            BusinessEventDefinition definition = iterator.next().getValue();
            if (Intrinsics.areEqual((Object)definition.getSameClause(), (Object)true)) {
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = txEvents;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    Pair it = (Pair)element$iv$iv;
                    boolean bl = false;
                    Integer key$iv$iv = (int)((IndexedEvent)it.getFirst()).getClauseIndex();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                map = destination$iv$iv;
            } else {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)0, txEvents));
            }
            Map groupedEvents = map;
            boolean definitionMatched = false;
            Iterator iterator2 = groupedEvents.entrySet().iterator();
            while (iterator2.hasNext()) {
                List group = (List)iterator2.next().getValue();
                Map<String, Pair<IndexedEvent, GenericEventParameters>> eventsForAlias = Intrinsics.areEqual((Object)definition.getCheckAllCombinations(), (Object)true) ? this.checkAllCombinations(group, definition) : BusinessEventUtils.INSTANCE.mapEventsToAliases(group, definition.getEvents());
                if (!(!eventsForAlias.isEmpty()) || !BusinessEventUtils.INSTANCE.validateRules(definition.getRules(), eventsForAlias)) continue;
                matchedBusinessEvents.add(this.createBusinessEvent(eventsForAlias, definition));
                definitionMatched = true;
            }
            if (!definitionMatched) continue;
            break;
        }
        return matchedBusinessEvents;
    }

    private final Map<String, Pair<IndexedEvent, GenericEventParameters>> checkAllCombinations(List<Pair<IndexedEvent, GenericEventParameters>> group, BusinessEventDefinition definition) {
        Integer n = definition.getMaxAttempts();
        List<Map<String, Pair<IndexedEvent, GenericEventParameters>>> eventCombinations = BusinessEventUtils.INSTANCE.generateAllValidCombinations(group, definition.getEvents(), n != null ? n : 10);
        for (Map<String, Pair<IndexedEvent, GenericEventParameters>> eventsForAlias : eventCombinations) {
            if (!(!eventsForAlias.isEmpty()) || !BusinessEventUtils.INSTANCE.validateRules(definition.getRules(), eventsForAlias)) continue;
            return eventsForAlias;
        }
        return MapsKt.emptyMap();
    }

    private final Pair<IndexedEvent, GenericEventParameters> createBusinessEvent(Map<String, Pair<IndexedEvent, GenericEventParameters>> eventsForAlias, BusinessEventDefinition definition) {
        Map<String, Object> params2 = BusinessEventUtils.INSTANCE.extractParams(definition.getParamsDefinition(), eventsForAlias);
        IndexedEvent firstEvent = (IndexedEvent)((Pair)CollectionsKt.first((Iterable)eventsForAlias.values())).getFirst();
        return new Pair((Object)firstEvent, (Object)new GenericEventParameters(params2, definition.getName()));
    }
}

