/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.AbiManager;
import org.vechain.indexer.event.model.abi.AbiElement;
import org.vechain.indexer.event.model.abi.InputOutput;
import org.vechain.indexer.event.model.generic.GenericEventParameters;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.event.model.generic.RawEvent;
import org.vechain.indexer.event.utils.EventUtils;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.Transaction;
import org.vechain.indexer.thor.model.TxEvent;
import org.vechain.indexer.thor.model.TxOutputs;
import org.vechain.indexer.thor.model.TxTransfer;
import org.vechain.indexer.utils.DataUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JL\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J:\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J*\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000eH\u0002J \u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u000e2\u0006\u0010\u0012\u001a\u00020\u0013JZ\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\b\b\u0002\u0010#\u001a\u00020$J,\u0010%\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000eH\u0002JF\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/vechain/indexer/event/GenericEventIndexer;", "", "abiManager", "Lorg/vechain/indexer/event/AbiManager;", "(Lorg/vechain/indexer/event/AbiManager;)V", "logger", "Lorg/slf4j/Logger;", "decodeEvent", "Lkotlin/Pair;", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "Lorg/vechain/indexer/event/model/generic/GenericEventParameters;", "event", "Lorg/vechain/indexer/thor/model/TxEvent;", "configuredEvents", "", "Lorg/vechain/indexer/event/model/abi/AbiElement;", "tx", "Lorg/vechain/indexer/thor/model/Transaction;", "block", "Lorg/vechain/indexer/thor/model/Block;", "outputIndex", "", "eventIndex", "extractVetTransfers", "output", "Lorg/vechain/indexer/thor/model/TxOutputs;", "generateEventId", "", "txId", "getConfiguredEvents", "abiNames", "eventNames", "getEvents", "getEventsByFilters", "contractAddresses", "vetTransfers", "", "isEventValid", "processEvents", "indexer-core"})
public final class GenericEventIndexer {
    @NotNull
    private final AbiManager abiManager;
    @NotNull
    private final Logger logger;

    public GenericEventIndexer(@NotNull AbiManager abiManager) {
        Intrinsics.checkNotNullParameter((Object)abiManager, (String)"abiManager");
        this.abiManager = abiManager;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
    }

    @NotNull
    public final List<Pair<IndexedEvent, GenericEventParameters>> getEvents(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return GenericEventIndexer.getEventsByFilters$default(this, block, null, null, null, false, 30, null);
    }

    @NotNull
    public final List<Pair<IndexedEvent, GenericEventParameters>> getEventsByFilters(@NotNull Block block, @NotNull List<String> abiNames, @NotNull List<String> eventNames, @NotNull List<String> contractAddresses, boolean vetTransfers) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(abiNames, (String)"abiNames");
        Intrinsics.checkNotNullParameter(eventNames, (String)"eventNames");
        Intrinsics.checkNotNullParameter(contractAddresses, (String)"contractAddresses");
        List<AbiElement> configuredEvents = this.getConfiguredEvents(abiNames, eventNames);
        return this.processEvents(block, configuredEvents, contractAddresses, vetTransfers);
    }

    public static /* synthetic */ List getEventsByFilters$default(GenericEventIndexer genericEventIndexer, Block block, List list, List list2, List list3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return genericEventIndexer.getEventsByFilters(block, list, list2, list3, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbiElement> getConfiguredEvents(List<String> abiNames, List<String> eventNames) {
        List list;
        if (!((Collection)abiNames).isEmpty()) {
            list = this.abiManager.getEventsByNames(abiNames, eventNames);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CollectionsKt.flatten((Iterable)this.abiManager.getAbis().values());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AbiElement it = (AbiElement)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getType(), (Object)"event") && (eventNames.isEmpty() || CollectionsKt.contains((Iterable)eventNames, (Object)it.getName())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<IndexedEvent, GenericEventParameters>> processEvents(Block block, List<AbiElement> configuredEvents, List<String> contractAddresses, boolean vetTransfers) {
        List events = new ArrayList();
        Iterable $this$forEach$iv = block.getTransactions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Transaction tx = (Transaction)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = tx.getOutputs();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void output;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TxOutputs txOutputs = (TxOutputs)item$iv;
                int outputIndex = n;
                boolean bl2 = false;
                Iterable $this$forEachIndexed$iv2 = output.getEvents();
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    Pair<IndexedEvent, GenericEventParameters> it;
                    void event;
                    int n2;
                    if ((n2 = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    TxEvent txEvent = (TxEvent)item$iv2;
                    int eventIndex = n2;
                    boolean bl3 = false;
                    if (!this.isEventValid((TxEvent)event, configuredEvents, contractAddresses)) continue;
                    if (this.decodeEvent((TxEvent)event, configuredEvents, tx, block, outputIndex, eventIndex) == null) continue;
                    boolean bl4 = false;
                    events.add(it);
                }
                if (!vetTransfers) continue;
                events.addAll((Collection)this.extractVetTransfers((TxOutputs)output, tx, block, outputIndex));
            }
        }
        return events;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isEventValid(TxEvent event, List<AbiElement> configuredEvents, List<String> contractAddresses) {
        block9: {
            block8: {
                $this$any$iv = configuredEvents;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (AbiElement)element$iv;
                        $i$a$-any-GenericEventIndexer$isEventValid$matchesAbi$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getSignature(), (Object)DataUtils.INSTANCE.removePrefix(event.getTopics().get(0)))) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = matchesAbi = false;
                }
            }
            if (contractAddresses.isEmpty()) ** GOTO lbl-1000
            $this$any$iv = contractAddresses;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    $i$a$-any-GenericEventIndexer$isEventValid$matchesContract$1 = false;
                    if (!StringsKt.equals((String)it, (String)event.getAddress(), (boolean)true)) continue;
                    v1 = true;
                    break block9;
                }
                v1 = false;
            }
        }
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        matchesContract = v2;
        return ((Collection)event.getTopics()).isEmpty() == false != false && matchesAbi != false && matchesContract != false;
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<IndexedEvent, GenericEventParameters> decodeEvent(TxEvent event, List<AbiElement> configuredEvents, Transaction tx, Block block, int outputIndex, int eventIndex) {
        block10: {
            $this$firstOrNull$iv = configuredEvents;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                abi = (AbiElement)element$iv;
                $i$a$-firstOrNull-GenericEventIndexer$decodeEvent$matchingAbi$1 = false;
                if (!Intrinsics.areEqual((Object)abi.getSignature(), (Object)DataUtils.INSTANCE.removePrefix(event.getTopics().get(0)))) ** GOTO lbl-1000
                $this$count$iv = abi.getInputs();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v0 = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (InputOutput)element$iv;
                        $i$a$-count-GenericEventIndexer$decodeEvent$matchingAbi$1$1 = false;
                        if (!it.getIndexed() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v0 = count$iv;
                }
                if (v0 + 1 == event.getTopics().size()) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block10;
            }
            v2 = null;
        }
        v3 = matchingAbi = (AbiElement)v2;
        if (v3 != null) {
            abi = v3;
            $i$a$-let-GenericEventIndexer$decodeEvent$1 = false;
            try {
                parameters = EventUtils.INSTANCE.decodeEvent(event, abi);
                var11_12 = TuplesKt.to((Object)new IndexedEvent(this.generateEventId(tx.getId(), outputIndex, eventIndex, event), block.getId(), block.getNumber(), block.getTimestamp(), tx.getId(), tx.getOrigin(), tx.getGasPayer(), new RawEvent(event.getData(), event.getTopics()), parameters, event.getAddress(), parameters.getEventType(), outputIndex, event.getTopics().get(0)), (Object)parameters);
            }
            catch (IllegalArgumentException ex) {
                this.logger.warn("Failed to decode event with ABI: " + abi.getName() + ", txId: " + tx.getId() + ". Skipping event.");
                var11_12 = null;
            }
            v4 = var11_12;
        } else {
            v4 = null;
        }
        return v4;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<IndexedEvent, GenericEventParameters>> extractVetTransfers(TxOutputs output, Transaction tx, Block block, int outputIndex) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv = output.getTransfers();
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Pair it$iv$iv;
            Pair pair;
            void transfer;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            TxTransfer txTransfer = (TxTransfer)element$iv$iv;
            int transferIndex = index$iv$iv;
            boolean bl2 = false;
            try {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"from", (Object)transfer.getSender()), TuplesKt.to((Object)"to", (Object)transfer.getRecipient()), TuplesKt.to((Object)"amount", (Object)DataUtils.INSTANCE.decodeQuantity(transfer.getAmount()))};
                GenericEventParameters parameters = new GenericEventParameters(MapsKt.mapOf((Pair[])pairArray), "VET_TRANSFER");
                IndexedEvent indexedEvent = new IndexedEvent(this.generateEventId(tx.getId(), outputIndex, transferIndex, transfer), block.getId(), block.getNumber(), block.getTimestamp(), tx.getId(), tx.getOrigin(), tx.getGasPayer(), null, parameters, transfer.getRecipient(), "VET_TRANSFER", outputIndex, null, 4224, null);
                pair = TuplesKt.to((Object)indexedEvent, (Object)parameters);
            }
            catch (Exception ex) {
                this.logger.warn("Failed to process VET transfer: " + transfer.getSender() + " -> " + transfer.getRecipient(), (Throwable)ex);
                pair = null;
            }
            if (pair == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String generateEventId(String txId, int outputIndex, int eventIndex, Object event) {
        int eventHash = event.hashCode();
        return txId + '-' + outputIndex + '-' + eventIndex + '-' + eventHash;
    }
}

