/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event.types;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.model.abi.InputOutput;
import org.vechain.indexer.event.types.DecodedValue;
import org.vechain.indexer.event.types.Types;
import org.vechain.indexer.utils.DataUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0001\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH&J\f\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\tH&J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H&j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001b\u00a8\u0006\u001d"}, d2={"Lorg/vechain/indexer/event/types/Types;", "", "(Ljava/lang/String;I)V", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "isType", "", "typeName", "ADDRESS", "UINT", "BOOL", "BYTES", "STRING", "TUPLE", "ARRAY", "Companion", "indexer-core"})
public abstract class Types
extends Enum<Types> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger logger;
    public static final /* enum */ Types ADDRESS;
    public static final /* enum */ Types UINT;
    public static final /* enum */ Types BOOL;
    public static final /* enum */ Types BYTES;
    public static final /* enum */ Types STRING;
    public static final /* enum */ Types TUPLE;
    public static final /* enum */ Types ARRAY;
    private static final /* synthetic */ Types[] $VALUES;

    private Types() {
    }

    public abstract boolean isType(@NotNull String var1);

    @NotNull
    public abstract <T> DecodedValue<T> decode(@NotNull String var1, @NotNull Class<T> var2, @NotNull String var3, @Nullable String var4, int var5, @Nullable List<InputOutput> var6);

    public static /* synthetic */ DecodedValue decode$default(Types types, String string, Class clazz, String string2, String string3, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n2 & 0x20) != 0) {
            list = null;
        }
        return types.decode(string, clazz, string2, string3, n, list);
    }

    @NotNull
    public abstract Class<?> getClaas();

    public static Types[] values() {
        return (Types[])$VALUES.clone();
    }

    public static Types valueOf(String value) {
        return Enum.valueOf(Types.class, value);
    }

    public /* synthetic */ Types(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        ADDRESS = new ADDRESS("ADDRESS", 0);
        UINT = new UINT("UINT", 1);
        BOOL = new BOOL("BOOL", 2);
        BYTES = new BYTES("BYTES", 3);
        STRING = new STRING("STRING", 4);
        TUPLE = new TUPLE("TUPLE", 5);
        ARRAY = new ARRAY("ARRAY", 6);
        $VALUES = typesArray = new Types[]{Types.ADDRESS, Types.UINT, Types.BOOL, Types.BYTES, Types.STRING, Types.TUPLE, Types.ARRAY};
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        Types.logger = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ'\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0006\b\u0000\u0010\u0010\u0018\u00012\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0082\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/vechain/indexer/event/types/Types$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "decodeAbiString", "", "encodedString", "startPosition", "", "decodeArray", "", "elementType", "fullData", "decodeBasicType", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "typeName", "encoded", "indexer-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String decodeAbiString(@NotNull String encodedString, int startPosition) {
            Intrinsics.checkNotNullParameter((Object)encodedString, (String)"encodedString");
            String inputData = DataUtils.INSTANCE.removePrefix(encodedString);
            try {
                if (inputData.length() < startPosition + 64) {
                    throw new IllegalArgumentException("Data is too short for extracting offset");
                }
                String string = inputData.substring(startPosition, startPosition + 64);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String offsetHex = string;
                int offset = DataUtils.INSTANCE.decodeQuantity(DataUtils.INSTANCE.addPrefix(offsetHex)).intValue();
                if (offset * 2 + 64 > inputData.length()) {
                    throw new IllegalArgumentException("Invalid offset or data length");
                }
                String string2 = inputData.substring(offset * 2, offset * 2 + 64);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String lengthHex = string2;
                int length = DataUtils.INSTANCE.decodeQuantity(DataUtils.INSTANCE.addPrefix(lengthHex)).intValue();
                int stringStart = offset * 2 + 64;
                int stringEnd = stringStart + length * 2;
                if (inputData.length() < stringEnd) {
                    throw new IllegalArgumentException("String end exceeds data length");
                }
                String string3 = inputData.substring(stringStart, stringEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String stringHex = string3;
                return new String(DataUtils.INSTANCE.hexStringToByteArray(DataUtils.INSTANCE.addPrefix(stringHex)), Charsets.UTF_8);
            }
            catch (Exception e) {
                logger.error("Error decoding string at offset: " + startPosition, (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Object> decodeArray(@NotNull String elementType, @NotNull String fullData, int startPosition) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)fullData, (String)"fullData");
            String inputData = DataUtils.INSTANCE.removePrefix(fullData);
            String string = inputData.substring(startPosition, startPosition + 64);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String arrayOffsetHex = string;
            int arrayOffset = DataUtils.INSTANCE.decodeQuantity(DataUtils.INSTANCE.addPrefix(arrayOffsetHex)).intValue() * 2;
            String string2 = inputData.substring(arrayOffset, arrayOffset + 64);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String arrayLengthHex = string2;
            int arrayLength = DataUtils.INSTANCE.decodeQuantity(DataUtils.INSTANCE.addPrefix(arrayLengthHex)).intValue();
            List decodedArray = new ArrayList();
            int currentOffset = arrayOffset + 64;
            for (int i = 0; i < arrayLength; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)inputData.substring(currentOffset, currentOffset + 64), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                try {
                    Types types;
                    Object object;
                    String prefixedElementData;
                    block5: {
                        Types types2;
                        void $this$firstOrNull$iv$iv;
                        String elementData;
                        prefixedElementData = DataUtils.INSTANCE.addPrefix(elementData);
                        Companion this_$iv = this;
                        boolean $i$f$decodeBasicType = false;
                        object = Types.values();
                        boolean $i$f$firstOrNull = false;
                        int n = ((void)$this$firstOrNull$iv$iv).length;
                        for (int j = 0; j < n; ++j) {
                            void element$iv$iv;
                            void it$iv = element$iv$iv = $this$firstOrNull$iv$iv[j];
                            boolean bl = false;
                            if (!it$iv.isType(elementType)) continue;
                            types2 = element$iv$iv;
                            break block5;
                        }
                        types2 = types = null;
                    }
                    if (types == null || (object = Types.decode$default(types, prefixedElementData, Object.class, elementType, null, 0, null, 32, null)) == null) {
                        throw new IllegalArgumentException("Unsupported type: " + elementType);
                    }
                    Object element = object;
                    decodedArray.add(((DecodedValue)element).getActualValue());
                }
                catch (Exception e) {
                    logger.error("Error decoding element " + i + " of type " + elementType + " at offset " + currentOffset + ": " + e.getMessage());
                    throw e;
                }
                currentOffset += 64;
            }
            return decodedArray;
        }

        /*
         * WARNING - void declaration
         */
        private final /* synthetic */ <T> DecodedValue<T> decodeBasicType(String typeName, String encoded) {
            Object object;
            block5: {
                block4: {
                    Object v0;
                    block3: {
                        void $this$firstOrNull$iv;
                        boolean $i$f$decodeBasicType = false;
                        object = Types.values();
                        boolean $i$f$firstOrNull = false;
                        for (void element$iv : $this$firstOrNull$iv) {
                            Types it = (Types)element$iv;
                            boolean bl = false;
                            if (!it.isType(typeName)) continue;
                            v0 = element$iv;
                            break block3;
                        }
                        v0 = null;
                    }
                    Types types = v0;
                    if (types == null) break block4;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    object = Types.decode$default(types, encoded, Object.class, typeName, null, 0, null, 32, null);
                    if (object != null) break block5;
                }
                throw new IllegalArgumentException("Unsupported type: " + typeName);
            }
            return (DecodedValue)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001JT\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/vechain/indexer/event/types/Types$ADDRESS;", "Lorg/vechain/indexer/event/types/Types;", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "isType", "", "typeName", "indexer-core"})
    static final class ADDRESS
    extends Types {
        /*
         * WARNING - void declaration
         */
        ADDRESS() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return Intrinsics.areEqual((Object)typeName, (Object)"address");
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (encoded.length() < 64) {
                throw new IllegalArgumentException("Invalid address length: " + encoded);
            }
            String decoded = "0x" + StringsKt.takeLast((String)encoded, (int)40);
            return new DecodedValue<T>(decoded, clazz, clazz.cast(decoded), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return String.class;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001JT\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/vechain/indexer/event/types/Types$UINT;", "Lorg/vechain/indexer/event/types/Types;", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "isType", "", "typeName", "indexer-core"})
    static final class UINT
    extends Types {
        /*
         * WARNING - void declaration
         */
        UINT() {
            void var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            if (!StringsKt.startsWith$default((String)typeName, (String)"uint", (boolean)false, (int)2, null)) return false;
            if (Intrinsics.areEqual((Object)typeName, (Object)"uint")) return true;
            IntRange intRange = new IntRange(8, 256);
            Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)typeName, (CharSequence)"uint"));
            if (n == null) return false;
            if (!intRange.contains(n.intValue())) return false;
            return true;
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            BigInteger decoded = DataUtils.INSTANCE.decodeQuantity(encoded);
            String string = decoded.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decoded.toString()");
            return new DecodedValue<T>(string, clazz, clazz.cast(decoded), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return BigInteger.class;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001JT\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/vechain/indexer/event/types/Types$BOOL;", "Lorg/vechain/indexer/event/types/Types;", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "isType", "", "typeName", "indexer-core"})
    static final class BOOL
    extends Types {
        /*
         * WARNING - void declaration
         */
        BOOL() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return Intrinsics.areEqual((Object)typeName, (Object)"bool");
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            BigInteger decodedValue = DataUtils.INSTANCE.decodeQuantity(encoded);
            boolean boolValue = Intrinsics.areEqual((Object)decodedValue, (Object)BigInteger.ONE);
            return new DecodedValue<T>(String.valueOf(boolValue), clazz, clazz.cast(boolValue), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return Boolean.TYPE;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001JT\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/vechain/indexer/event/types/Types$BYTES;", "Lorg/vechain/indexer/event/types/Types;", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "isType", "", "typeName", "indexer-core"})
    static final class BYTES
    extends Types {
        /*
         * WARNING - void declaration
         */
        BYTES() {
            void var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            if (Intrinsics.areEqual((Object)typeName, (Object)"bytes")) return true;
            if (!StringsKt.startsWith$default((String)typeName, (String)"bytes", (boolean)false, (int)2, null)) return false;
            IntRange intRange = new IntRange(1, 32);
            Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)typeName, (CharSequence)"bytes"));
            if (n == null) return false;
            if (!intRange.contains(n.intValue())) return false;
            return true;
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (encoded.length() % 2 != 0 || !StringsKt.startsWith$default((String)encoded, (String)"0x", (boolean)false, (int)2, null)) {
                throw new IllegalArgumentException("Invalid bytes value: " + encoded);
            }
            return new DecodedValue<T>(encoded, clazz, clazz.cast(encoded), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return String.class;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001JT\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/vechain/indexer/event/types/Types$STRING;", "Lorg/vechain/indexer/event/types/Types;", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "isType", "", "typeName", "indexer-core"})
    static final class STRING
    extends Types {
        /*
         * WARNING - void declaration
         */
        STRING() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return Intrinsics.areEqual((Object)typeName, (Object)"string");
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            CharSequence charSequence = fullData;
            if (charSequence == null || charSequence.length() == 0) {
                return new DecodedValue<T>(encoded, clazz, clazz.cast(encoded), name);
            }
            charSequence = Companion.decodeAbiString(fullData, startPosition);
            if (charSequence != null) {
                CharSequence it = charSequence;
                boolean bl = false;
                return new DecodedValue<T>((String)it, clazz, clazz.cast(it), name);
            }
            throw new IllegalArgumentException("Error decoding string at offset: " + startPosition);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return String.class;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001JT\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/vechain/indexer/event/types/Types$TUPLE;", "Lorg/vechain/indexer/event/types/Types;", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "isType", "", "typeName", "indexer-core"})
    static final class TUPLE
    extends Types {
        /*
         * WARNING - void declaration
         */
        TUPLE() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return Intrinsics.areEqual((Object)typeName, (Object)"tuple");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (components == null) {
                throw new IllegalArgumentException("Components must be provided for tuple types");
            }
            String string = fullData;
            if (string == null) {
                string = encoded;
            }
            String inputData = DataUtils.INSTANCE.removePrefix(string);
            Map decodedComponents = new LinkedHashMap();
            int currentOffset = startPosition;
            for (InputOutput component : components) {
                String componentData;
                Types types;
                Object object;
                block6: {
                    Types types2;
                    void $this$firstOrNull$iv;
                    if (inputData.length() < currentOffset + 64) {
                        throw new IllegalArgumentException("Data too short for tuple component at offset " + currentOffset);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)inputData.substring(currentOffset, currentOffset + 64), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    object = Types.values();
                    boolean $i$f$firstOrNull = false;
                    int n = ((void)$this$firstOrNull$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!it.isType(component.getType())) continue;
                        types2 = element$iv;
                        break block6;
                    }
                    types2 = types = null;
                }
                if (types == null || (object = Types.decode$default(types, DataUtils.INSTANCE.addPrefix(componentData), Object.class, component.getType(), fullData, currentOffset, null, 32, null)) == null) {
                    throw new IllegalArgumentException("Unsupported type in tuple: " + component.getType());
                }
                Object decodedComponent = object;
                decodedComponents.put(component.getName(), ((DecodedValue)decodedComponent).getActualValue());
                currentOffset += 64;
            }
            return new DecodedValue<T>(decodedComponents.toString(), clazz, clazz.cast(decodedComponents), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return List.class;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001JT\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/vechain/indexer/event/types/Types$ARRAY;", "Lorg/vechain/indexer/event/types/Types;", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "isType", "", "typeName", "indexer-core"})
    static final class ARRAY
    extends Types {
        /*
         * WARNING - void declaration
         */
        ARRAY() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return StringsKt.endsWith$default((String)typeName, (String)"[]", (boolean)false, (int)2, null) || new Regex(".+\\[\\d+\\]").matches(charSequence = (CharSequence)typeName);
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            String string;
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (StringsKt.endsWith$default((String)name, (String)"[]", (boolean)false, (int)2, null)) {
                string = StringsKt.removeSuffix((String)name, (CharSequence)"[]");
            } else {
                CharSequence charSequence = name;
                if (new Regex(".+\\[\\d+\\]").matches(charSequence)) {
                    string = StringsKt.substringBeforeLast$default((String)name, (String)"[", null, (int)2, null);
                } else {
                    throw new IllegalArgumentException("Invalid array type: " + name);
                }
            }
            String elementType = string;
            String string2 = fullData;
            if (string2 == null) {
                string2 = encoded;
            }
            List<Object> decodedElements = Companion.decodeArray(elementType, string2, startPosition);
            String stringRepresentation2 = CollectionsKt.joinToString$default((Iterable)decodedElements, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)decode.stringRepresentation.1.INSTANCE, (int)25, null);
            return new DecodedValue<T>(stringRepresentation2, clazz, clazz.cast(decodedElements), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return List.class;
        }
    }
}

