/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.BlockIndexer;
import org.vechain.indexer.LogsIndexer;
import org.vechain.indexer.Status;
import org.vechain.indexer.event.AbiManager;
import org.vechain.indexer.event.BusinessEventManager;
import org.vechain.indexer.event.BusinessEventProcessor;
import org.vechain.indexer.event.GenericEventIndexer;
import org.vechain.indexer.event.model.generic.FilterCriteria;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.exception.BlockNotFoundException;
import org.vechain.indexer.exception.ReorgException;
import org.vechain.indexer.thor.client.ThorClient;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.BlockIdentifier;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b&\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u00106\u001a\u000207H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b8\u00109J\u0011\u0010:\u001a\u000207H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u0011\u0010;\u001a\u00020<H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u0019\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\n\u0010@\u001a\u0004\u0018\u00010 H&J\r\u0010A\u001a\u000207H\u0000\u00a2\u0006\u0002\bBJ\b\u0010C\u001a\u000207H\u0002J\b\u0010D\u001a\u000207H\u0002J\r\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0002\bGJ\u0019\u0010H\u001a\u0002072\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010%J\u0019\u0010I\u001a\u0002072\u0006\u0010J\u001a\u00020<H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KJ \u0010L\u001a\b\u0012\u0004\u0012\u00020N0M2\u0006\u0010J\u001a\u00020<2\b\b\u0002\u0010O\u001a\u00020PH\u0014J\u0010\u0010Q\u001a\u0002072\u0006\u0010J\u001a\u00020<H&J&\u0010R\u001a\b\u0012\u0004\u0012\u00020N0M2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020N0M2\b\b\u0002\u0010O\u001a\u00020PH\u0014J \u0010T\u001a\b\u0012\u0004\u0012\u00020N0M2\u0006\u0010J\u001a\u00020<2\b\b\u0002\u0010O\u001a\u00020PH\u0014J=\u0010U\u001a\b\u0012\u0004\u0012\u00020N0M2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020N0M2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u001c0M2\n\b\u0002\u0010W\u001a\u0004\u0018\u00010FH\u0000\u00a2\u0006\u0004\bX\u0010YJ\u0011\u0010Z\u001a\u000207H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u0010\u0010[\u001a\u0002072\u0006\u0010>\u001a\u00020\u0005H&J\u0011\u0010\\\u001a\u000207H\u0082P\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u001d\u0010]\u001a\u0002072\n\b\u0002\u0010^\u001a\u0004\u0018\u00010\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010_J\u0017\u0010`\u001a\u0002072\n\b\u0002\u0010^\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010%R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010&\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0014R$\u0010)\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020(@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R$\u00101\u001a\u0002002\u0006\u0010\u0011\u001a\u000200@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006a"}, d2={"Lorg/vechain/indexer/BlockIndexer;", "", "thorClient", "Lorg/vechain/indexer/thor/client/ThorClient;", "startBlock", "", "syncLoggerInterval", "abiManager", "Lorg/vechain/indexer/event/AbiManager;", "businessEventManager", "Lorg/vechain/indexer/event/BusinessEventManager;", "(Lorg/vechain/indexer/thor/client/ThorClient;JJLorg/vechain/indexer/event/AbiManager;Lorg/vechain/indexer/event/BusinessEventManager;)V", "getAbiManager", "()Lorg/vechain/indexer/event/AbiManager;", "backoffPeriod", "getBusinessEventManager", "()Lorg/vechain/indexer/event/BusinessEventManager;", "<set-?>", "currentBlockNumber", "getCurrentBlockNumber", "()J", "setCurrentBlockNumber", "(J)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "name", "", "getName", "()Ljava/lang/String;", "previousBlock", "Lorg/vechain/indexer/thor/model/BlockIdentifier;", "remainingIterations", "getRemainingIterations$indexer_core", "()Ljava/lang/Long;", "setRemainingIterations$indexer_core", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getStartBlock", "Lorg/vechain/indexer/Status;", "status", "getStatus", "()Lorg/vechain/indexer/Status;", "setStatus", "(Lorg/vechain/indexer/Status;)V", "getThorClient", "()Lorg/vechain/indexer/thor/client/ThorClient;", "Ljava/time/LocalDateTime;", "timeLastProcessed", "getTimeLastProcessed", "()Ljava/time/LocalDateTime;", "setTimeLastProcessed$indexer_core", "(Ljava/time/LocalDateTime;)V", "backoffDelay", "", "backoffDelay$indexer_core", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ensureFullySynced", "getBestBlockFromChain", "Lorg/vechain/indexer/thor/model/Block;", "getBlockFromChain", "blockNumber", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastSyncedBlock", "handleError", "handleError$indexer_core", "handleFullySynced", "handleReorg", "hasNoRemainingIterations", "", "hasNoRemainingIterations$indexer_core", "initialise", "postProcessBlock", "block", "(Lorg/vechain/indexer/thor/model/Block;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processAllEvents", "", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "criteria", "Lorg/vechain/indexer/event/model/generic/FilterCriteria;", "processBlock", "processBlockBusinessEvents", "decodedEvents", "processBlockGenericEvents", "processBusinessEvents", "businessEventNames", "removeDuplicates", "processBusinessEvents$indexer_core", "(Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;)Ljava/util/List;", "restart", "rollback", "run", "start", "iterations", "(Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startInCoroutine", "indexer-core"})
public abstract class BlockIndexer {
    @NotNull
    private final ThorClient thorClient;
    private final long startBlock;
    private final long syncLoggerInterval;
    @Nullable
    private final AbiManager abiManager;
    @Nullable
    private final BusinessEventManager businessEventManager;
    @Nullable
    private BlockIdentifier previousBlock;
    @Nullable
    private Long remainingIterations;
    @NotNull
    private final Logger logger;
    @NotNull
    private Status status;
    private long currentBlockNumber;
    @NotNull
    private LocalDateTime timeLastProcessed;
    private long backoffPeriod;

    public BlockIndexer(@NotNull ThorClient thorClient, long startBlock, long syncLoggerInterval, @Nullable AbiManager abiManager, @Nullable BusinessEventManager businessEventManager) {
        Intrinsics.checkNotNullParameter((Object)thorClient, (String)"thorClient");
        this.thorClient = thorClient;
        this.startBlock = startBlock;
        this.syncLoggerInterval = syncLoggerInterval;
        this.abiManager = abiManager;
        this.businessEventManager = businessEventManager;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
        this.status = Status.SYNCING;
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(ZoneOffset.UTC)");
        this.timeLastProcessed = localDateTime;
    }

    public /* synthetic */ BlockIndexer(ThorClient thorClient, long l, long l2, AbiManager abiManager, BusinessEventManager businessEventManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = 1000L;
        }
        if ((n & 8) != 0) {
            abiManager = null;
        }
        if ((n & 0x10) != 0) {
            businessEventManager = null;
        }
        this(thorClient, l, l2, abiManager, businessEventManager);
    }

    @NotNull
    protected ThorClient getThorClient() {
        return this.thorClient;
    }

    protected final long getStartBlock() {
        return this.startBlock;
    }

    @Nullable
    protected AbiManager getAbiManager() {
        return this.abiManager;
    }

    @Nullable
    protected BusinessEventManager getBusinessEventManager() {
        return this.businessEventManager;
    }

    @Nullable
    public final Long getRemainingIterations$indexer_core() {
        return this.remainingIterations;
    }

    public final void setRemainingIterations$indexer_core(@Nullable Long l) {
        this.remainingIterations = l;
    }

    @NotNull
    public final String getName() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.simpleName");
        return string;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    protected final void setStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"<set-?>");
        this.status = status;
    }

    public final long getCurrentBlockNumber() {
        return this.currentBlockNumber;
    }

    protected final void setCurrentBlockNumber(long l) {
        this.currentBlockNumber = l;
    }

    @NotNull
    public final LocalDateTime getTimeLastProcessed() {
        return this.timeLastProcessed;
    }

    public final void setTimeLastProcessed$indexer_core(@NotNull LocalDateTime localDateTime) {
        Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"<set-?>");
        this.timeLastProcessed = localDateTime;
    }

    private final void initialise(Long blockNumber) {
        BlockIdentifier lastBlock;
        long l;
        Long l2 = blockNumber;
        if (l2 != null) {
            l = l2;
        } else {
            BlockIdentifier blockIdentifier = this.getLastSyncedBlock();
            Long l3 = blockIdentifier != null ? Long.valueOf(blockIdentifier.getNumber()) : null;
            l = l3 != null ? l3 : this.startBlock;
        }
        long lastSyncedBlockNumber = l;
        this.rollback(lastSyncedBlockNumber);
        this.currentBlockNumber = lastSyncedBlockNumber;
        this.status = Status.SYNCING;
        BlockIdentifier blockIdentifier = lastBlock = this.getLastSyncedBlock();
        this.previousBlock = (blockIdentifier != null ? blockIdentifier.getNumber() == lastSyncedBlockNumber - 1L : false) ? lastBlock : null;
    }

    static /* synthetic */ void initialise$default(BlockIndexer blockIndexer, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialise");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        blockIndexer.initialise(l);
    }

    public final void startInCoroutine(@Nullable Long iterations) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, iterations, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BlockIndexer this$0;
            final /* synthetic */ Long $iterations;
            {
                this.this$0 = $receiver;
                this.$iterations = $iterations;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        Object object3 = this.this$0.start(this.$iterations, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            this.this$0.getLogger().error("Error starting indexer " + $this$launch.getClass().getSimpleName() + ": ", (Throwable)e);
                            throw new Exception(e.getMessage(), e);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void startInCoroutine$default(BlockIndexer blockIndexer, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startInCoroutine");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        blockIndexer.startInCoroutine(l);
    }

    @Nullable
    public Object start(@Nullable Long iterations, @NotNull Continuation<? super Unit> $completion) {
        return BlockIndexer.start$suspendImpl(this, iterations, $completion);
    }

    static /* synthetic */ Object start$suspendImpl(BlockIndexer $this, Long iterations, Continuation<? super Unit> $completion) {
        $this.remainingIterations = iterations;
        if (!($this instanceof LogsIndexer)) {
            BlockIndexer.initialise$default($this, null, 1, null);
        }
        $this.logger.info("Starting @ Block: " + $this.currentBlockNumber);
        Object object = $this.run($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object start$default(BlockIndexer blockIndexer, Long l, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        return blockIndexer.start(l, (Continuation<? super Unit>)continuation);
    }

    private final Object restart(Continuation<? super Unit> $completion) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.status.ordinal()]) {
            case 1: {
                this.initialise(Boxing.boxLong((long)this.currentBlockNumber));
                break;
            }
            case 2: {
                this.initialise(Boxing.boxLong((long)(this.currentBlockNumber - 1L)));
                break;
            }
            default: {
                BlockIndexer.initialise$default(this, null, 1, null);
            }
        }
        this.logger.info("Restarting indexer @ Block: " + this.currentBlockNumber);
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object run(Continuation<? super Unit> var1_1) {
        block31: {
            if (!(var1_1 instanceof run.1)) ** GOTO lbl-1000
            var6_2 = var1_1;
            if ((var6_2.label & -2147483648) != 0) {
                var6_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ BlockIndexer this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return BlockIndexer.access$run(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
lbl12:
                    // 2 sources

                    while (true) {
                        if (this.hasNoRemainingIterations$indexer_core()) {
                            return Unit.INSTANCE;
                        }
                        $continuation.L$0 = this;
                        $continuation.label = 1;
                        v0 = this.backoffDelay$indexer_core((Continuation<? super Unit>)$continuation);
                        ** if (v0 != var7_4) goto lbl22
lbl21:
                        // 1 sources

                        return var7_4;
lbl22:
                        // 1 sources

                        ** GOTO lbl29
                        break;
                    }
                }
                case 1: {
                    this = (BlockIndexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    if (this.status != Status.ERROR && this.status != Status.REORG) ** GOTO lbl42
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v1 = this.restart((Continuation<? super Unit>)$continuation);
                    ** if (v1 != var7_4) goto lbl35
lbl34:
                    // 1 sources

                    return var7_4;
lbl35:
                    // 1 sources

                    ** GOTO lbl42
                }
                case 2: {
                    this = (BlockIndexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl42:
                    // 3 sources

                    $continuation.L$0 = this;
                    $continuation.label = 3;
                    v2 = this.getBlockFromChain(this.currentBlockNumber, (Continuation<? super Block>)$continuation);
                    ** if (v2 != var7_4) goto lbl47
lbl46:
                    // 1 sources

                    return var7_4;
lbl47:
                    // 1 sources

                    ** GOTO lbl54
                }
                case 3: {
                    this = (BlockIndexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl54:
                    // 2 sources

                    block = (Block)v2;
                    if (this.currentBlockNumber > this.startBlock) {
                        v3 = this.previousBlock;
                        if (v3 != null && (v3 = v3.getId()) != null) {
                            it = v3;
                            $i$a$-let-BlockIndexer$run$2 = false;
                            v4 = !Intrinsics.areEqual((Object)it, (Object)block.getParentID());
                        } else {
                            v4 = false;
                        }
                        if (v4) {
                            throw new ReorgException("Chain re-organization detected @ Block " + this.currentBlockNumber + " with parent block ID " + block.getParentID());
                        }
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Processing @ Block " + this.currentBlockNumber + " (" + (Object)this.status + ')');
                    } else if (this.status != Status.SYNCING || this.currentBlockNumber % this.syncLoggerInterval == 0L) {
                        this.logger.info("Processing @ Block " + this.currentBlockNumber + " (" + (Object)this.status + ')');
                    }
                    this.processBlock(block);
                    $continuation.L$0 = this;
                    $continuation.label = 4;
                    v5 = this.postProcessBlock(block, (Continuation<? super Unit>)$continuation);
                    if (v5 != var7_4) break block31;
                    return var7_4;
                }
                case 4: {
                    this = (BlockIndexer)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
                    }
                    catch (BlockNotFoundException block) {
                        this.logger.info("Block " + this.currentBlockNumber + " not found. Indexer may be fully synchronised.");
                        this.handleFullySynced();
                        $continuation.L$0 = this;
                        $continuation.label = 5;
                        v6 = this.ensureFullySynced((Continuation<? super Unit>)$continuation);
                        if (v6 == var7_4) {
                            return var7_4;
                        }
                        break block31;
                    }
                }
                case 5: {
                    this = (BlockIndexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
                    break block31;
                }
            }
            catch (ReorgException block) {
                this.logger.error("REORG @ Block " + this.currentBlockNumber);
                this.handleReorg();
                break block31;
            }
            catch (Exception e) {
                this.logger.error("Error while processing block " + this.currentBlockNumber, (Throwable)e);
                this.handleError$indexer_core();
            }
        }
        ** while (true)
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasNoRemainingIterations$indexer_core() {
        if (this.remainingIterations != null) {
            Long l = this.remainingIterations;
            Intrinsics.checkNotNull((Object)l);
            if (l <= 0L) {
                this.logger.info("Indexer finished at block " + this.currentBlockNumber);
                return true;
            }
            Long l2 = this.remainingIterations;
            this.remainingIterations = l2 != null ? Long.valueOf(l2 + -1L) : null;
        }
        return false;
    }

    private final void handleFullySynced() {
        this.backoffPeriod = 4000L;
        this.status = Status.FULLY_SYNCED;
    }

    public final void handleError$indexer_core() {
        this.backoffPeriod = 10000L;
        this.status = Status.ERROR;
    }

    private final void handleReorg() {
        this.backoffPeriod = 10000L;
        this.status = Status.REORG;
    }

    /*
     * Unable to fully structure code
     */
    private final Object postProcessBlock(Block var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof postProcessBlock.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BlockIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BlockIndexer.access$postProcessBlock(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.status == Status.FULLY_SYNCED && this.currentBlockNumber % (long)20 == 0L) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = block;
                    $continuation.label = 1;
                    v0 = this.ensureFullySynced((Continuation<? super Unit>)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                }
                ** GOTO lbl25
            }
            case 1: {
                block = (Block)$continuation.L$1;
                this = (BlockIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (this.status == Status.FULLY_SYNCED) {
                    currentEpoch = LocalDateTime.now(ZoneOffset.UTC).toInstant(ZoneOffset.UTC).toEpochMilli();
                    timeSinceLastBlock = Math.max(currentEpoch - block.getTimestamp() * (long)1000, 0L);
                    this.backoffPeriod = Math.max(0L, 10000L - timeSinceLastBlock) + (long)100;
                    this.logger.info("Success @ Block " + this.currentBlockNumber + " (" + timeSinceLastBlock + " ms since mine)");
                }
                var3_6 = this.currentBlockNumber;
                this.currentBlockNumber = var3_6 + 1L;
                this.previousBlock = new BlockIdentifier(block.getNumber(), block.getId());
                v1 = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"now(ZoneOffset.UTC)");
                this.timeLastProcessed = v1;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object ensureFullySynced(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof ensureFullySynced.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BlockIndexer.access$ensureFullySynced(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.status != Status.FULLY_SYNCED) ** GOTO lbl26
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.getBestBlockFromChain((Continuation<? super Block>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (BlockIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if ((latestBlock = (Block)v0).getNumber() > this.currentBlockNumber) {
                    this.logger.info(this.getName() + " - Changing status to SYNCING (indexerBlock=" + this.currentBlockNumber + ", latestBlock=" + latestBlock.getNumber() + ')');
                    this.status = Status.SYNCING;
                }
lbl26:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object backoffDelay$indexer_core(@NotNull Continuation<? super Unit> $completion) {
        if (this.status != Status.SYNCING) {
            Object object = DelayKt.delay((long)this.backoffPeriod, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Object getBlockFromChain(long blockNumber, Continuation<? super Block> $completion) {
        return this.getThorClient().getBlock(blockNumber, $completion);
    }

    private final Object getBestBlockFromChain(Continuation<? super Block> $completion) {
        return this.getThorClient().getBestBlock($completion);
    }

    @Nullable
    public abstract BlockIdentifier getLastSyncedBlock();

    public abstract void rollback(long var1);

    public abstract void processBlock(@NotNull Block var1);

    @NotNull
    protected List<IndexedEvent> processAllEvents(@NotNull Block block, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        Object object = this.getBusinessEventManager();
        if (object == null || (object = ((BusinessEventManager)object).updateCriteriaWithBusinessEvents(criteria)) == null) {
            object = criteria;
        }
        Object updatedCriteria = object;
        List<IndexedEvent> decodedEvents = this.processBlockGenericEvents(block, (FilterCriteria)updatedCriteria);
        return this.processBusinessEvents$indexer_core(decodedEvents, ((FilterCriteria)updatedCriteria).getBusinessEventNames(), ((FilterCriteria)updatedCriteria).getRemoveDuplicates());
    }

    public static /* synthetic */ List processAllEvents$default(BlockIndexer blockIndexer, Block block, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processAllEvents");
        }
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return blockIndexer.processAllEvents(block, filterCriteria);
    }

    @NotNull
    protected List<IndexedEvent> processBlockGenericEvents(@NotNull Block block, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (this.getAbiManager() == null) {
            this.logger.warn("ABI Manager is not configured. Skipping generic event processing.");
            return CollectionsKt.emptyList();
        }
        AbiManager abiManager = this.getAbiManager();
        Intrinsics.checkNotNull((Object)abiManager);
        GenericEventIndexer eventIndexer = new GenericEventIndexer(abiManager);
        return eventIndexer.getBlockEventsByFilters(block, criteria);
    }

    public static /* synthetic */ List processBlockGenericEvents$default(BlockIndexer blockIndexer, Block block, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBlockGenericEvents");
        }
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return blockIndexer.processBlockGenericEvents(block, filterCriteria);
    }

    @NotNull
    protected List<IndexedEvent> processBlockBusinessEvents(@NotNull List<IndexedEvent> decodedEvents, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter(decodedEvents, (String)"decodedEvents");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (this.getBusinessEventManager() == null) {
            this.logger.warn("Business Event Manager is not configured. Skipping business event processing.");
            return CollectionsKt.emptyList();
        }
        BusinessEventManager businessEventManager = this.getBusinessEventManager();
        Intrinsics.checkNotNull((Object)businessEventManager);
        BusinessEventProcessor processor = new BusinessEventProcessor(businessEventManager);
        return processor.getOnlyBusinessEvents(decodedEvents, criteria.getBusinessEventNames(), this instanceof LogsIndexer);
    }

    public static /* synthetic */ List processBlockBusinessEvents$default(BlockIndexer blockIndexer, List list, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBlockBusinessEvents");
        }
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return blockIndexer.processBlockBusinessEvents(list, filterCriteria);
    }

    @NotNull
    public final List<IndexedEvent> processBusinessEvents$indexer_core(@NotNull List<IndexedEvent> decodedEvents, @NotNull List<String> businessEventNames, @Nullable Boolean removeDuplicates) {
        Intrinsics.checkNotNullParameter(decodedEvents, (String)"decodedEvents");
        Intrinsics.checkNotNullParameter(businessEventNames, (String)"businessEventNames");
        if (this.getBusinessEventManager() != null) {
            BusinessEventManager businessEventManager = this.getBusinessEventManager();
            Intrinsics.checkNotNull((Object)businessEventManager);
            BusinessEventProcessor processor = new BusinessEventProcessor(businessEventManager);
            boolean logsIndexer = this instanceof LogsIndexer;
            Boolean bl = removeDuplicates;
            return processor.processEvents(decodedEvents, businessEventNames, bl != null ? bl : true, logsIndexer);
        }
        this.logger.debug("Skipping business event processing as manager is missing.");
        return decodedEvents;
    }

    public static /* synthetic */ List processBusinessEvents$indexer_core$default(BlockIndexer blockIndexer, List list, List list2, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBusinessEvents");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return blockIndexer.processBusinessEvents$indexer_core(list, list2, bl);
    }

    public static final /* synthetic */ Object access$restart(BlockIndexer $this, Continuation $completion) {
        return $this.restart((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$run(BlockIndexer $this, Continuation $completion) {
        return $this.run((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$postProcessBlock(BlockIndexer $this, Block block, Continuation $completion) {
        return $this.postProcessBlock(block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$ensureFullySynced(BlockIndexer $this, Continuation $completion) {
        return $this.ensureFullySynced((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$getBlockFromChain(BlockIndexer $this, long blockNumber, Continuation $completion) {
        return $this.getBlockFromChain(blockNumber, (Continuation<? super Block>)$completion);
    }

    public static final /* synthetic */ Object access$getBestBlockFromChain(BlockIndexer $this, Continuation $completion) {
        return $this.getBestBlockFromChain((Continuation<? super Block>)$completion);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.REORG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

