/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vechain.indexer.BlockIndexer;
import org.vechain.indexer.LogsIndexer;
import org.vechain.indexer.Status;
import org.vechain.indexer.event.AbiManager;
import org.vechain.indexer.event.BusinessEventManager;
import org.vechain.indexer.event.GenericEventIndexer;
import org.vechain.indexer.event.model.abi.AbiElement;
import org.vechain.indexer.event.model.generic.FilterCriteria;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.thor.client.ThorClient;
import org.vechain.indexer.thor.enums.LogType;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.BlockIdentifier;
import org.vechain.indexer.thor.model.EventCriteria;
import org.vechain.indexer.thor.model.EventLog;
import org.vechain.indexer.thor.model.EventLogsRequest;
import org.vechain.indexer.thor.model.EventMeta;
import org.vechain.indexer.thor.model.LogFetchResult;
import org.vechain.indexer.thor.model.LogsOptions;
import org.vechain.indexer.thor.model.LogsRange;
import org.vechain.indexer.thor.model.Transaction;
import org.vechain.indexer.thor.model.TransferCriteria;
import org.vechain.indexer.thor.model.TransferLog;
import org.vechain.indexer.thor.model.TransferLogsRequest;
import org.vechain.indexer.thor.model.TxEvent;
import org.vechain.indexer.thor.model.TxOutputs;
import org.vechain.indexer.thor.model.TxTransfer;
import org.vechain.indexer.utils.LogsUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J'\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\r2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J!\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J'\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J \u0010'\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0019\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010.J6\u0010/\u001a\b\u0012\u0004\u0012\u0002000\r2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001f0\r2\u000e\b\u0002\u00102\u001a\b\u0012\u0004\u0012\u00020&0\r2\b\b\u0002\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020,2\u0006\u00106\u001a\u000207H\u0016J&\u00108\u001a\b\u0012\u0004\u0012\u00020\u001f0\r2\u0006\u00109\u001a\u00020:2\u0006\u00106\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002J6\u0010=\u001a\b\u0012\u0004\u0012\u0002000\r2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001f0\r2\u000e\b\u0002\u00102\u001a\b\u0012\u0004\u0012\u00020&0\r2\b\b\u0002\u00103\u001a\u000204H\u0014J&\u0010>\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u00109\u001a\u00020:2\u0006\u00106\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002J$\u0010?\u001a\u00020,2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001f0\r2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020&0\rH&J\u001b\u0010B\u001a\u00020,2\b\u0010C\u001a\u0004\u0018\u00010\u0005H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DJ\u0019\u0010E\u001a\u00020,2\u0006\u0010!\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u001c\u0010G\u001a\u00020\u001f*\u00020H2\u0006\u00106\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002J\u001c\u0010I\u001a\u00020&*\u00020J2\u0006\u00106\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2={"Lorg/vechain/indexer/LogsIndexer;", "Lorg/vechain/indexer/BlockIndexer;", "thorClient", "Lorg/vechain/indexer/thor/client/ThorClient;", "startBlock", "", "syncLoggerInterval", "logsType", "", "Lorg/vechain/indexer/thor/enums/LogType;", "blockBatchSize", "logFetchLimit", "eventCriteriaSet", "", "Lorg/vechain/indexer/thor/model/EventCriteria;", "transferCriteriaSet", "Lorg/vechain/indexer/thor/model/TransferCriteria;", "abiManager", "Lorg/vechain/indexer/event/AbiManager;", "businessEventManager", "Lorg/vechain/indexer/event/BusinessEventManager;", "(Lorg/vechain/indexer/thor/client/ThorClient;JJLjava/util/Set;JJLjava/util/List;Ljava/util/List;Lorg/vechain/indexer/event/AbiManager;Lorg/vechain/indexer/event/BusinessEventManager;)V", "getAbiManager", "()Lorg/vechain/indexer/event/AbiManager;", "getBusinessEventManager", "()Lorg/vechain/indexer/event/BusinessEventManager;", "cachedConfiguredEvents", "Lorg/vechain/indexer/event/model/abi/AbiElement;", "getThorClient", "()Lorg/vechain/indexer/thor/client/ThorClient;", "fetchEventLogs", "Lorg/vechain/indexer/thor/model/EventLog;", "fromBlock", "toBlock", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchLogs", "Lorg/vechain/indexer/thor/model/LogFetchResult;", "fetchTransfers", "Lorg/vechain/indexer/thor/model/TransferLog;", "hasMultipleInRange", "", "endBlock", "x", "initialise", "", "blockNumber", "(Ljava/lang/Long;)V", "processAllEvents", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "eventLogs", "transferLogs", "criteria", "Lorg/vechain/indexer/event/model/generic/FilterCriteria;", "processBlock", "block", "Lorg/vechain/indexer/thor/model/Block;", "processBlockEvents", "output", "Lorg/vechain/indexer/thor/model/TxOutputs;", "tx", "Lorg/vechain/indexer/thor/model/Transaction;", "processBlockGenericEvents", "processBlockTransfers", "processLogs", "events", "transfers", "start", "iterations", "(Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "syncLogs", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toEventLog", "Lorg/vechain/indexer/thor/model/TxEvent;", "toTransferLog", "Lorg/vechain/indexer/thor/model/TxTransfer;", "indexer-core"})
public abstract class LogsIndexer
extends BlockIndexer {
    @NotNull
    private final ThorClient thorClient;
    private final long syncLoggerInterval;
    @NotNull
    private final Set<LogType> logsType;
    private final long blockBatchSize;
    private final long logFetchLimit;
    @Nullable
    private List<EventCriteria> eventCriteriaSet;
    @Nullable
    private List<TransferCriteria> transferCriteriaSet;
    @Nullable
    private final AbiManager abiManager;
    @Nullable
    private final BusinessEventManager businessEventManager;
    @Nullable
    private List<AbiElement> cachedConfiguredEvents;

    public LogsIndexer(@NotNull ThorClient thorClient, long startBlock, long syncLoggerInterval, @NotNull Set<? extends LogType> logsType, long blockBatchSize, long logFetchLimit, @Nullable List<EventCriteria> eventCriteriaSet, @Nullable List<TransferCriteria> transferCriteriaSet, @Nullable AbiManager abiManager, @Nullable BusinessEventManager businessEventManager) {
        Intrinsics.checkNotNullParameter((Object)thorClient, (String)"thorClient");
        Intrinsics.checkNotNullParameter(logsType, (String)"logsType");
        super(thorClient, startBlock, syncLoggerInterval, abiManager, businessEventManager);
        this.thorClient = thorClient;
        this.syncLoggerInterval = syncLoggerInterval;
        this.logsType = logsType;
        this.blockBatchSize = blockBatchSize;
        this.logFetchLimit = logFetchLimit;
        this.eventCriteriaSet = eventCriteriaSet;
        this.transferCriteriaSet = transferCriteriaSet;
        this.abiManager = abiManager;
        this.businessEventManager = businessEventManager;
    }

    public /* synthetic */ LogsIndexer(ThorClient thorClient, long l, long l2, Set set, long l3, long l4, List list, List list2, AbiManager abiManager, BusinessEventManager businessEventManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = 1000L;
        }
        if ((n & 8) != 0) {
            set = SetsKt.setOf((Object)((Object)LogType.EVENT));
        }
        if ((n & 0x10) != 0) {
            l3 = 100L;
        }
        if ((n & 0x20) != 0) {
            l4 = 1000L;
        }
        if ((n & 0x40) != 0) {
            list = null;
        }
        if ((n & 0x80) != 0) {
            list2 = null;
        }
        if ((n & 0x100) != 0) {
            abiManager = null;
        }
        if ((n & 0x200) != 0) {
            businessEventManager = null;
        }
        this(thorClient, l, l2, set, l3, l4, list, list2, abiManager, businessEventManager);
    }

    @Override
    @NotNull
    protected ThorClient getThorClient() {
        return this.thorClient;
    }

    @Override
    @Nullable
    protected final AbiManager getAbiManager() {
        return this.abiManager;
    }

    @Override
    @Nullable
    protected BusinessEventManager getBusinessEventManager() {
        return this.businessEventManager;
    }

    public abstract void processLogs(@NotNull List<EventLog> var1, @NotNull List<TransferLog> var2);

    private final void initialise(Long blockNumber) {
        long l;
        Long l2 = blockNumber;
        if (l2 != null) {
            l = l2;
        } else {
            BlockIdentifier blockIdentifier = this.getLastSyncedBlock();
            Long l3 = blockIdentifier != null ? Long.valueOf(blockIdentifier.getNumber()) : null;
            l = l3 != null ? l3.longValue() : this.getStartBlock();
        }
        long lastSyncedBlockNumber = l;
        this.rollback(lastSyncedBlockNumber);
        this.setCurrentBlockNumber(lastSyncedBlockNumber);
        this.setStatus(Status.SYNCING);
        this.getLogger().info("Initialized LogsIndexer at block: " + lastSyncedBlockNumber);
    }

    static /* synthetic */ void initialise$default(LogsIndexer logsIndexer, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialise");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        logsIndexer.initialise(l);
    }

    @Override
    @Nullable
    public Object start(@Nullable Long iterations, @NotNull Continuation<? super Unit> $completion) {
        return LogsIndexer.start$suspendImpl(this, iterations, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object start$suspendImpl(LogsIndexer var0, Long var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof start.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ LogsIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogsIndexer.start$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                LogsIndexer.initialise$default($this, null, 1, null);
                $continuation.L$0 = $this;
                $continuation.L$1 = iterations;
                $continuation.label = 1;
                v0 = $this.getThorClient().getFinalizedBlock((Continuation<? super Block>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                iterations = (Long)$continuation.L$1;
                $this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                finalizedBlock = ((Block)v0).getNumber();
                $this.setRemainingIterations$indexer_core(iterations);
                if ($this.getCurrentBlockNumber() < finalizedBlock) {
                    $continuation.L$0 = $this;
                    $continuation.L$1 = iterations;
                    $continuation.label = 2;
                    v1 = $this.syncLogs(finalizedBlock, (Continuation<? super Unit>)$continuation);
                    if (v1 == var7_5) {
                        return var7_5;
                    }
                }
                ** GOTO lbl40
            }
            case 2: {
                iterations = (Long)$continuation.L$1;
                $this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                $this.getLogger().info("Fast sync complete, switching to block indexer");
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v2 = super.start(iterations, (Continuation<? super Unit>)$continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl51
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl51:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object syncLogs(long var1_1, Continuation<? super Unit> var3_2) {
        if (!(var3_2 instanceof syncLogs.1)) ** GOTO lbl-1000
        var8_3 = var3_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_2){
                Object L$0;
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                final /* synthetic */ LogsIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogsIndexer.access$syncLogs(this.this$0, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 4 sources

                while (this.getCurrentBlockNumber() < toBlock) {
                    if (this.hasNoRemainingIterations$indexer_core()) {
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = this;
                    $continuation.J$0 = toBlock;
                    $continuation.label = 1;
                    v0 = this.backoffDelay$indexer_core((Continuation<? super Unit>)$continuation);
                    ** if (v0 != var9_5) goto lbl23
lbl22:
                    // 1 sources

                    return var9_5;
lbl23:
                    // 1 sources

                    ** GOTO lbl32
                }
                break;
            }
            case 1: {
                toBlock = $continuation.J$0;
                this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                batchEndBlock = Math.min(this.getCurrentBlockNumber() + this.blockBatchSize, toBlock);
                $continuation.L$0 = this;
                $continuation.J$0 = toBlock;
                $continuation.J$1 = batchEndBlock;
                $continuation.label = 2;
                v1 = this.fetchLogs(this.getCurrentBlockNumber(), batchEndBlock, (Continuation<? super LogFetchResult>)$continuation);
                ** if (v1 != var9_5) goto lbl40
lbl39:
                // 1 sources

                return var9_5;
lbl40:
                // 1 sources

                ** GOTO lbl49
            }
            case 2: {
                batchEndBlock = $continuation.J$1;
                toBlock = $continuation.J$0;
                this = (LogsIndexer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl49:
                    // 2 sources

                    logsBatch = (LogFetchResult)v1;
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().info("Fast Syncing @ Block Range " + this.getCurrentBlockNumber() + " - " + batchEndBlock);
                    } else if (this.hasMultipleInRange(this.getCurrentBlockNumber(), batchEndBlock, this.syncLoggerInterval)) {
                        this.getLogger().info("Fast Syncing @ Block Range " + this.getCurrentBlockNumber() + " - " + batchEndBlock);
                    }
                    if (!logsBatch.getEventLogs().isEmpty() || !logsBatch.getTransferLogs().isEmpty()) ** GOTO lbl61
                    this.setCurrentBlockNumber(batchEndBlock + 1L);
                    v2 = LocalDateTime.now(ZoneOffset.UTC);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"now(ZoneOffset.UTC)");
                    this.setTimeLastProcessed$indexer_core(v2);
                    ** GOTO lbl12
lbl61:
                    // 1 sources

                    this.processLogs(logsBatch.getEventLogs(), logsBatch.getTransferLogs());
                    this.setCurrentBlockNumber(batchEndBlock + 1L);
                    v3 = LocalDateTime.now(ZoneOffset.UTC);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"now(ZoneOffset.UTC)");
                    this.setTimeLastProcessed$indexer_core(v3);
                }
                catch (Exception e) {
                    this.getLogger().error("Error fetching logs at block " + this.getCurrentBlockNumber() + ": " + e.getMessage());
                    this.handleError$indexer_core();
                }
                ** GOTO lbl12
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object fetchLogs(long var1_1, long var3_2, Continuation<? super LogFetchResult> var5_3) {
        if (!(var5_3 instanceof fetchLogs.1)) ** GOTO lbl-1000
        var10_4 = var5_3;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                final /* synthetic */ LogsIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogsIndexer.access$fetchLogs(this.this$0, 0L, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                eventLogs = new ArrayList<E>();
                transferLogs = new ArrayList<E>();
                if (!this.logsType.contains((Object)LogType.EVENT)) ** GOTO lbl38
                var8_9 = eventLogs;
                $continuation.L$0 = this;
                $continuation.L$1 = eventLogs;
                $continuation.L$2 = transferLogs;
                $continuation.L$3 = var8_9;
                $continuation.J$0 = fromBlock;
                $continuation.J$1 = toBlock;
                $continuation.label = 1;
                v0 = this.fetchEventLogs(fromBlock, toBlock, (Continuation<? super List<EventLog>>)$continuation);
                if (v0 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl36
            }
            case 1: {
                toBlock = $continuation.J$1;
                fromBlock = $continuation.J$0;
                var8_9 = (List)$continuation.L$3;
                transferLogs = (List)$continuation.L$2;
                eventLogs = (List)$continuation.L$1;
                this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 2 sources

                var8_9.addAll((Collection)v0);
lbl38:
                // 2 sources

                if (!this.logsType.contains((Object)LogType.TRANSFER)) ** GOTO lbl57
                var8_9 = transferLogs;
                $continuation.L$0 = eventLogs;
                $continuation.L$1 = transferLogs;
                $continuation.L$2 = var8_9;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v1 = this.fetchTransfers(fromBlock, toBlock, (Continuation<? super List<TransferLog>>)$continuation);
                if (v1 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl55
            }
            case 2: {
                var8_9 = (List)$continuation.L$2;
                transferLogs = (List)$continuation.L$1;
                eventLogs = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl55:
                // 2 sources

                var8_9.addAll((Collection)v1);
lbl57:
                // 2 sources

                return new LogFetchResult(eventLogs, transferLogs);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object fetchEventLogs(long var1_1, long var3_2, Continuation<? super List<EventLog>> var5_3) {
        if (!(var5_3 instanceof fetchEventLogs.1)) ** GOTO lbl-1000
        var11_4 = var5_3;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_3){
                Object L$0;
                Object L$1;
                long J$0;
                long J$1;
                long J$2;
                /* synthetic */ Object result;
                final /* synthetic */ LogsIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogsIndexer.access$fetchEventLogs(this.this$0, 0L, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                logs = new ArrayList<E>();
                offset = 0L;
lbl15:
                // 2 sources

                while (true) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = logs;
                    $continuation.J$0 = fromBlock;
                    $continuation.J$1 = toBlock;
                    $continuation.J$2 = offset;
                    $continuation.label = 1;
                    v0 = this.getThorClient().getEventLogs(new EventLogsRequest(new LogsRange("block", Boxing.boxLong((long)fromBlock), Boxing.boxLong((long)toBlock)), new LogsOptions(Boxing.boxLong((long)offset), Boxing.boxLong((long)this.logFetchLimit)), this.eventCriteriaSet, "asc"), (Continuation<? super List<EventLog>>)$continuation);
                    if (v0 == var12_6) {
                        return var12_6;
                    }
                    ** GOTO lbl34
                    break;
                }
            }
            case 1: {
                offset = $continuation.J$2;
                toBlock = $continuation.J$1;
                fromBlock = $continuation.J$0;
                logs = (List)$continuation.L$1;
                this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                if (!(response = (List)v0).isEmpty()) {
                    logs.addAll(response);
                    if ((long)response.size() >= this.logFetchLimit) {
                        offset += this.logFetchLimit;
                        ** continue;
                    }
                }
                return logs;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object fetchTransfers(long var1_1, long var3_2, Continuation<? super List<TransferLog>> var5_3) {
        if (!(var5_3 instanceof fetchTransfers.1)) ** GOTO lbl-1000
        var14_4 = var5_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_3){
                Object L$0;
                Object L$1;
                long J$0;
                long J$1;
                long J$2;
                /* synthetic */ Object result;
                final /* synthetic */ LogsIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogsIndexer.access$fetchTransfers(this.this$0, 0L, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                transfers = new ArrayList<E>();
                offset = 0L;
lbl15:
                // 2 sources

                while (true) {
                    var10_10 = new LogsRange("block", Boxing.boxLong((long)fromBlock), Boxing.boxLong((long)toBlock));
                    var11_11 = new LogsOptions(Boxing.boxLong((long)offset), Boxing.boxLong((long)this.logFetchLimit));
                    var12_12 = this.transferCriteriaSet;
                    $continuation.L$0 = this;
                    $continuation.L$1 = transfers;
                    $continuation.J$0 = fromBlock;
                    $continuation.J$1 = toBlock;
                    $continuation.J$2 = offset;
                    $continuation.label = 1;
                    v0 = this.getThorClient().getVetTransfers(new TransferLogsRequest(var10_10, var11_11, var12_12, "asc"), (Continuation<? super List<TransferLog>>)$continuation);
                    if (v0 == var15_6) {
                        return var15_6;
                    }
                    ** GOTO lbl37
                    break;
                }
            }
            case 1: {
                offset = $continuation.J$2;
                toBlock = $continuation.J$1;
                fromBlock = $continuation.J$0;
                transfers = (List)$continuation.L$1;
                this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                if (!(response = (List)v0).isEmpty()) {
                    transfers.addAll(response);
                    if ((long)response.size() >= this.logFetchLimit) {
                        offset += this.logFetchLimit;
                        ** continue;
                    }
                }
                return transfers;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void processBlock(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        List eventLogs = new ArrayList();
        List transferLogs = new ArrayList();
        for (Transaction tx : block.getTransactions()) {
            for (TxOutputs output : tx.getOutputs()) {
                if (this.logsType.contains((Object)LogType.EVENT)) {
                    eventLogs.addAll((Collection)this.processBlockEvents(output, block, tx));
                }
                if (!this.logsType.contains((Object)LogType.TRANSFER)) continue;
                transferLogs.addAll((Collection)this.processBlockTransfers(output, block, tx));
            }
        }
        if (!((Collection)eventLogs).isEmpty() || !((Collection)transferLogs).isEmpty()) {
            this.processLogs(eventLogs, transferLogs);
        }
    }

    private final List<EventLog> processBlockEvents(TxOutputs output, Block block, Transaction tx) {
        List eventLogs = new ArrayList();
        Iterable $this$forEach$iv = output.getEvents();
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            TxEvent event = (TxEvent)element$iv;
            boolean bl = false;
            Collection collection = this.eventCriteriaSet;
            if (collection == null || collection.isEmpty()) {
                eventLogs.add(this.toEventLog(event, block, tx));
                continue;
            }
            List<EventCriteria> list = this.eventCriteriaSet;
            Intrinsics.checkNotNull(list);
            for (EventCriteria criteria : list) {
                if (!LogsUtilsKt.matchesEventCriteria(event, criteria)) continue;
                eventLogs.add(this.toEventLog(event, block, tx));
                continue block0;
            }
        }
        return eventLogs;
    }

    private final List<TransferLog> processBlockTransfers(TxOutputs output, Block block, Transaction tx) {
        List transferLogs = new ArrayList();
        Iterable $this$forEach$iv = output.getTransfers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TxTransfer transfer = (TxTransfer)element$iv;
            boolean bl = false;
            Collection collection = this.transferCriteriaSet;
            if (collection == null || collection.isEmpty()) {
                transferLogs.add(this.toTransferLog(transfer, block, tx));
                continue;
            }
            List<TransferCriteria> list = this.transferCriteriaSet;
            Intrinsics.checkNotNull(list);
            for (TransferCriteria criteria : list) {
                if (!LogsUtilsKt.matchesTransferCriteria(transfer, criteria, tx)) continue;
                transferLogs.add(this.toTransferLog(transfer, block, tx));
            }
        }
        return transferLogs;
    }

    private final EventLog toEventLog(TxEvent $this$toEventLog, Block block, Transaction tx) {
        return new EventLog($this$toEventLog.getAddress(), $this$toEventLog.getTopics(), $this$toEventLog.getData(), new EventMeta(block.getId(), block.getNumber(), block.getTimestamp(), tx.getId(), tx.getOrigin(), 0));
    }

    private final TransferLog toTransferLog(TxTransfer $this$toTransferLog, Block block, Transaction tx) {
        return new TransferLog($this$toTransferLog.getSender(), $this$toTransferLog.getRecipient(), $this$toTransferLog.getAmount(), new EventMeta(block.getId(), block.getNumber(), block.getTimestamp(), tx.getId(), tx.getOrigin(), 0));
    }

    @NotNull
    protected List<IndexedEvent> processAllEvents(@NotNull List<EventLog> eventLogs, @NotNull List<TransferLog> transferLogs, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter(eventLogs, (String)"eventLogs");
        Intrinsics.checkNotNullParameter(transferLogs, (String)"transferLogs");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        List<IndexedEvent> decodedEvents = this.processBlockGenericEvents(eventLogs, transferLogs, criteria);
        return this.processBusinessEvents$indexer_core(decodedEvents, criteria.getBusinessEventNames(), criteria.getRemoveDuplicates());
    }

    public static /* synthetic */ List processAllEvents$default(LogsIndexer logsIndexer, List list, List list2, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processAllEvents");
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return logsIndexer.processAllEvents(list, list2, filterCriteria);
    }

    @NotNull
    protected List<IndexedEvent> processBlockGenericEvents(@NotNull List<EventLog> eventLogs, @NotNull List<TransferLog> transferLogs, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter(eventLogs, (String)"eventLogs");
        Intrinsics.checkNotNullParameter(transferLogs, (String)"transferLogs");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (this.abiManager == null) {
            this.getLogger().warn("ABI Manager is not configured. Skipping generic event processing.");
            return CollectionsKt.emptyList();
        }
        GenericEventIndexer eventIndexer = new GenericEventIndexer(this.abiManager);
        if (this.cachedConfiguredEvents == null) {
            Object object = this.getBusinessEventManager();
            if (object == null || (object = ((BusinessEventManager)object).updateCriteriaWithBusinessEvents(criteria)) == null) {
                object = criteria;
            }
            Object updatedCriteria = object;
            this.cachedConfiguredEvents = eventIndexer.getConfiguredEvents(((FilterCriteria)updatedCriteria).getAbiNames(), ((FilterCriteria)updatedCriteria).getEventNames());
        }
        List<AbiElement> list = this.cachedConfiguredEvents;
        Intrinsics.checkNotNull(list);
        List<IndexedEvent> contractEvents = eventIndexer.decodeLogEvents(eventLogs, list, criteria);
        List<IndexedEvent> vetTransfers = eventIndexer.decodeLogTransfers(transferLogs);
        return CollectionsKt.plus((Collection)contractEvents, (Iterable)vetTransfers);
    }

    public static /* synthetic */ List processBlockGenericEvents$default(LogsIndexer logsIndexer, List list, List list2, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBlockGenericEvents");
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return logsIndexer.processBlockGenericEvents(list, list2, filterCriteria);
    }

    private final boolean hasMultipleInRange(long startBlock, long endBlock, long x) {
        long firstMultiple;
        if (x == 0L) {
            return false;
        }
        long l = firstMultiple = startBlock % x == 0L ? startBlock : (startBlock / x + 1L) * x;
        return startBlock <= firstMultiple ? firstMultiple <= endBlock : false;
    }

    public static final /* synthetic */ Object access$syncLogs(LogsIndexer $this, long toBlock, Continuation $completion) {
        return $this.syncLogs(toBlock, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$fetchLogs(LogsIndexer $this, long fromBlock, long toBlock, Continuation $completion) {
        return $this.fetchLogs(fromBlock, toBlock, (Continuation<? super LogFetchResult>)$completion);
    }

    public static final /* synthetic */ Object access$fetchEventLogs(LogsIndexer $this, long fromBlock, long toBlock, Continuation $completion) {
        return $this.fetchEventLogs(fromBlock, toBlock, (Continuation<? super List<EventLog>>)$completion);
    }

    public static final /* synthetic */ Object access$fetchTransfers(LogsIndexer $this, long fromBlock, long toBlock, Continuation $completion) {
        return $this.fetchTransfers(fromBlock, toBlock, (Continuation<? super List<TransferLog>>)$completion);
    }
}

