/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.model.abi.AbiElement;
import org.vechain.indexer.event.model.abi.InputOutput;
import org.vechain.indexer.utils.JsonUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u000bJ(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006J\u001a\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u000bR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/vechain/indexer/event/AbiManager;", "", "()V", "abis", "", "", "", "Lorg/vechain/indexer/event/model/abi/AbiElement;", "logger", "Lorg/slf4j/Logger;", "getAbis", "", "getEventsByNames", "abiNames", "eventNames", "loadAbis", "", "abiFiles", "Ljava/io/InputStream;", "indexer-core"})
public final class AbiManager {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<String, List<AbiElement>> abis;

    public AbiManager() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
        this.abis = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadAbis(@NotNull Map<String, ? extends InputStream> abiFiles) {
        Intrinsics.checkNotNullParameter(abiFiles, (String)"abiFiles");
        Map<String, ? extends InputStream> $this$forEach$iv = abiFiles;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends InputStream>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends InputStream> element$iv;
            Map.Entry<String, ? extends InputStream> entry = element$iv = iterator.next();
            boolean bl = false;
            String abiName = entry.getKey();
            InputStream inputStream = entry.getValue();
            try {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream stream = (InputStream)closeable;
                    boolean bl2 = false;
                    List abiList2 = (List)JsonUtils.INSTANCE.getMapper().readValue(stream, (TypeReference)new TypeReference<List<? extends AbiElement>>(){});
                    Intrinsics.checkNotNullExpressionValue((Object)abiList2, (String)"abiList");
                    Iterable $this$forEach$iv2 = abiList2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        AbiElement it = (AbiElement)element$iv2;
                        boolean bl3 = false;
                        it.setSignature();
                    }
                    this.abis.put(abiName, abiList2);
                    this.logger.info("Loaded ABI: " + abiName);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to parse ABI file: " + abiName, (Throwable)e);
            }
        }
    }

    @NotNull
    public final Map<String, List<AbiElement>> getAbis() {
        return this.abis;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AbiElement> getEventsByNames(@NotNull List<String> abiNames, @NotNull List<String> eventNames) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(abiNames, (String)"abiNames");
        Intrinsics.checkNotNullParameter(eventNames, (String)"eventNames");
        Iterable $this$flatMap$iv = abiNames;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String abiName = (String)element$iv$iv;
            boolean bl3 = false;
            List<AbiElement> list2 = this.abis.get(abiName);
            if (list2 != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    AbiElement it = (AbiElement)element$iv$iv2;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getType(), (Object)"event") && (eventNames.isEmpty() || CollectionsKt.contains((Iterable)eventNames, (Object)it.getName())))) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            int n;
            Pair key$iv;
            int n2;
            void $this$count$iv;
            AbiElement it = (AbiElement)e$iv;
            boolean bl = false;
            Iterable bl3 = it.getInputs();
            String string = it.getSignature();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    InputOutput input = (InputOutput)element$iv;
                    boolean bl4 = false;
                    if (!input.getIndexed() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            if (!set$iv.add(key$iv = TuplesKt.to((Object)string, (Object)(n = n2)))) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }
}

