/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.BusinessEventManager;
import org.vechain.indexer.event.model.business.BusinessEventDefinition;
import org.vechain.indexer.event.model.generic.GenericEventParameters;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.event.utils.BusinessEventUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\f2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J<\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\f2\b\b\u0002\u0010\u0017\u001a\u00020\u00152\b\b\u0002\u0010\u0014\u001a\u00020\u0015J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/vechain/indexer/event/BusinessEventProcessor;", "", "businessEventManager", "Lorg/vechain/indexer/event/BusinessEventManager;", "(Lorg/vechain/indexer/event/BusinessEventManager;)V", "logger", "Lorg/slf4j/Logger;", "checkAllCombinations", "", "", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "group", "", "definition", "Lorg/vechain/indexer/event/model/business/BusinessEventDefinition;", "createBusinessEvent", "eventsForAlias", "getOnlyBusinessEvents", "events", "businessEventNames", "groupByBlock", "", "processEvents", "removeDuplicates", "processTransactionForBusinessEvents", "txEvents", "indexer-core"})
public final class BusinessEventProcessor {
    @NotNull
    private final BusinessEventManager businessEventManager;
    @NotNull
    private final Logger logger;

    public BusinessEventProcessor(@NotNull BusinessEventManager businessEventManager) {
        Intrinsics.checkNotNullParameter((Object)businessEventManager, (String)"businessEventManager");
        this.businessEventManager = businessEventManager;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndexedEvent> processEvents(@NotNull List<IndexedEvent> events, @NotNull List<String> businessEventNames, boolean removeDuplicates, boolean groupByBlock) {
        Map groupedEvents;
        Map map;
        Object key$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(businessEventNames, (String)"businessEventNames");
        List businessEvents = new ArrayList();
        List remainingEvents = new ArrayList();
        if (groupByBlock) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = events;
            boolean $i$f$groupBy = false;
            object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                IndexedEvent it = (IndexedEvent)element$iv$iv;
                boolean bl = false;
                key$iv$iv = it.getBlockNumber();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)0L, events));
        }
        Map $this$forEach$iv = groupedEvents = map;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            long blockNumber = ((Number)entry.getKey()).longValue();
            List blockEvents = (List)entry.getValue();
            try {
                void $this$forEach$iv2;
                void $this$groupByTo$iv$iv;
                Map $this$groupBy$iv;
                key$iv$iv = blockEvents;
                boolean $i$f$groupBy = false;
                void $i$f$getOrPut = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object3;
                    IndexedEvent it = (IndexedEvent)element$iv$iv;
                    boolean bl3 = false;
                    String key$iv$iv2 = it.getTxId();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut2 = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                        object3 = answer$iv$iv$iv;
                    } else {
                        object3 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object3;
                    list$iv$iv.add(element$iv$iv);
                }
                $this$groupBy$iv = destination$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry entry2 = element$iv2 = iterator.next();
                    boolean bl5 = false;
                    List transactionEvents = (List)entry2.getValue();
                    List<IndexedEvent> matchedEvents = this.processTransactionForBusinessEvents(transactionEvents, businessEventNames);
                    businessEvents.addAll((Collection)matchedEvents);
                    if (removeDuplicates && !matchedEvents.isEmpty()) continue;
                    remainingEvents.addAll(transactionEvents);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to process events in block " + blockNumber + ": " + blockEvents, (Throwable)e);
                remainingEvents.addAll(blockEvents);
            }
        }
        return CollectionsKt.plus((Collection)remainingEvents, (Iterable)businessEvents);
    }

    public static /* synthetic */ List processEvents$default(BusinessEventProcessor businessEventProcessor, List list, List list2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return businessEventProcessor.processEvents(list, list2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndexedEvent> getOnlyBusinessEvents(@NotNull List<IndexedEvent> events, @NotNull List<String> businessEventNames, boolean groupByBlock) {
        void $this$flatMapTo$iv$iv;
        Map groupedEvents;
        Object object;
        Object list$iv$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        boolean bl;
        Object element$iv$iv;
        Iterator<Object> iterator;
        Map $this$groupByTo$iv$iv;
        Object destination$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(businessEventNames, (String)"businessEventNames");
        if (groupByBlock) {
            Iterable $this$groupBy$iv = events;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                element$iv$iv = iterator.next();
                IndexedEvent it = (IndexedEvent)element$iv$iv;
                bl = false;
                Long key$iv$iv = it.getBlockNumber();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else {
            object = MapsKt.mapOf((Pair)TuplesKt.to((Object)0L, events));
        }
        Map $this$flatMap$iv = groupedEvents = object;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            Object list$iv$iv2;
            void $this$groupByTo$iv$iv2;
            Map $this$groupBy$iv;
            list$iv$iv = element$iv$iv = (Map.Entry)iterator.next();
            bl = false;
            List blockEvents = (List)list$iv$iv.getValue();
            $this$getOrPut$iv$iv$iv = blockEvents;
            boolean $i$f$groupBy = false;
            value$iv$iv$iv = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object t : $this$groupByTo$iv$iv2) {
                Object object3;
                IndexedEvent it = (IndexedEvent)t;
                boolean bl3 = false;
                String key$iv$iv = it.getTxId();
                Map $this$getOrPut$iv$iv$iv2 = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv2 == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv2;
                }
                list$iv$iv2 = (List)object3;
                list$iv$iv2.add(t);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$flatMap2 = false;
            $this$groupByTo$iv$iv2 = $this$flatMap$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Map.Entry entry : $this$flatMapTo$iv$iv2.entrySet()) {
                list$iv$iv2 = entry;
                boolean bl5 = false;
                List transactionEvents = (List)list$iv$iv2.getValue();
                Iterable list$iv$iv3 = this.processTransactionForBusinessEvents(transactionEvents, businessEventNames);
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv3);
            }
            list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getOnlyBusinessEvents$default(BusinessEventProcessor businessEventProcessor, List list, List list2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return businessEventProcessor.getOnlyBusinessEvents(list, list2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexedEvent> processTransactionForBusinessEvents(List<IndexedEvent> txEvents, List<String> businessEventNames) {
        Map<String, BusinessEventDefinition> businessEvents = businessEventNames.isEmpty() ? this.businessEventManager.getAllBusinessEvents() : this.businessEventManager.getBusinessEventsByNames(businessEventNames);
        List matchedBusinessEvents = new ArrayList();
        Iterator<Map.Entry<String, BusinessEventDefinition>> iterator = businessEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map map;
            BusinessEventDefinition definition = iterator.next().getValue();
            if (Intrinsics.areEqual((Object)definition.getSameClause(), (Object)true)) {
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = txEvents;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    IndexedEvent it = (IndexedEvent)element$iv$iv;
                    boolean bl = false;
                    Integer key$iv$iv = (int)it.getClauseIndex();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                map = destination$iv$iv;
            } else {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)0, txEvents));
            }
            Map groupedEvents = map;
            boolean definitionMatched = false;
            Iterator iterator2 = groupedEvents.entrySet().iterator();
            while (iterator2.hasNext()) {
                List group = (List)iterator2.next().getValue();
                Map<String, IndexedEvent> eventsForAlias = Intrinsics.areEqual((Object)definition.getCheckAllCombinations(), (Object)true) ? this.checkAllCombinations(group, definition) : BusinessEventUtils.INSTANCE.mapEventsToAliases(group, definition.getEvents());
                if (!(!eventsForAlias.isEmpty()) || !BusinessEventUtils.INSTANCE.validateRules(definition.getRules(), eventsForAlias)) continue;
                matchedBusinessEvents.add(this.createBusinessEvent(eventsForAlias, definition));
                definitionMatched = true;
            }
            if (!definitionMatched) continue;
            break;
        }
        return matchedBusinessEvents;
    }

    private final Map<String, IndexedEvent> checkAllCombinations(List<IndexedEvent> group, BusinessEventDefinition definition) {
        Integer n = definition.getMaxAttempts();
        List<Map<String, IndexedEvent>> eventCombinations = BusinessEventUtils.INSTANCE.generateAllValidCombinations(group, definition.getEvents(), n != null ? n : 10);
        for (Map<String, IndexedEvent> eventsForAlias : eventCombinations) {
            if (!(!eventsForAlias.isEmpty()) || !BusinessEventUtils.INSTANCE.validateRules(definition.getRules(), eventsForAlias)) continue;
            return eventsForAlias;
        }
        return MapsKt.emptyMap();
    }

    private final IndexedEvent createBusinessEvent(Map<String, IndexedEvent> eventsForAlias, BusinessEventDefinition definition) {
        Map<String, Object> params2 = BusinessEventUtils.INSTANCE.extractParams(definition.getParamsDefinition(), eventsForAlias);
        IndexedEvent firstEvent = (IndexedEvent)CollectionsKt.first((Iterable)eventsForAlias.values());
        return new IndexedEvent(firstEvent.getId(), firstEvent.getBlockId(), firstEvent.getBlockNumber(), firstEvent.getBlockTimestamp(), firstEvent.getTxId(), firstEvent.getOrigin(), firstEvent.getPaid(), firstEvent.getGasUsed(), firstEvent.getGasPayer(), null, new GenericEventParameters(params2, definition.getName()), null, definition.getName(), firstEvent.getClauseIndex(), null, 18944, null);
    }
}

