/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.AbiManager;
import org.vechain.indexer.event.model.abi.AbiElement;
import org.vechain.indexer.event.model.abi.InputOutput;
import org.vechain.indexer.event.model.generic.FilterCriteria;
import org.vechain.indexer.event.model.generic.GenericEventParameters;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.event.model.generic.RawEvent;
import org.vechain.indexer.event.utils.EventUtils;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.EventLog;
import org.vechain.indexer.thor.model.Transaction;
import org.vechain.indexer.thor.model.TransferLog;
import org.vechain.indexer.thor.model.TxEvent;
import org.vechain.indexer.thor.model.TxOutputs;
import org.vechain.indexer.thor.model.TxTransfer;
import org.vechain.indexer.utils.DataUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001b0\fJ.\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0001H\u0002J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0019J(\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020 0\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\fJ:\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020 0\f2\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/vechain/indexer/event/GenericEventIndexer;", "", "abiManager", "Lorg/vechain/indexer/event/AbiManager;", "(Lorg/vechain/indexer/event/AbiManager;)V", "logger", "Lorg/slf4j/Logger;", "decodeEvent", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "event", "Lorg/vechain/indexer/thor/model/TxEvent;", "configuredEvents", "", "Lorg/vechain/indexer/event/model/abi/AbiElement;", "tx", "Lorg/vechain/indexer/thor/model/Transaction;", "block", "Lorg/vechain/indexer/thor/model/Block;", "outputIndex", "", "eventIndex", "decodeLogEvents", "logs", "Lorg/vechain/indexer/thor/model/EventLog;", "criteria", "Lorg/vechain/indexer/event/model/generic/FilterCriteria;", "decodeLogTransfers", "Lorg/vechain/indexer/thor/model/TransferLog;", "extractVetTransfers", "output", "Lorg/vechain/indexer/thor/model/TxOutputs;", "generateEventId", "", "txId", "getBlockEvents", "getBlockEventsByFilters", "filterCriteria", "getConfiguredEvents", "abiNames", "eventNames", "processBlockEvents", "contractAddresses", "vetTransfers", "", "indexer-core"})
public final class GenericEventIndexer {
    @NotNull
    private final AbiManager abiManager;
    @NotNull
    private final Logger logger;

    public GenericEventIndexer(@NotNull AbiManager abiManager) {
        Intrinsics.checkNotNullParameter((Object)abiManager, (String)"abiManager");
        this.abiManager = abiManager;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
    }

    @NotNull
    public final List<IndexedEvent> getBlockEvents(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return GenericEventIndexer.getBlockEventsByFilters$default(this, block, null, 2, null);
    }

    @NotNull
    public final List<IndexedEvent> getBlockEventsByFilters(@NotNull Block block, @Nullable FilterCriteria filterCriteria) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        FilterCriteria filterCriteria2 = filterCriteria;
        Intrinsics.checkNotNull((Object)filterCriteria2);
        List<AbiElement> configuredEvents = this.getConfiguredEvents(filterCriteria2.getAbiNames(), filterCriteria.getEventNames());
        return this.processBlockEvents(block, configuredEvents, filterCriteria.getContractAddresses(), filterCriteria.getVetTransfers());
    }

    public static /* synthetic */ List getBlockEventsByFilters$default(GenericEventIndexer genericEventIndexer, Block block, FilterCriteria filterCriteria, int n, Object object) {
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return genericEventIndexer.getBlockEventsByFilters(block, filterCriteria);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AbiElement> getConfiguredEvents(@NotNull List<String> abiNames, @NotNull List<String> eventNames) {
        List list;
        Intrinsics.checkNotNullParameter(abiNames, (String)"abiNames");
        Intrinsics.checkNotNullParameter(eventNames, (String)"eventNames");
        if (!((Collection)abiNames).isEmpty()) {
            list = this.abiManager.getEventsByNames(abiNames, eventNames);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CollectionsKt.flatten((Iterable)this.abiManager.getAbis().values());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AbiElement it = (AbiElement)element$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getType(), (Object)"event") && (eventNames.isEmpty() || CollectionsKt.contains((Iterable)eventNames, (Object)it.getName())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$distinctBy$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<Pair> set$iv = new HashSet<Pair>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                int n;
                Pair key$iv;
                int n2;
                void $this$count$iv;
                AbiElement it = (AbiElement)e$iv;
                boolean bl = false;
                Iterable bl2 = it.getInputs();
                String string = it.getSignature();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        InputOutput input = (InputOutput)element$iv;
                        boolean bl3 = false;
                        if (!input.getIndexed() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                if (!set$iv.add(key$iv = TuplesKt.to((Object)string, (Object)(n = n2)))) continue;
                list$iv.add(e$iv);
            }
            list = list$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexedEvent> processBlockEvents(Block block, List<AbiElement> configuredEvents, List<String> contractAddresses, boolean vetTransfers) {
        List events = new ArrayList();
        Iterable $this$forEach$iv = block.getTransactions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Transaction tx = (Transaction)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = tx.getOutputs();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void output;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TxOutputs txOutputs = (TxOutputs)item$iv;
                int outputIndex = n;
                boolean bl2 = false;
                Iterable $this$forEachIndexed$iv2 = output.getEvents();
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    IndexedEvent indexedEvent;
                    void event;
                    int n2;
                    if ((n2 = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    TxEvent txEvent = (TxEvent)item$iv2;
                    int eventIndex = n2;
                    boolean bl3 = false;
                    if (!EventUtils.INSTANCE.isEventValid((TxEvent)event, configuredEvents, contractAddresses) || (indexedEvent = this.decodeEvent((TxEvent)event, configuredEvents, tx, block, outputIndex, eventIndex)) == null) continue;
                    IndexedEvent it = indexedEvent;
                    boolean bl4 = false;
                    events.add(it);
                }
                if (!vetTransfers) continue;
                events.addAll((Collection)this.extractVetTransfers((TxOutputs)output, tx, block, outputIndex));
            }
        }
        return events;
    }

    private final IndexedEvent decodeEvent(TxEvent event, List<AbiElement> configuredEvents, Transaction tx, Block block, int outputIndex, int eventIndex) {
        IndexedEvent indexedEvent;
        AbiElement matchingAbi;
        AbiElement abiElement = matchingAbi = EventUtils.INSTANCE.findMatchingAbi(event.getTopics(), configuredEvents);
        if (abiElement != null) {
            IndexedEvent indexedEvent2;
            AbiElement abi = abiElement;
            boolean bl = false;
            try {
                GenericEventParameters parameters = EventUtils.INSTANCE.decodeEvent(event, abi);
                String string = this.generateEventId(tx.getId(), outputIndex, eventIndex, event);
                String string2 = block.getId();
                long l = block.getNumber();
                long l2 = block.getTimestamp();
                String string3 = tx.getId();
                String string4 = tx.getOrigin();
                String string5 = tx.getGasPayer();
                long l3 = tx.getGasUsed();
                String string6 = tx.getPaid();
                RawEvent rawEvent = new RawEvent(event.getData(), event.getTopics());
                String string7 = event.getAddress();
                String string8 = parameters.getEventType();
                long l4 = outputIndex;
                String string9 = event.getTopics().get(0);
                indexedEvent2 = new IndexedEvent(string, string2, l, l2, string3, string4, string6, l3, string5, rawEvent, parameters, string7, string8, l4, string9);
            }
            catch (IllegalArgumentException ex) {
                this.logger.warn("Failed to decode event with ABI: " + abi.getName() + ", txId: " + tx.getId() + ". Skipping event.");
                indexedEvent2 = null;
            }
            indexedEvent = indexedEvent2;
        } else {
            indexedEvent = null;
        }
        return indexedEvent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndexedEvent> decodeLogEvents(@NotNull List<EventLog> logs, @NotNull List<AbiElement> configuredEvents, @NotNull FilterCriteria criteria) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        Intrinsics.checkNotNullParameter(configuredEvents, (String)"configuredEvents");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (logs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapIndexedNotNull$iv = logs;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            IndexedEvent indexedEvent;
            void log;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            EventLog eventLog = (EventLog)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            TxEvent txEvent = new TxEvent(log.getAddress(), log.getTopics(), log.getData());
            if (!EventUtils.INSTANCE.isEventValid(txEvent, configuredEvents, criteria.getContractAddresses())) {
                indexedEvent = null;
            } else if (EventUtils.INSTANCE.findMatchingAbi(log.getTopics(), configuredEvents) == null) {
                indexedEvent = null;
            } else {
                IndexedEvent indexedEvent2;
                AbiElement matchingAbi;
                try {
                    GenericEventParameters parameters = EventUtils.INSTANCE.decodeEvent(txEvent, matchingAbi);
                    indexedEvent2 = new IndexedEvent(this.generateEventId(log.getMeta().getTxID(), log.getMeta().getClauseIndex(), i, txEvent), log.getMeta().getBlockID(), log.getMeta().getBlockNumber(), log.getMeta().getBlockTimestamp(), log.getMeta().getTxID(), log.getMeta().getTxOrigin(), null, null, null, new RawEvent(log.getData(), log.getTopics()), parameters, log.getAddress(), parameters.getEventType(), log.getMeta().getClauseIndex(), log.getTopics().get(0), 448, null);
                }
                catch (Exception ex) {
                    this.logger.warn("Failed to decode log event with ABI: " + matchingAbi.getName() + ", txId: " + log.getMeta().getTxID());
                    indexedEvent2 = null;
                }
                indexedEvent = indexedEvent2;
            }
            if (indexedEvent == null) continue;
            IndexedEvent it$iv$iv = indexedEvent;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List decodeLogEvents$default(GenericEventIndexer genericEventIndexer, List list, List list2, FilterCriteria filterCriteria, int n, Object object) {
        if ((n & 4) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return genericEventIndexer.decodeLogEvents(list, list2, filterCriteria);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IndexedEvent> decodeLogTransfers(@NotNull List<TransferLog> logs) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        if (logs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapIndexedNotNull$iv = logs;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            IndexedEvent it$iv$iv;
            IndexedEvent indexedEvent;
            void log;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            TransferLog transferLog = (TransferLog)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            try {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"from", (Object)log.getSender()), TuplesKt.to((Object)"to", (Object)log.getRecipient()), TuplesKt.to((Object)"amount", (Object)DataUtils.INSTANCE.decodeQuantity(log.getAmount()))};
                GenericEventParameters parameters = new GenericEventParameters(MapsKt.mapOf((Pair[])pairArray), "VET_TRANSFER");
                indexedEvent = new IndexedEvent(this.generateEventId(log.getMeta().getTxID(), log.getMeta().getClauseIndex(), i, parameters), log.getMeta().getBlockID(), log.getMeta().getBlockNumber(), log.getMeta().getBlockTimestamp(), log.getMeta().getTxID(), log.getMeta().getTxOrigin(), null, null, null, null, parameters, null, "VET_TRANSFER", log.getMeta().getClauseIndex(), null, 19392, null);
            }
            catch (Exception ex) {
                this.logger.warn("Failed to process VET transfer: " + log.getSender() + " -> " + log.getRecipient(), (Throwable)ex);
                indexedEvent = null;
            }
            if (indexedEvent == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexedEvent> extractVetTransfers(TxOutputs output, Transaction tx, Block block, int outputIndex) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv = output.getTransfers();
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            IndexedEvent it$iv$iv;
            IndexedEvent indexedEvent;
            void transfer;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            TxTransfer txTransfer = (TxTransfer)element$iv$iv;
            int transferIndex = index$iv$iv;
            boolean bl2 = false;
            try {
                IndexedEvent indexedEvent2;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"from", (Object)transfer.getSender()), TuplesKt.to((Object)"to", (Object)transfer.getRecipient()), TuplesKt.to((Object)"amount", (Object)DataUtils.INSTANCE.decodeQuantity(transfer.getAmount()))};
                GenericEventParameters parameters = new GenericEventParameters(MapsKt.mapOf((Pair[])pairArray), "VET_TRANSFER");
                indexedEvent = indexedEvent2 = new IndexedEvent(this.generateEventId(tx.getId(), outputIndex, transferIndex, transfer), block.getId(), block.getNumber(), block.getTimestamp(), tx.getId(), tx.getOrigin(), tx.getPaid(), tx.getGasUsed(), tx.getGasPayer(), null, parameters, null, "VET_TRANSFER", outputIndex, null, 18944, null);
            }
            catch (Exception ex) {
                this.logger.warn("Failed to process VET transfer: " + transfer.getSender() + " -> " + transfer.getRecipient(), (Throwable)ex);
                indexedEvent = null;
            }
            if (indexedEvent == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String generateEventId(String txId, int outputIndex, int eventIndex, Object event) {
        int eventHash = event.hashCode();
        return txId + '-' + outputIndex + '-' + eventIndex + '-' + eventHash;
    }
}

