/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.vechain.indexer.event.model.business.Condition;
import org.vechain.indexer.event.model.business.Event;
import org.vechain.indexer.event.model.business.ParamDefinition;
import org.vechain.indexer.event.model.business.Rule;
import org.vechain.indexer.event.model.enums.Operator;
import org.vechain.indexer.event.model.generic.GenericEventParameters;
import org.vechain.indexer.event.model.generic.IndexedEvent;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004J>\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u00040\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J.\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007H\u0002J(\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004\u00a8\u0006\u001d"}, d2={"Lorg/vechain/indexer/event/utils/BusinessEventUtils;", "", "()V", "extractParams", "", "", "paramsDefinition", "", "Lorg/vechain/indexer/event/model/business/ParamDefinition;", "events", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "generateAllValidCombinations", "eventDefinitions", "Lorg/vechain/indexer/event/model/business/Event;", "maxAttempts", "", "getEventValue", "event", "operand", "mapEventsToAliases", "resolveOperandValue", "isStatic", "", "validateConditions", "conditions", "Lorg/vechain/indexer/event/model/business/Condition;", "validateRules", "rules", "Lorg/vechain/indexer/event/model/business/Rule;", "indexer-core"})
public final class BusinessEventUtils {
    @NotNull
    public static final BusinessEventUtils INSTANCE = new BusinessEventUtils();

    private BusinessEventUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, IndexedEvent> mapEventsToAliases(@NotNull List<IndexedEvent> events, @NotNull List<Event> eventDefinitions) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(eventDefinitions, (String)"eventDefinitions");
        Set assignedEvents = new LinkedHashSet();
        Map mappedEvents = new LinkedHashMap();
        for (Event eventDefinition : eventDefinitions) {
            IndexedEvent indexedEvent;
            Object v1;
            block3: {
                void $this$firstOrNull$iv;
                Iterable iterable = events;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IndexedEvent it = (IndexedEvent)element$iv;
                    boolean bl = false;
                    boolean bl2 = Intrinsics.areEqual((Object)it.getParams().getEventType(), (Object)eventDefinition.getName()) && INSTANCE.validateConditions(it, eventDefinition.getConditions()) && !assignedEvents.contains(it);
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            if ((indexedEvent = (IndexedEvent)v1) == null) continue;
            IndexedEvent it = indexedEvent;
            boolean bl = false;
            mappedEvents.put(eventDefinition.getAlias(), it);
            assignedEvents.add(it);
        }
        if (mappedEvents.size() != eventDefinitions.size()) {
            return MapsKt.emptyMap();
        }
        return mappedEvents;
    }

    @NotNull
    public final List<Map<String, IndexedEvent>> generateAllValidCombinations(@NotNull List<IndexedEvent> events, @NotNull List<Event> eventDefinitions, int maxAttempts) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(eventDefinitions, (String)"eventDefinitions");
        List validCombinations = new ArrayList();
        Ref.IntRef attempts = new Ref.IntRef();
        BusinessEventUtils.generateAllValidCombinations$backtrack(attempts, maxAttempts, eventDefinitions, validCombinations, events, 0, 0, new boolean[events.size()], new LinkedHashMap());
        return validCombinations;
    }

    public static /* synthetic */ List generateAllValidCombinations$default(BusinessEventUtils businessEventUtils, List list, List list2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 10;
        }
        return businessEventUtils.generateAllValidCombinations(list, list2, n);
    }

    public final boolean validateRules(@NotNull List<Rule> rules, @NotNull Map<String, IndexedEvent> events) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$all$iv = rules;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String secondValue;
                    Rule rule = (Rule)element$iv;
                    boolean bl2 = false;
                    Object object = INSTANCE.getEventValue(events.get(rule.getFirstEventName()), rule.getFirstEventProperty());
                    String firstValue = object != null ? object.toString() : null;
                    Object object2 = INSTANCE.getEventValue(events.get(rule.getSecondEventName()), rule.getSecondEventProperty());
                    String string = secondValue = object2 != null ? object2.toString() : null;
                    if (firstValue != null && secondValue != null && rule.getOperator().evaluate(firstValue, secondValue)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> extractParams(@NotNull List<ParamDefinition> paramsDefinition, @NotNull Map<String, IndexedEvent> events) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(paramsDefinition, (String)"paramsDefinition");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$associate$iv = paramsDefinition;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ParamDefinition param = (ParamDefinition)element$iv$iv;
            boolean bl = false;
            Object object = INSTANCE.getEventValue(events.get(param.getEventName()), param.getName());
            if (object == null) {
                object = "";
            }
            Object value = object;
            Pair pair = TuplesKt.to((Object)param.getBusinessEventName(), (Object)value);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final boolean validateConditions(IndexedEvent event, List<Condition> conditions) {
        boolean bl;
        block5: {
            Iterable $this$all$iv = conditions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String string;
                    Condition condition = (Condition)element$iv;
                    boolean bl2 = false;
                    String firstValue = INSTANCE.resolveOperandValue(condition.getFirstOperand(), condition.isFirstStatic(), event);
                    String secondValue = INSTANCE.resolveOperandValue(condition.getSecondOperand(), condition.isSecondStatic(), event);
                    Operator operator = condition.getOperator();
                    String string2 = firstValue;
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string = secondValue) == null) {
                        string = "";
                    }
                    if (operator.evaluate(string2, string)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String resolveOperandValue(String operand, boolean isStatic, IndexedEvent event) {
        String string;
        if (isStatic) {
            String string2 = operand.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            return string;
        } else {
            Object object = this.getEventValue(event, operand);
            Object object2 = object;
            if (object == null) return null;
            String string3 = object2.toString();
            object2 = string3;
            if (string3 == null) return null;
            String string4 = ((String)object2).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            object2 = string4;
            if (string4 == null) return null;
            string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
        }
        return string;
    }

    private final Object getEventValue(IndexedEvent event, String operand) {
        Object object = event;
        if (object == null || (object = ((IndexedEvent)object).getParams()) == null || (object = ((GenericEventParameters)object).getReturnValues()) == null || (object = object.get(operand)) == null) {
            IndexedEvent indexedEvent = event;
            object = indexedEvent != null ? indexedEvent.get(operand) : null;
        }
        return object;
    }

    private static final void generateAllValidCombinations$backtrack(Ref.IntRef attempts, int $maxAttempts, List<Event> $eventDefinitions, List<Map<String, IndexedEvent>> validCombinations, List<IndexedEvent> $events, int eventIndex, int aliasIndex, boolean[] used, Map<String, IndexedEvent> aliasMap) {
        if (attempts.element >= $maxAttempts) {
            return;
        }
        int n = attempts.element;
        attempts.element = n + 1;
        if (aliasIndex == $eventDefinitions.size()) {
            validCombinations.add(MapsKt.toMap(aliasMap));
            return;
        }
        Event eventDefinition = $eventDefinitions.get(aliasIndex);
        int n2 = $events.size();
        for (int i = eventIndex; i < n2; ++i) {
            IndexedEvent event;
            if (used[i] || !Intrinsics.areEqual((Object)(event = $events.get(i)).getParams().getEventType(), (Object)eventDefinition.getName())) continue;
            used[i] = true;
            aliasMap.put(eventDefinition.getAlias(), event);
            BusinessEventUtils.generateAllValidCombinations$backtrack(attempts, $maxAttempts, $eventDefinitions, validCombinations, $events, 0, aliasIndex + 1, used, aliasMap);
            aliasMap.remove(eventDefinition.getAlias());
            used[i] = false;
        }
    }
}

