/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vechain.indexer.event.model.abi.AbiElement;
import org.vechain.indexer.event.model.abi.InputOutput;
import org.vechain.indexer.event.model.generic.GenericEventParameters;
import org.vechain.indexer.event.types.DecodedValue;
import org.vechain.indexer.event.types.Types;
import org.vechain.indexer.event.utils.EventUtils;
import org.vechain.indexer.thor.model.TxEvent;
import org.vechain.indexer.utils.DataUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ@\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J$\u0010\u0016\u001a\u0004\u0018\u00010\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0011J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bJ*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011\u00a8\u0006\u001e"}, d2={"Lorg/vechain/indexer/event/utils/EventUtils;", "", "()V", "decodeEvent", "Lorg/vechain/indexer/event/model/generic/GenericEventParameters;", "event", "Lorg/vechain/indexer/thor/model/TxEvent;", "abiElement", "Lorg/vechain/indexer/event/model/abi/AbiElement;", "decodeType", "hexValue", "", "solidityType", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "extractDataSegment", "data", "index", "findMatchingAbi", "topics", "configuredEvents", "getEventSignature", "canonicalName", "isEventValid", "", "contractAddresses", "indexer-core"})
public final class EventUtils {
    @NotNull
    public static final EventUtils INSTANCE = new EventUtils();

    private EventUtils() {
    }

    @NotNull
    public final String getEventSignature(@NotNull String canonicalName) {
        Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
        if (!(!StringsKt.isBlank((CharSequence)canonicalName))) {
            boolean $i$a$-require-EventUtils$getEventSignature$22 = false;
            String $i$a$-require-EventUtils$getEventSignature$22 = "Canonical name must not be blank.";
            throw new IllegalArgumentException($i$a$-require-EventUtils$getEventSignature$22.toString());
        }
        Keccak.Digest256 keccak = new Keccak.Digest256();
        byte[] byArray = canonicalName.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] hash = keccak.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
        return ArraysKt.joinToString$default((byte[])hash, (CharSequence)"", null, null, (int)0, null, (Function1)getEventSignature.2.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GenericEventParameters decodeEvent(@NotNull TxEvent event, @NotNull AbiElement abiElement) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        boolean bl;
        InputOutput it;
        Iterator<InputOutput> $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)abiElement, (String)"abiElement");
        Map decodedParameters = new LinkedHashMap();
        List<InputOutput> inputs = abiElement.getInputs();
        Iterable $this$filter$iv = inputs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            it = (InputOutput)t;
            bl = false;
            if (!it.getIndexed()) continue;
            destination$iv$iv.add(t);
        }
        List indexedInputs = (List)destination$iv$iv;
        if (indexedInputs.size() + 1 != event.getTopics().size()) {
            throw new IllegalArgumentException("Mismatch between ABI indexed inputs and event topics");
        }
        int topicIndex = 1;
        int dataOffset = 0;
        for (InputOutput input : inputs) {
            Object object;
            if (input.getIndexed()) {
                object = EventUtils.decodeType$default(this, event.getTopics().get(topicIndex++), input.getType(), null, 0, null, 28, null);
            } else {
                String segment = this.extractDataSegment(event.getData(), dataOffset++);
                object = this.decodeType(segment, input.getType(), event.getData(), (dataOffset - 1) * 64, input.getComponents());
            }
            Object decodedValue = object;
            decodedParameters.put(input.getName(), decodedValue);
        }
        Map $this$filterValues$iv = decodedParameters;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = entry.getValue();
            bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filterValues$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean bl2 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Object v;
            void it2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl3 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl22 = false;
            Intrinsics.checkNotNull(it2.getValue(), (String)"null cannot be cast to non-null type kotlin.Any");
            map2.put(k, v);
        }
        String string = abiElement.getName();
        if (string == null) {
            string = "Unknown";
        }
        String string2 = string;
        Map map = destination$iv$iv2;
        return new GenericEventParameters(map, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final Object decodeType(String hexValue, String solidityType, String fullData, int startPosition, List<InputOutput> components) {
        Object t;
        Types types;
        Object object;
        block2: {
            Types types2;
            void $this$firstOrNull$iv;
            object = Types.values();
            boolean $i$f$firstOrNull = false;
            int n = ((void)$this$firstOrNull$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!it.isType(solidityType)) continue;
                types2 = element$iv;
                break block2;
            }
            types2 = types = null;
        }
        if (types == null || (object = types.decode(hexValue, Object.class, solidityType, fullData, startPosition, components)) == null || (t = ((DecodedValue)object).getActualValue()) == null) {
            throw new IllegalArgumentException("Unsupported Solidity type: " + solidityType);
        }
        return t;
    }

    static /* synthetic */ Object decodeType$default(EventUtils eventUtils, String string, String string2, String string3, int n, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            list = null;
        }
        return eventUtils.decodeType(string, string2, string3, n, list);
    }

    private final String extractDataSegment(String data, int index) {
        int offset = index * 64;
        String cleanData = DataUtils.INSTANCE.removePrefix(data);
        if (offset + 64 > cleanData.length()) {
            throw new IllegalArgumentException("Data segment out of bounds for index " + index);
        }
        String string = cleanData.substring(offset, offset + 64);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return DataUtils.INSTANCE.addPrefix(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final AbiElement findMatchingAbi(@NotNull List<String> topics, @NotNull List<AbiElement> configuredEvents) {
        Object element$iv;
        Object v0;
        boolean bl;
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        Intrinsics.checkNotNullParameter(configuredEvents, (String)"configuredEvents");
        if (topics.isEmpty()) {
            return null;
        }
        String eventSignature = DataUtils.INSTANCE.removePrefix(topics.get(0));
        Iterable $this$firstOrNull$iv = configuredEvents;
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator.next();
            AbiElement abi = (AbiElement)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)abi.getSignature(), (Object)eventSignature)) {
                int n;
                Iterable $this$count$iv = abi.getInputs();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv2 : $this$count$iv) {
                        InputOutput it = (InputOutput)element$iv2;
                        boolean bl3 = false;
                        if (!it.getIndexed() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                if (n + 1 == topics.size()) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean isEventValid(@NotNull TxEvent event, @NotNull List<AbiElement> configuredEvents, @NotNull List<String> contractAddresses) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(configuredEvents, (String)"configuredEvents");
                Intrinsics.checkNotNullParameter(contractAddresses, (String)"contractAddresses");
                $this$any$iv = configuredEvents;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (AbiElement)element$iv;
                        $i$a$-any-EventUtils$isEventValid$matchesAbi$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getSignature(), (Object)DataUtils.INSTANCE.removePrefix(event.getTopics().get(0)))) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = matchesAbi = false;
                }
            }
            if (contractAddresses.isEmpty()) ** GOTO lbl-1000
            $this$any$iv = contractAddresses;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    $i$a$-any-EventUtils$isEventValid$matchesContract$1 = false;
                    if (!StringsKt.equals((String)it, (String)event.getAddress(), (boolean)true)) continue;
                    v1 = true;
                    break block9;
                }
                v1 = false;
            }
        }
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        matchesContract = v2;
        return ((Collection)event.getTopics()).isEmpty() == false != false && matchesAbi != false && matchesContract != false;
    }
}

