/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.BlockIndexer;
import org.vechain.indexer.Indexer;
import org.vechain.indexer.LogsIndexer;
import org.vechain.indexer.Status;
import org.vechain.indexer.event.AbiManager;
import org.vechain.indexer.event.BusinessEventManager;
import org.vechain.indexer.event.BusinessEventProcessor;
import org.vechain.indexer.event.GenericEventIndexer;
import org.vechain.indexer.event.model.generic.FilterCriteria;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.exception.BlockNotFoundException;
import org.vechain.indexer.exception.ReorgException;
import org.vechain.indexer.thor.client.ThorClient;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.BlockIdentifier;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u00107\u001a\u0002082\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010:\u001a\u0002082\b\u0010;\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010<\u001a\u0002082\b\u0010;\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u000208H\u0002J\u000e\u0010?\u001a\u000208H\u0082P\u00a2\u0006\u0002\u0010@J\r\u0010A\u001a\u00020BH\u0000\u00a2\u0006\u0002\bCJ\b\u0010D\u001a\u000208H\u0002J\r\u0010E\u001a\u000208H\u0000\u00a2\u0006\u0002\bFJ\b\u0010G\u001a\u000208H\u0002J\u0016\u0010H\u001a\u0002082\u0006\u0010I\u001a\u00020JH\u0082@\u00a2\u0006\u0002\u0010KJ\u000e\u0010L\u001a\u000208H\u0082@\u00a2\u0006\u0002\u0010@J\u0010\u0010M\u001a\u000208H\u0080@\u00a2\u0006\u0004\bN\u0010@J\u0016\u0010O\u001a\u00020J2\u0006\u00109\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010PJ\u000e\u0010Q\u001a\u00020JH\u0082@\u00a2\u0006\u0002\u0010@J \u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\u0006\u0010I\u001a\u00020J2\b\b\u0002\u0010U\u001a\u00020VH\u0014J \u0010W\u001a\b\u0012\u0004\u0012\u00020T0S2\u0006\u0010I\u001a\u00020J2\b\b\u0002\u0010U\u001a\u00020VH\u0014J&\u0010X\u001a\b\u0012\u0004\u0012\u00020T0S2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020T0S2\b\b\u0002\u0010U\u001a\u00020VH\u0014J=\u0010Z\u001a\b\u0012\u0004\u0012\u00020T0S2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020T0S2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u001e0S2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010BH\u0000\u00a2\u0006\u0004\b]\u0010^R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010,\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0010\"\u0004\b.\u0010/R$\u00101\u001a\u0002002\u0006\u0010+\u001a\u000200@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u00106\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lorg/vechain/indexer/BlockIndexer;", "Lorg/vechain/indexer/Indexer;", "thorClient", "Lorg/vechain/indexer/thor/client/ThorClient;", "startBlock", "", "syncLoggerInterval", "abiManager", "Lorg/vechain/indexer/event/AbiManager;", "businessEventManager", "Lorg/vechain/indexer/event/BusinessEventManager;", "<init>", "(Lorg/vechain/indexer/thor/client/ThorClient;JJLorg/vechain/indexer/event/AbiManager;Lorg/vechain/indexer/event/BusinessEventManager;)V", "getThorClient", "()Lorg/vechain/indexer/thor/client/ThorClient;", "getStartBlock", "()J", "getAbiManager", "()Lorg/vechain/indexer/event/AbiManager;", "getBusinessEventManager", "()Lorg/vechain/indexer/event/BusinessEventManager;", "previousBlock", "Lorg/vechain/indexer/thor/model/BlockIdentifier;", "remainingIterations", "getRemainingIterations$indexer_core", "()Ljava/lang/Long;", "setRemainingIterations$indexer_core", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "name", "", "getName", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "status", "Lorg/vechain/indexer/Status;", "getStatus", "()Lorg/vechain/indexer/Status;", "setStatus", "(Lorg/vechain/indexer/Status;)V", "value", "currentBlockNumber", "getCurrentBlockNumber", "setCurrentBlockNumber", "(J)V", "Ljava/time/LocalDateTime;", "timeLastProcessed", "getTimeLastProcessed", "()Ljava/time/LocalDateTime;", "setTimeLastProcessed$indexer_core", "(Ljava/time/LocalDateTime;)V", "backoffPeriod", "initialise", "", "blockNumber", "startInCoroutine", "iterations", "start", "(Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restart", "run", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasNoRemainingIterations", "", "hasNoRemainingIterations$indexer_core", "handleFullySynced", "handleError", "handleError$indexer_core", "handleReorg", "postProcessBlock", "block", "Lorg/vechain/indexer/thor/model/Block;", "(Lorg/vechain/indexer/thor/model/Block;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ensureFullySynced", "backoffDelay", "backoffDelay$indexer_core", "getBlockFromChain", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBestBlockFromChain", "processAllEvents", "", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "criteria", "Lorg/vechain/indexer/event/model/generic/FilterCriteria;", "processBlockGenericEvents", "processBlockBusinessEvents", "decodedEvents", "processBusinessEvents", "businessEventNames", "removeDuplicates", "processBusinessEvents$indexer_core", "(Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;)Ljava/util/List;", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nBlockIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockIndexer.kt\norg/vechain/indexer/BlockIndexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,361:1\n1#2:362\n*E\n"})
public abstract class BlockIndexer
implements Indexer {
    @NotNull
    private final ThorClient thorClient;
    private final long startBlock;
    private final long syncLoggerInterval;
    @Nullable
    private final AbiManager abiManager;
    @Nullable
    private final BusinessEventManager businessEventManager;
    @Nullable
    private BlockIdentifier previousBlock;
    @Nullable
    private Long remainingIterations;
    @NotNull
    private final Logger logger;
    @NotNull
    private Status status;
    private long currentBlockNumber;
    @NotNull
    private LocalDateTime timeLastProcessed;
    private long backoffPeriod;

    public BlockIndexer(@NotNull ThorClient thorClient, long startBlock, long syncLoggerInterval, @Nullable AbiManager abiManager, @Nullable BusinessEventManager businessEventManager) {
        Intrinsics.checkNotNullParameter((Object)thorClient, (String)"thorClient");
        this.thorClient = thorClient;
        this.startBlock = startBlock;
        this.syncLoggerInterval = syncLoggerInterval;
        this.abiManager = abiManager;
        this.businessEventManager = businessEventManager;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.status = Status.SYNCING;
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        this.timeLastProcessed = localDateTime;
    }

    public /* synthetic */ BlockIndexer(ThorClient thorClient, long l, long l2, AbiManager abiManager, BusinessEventManager businessEventManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = 1000L;
        }
        if ((n & 8) != 0) {
            abiManager = null;
        }
        if ((n & 0x10) != 0) {
            businessEventManager = null;
        }
        this(thorClient, l, l2, abiManager, businessEventManager);
    }

    @NotNull
    protected ThorClient getThorClient() {
        return this.thorClient;
    }

    protected final long getStartBlock() {
        return this.startBlock;
    }

    @Nullable
    protected AbiManager getAbiManager() {
        return this.abiManager;
    }

    @Nullable
    protected BusinessEventManager getBusinessEventManager() {
        return this.businessEventManager;
    }

    @Nullable
    public final Long getRemainingIterations$indexer_core() {
        return this.remainingIterations;
    }

    public final void setRemainingIterations$indexer_core(@Nullable Long l) {
        this.remainingIterations = l;
    }

    @NotNull
    public final String getName() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"<set-?>");
        this.status = status;
    }

    public final long getCurrentBlockNumber() {
        return this.currentBlockNumber;
    }

    protected final void setCurrentBlockNumber(long l) {
        this.currentBlockNumber = l;
    }

    @NotNull
    public final LocalDateTime getTimeLastProcessed() {
        return this.timeLastProcessed;
    }

    public final void setTimeLastProcessed$indexer_core(@NotNull LocalDateTime localDateTime) {
        Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"<set-?>");
        this.timeLastProcessed = localDateTime;
    }

    private final void initialise(Long blockNumber) {
        BlockIdentifier lastBlock;
        long l;
        Long l2 = blockNumber;
        if (l2 != null) {
            l = l2;
        } else {
            BlockIdentifier blockIdentifier = this.getLastSyncedBlock();
            Long l3 = blockIdentifier != null ? Long.valueOf(blockIdentifier.getNumber()) : null;
            l = l3 != null ? l3 : this.startBlock;
        }
        long lastSyncedBlockNumber = l;
        this.rollback(lastSyncedBlockNumber);
        this.currentBlockNumber = lastSyncedBlockNumber;
        this.setStatus(Status.SYNCING);
        BlockIdentifier blockIdentifier = lastBlock = this.getLastSyncedBlock();
        this.previousBlock = (blockIdentifier != null ? blockIdentifier.getNumber() == lastSyncedBlockNumber - 1L : false) ? lastBlock : null;
    }

    static /* synthetic */ void initialise$default(BlockIndexer blockIndexer, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialise");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        blockIndexer.initialise(l);
    }

    @Override
    public void startInCoroutine(@Nullable Long iterations) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, iterations, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BlockIndexer this$0;
            final /* synthetic */ Long $iterations;
            {
                this.this$0 = $receiver;
                this.$iterations = $iterations;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        Object object3 = this.this$0.start(this.$iterations, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            this.this$0.getLogger().error("Error starting indexer " + $this$launch.getClass().getSimpleName() + ": ", (Throwable)e);
                            throw new Exception(e.getMessage(), e);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @Nullable
    public Object start(@Nullable Long iterations, @NotNull Continuation<? super Unit> $completion) {
        return BlockIndexer.start$suspendImpl(this, iterations, $completion);
    }

    static /* synthetic */ Object start$suspendImpl(BlockIndexer $this, Long iterations, Continuation<? super Unit> $completion) {
        $this.remainingIterations = iterations;
        if (!($this instanceof LogsIndexer)) {
            BlockIndexer.initialise$default($this, null, 1, null);
        }
        $this.logger.info("Starting @ Block: " + $this.currentBlockNumber);
        Object object = $this.run($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void restart() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStatus().ordinal()]) {
            case 1: {
                this.initialise(this.currentBlockNumber);
                break;
            }
            case 2: {
                this.initialise(this.currentBlockNumber - 1L);
                break;
            }
            default: {
                BlockIndexer.initialise$default(this, null, 1, null);
            }
        }
        this.logger.info("Restarting indexer @ Block: " + this.currentBlockNumber);
    }

    /*
     * Unable to fully structure code
     */
    private final Object run(Continuation<? super Unit> $completion) {
        block29: {
            if (!($completion instanceof run.1)) ** GOTO lbl-1000
            var7_2 = $completion;
            if ((var7_2.label & -2147483648) != 0) {
                var7_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ BlockIndexer this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return BlockIndexer.access$run(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var2_5 = this;
lbl13:
                    // 2 sources

                    while (true) {
                        if (var2_5.hasNoRemainingIterations$indexer_core()) {
                            return Unit.INSTANCE;
                        }
                        $continuation.L$0 = var2_5;
                        $continuation.label = 1;
                        v0 = var2_5.backoffDelay$indexer_core((Continuation<? super Unit>)$continuation);
                        ** if (v0 != var8_4) goto lbl23
lbl22:
                        // 1 sources

                        return var8_4;
lbl23:
                        // 1 sources

                        ** GOTO lbl30
                        break;
                    }
                }
                case 1: {
                    var2_5 = (BlockIndexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    if (var2_5.getStatus() == Status.ERROR || var2_5.getStatus() == Status.REORG) {
                        var2_5.restart();
                    }
                    $continuation.L$0 = var2_5;
                    $continuation.label = 2;
                    v1 = var2_5.getBlockFromChain(var2_5.currentBlockNumber, (Continuation<? super Block>)$continuation);
                    ** if (v1 != var8_4) goto lbl37
lbl36:
                    // 1 sources

                    return var8_4;
lbl37:
                    // 1 sources

                    ** GOTO lbl44
                }
                case 2: {
                    var2_5 = (BlockIndexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl44:
                    // 2 sources

                    block = (Block)v1;
                    if (var2_5.currentBlockNumber > var2_5.startBlock) {
                        v2 = var2_5.previousBlock;
                        if (v2 != null && (v2 = v2.getId()) != null) {
                            it = v2;
                            $i$a$-let-BlockIndexer$run$2 = false;
                            v3 = !Intrinsics.areEqual((Object)it, (Object)block.getParentID());
                        } else {
                            v3 = false;
                        }
                        if (v3) {
                            throw new ReorgException("Chain re-organization detected @ Block " + var2_5.currentBlockNumber + " with parent block ID " + block.getParentID());
                        }
                    }
                    if (var2_5.logger.isTraceEnabled()) {
                        var2_5.logger.trace("Processing @ Block " + var2_5.currentBlockNumber + " (" + var2_5.getStatus() + ")");
                    } else if (var2_5.getStatus() != Status.SYNCING || var2_5.currentBlockNumber % var2_5.syncLoggerInterval == 0L) {
                        var2_5.logger.info("Processing @ Block " + var2_5.currentBlockNumber + " (" + var2_5.getStatus() + ")");
                    }
                    var2_5.processBlock(block);
                    $continuation.L$0 = var2_5;
                    $continuation.label = 3;
                    v4 = var2_5.postProcessBlock(block, (Continuation<? super Unit>)$continuation);
                    if (v4 != var8_4) break block29;
                    return var8_4;
                }
                case 3: {
                    var2_5 = (BlockIndexer)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                    }
                    catch (BlockNotFoundException block) {
                        var2_5.logger.info("Block " + var2_5.currentBlockNumber + " not found. Indexer may be fully synchronised.");
                        var2_5.handleFullySynced();
                        $continuation.L$0 = var2_5;
                        $continuation.label = 4;
                        v5 = var2_5.ensureFullySynced((Continuation<? super Unit>)$continuation);
                        if (v5 == var8_4) {
                            return var8_4;
                        }
                        break block29;
                    }
                }
                case 4: {
                    var2_5 = (BlockIndexer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
                    break block29;
                }
            }
            catch (ReorgException block) {
                var2_5.logger.error("REORG @ Block " + var2_5.currentBlockNumber);
                var2_5.handleReorg();
                break block29;
            }
            catch (Exception e) {
                var2_5.logger.error("Error while processing block " + var2_5.currentBlockNumber, (Throwable)e);
                var2_5.handleError$indexer_core();
            }
        }
        ** while (true)
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasNoRemainingIterations$indexer_core() {
        if (this.remainingIterations != null) {
            Long l = this.remainingIterations;
            Intrinsics.checkNotNull((Object)l);
            if (l <= 0L) {
                this.logger.info("Indexer finished at block " + this.currentBlockNumber);
                return true;
            }
            Long l2 = this.remainingIterations;
            this.remainingIterations = l2 != null ? Long.valueOf(l2 + -1L) : null;
        }
        return false;
    }

    private final void handleFullySynced() {
        this.backoffPeriod = 4000L;
        this.setStatus(Status.FULLY_SYNCED);
    }

    public final void handleError$indexer_core() {
        this.backoffPeriod = 10000L;
        this.setStatus(Status.ERROR);
    }

    private final void handleReorg() {
        this.backoffPeriod = 10000L;
        this.setStatus(Status.REORG);
    }

    /*
     * Unable to fully structure code
     */
    private final Object postProcessBlock(Block var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof postProcessBlock.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BlockIndexer.access$postProcessBlock(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getStatus() == Status.FULLY_SYNCED && this.currentBlockNumber % (long)20 == 0L) {
                    $continuation.L$0 = block;
                    $continuation.label = 1;
                    v0 = this.ensureFullySynced((Continuation<? super Unit>)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                }
                ** GOTO lbl23
            }
            case 1: {
                block = (Block)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if (this.getStatus() == Status.FULLY_SYNCED) {
                    currentEpoch = LocalDateTime.now(ZoneOffset.UTC).toInstant(ZoneOffset.UTC).toEpochMilli();
                    timeSinceLastBlock = Math.max(currentEpoch - block.getTimestamp() * (long)1000, 0L);
                    this.backoffPeriod = Math.max(0L, 10000L - timeSinceLastBlock) + (long)100;
                    this.logger.info("Success @ Block " + this.currentBlockNumber + " (" + timeSinceLastBlock + " ms since mine)");
                }
                var3_6 = this.currentBlockNumber;
                this.currentBlockNumber = var3_6 + 1L;
                this.previousBlock = new BlockIdentifier(block.getNumber(), block.getId());
                v1 = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"now(...)");
                this.timeLastProcessed = v1;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object ensureFullySynced(Continuation<? super Unit> $completion) {
        if (!($completion instanceof ensureFullySynced.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ BlockIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BlockIndexer.access$ensureFullySynced(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getStatus() != Status.FULLY_SYNCED) ** GOTO lbl24
                $continuation.label = 1;
                v0 = this.getBestBlockFromChain((Continuation<? super Block>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                if ((latestBlock = (Block)v0).getNumber() > this.currentBlockNumber) {
                    this.logger.info(this.getName() + " - Changing status to SYNCING (indexerBlock=" + this.currentBlockNumber + ", latestBlock=" + latestBlock.getNumber() + ")");
                    this.setStatus(Status.SYNCING);
                }
lbl24:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object backoffDelay$indexer_core(@NotNull Continuation<? super Unit> $completion) {
        if (this.getStatus() != Status.SYNCING) {
            Object object = DelayKt.delay((long)this.backoffPeriod, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Object getBlockFromChain(long blockNumber, Continuation<? super Block> $completion) {
        return this.getThorClient().getBlock(blockNumber, $completion);
    }

    private final Object getBestBlockFromChain(Continuation<? super Block> $completion) {
        return this.getThorClient().getBestBlock($completion);
    }

    @NotNull
    protected List<IndexedEvent> processAllEvents(@NotNull Block block, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        Object object = this.getBusinessEventManager();
        if (object == null || (object = ((BusinessEventManager)object).updateCriteriaWithBusinessEvents(criteria)) == null) {
            object = criteria;
        }
        Object updatedCriteria = object;
        List<IndexedEvent> decodedEvents = this.processBlockGenericEvents(block, (FilterCriteria)updatedCriteria);
        return this.processBusinessEvents$indexer_core(decodedEvents, ((FilterCriteria)updatedCriteria).getBusinessEventNames(), ((FilterCriteria)updatedCriteria).getRemoveDuplicates());
    }

    public static /* synthetic */ List processAllEvents$default(BlockIndexer blockIndexer, Block block, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processAllEvents");
        }
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return blockIndexer.processAllEvents(block, filterCriteria);
    }

    @NotNull
    protected List<IndexedEvent> processBlockGenericEvents(@NotNull Block block, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (this.getAbiManager() == null) {
            this.logger.warn("ABI Manager is not configured. Skipping generic event processing.");
            return CollectionsKt.emptyList();
        }
        AbiManager abiManager = this.getAbiManager();
        Intrinsics.checkNotNull((Object)abiManager);
        GenericEventIndexer eventIndexer = new GenericEventIndexer(abiManager);
        return eventIndexer.getBlockEventsByFilters(block, criteria);
    }

    public static /* synthetic */ List processBlockGenericEvents$default(BlockIndexer blockIndexer, Block block, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBlockGenericEvents");
        }
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return blockIndexer.processBlockGenericEvents(block, filterCriteria);
    }

    @NotNull
    protected List<IndexedEvent> processBlockBusinessEvents(@NotNull List<IndexedEvent> decodedEvents, @NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter(decodedEvents, (String)"decodedEvents");
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (this.getBusinessEventManager() == null) {
            this.logger.warn("Business Event Manager is not configured. Skipping business event processing.");
            return CollectionsKt.emptyList();
        }
        BusinessEventManager businessEventManager = this.getBusinessEventManager();
        Intrinsics.checkNotNull((Object)businessEventManager);
        BusinessEventProcessor processor = new BusinessEventProcessor(businessEventManager);
        return processor.getOnlyBusinessEvents(decodedEvents, criteria.getBusinessEventNames(), this instanceof LogsIndexer);
    }

    public static /* synthetic */ List processBlockBusinessEvents$default(BlockIndexer blockIndexer, List list, FilterCriteria filterCriteria, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBlockBusinessEvents");
        }
        if ((n & 2) != 0) {
            filterCriteria = new FilterCriteria(null, null, null, null, false, false, 63, null);
        }
        return blockIndexer.processBlockBusinessEvents(list, filterCriteria);
    }

    @NotNull
    public final List<IndexedEvent> processBusinessEvents$indexer_core(@NotNull List<IndexedEvent> decodedEvents, @NotNull List<String> businessEventNames, @Nullable Boolean removeDuplicates) {
        Intrinsics.checkNotNullParameter(decodedEvents, (String)"decodedEvents");
        Intrinsics.checkNotNullParameter(businessEventNames, (String)"businessEventNames");
        if (this.getBusinessEventManager() != null) {
            BusinessEventManager businessEventManager = this.getBusinessEventManager();
            Intrinsics.checkNotNull((Object)businessEventManager);
            BusinessEventProcessor processor = new BusinessEventProcessor(businessEventManager);
            boolean logsIndexer = this instanceof LogsIndexer;
            Boolean bl = removeDuplicates;
            return processor.processEvents(decodedEvents, businessEventNames, bl != null ? bl : true, logsIndexer);
        }
        this.logger.debug("Skipping business event processing as manager is missing.");
        return decodedEvents;
    }

    public static /* synthetic */ List processBusinessEvents$indexer_core$default(BlockIndexer blockIndexer, List list, List list2, Boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBusinessEvents");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return blockIndexer.processBusinessEvents$indexer_core(list, list2, bl);
    }

    public static final /* synthetic */ Object access$run(BlockIndexer $this, Continuation $completion) {
        return $this.run((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$postProcessBlock(BlockIndexer $this, Block block, Continuation $completion) {
        return $this.postProcessBlock(block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$ensureFullySynced(BlockIndexer $this, Continuation $completion) {
        return $this.ensureFullySynced((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$getBlockFromChain(BlockIndexer $this, long blockNumber, Continuation $completion) {
        return $this.getBlockFromChain(blockNumber, (Continuation<? super Block>)$completion);
    }

    public static final /* synthetic */ Object access$getBestBlockFromChain(BlockIndexer $this, Continuation $completion) {
        return $this.getBestBlockFromChain((Continuation<? super Block>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.REORG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

