/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.vechain.indexer.event.ResourceManager;
import org.vechain.indexer.event.model.abi.AbiElement;
import org.vechain.indexer.event.model.abi.InputOutput;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u000bJ\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u000bJ(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/vechain/indexer/event/AbiManager;", "Lorg/vechain/indexer/event/ResourceManager;", "abiFiles", "", "", "<init>", "(Ljava/util/List;)V", "abis", "", "Lorg/vechain/indexer/event/model/abi/AbiElement;", "loadAbis", "", "getAbis", "getEventsByNames", "abiNames", "eventNames", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nAbiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiManager.kt\norg/vechain/indexer/event/AbiManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n216#2,2:54\n1374#3:56\n1460#3,2:57\n774#3:59\n865#3,2:60\n1462#3,3:62\n1669#3,4:65\n1788#3,4:69\n1673#3,4:73\n*S KotlinDebug\n*F\n+ 1 AbiManager.kt\norg/vechain/indexer/event/AbiManager\n*L\n11#1:54,2\n46#1:56\n46#1:57,2\n47#1:59\n47#1:60,2\n46#1:62,3\n51#1:65,4\n51#1:69,4\n51#1:73,4\n*E\n"})
public final class AbiManager
extends ResourceManager {
    @NotNull
    private final List<String> abiFiles;
    @NotNull
    private final Map<String, List<AbiElement>> abis;

    public AbiManager(@NotNull List<String> abiFiles) {
        Intrinsics.checkNotNullParameter(abiFiles, (String)"abiFiles");
        super(null, 1, null);
        this.abiFiles = abiFiles;
        this.abis = new LinkedHashMap();
        Map<String, List<AbiElement>> $this$forEach$iv = this.loadAbis();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<AbiElement>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<AbiElement>> element$iv;
            Map.Entry<String, List<AbiElement>> entry = element$iv = iterator.next();
            boolean bl = false;
            String fileName = entry.getKey();
            List<AbiElement> abiEntries2 = entry.getValue();
            this.abis.put(fileName, abiEntries2);
            this.getLogger().info("Loaded ABI from " + fileName + " with " + abiEntries2.size() + " entries");
        }
    }

    @NotNull
    public final Map<String, List<AbiElement>> loadAbis() {
        Map result = new LinkedHashMap();
        for (String path : this.abiFiles) {
            if (this.readAndSubstituteJson(path) == null) continue;
            try {
                String substitutedJson;
                Object object = this.getObjectMapper().readValue(substitutedJson, (TypeReference)new TypeReference<List<? extends AbiElement>>(){});
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                List abiEntries2 = (List)object;
                String fileName = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)path, (String)"/", null, (int)2, null), (String)".", null, (int)2, null);
                result.put(fileName, abiEntries2);
            }
            catch (Exception ex) {
                this.getLogger().error("\u274c Error parsing ABI file " + path + ": " + ex.getMessage());
                throw ex;
            }
        }
        return result;
    }

    @NotNull
    public final Map<String, List<AbiElement>> getAbis() {
        return this.abis;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AbiElement> getEventsByNames(@NotNull List<String> abiNames, @NotNull List<String> eventNames) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(abiNames, (String)"abiNames");
        Intrinsics.checkNotNullParameter(eventNames, (String)"eventNames");
        Iterable $this$flatMap$iv = abiNames;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String abiName = (String)element$iv$iv;
            boolean bl3 = false;
            List<AbiElement> list2 = this.abis.get(abiName);
            if (list2 != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    AbiElement it = (AbiElement)element$iv$iv2;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getType(), (Object)"event") && (eventNames.isEmpty() || CollectionsKt.contains((Iterable)eventNames, (Object)it.getName())))) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            int n;
            Pair key$iv;
            int n2;
            void $this$count$iv;
            AbiElement it = (AbiElement)e$iv;
            boolean bl = false;
            Iterable bl3 = it.getInputs();
            String string = it.getSignature();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    InputOutput input = (InputOutput)element$iv;
                    boolean bl4 = false;
                    if (!input.getIndexed() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            if (!set$iv.add(key$iv = TuplesKt.to((Object)string, (Object)(n = n2)))) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }
}

