/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vechain.indexer.event.ResourceManager;
import org.vechain.indexer.event.model.business.BusinessEventDefinition;
import org.vechain.indexer.event.model.business.Event;
import org.vechain.indexer.event.model.generic.FilterCriteria;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003J\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u0006J \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/vechain/indexer/event/BusinessEventManager;", "Lorg/vechain/indexer/event/ResourceManager;", "eventFiles", "", "", "envParams", "", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "businessEvents", "", "Lorg/vechain/indexer/event/model/business/BusinessEventDefinition;", "loadBusinessEvents", "getAllBusinessEvents", "getBusinessEventsByNames", "names", "getBusinessGenericEventNames", "updateCriteriaWithBusinessEvents", "Lorg/vechain/indexer/event/model/generic/FilterCriteria;", "criteria", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nBusinessEventManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BusinessEventManager.kt\norg/vechain/indexer/event/BusinessEventManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,56:1\n1869#2,2:57\n1617#2,9:59\n1869#2:68\n1870#2:71\n1626#2:72\n1563#2:76\n1634#2,3:77\n1#3:69\n1#3:70\n77#4:73\n97#4,2:74\n99#4,3:80\n*S KotlinDebug\n*F\n+ 1 BusinessEventManager.kt\norg/vechain/indexer/event/BusinessEventManager\n*L\n14#1:57,2\n41#1:59,9\n41#1:68\n41#1:71\n41#1:72\n45#1:76\n45#1:77,3\n41#1:70\n44#1:73\n44#1:74,2\n44#1:80,3\n*E\n"})
public final class BusinessEventManager
extends ResourceManager {
    @NotNull
    private final List<String> eventFiles;
    @NotNull
    private final Map<String, BusinessEventDefinition> businessEvents;

    public BusinessEventManager(@NotNull List<String> eventFiles, @NotNull Map<String, String> envParams) {
        Intrinsics.checkNotNullParameter(eventFiles, (String)"eventFiles");
        Intrinsics.checkNotNullParameter(envParams, (String)"envParams");
        super(envParams);
        this.eventFiles = eventFiles;
        this.businessEvents = new LinkedHashMap();
        Iterable $this$forEach$iv = this.loadBusinessEvents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BusinessEventDefinition event = (BusinessEventDefinition)element$iv;
            boolean bl = false;
            this.businessEvents.put(event.getName(), event);
            this.getLogger().info("Loaded business event: " + event.getName());
        }
    }

    public /* synthetic */ BusinessEventManager(List list, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(list, map);
    }

    @NotNull
    public final List<BusinessEventDefinition> loadBusinessEvents() {
        List loadedEvents = new ArrayList();
        for (String path : this.eventFiles) {
            if (this.readAndSubstituteJson(path) == null) continue;
            try {
                String substitutedJson;
                BusinessEventDefinition event = (BusinessEventDefinition)this.getObjectMapper().readValue(substitutedJson, BusinessEventDefinition.class);
                Intrinsics.checkNotNull((Object)event);
                boolean bl = loadedEvents.add(event);
            }
            catch (Exception ex) {
                this.getLogger().error("\u274c Error parsing file " + path + ": " + ex.getMessage());
                throw ex;
            }
        }
        return loadedEvents;
    }

    @NotNull
    public final Map<String, BusinessEventDefinition> getAllBusinessEvents() {
        return this.businessEvents;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, BusinessEventDefinition> getBusinessEventsByNames(@NotNull List<String> names) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Iterable $this$mapNotNull$iv = names;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String name = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.businessEvents.get(name) != null) {
                BusinessEventDefinition it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)name, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getBusinessGenericEventNames(@NotNull List<String> names) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, (String)"names");
        Map<String, BusinessEventDefinition> $this$flatMap$iv = this.getBusinessEventsByNames(names);
        boolean $i$f$flatMap = false;
        Map<String, BusinessEventDefinition> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            BusinessEventDefinition businessEventDefinition = (BusinessEventDefinition)entry.getValue();
            Iterable $this$map$iv = businessEventDefinition.getEvents();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Event event = (Event)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final FilterCriteria updateCriteriaWithBusinessEvents(@NotNull FilterCriteria criteria) {
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (!((Collection)criteria.getBusinessEventNames()).isEmpty()) {
            List<String> names = this.getBusinessGenericEventNames(criteria.getBusinessEventNames());
            return criteria.addBusinessEventNames(names);
        }
        return criteria;
    }
}

