/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.utils.FileUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0004J$\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u0004R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/vechain/indexer/event/ResourceManager;", "", "envParams", "", "", "<init>", "(Ljava/util/Map;)V", "getEnvParams", "()Ljava/util/Map;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "readAndSubstituteJson", "path", "substitutePlaceholders", "text", "params", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nResourceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceManager.kt\norg/vechain/indexer/event/ResourceManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public abstract class ResourceManager {
    @NotNull
    private final Map<String, String> envParams;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ObjectMapper objectMapper;

    public ResourceManager(@NotNull Map<String, String> envParams) {
        Intrinsics.checkNotNullParameter(envParams, (String)"envParams");
        this.envParams = envParams;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
    }

    public /* synthetic */ ResourceManager(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    @NotNull
    protected final Map<String, String> getEnvParams() {
        return this.envParams;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final String readAndSubstituteJson(@NotNull String path) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream2 = FileUtils.INSTANCE.getResourceAsStream(path);
        if (inputStream2 == null) {
            throw new IllegalStateException("Resource not found: " + path);
        }
        Closeable closeable = inputStream = inputStream2;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object originalJson = object2;
        String substitutedJson = this.substitutePlaceholders((String)originalJson, this.envParams);
        if (StringsKt.contains$default((CharSequence)substitutedJson, (CharSequence)"${", (boolean)false, (int)2, null)) {
            this.logger.warn("\u26a0\ufe0fUnresolved placeholders found in " + path);
        }
        return substitutedJson;
    }

    @NotNull
    protected final String substitutePlaceholders(@NotNull String text, @NotNull Map<String, String> params) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Pattern regex = Pattern.compile("\\$\\{(\\w+)}");
        Matcher matcher = regex.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String key = matcher.group(1);
            String string = params.get(key);
            if (string == null) {
                string = System.getenv(key);
            }
            Matcher matcher2 = (replacement = string) != null ? matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement)) : matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group(0)));
        }
        matcher.appendTail(sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public ResourceManager() {
        this(null, 1, null);
    }
}

