/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event.types;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.model.abi.InputOutput;
import org.vechain.indexer.event.types.DecodedValue;
import org.vechain.indexer.utils.DataUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&JV\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH&J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0015H&J\u0014\u0010\u001e\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006 "}, d2={"Lorg/vechain/indexer/event/types/Types;", "", "<init>", "(Ljava/lang/String;I)V", "ADDRESS", "UINT", "BOOL", "INT", "BYTES", "STRING", "TUPLE", "ARRAY", "isType", "", "typeName", "", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "isTupleDynamic", "Companion", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Types.kt\norg/vechain/indexer/event/types/Types\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,377:1\n1761#2,2:378\n1763#2:381\n1#3:380\n*S KotlinDebug\n*F\n+ 1 Types.kt\norg/vechain/indexer/event/types/Types\n*L\n368#1:378,2\n368#1:381\n*E\n"})
public abstract class Types
extends Enum<Types> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger logger;
    public static final /* enum */ Types ADDRESS;
    public static final /* enum */ Types UINT;
    public static final /* enum */ Types BOOL;
    public static final /* enum */ Types INT;
    public static final /* enum */ Types BYTES;
    public static final /* enum */ Types STRING;
    public static final /* enum */ Types TUPLE;
    public static final /* enum */ Types ARRAY;
    private static final /* synthetic */ Types[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Types() {
    }

    public abstract boolean isType(@NotNull String var1);

    @NotNull
    public abstract <T> DecodedValue<T> decode(@NotNull String var1, @NotNull Class<T> var2, @NotNull String var3, @Nullable String var4, int var5, @Nullable List<InputOutput> var6);

    public static /* synthetic */ DecodedValue decode$default(Types types, String string, Class clazz, String string2, String string3, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n2 & 0x20) != 0) {
            list = null;
        }
        return types.decode(string, clazz, string2, string3, n, list);
    }

    @NotNull
    public abstract Class<?> getClaas();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTupleDynamic(@NotNull List<InputOutput> components) {
        boolean bl;
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Iterable $this$any$iv = components;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            InputOutput input = (InputOutput)element$iv;
            boolean bl2 = false;
            String type = input.getType();
            if (Intrinsics.areEqual((Object)type, (Object)"string")) return true;
            if (Intrinsics.areEqual((Object)type, (Object)"bytes")) return true;
            if (StringsKt.endsWith$default((String)type, (String)"[]", (boolean)false, (int)2, null)) return true;
            if (Intrinsics.areEqual((Object)type, (Object)"tuple")) {
                boolean bl3;
                if (input.getComponents() != null) {
                    List<InputOutput> it;
                    boolean bl4 = false;
                    if (this.isTupleDynamic(it)) {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static Types[] values() {
        return (Types[])$VALUES.clone();
    }

    public static Types valueOf(String value) {
        return Enum.valueOf(Types.class, value);
    }

    @NotNull
    public static EnumEntries<Types> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ Types(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        ADDRESS = new ADDRESS("ADDRESS", 0);
        UINT = new UINT("UINT", 1);
        BOOL = new BOOL("BOOL", 2);
        INT = new INT("INT", 3);
        BYTES = new BYTES("BYTES", 4);
        STRING = new STRING("STRING", 5);
        TUPLE = new TUPLE("TUPLE", 6);
        ARRAY = new ARRAY("ARRAY", 7);
        $VALUES = typesArray = new Types[]{Types.ADDRESS, Types.UINT, Types.BOOL, Types.INT, Types.BYTES, Types.STRING, Types.TUPLE, Types.ARRAY};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Types.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016JT\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\u0014"}, d2={"org/vechain/indexer/event/types/Types.ADDRESS", "Lorg/vechain/indexer/event/types/Types;", "isType", "", "typeName", "", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "indexer-core"})
    static final class ADDRESS
    extends Types {
        /*
         * WARNING - void declaration
         */
        ADDRESS() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return Intrinsics.areEqual((Object)typeName, (Object)"address");
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (encoded.length() < 64) {
                throw new IllegalArgumentException("Invalid address length: " + encoded);
            }
            String decoded = "0x" + StringsKt.takeLast((String)encoded, (int)40);
            return new DecodedValue<T>(decoded, clazz, clazz.cast(decoded), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return String.class;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016JT\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\u0014"}, d2={"org/vechain/indexer/event/types/Types.ARRAY", "Lorg/vechain/indexer/event/types/Types;", "isType", "", "typeName", "", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "indexer-core"})
    static final class ARRAY
    extends Types {
        /*
         * WARNING - void declaration
         */
        ARRAY() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return StringsKt.endsWith$default((String)typeName, (String)"[]", (boolean)false, (int)2, null) || new Regex(".+\\[\\d+\\]").matches(charSequence = (CharSequence)typeName);
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            String string;
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (StringsKt.endsWith$default((String)name, (String)"[]", (boolean)false, (int)2, null)) {
                string = StringsKt.removeSuffix((String)name, (CharSequence)"[]");
            } else {
                CharSequence charSequence = name;
                if (new Regex(".+\\[\\d+\\]").matches(charSequence)) {
                    string = StringsKt.substringBeforeLast$default((String)name, (String)"[", null, (int)2, null);
                } else {
                    throw new IllegalArgumentException("Invalid array type: " + name);
                }
            }
            String elementType = string;
            String string2 = fullData;
            if (string2 == null) {
                string2 = encoded;
            }
            List<Object> decodedElements = Companion.decodeArray(elementType, string2, startPosition);
            String stringRepresentation = CollectionsKt.joinToString$default((Iterable)decodedElements, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, ARRAY::decode$lambda$0, (int)25, null);
            return new DecodedValue<T>(stringRepresentation, clazz, clazz.cast(decodedElements), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return List.class;
        }

        private static final CharSequence decode$lambda$0(Object it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.toString();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016JT\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\u0014"}, d2={"org/vechain/indexer/event/types/Types.BOOL", "Lorg/vechain/indexer/event/types/Types;", "isType", "", "typeName", "", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "indexer-core"})
    static final class BOOL
    extends Types {
        /*
         * WARNING - void declaration
         */
        BOOL() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return Intrinsics.areEqual((Object)typeName, (Object)"bool");
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            BigInteger decodedValue = DataUtils.INSTANCE.decodeQuantity(encoded);
            boolean boolValue = Intrinsics.areEqual((Object)decodedValue, (Object)BigInteger.ONE);
            return new DecodedValue<T>(String.valueOf(boolValue), clazz, clazz.cast(boolValue), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return Boolean.TYPE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016JT\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\u0014"}, d2={"org/vechain/indexer/event/types/Types.BYTES", "Lorg/vechain/indexer/event/types/Types;", "isType", "", "typeName", "", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "indexer-core"})
    static final class BYTES
    extends Types {
        /*
         * WARNING - void declaration
         */
        BYTES() {
            void var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            if (Intrinsics.areEqual((Object)typeName, (Object)"bytes")) return true;
            if (!StringsKt.startsWith$default((String)typeName, (String)"bytes", (boolean)false, (int)2, null)) return false;
            IntRange intRange = new IntRange(1, 32);
            Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)typeName, (CharSequence)"bytes"));
            if (n == null) return false;
            if (!intRange.contains(n.intValue())) return false;
            return true;
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (encoded.length() % 2 != 0 || !StringsKt.startsWith$default((String)encoded, (String)"0x", (boolean)false, (int)2, null)) {
                throw new IllegalArgumentException("Invalid bytes value: " + encoded);
            }
            return new DecodedValue<T>(encoded, clazz, clazz.cast(encoded), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return String.class;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\nJ=\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0006\b\u0000\u0010\u0015\u0018\u00012\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0082\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/vechain/indexer/event/types/Types$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "decodeAbiString", "", "encodedString", "startPosition", "", "decodeArray", "", "elementType", "fullData", "convertToSignedBigInt", "Ljava/math/BigInteger;", "value", "bitSize", "decodeBasicType", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "typeName", "encoded", "indexer-core"})
    @SourceDebugExtension(value={"SMAP\nTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Types.kt\norg/vechain/indexer/event/types/Types$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,377:1\n355#1,2:378\n357#1,8:382\n1310#2,2:380\n1310#2,2:390\n*S KotlinDebug\n*F\n+ 1 Types.kt\norg/vechain/indexer/event/types/Types$Companion\n*L\n315#1:378,2\n315#1:382,8\n315#1:380,2\n356#1:390,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String decodeAbiString(@NotNull String encodedString, int startPosition) {
            Intrinsics.checkNotNullParameter((Object)encodedString, (String)"encodedString");
            String inputData = DataUtils.INSTANCE.removePrefix(encodedString);
            try {
                if (inputData.length() < startPosition + 64) {
                    throw new IllegalArgumentException("Data is too short for extracting offset");
                }
                String string = inputData.substring(startPosition, startPosition + 64);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String offsetHex = string;
                int offset = DataUtils.INSTANCE.decodeQuantity(DataUtils.INSTANCE.addPrefix(offsetHex)).intValue();
                if (offset * 2 + 64 > inputData.length()) {
                    throw new IllegalArgumentException("Invalid offset or data length");
                }
                String string2 = inputData.substring(offset * 2, offset * 2 + 64);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String lengthHex = string2;
                int length = DataUtils.INSTANCE.decodeQuantity(DataUtils.INSTANCE.addPrefix(lengthHex)).intValue();
                int stringStart = offset * 2 + 64;
                int stringEnd = stringStart + length * 2;
                if (inputData.length() < stringEnd) {
                    throw new IllegalArgumentException("String end exceeds data length");
                }
                String string3 = inputData.substring(stringStart, stringEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String stringHex = string3;
                return new String(DataUtils.INSTANCE.hexStringToByteArray(DataUtils.INSTANCE.addPrefix(stringHex)), Charsets.UTF_8);
            }
            catch (Exception e) {
                logger.error("Error decoding string at offset: " + startPosition, (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Object> decodeArray(@NotNull String elementType, @NotNull String fullData, int startPosition) {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)fullData, (String)"fullData");
            String inputData = DataUtils.INSTANCE.removePrefix(fullData);
            String string = inputData.substring(startPosition, startPosition + 64);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String arrayOffsetHex = string;
            int arrayOffset = DataUtils.INSTANCE.decodeQuantity(DataUtils.INSTANCE.addPrefix(arrayOffsetHex)).intValue() * 2;
            String string2 = inputData.substring(arrayOffset, arrayOffset + 64);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String arrayLengthHex = string2;
            int arrayLength = DataUtils.INSTANCE.decodeQuantity(DataUtils.INSTANCE.addPrefix(arrayLengthHex)).intValue();
            List decodedArray = new ArrayList();
            int currentOffset = arrayOffset + 64;
            String arrayData = null;
            if (Intrinsics.areEqual((Object)elementType, (Object)"bytes") || Intrinsics.areEqual((Object)elementType, (Object)"string")) {
                String string3 = inputData.substring(arrayOffset + 64);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                arrayData = string3;
                currentOffset = 0;
            }
            for (int i = 0; i < arrayLength; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)inputData.substring(currentOffset, currentOffset + 64), (String)"substring(...)");
                try {
                    Types types;
                    Object object;
                    String prefixedElementData;
                    block6: {
                        Types types2;
                        void $this$firstOrNull$iv$iv;
                        String elementData;
                        prefixedElementData = DataUtils.INSTANCE.addPrefix(elementData);
                        Companion this_$iv = this;
                        boolean $i$f$decodeBasicType = false;
                        object = Types.values();
                        boolean $i$f$firstOrNull = false;
                        int n = ((void)$this$firstOrNull$iv$iv).length;
                        for (int j = 0; j < n; ++j) {
                            void element$iv$iv;
                            void it$iv = element$iv$iv = $this$firstOrNull$iv$iv[j];
                            boolean bl = false;
                            if (!it$iv.isType(elementType)) continue;
                            types2 = element$iv$iv;
                            break block6;
                        }
                        types2 = types = null;
                    }
                    if (types == null || (object = Types.decode$default(types, prefixedElementData, Object.class, elementType, arrayData, currentOffset, null, 32, null)) == null) {
                        throw new IllegalArgumentException("Unsupported type: " + elementType);
                    }
                    Object element = object;
                    decodedArray.add(((DecodedValue)element).getActualValue());
                }
                catch (Exception e) {
                    logger.error("Error decoding element " + i + " of type " + elementType + " at offset " + currentOffset + ": " + e.getMessage());
                    throw e;
                }
                currentOffset += 64;
            }
            return decodedArray;
        }

        @NotNull
        public final BigInteger convertToSignedBigInt(@NotNull BigInteger value, int bitSize) {
            BigInteger bigInteger;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            BigInteger maxUnsignedValue = BigInteger.ONE.shiftLeft(bitSize);
            BigInteger maxSignedValue = maxUnsignedValue.shiftRight(1);
            if (value.compareTo(maxSignedValue) >= 0) {
                BigInteger bigInteger2 = value.subtract(maxUnsignedValue);
                Intrinsics.checkNotNull((Object)bigInteger2);
                bigInteger = bigInteger2;
            } else {
                bigInteger = value;
            }
            return bigInteger;
        }

        /*
         * WARNING - void declaration
         */
        private final /* synthetic */ <T> DecodedValue<T> decodeBasicType(String typeName, String encoded, String fullData, int startPosition) {
            Object object;
            block5: {
                block4: {
                    Object v0;
                    block3: {
                        void $this$firstOrNull$iv;
                        boolean $i$f$decodeBasicType = false;
                        object = Types.values();
                        boolean $i$f$firstOrNull = false;
                        for (void element$iv : $this$firstOrNull$iv) {
                            Types it = (Types)element$iv;
                            boolean bl = false;
                            if (!it.isType(typeName)) continue;
                            v0 = element$iv;
                            break block3;
                        }
                        v0 = null;
                    }
                    Types types = v0;
                    if (types == null) break block4;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    object = Types.decode$default(types, encoded, Object.class, typeName, fullData, startPosition, null, 32, null);
                    if (object != null) break block5;
                }
                throw new IllegalArgumentException("Unsupported type: " + typeName);
            }
            return (DecodedValue)object;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ DecodedValue decodeBasicType$default(Companion $this, String typeName, String encoded, String fullData, int startPosition, int n, Object object) {
            Object object2;
            block8: {
                block7: {
                    Object v0;
                    block6: {
                        void $this$firstOrNull$iv;
                        if ((n & 4) != 0) {
                            fullData = null;
                        }
                        if ((n & 8) != 0) {
                            startPosition = 0;
                        }
                        boolean $i$f$decodeBasicType = false;
                        object2 = Types.values();
                        boolean $i$f$firstOrNull = false;
                        for (void element$iv : $this$firstOrNull$iv) {
                            Types it = (Types)element$iv;
                            boolean bl = false;
                            if (!it.isType(typeName)) continue;
                            v0 = element$iv;
                            break block6;
                        }
                        v0 = null;
                    }
                    object = v0;
                    if (object == null) break block7;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    object2 = Types.decode$default((Types)((Object)object), encoded, Object.class, typeName, fullData, startPosition, null, 32, null);
                    if (object2 != null) break block8;
                }
                throw new IllegalArgumentException("Unsupported type: " + typeName);
            }
            return (DecodedValue)object2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016JT\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\u0014"}, d2={"org/vechain/indexer/event/types/Types.INT", "Lorg/vechain/indexer/event/types/Types;", "isType", "", "typeName", "", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "indexer-core"})
    static final class INT
    extends Types {
        /*
         * WARNING - void declaration
         */
        INT() {
            void var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            if (!StringsKt.startsWith$default((String)typeName, (String)"int", (boolean)false, (int)2, null)) return false;
            if (Intrinsics.areEqual((Object)typeName, (Object)"int")) return true;
            IntRange intRange = new IntRange(8, 256);
            Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)typeName, (CharSequence)"int"));
            if (n == null) return false;
            if (!intRange.contains(n.intValue())) return false;
            return true;
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            BigInteger decodedBigInt = DataUtils.INSTANCE.decodeQuantity(encoded);
            Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)name, (CharSequence)"int"));
            int bitSize = n != null ? n : 256;
            BigInteger signedValue = Companion.convertToSignedBigInt(decodedBigInt, bitSize);
            String string = signedValue.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new DecodedValue<T>(string, clazz, clazz.cast(signedValue), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return BigInteger.class;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016JT\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\u0014"}, d2={"org/vechain/indexer/event/types/Types.STRING", "Lorg/vechain/indexer/event/types/Types;", "isType", "", "typeName", "", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "indexer-core"})
    static final class STRING
    extends Types {
        /*
         * WARNING - void declaration
         */
        STRING() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return Intrinsics.areEqual((Object)typeName, (Object)"string");
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            CharSequence charSequence = fullData;
            if (charSequence == null || charSequence.length() == 0) {
                return new DecodedValue<T>(encoded, clazz, clazz.cast(encoded), name);
            }
            charSequence = Companion.decodeAbiString(fullData, startPosition);
            if (charSequence != null) {
                CharSequence it = charSequence;
                boolean bl = false;
                return new DecodedValue<T>((String)it, clazz, clazz.cast(it), name);
            }
            throw new IllegalArgumentException("Error decoding string at offset: " + startPosition);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return String.class;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016JT\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\u0014"}, d2={"org/vechain/indexer/event/types/Types.TUPLE", "Lorg/vechain/indexer/event/types/Types;", "isType", "", "typeName", "", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "indexer-core"})
    @SourceDebugExtension(value={"SMAP\nTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Types.kt\norg/vechain/indexer/event/types/Types$TUPLE\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,377:1\n1310#2,2:378\n*S KotlinDebug\n*F\n+ 1 Types.kt\norg/vechain/indexer/event/types/Types$TUPLE\n*L\n177#1:378,2\n*E\n"})
    static final class TUPLE
    extends Types {
        /*
         * WARNING - void declaration
         */
        TUPLE() {
            void var1_1;
        }

        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return Intrinsics.areEqual((Object)typeName, (Object)"tuple");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            String string;
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (components == null) {
                throw new IllegalArgumentException("Components must be provided for tuple types");
            }
            String string2 = fullData;
            if (string2 == null) {
                string2 = encoded;
            }
            String inputData = DataUtils.INSTANCE.removePrefix(string2);
            Map decodedComponents = new LinkedHashMap();
            boolean isDynamicTuple = this.isTupleDynamic(components);
            if (isDynamicTuple) {
                String string3 = inputData.substring(startPosition, startPosition + 64);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String offsetHex = string3;
                int offset = DataUtils.INSTANCE.decodeQuantity("0x" + offsetHex).intValue() * 2;
                String string4 = inputData.substring(offset);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            } else {
                String string5 = inputData.substring(startPosition);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            }
            String tupleData = string;
            int currentOffset = 0;
            for (InputOutput component : components) {
                String componentData;
                Types types;
                Object object;
                int startPos;
                block8: {
                    Types types2;
                    void $this$firstOrNull$iv;
                    if (inputData.length() < currentOffset + 64) {
                        throw new IllegalArgumentException("Data too short for tuple component at offset " + currentOffset);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)tupleData.substring(currentOffset, currentOffset + 64), (String)"substring(...)");
                    startPos = currentOffset;
                    object = Types.values();
                    boolean $i$f$firstOrNull = false;
                    int n = ((void)$this$firstOrNull$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!it.isType(component.getType())) continue;
                        types2 = element$iv;
                        break block8;
                    }
                    types2 = types = null;
                }
                if (types == null || (object = types.decode(DataUtils.INSTANCE.addPrefix(componentData), Object.class, component.getType(), tupleData, startPos, component.getComponents())) == null) {
                    throw new IllegalArgumentException("Unsupported type in tuple: " + component.getType());
                }
                Object decodedComponent = object;
                decodedComponents.put(component.getName(), ((DecodedValue)decodedComponent).getActualValue());
                currentOffset += 64;
            }
            return new DecodedValue<T>(decodedComponents.toString(), clazz, clazz.cast(decodedComponents), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return List.class;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00009\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016JT\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0016J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\u0014"}, d2={"org/vechain/indexer/event/types/Types.UINT", "Lorg/vechain/indexer/event/types/Types;", "isType", "", "typeName", "", "decode", "Lorg/vechain/indexer/event/types/DecodedValue;", "T", "encoded", "clazz", "Ljava/lang/Class;", "name", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "getClaas", "indexer-core"})
    static final class UINT
    extends Types {
        /*
         * WARNING - void declaration
         */
        UINT() {
            void var1_1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isType(@NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            if (!StringsKt.startsWith$default((String)typeName, (String)"uint", (boolean)false, (int)2, null)) return false;
            if (Intrinsics.areEqual((Object)typeName, (Object)"uint")) return true;
            IntRange intRange = new IntRange(8, 256);
            Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)typeName, (CharSequence)"uint"));
            if (n == null) return false;
            if (!intRange.contains(n.intValue())) return false;
            return true;
        }

        @Override
        @NotNull
        public <T> DecodedValue<T> decode(@NotNull String encoded, @NotNull Class<T> clazz, @NotNull String name, @Nullable String fullData, int startPosition, @Nullable List<InputOutput> components) {
            Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            BigInteger decoded = DataUtils.INSTANCE.decodeQuantity(encoded);
            String string = decoded.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new DecodedValue<T>(string, clazz, clazz.cast(decoded), name);
        }

        @Override
        @NotNull
        public Class<?> getClaas() {
            return BigInteger.class;
        }
    }
}

