/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vechain.indexer.ChannelIndexer;
import org.vechain.indexer.Indexer;
import org.vechain.indexer.IndexerProcessor;
import org.vechain.indexer.LogsIndexer;
import org.vechain.indexer.Pruner;
import org.vechain.indexer.event.CombinedEventProcessor;
import org.vechain.indexer.thor.client.DefaultThorClient;
import org.vechain.indexer.thor.client.ThorClient;
import org.vechain.indexer.thor.model.EventCriteria;
import org.vechain.indexer.thor.model.TransferCriteria;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010%\u001a\u00020&J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J?\u0010\u0006\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00052*\u0010(\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010*0)\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010*\u00a2\u0006\u0002\u0010+J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0005J\u0014\u0010\r\u001a\u00020\u00002\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eJ\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eJ\u0016\u0010/\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0014\u0010\u0014\u001a\u00020\u00002\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eJ\u0014\u0010\u0015\u001a\u00020\u00002\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eJ\u001a\u00101\u001a\u00020\u00002\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0017J\u0006\u00102\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u000bJ\u0014\u0010\u001e\u001a\u00020\u00002\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000eJ\u0014\u0010 \u001a\u00020\u00002\f\u00104\u001a\b\u0012\u0004\u0012\u00020!0\u000eJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020\u00002\u0006\u00105\u001a\u00020$J\u0006\u0010\"\u001a\u00020\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/vechain/indexer/IndexerFactory;", "", "<init>", "()V", "name", "", "thorClient", "Lorg/vechain/indexer/thor/client/ThorClient;", "processor", "Lorg/vechain/indexer/IndexerProcessor;", "startBlock", "", "abiBasePath", "abiEventNames", "", "abiContracts", "includeVetTransfers", "", "businessEventBasePath", "businessEventAbiBasePath", "businessEventNames", "businessEventContracts", "substitutionParams", "", "syncLoggerInterval", "blockBatchSize", "logFetchLimit", "pruner", "Lorg/vechain/indexer/Pruner;", "prunerInterval", "eventCriteriaSet", "Lorg/vechain/indexer/thor/model/EventCriteria;", "transferCriteriaSet", "Lorg/vechain/indexer/thor/model/TransferCriteria;", "includeFullBlock", "channelBatchSize", "", "build", "Lorg/vechain/indexer/Indexer;", "baseUrl", "headers", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Lorg/vechain/indexer/IndexerFactory;", "abis", "basePath", "eventNames", "businessEvents", "contracts", "businessEventSubstitutionParams", "excludeVetTransfers", "interval", "criteria", "size", "limit", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nIndexerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexerFactory.kt\norg/vechain/indexer/IndexerFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,314:1\n1#2:315\n*E\n"})
public final class IndexerFactory {
    @Nullable
    private String name;
    @Nullable
    private ThorClient thorClient;
    @Nullable
    private IndexerProcessor processor;
    private long startBlock;
    @Nullable
    private String abiBasePath;
    @NotNull
    private List<String> abiEventNames = CollectionsKt.emptyList();
    @NotNull
    private List<String> abiContracts = CollectionsKt.emptyList();
    private boolean includeVetTransfers = true;
    @Nullable
    private String businessEventBasePath;
    @Nullable
    private String businessEventAbiBasePath;
    @NotNull
    private List<String> businessEventNames = CollectionsKt.emptyList();
    @NotNull
    private List<String> businessEventContracts = CollectionsKt.emptyList();
    @NotNull
    private Map<String, String> substitutionParams = MapsKt.emptyMap();
    private long syncLoggerInterval = 1000L;
    private long blockBatchSize = 100L;
    private long logFetchLimit = 1000L;
    @Nullable
    private Pruner pruner;
    private long prunerInterval = 10000L;
    @Nullable
    private List<EventCriteria> eventCriteriaSet;
    @Nullable
    private List<TransferCriteria> transferCriteriaSet;
    private boolean includeFullBlock;
    private int channelBatchSize = 2;

    @NotNull
    public final Indexer build() {
        Indexer indexer;
        if (this.name == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.thorClient == null) {
            boolean $i$a$-requireNotNull-IndexerFactory$build$32 = false;
            String $i$a$-requireNotNull-IndexerFactory$build$32 = "Thor client must be set using thorClient() method.";
            throw new IllegalArgumentException($i$a$-requireNotNull-IndexerFactory$build$32.toString());
        }
        if (this.processor == null) {
            boolean bl = false;
            String string = "Processor must be set using processor() method.";
            throw new IllegalArgumentException(string.toString());
        }
        CombinedEventProcessor eventProcessor = CombinedEventProcessor.Companion.create(this.abiBasePath, this.abiEventNames, this.abiContracts, this.includeVetTransfers, this.businessEventBasePath, this.businessEventAbiBasePath, this.businessEventNames, this.businessEventContracts, this.substitutionParams);
        if (this.includeFullBlock) {
            String string = this.name;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            ThorClient thorClient = this.thorClient;
            Intrinsics.checkNotNull((Object)thorClient);
            ThorClient thorClient2 = thorClient;
            IndexerProcessor indexerProcessor = this.processor;
            Intrinsics.checkNotNull((Object)indexerProcessor);
            IndexerProcessor indexerProcessor2 = indexerProcessor;
            long l = this.startBlock;
            long l2 = this.syncLoggerInterval;
            Pruner pruner = this.pruner;
            long l3 = this.prunerInterval;
            int n = this.channelBatchSize;
            indexer = new ChannelIndexer(string2, thorClient2, indexerProcessor2, l, l2, eventProcessor, pruner, l3, n);
        } else {
            List list;
            String string = this.name;
            Intrinsics.checkNotNull((Object)string);
            ThorClient thorClient = this.thorClient;
            Intrinsics.checkNotNull((Object)thorClient);
            IndexerProcessor indexerProcessor = this.processor;
            Intrinsics.checkNotNull((Object)indexerProcessor);
            boolean bl = !this.includeVetTransfers;
            List list2 = this.eventCriteriaSet;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            if ((list = this.transferCriteriaSet) == null) {
                list = CollectionsKt.emptyList();
            }
            indexer = new LogsIndexer(string, thorClient, indexerProcessor, this.startBlock, this.syncLoggerInterval, bl, this.blockBatchSize, this.logFetchLimit, list2, list, eventProcessor, this.pruner, this.prunerInterval);
        }
        return indexer;
    }

    @NotNull
    public final IndexerFactory name(@NotNull String name) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IndexerFactory $this$name_u24lambda_u242 = indexerFactory = this;
        boolean bl = false;
        $this$name_u24lambda_u242.name = name;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory thorClient(@NotNull String baseUrl, Pair<String, ? extends Object> ... headers) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        IndexerFactory $this$thorClient_u24lambda_u243 = indexerFactory = this;
        boolean bl = false;
        $this$thorClient_u24lambda_u243.thorClient = new DefaultThorClient(baseUrl, Arrays.copyOf(headers, headers.length));
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory thorClient(@NotNull ThorClient thorClient) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter((Object)thorClient, (String)"thorClient");
        IndexerFactory $this$thorClient_u24lambda_u244 = indexerFactory = this;
        boolean bl = false;
        $this$thorClient_u24lambda_u244.thorClient = thorClient;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory processor(@NotNull IndexerProcessor processor) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        IndexerFactory $this$processor_u24lambda_u245 = indexerFactory = this;
        boolean bl = false;
        $this$processor_u24lambda_u245.processor = processor;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory startBlock(long startBlock) {
        IndexerFactory indexerFactory;
        IndexerFactory $this$startBlock_u24lambda_u246 = indexerFactory = this;
        boolean bl = false;
        $this$startBlock_u24lambda_u246.startBlock = startBlock;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory abis(@NotNull String basePath) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        IndexerFactory $this$abis_u24lambda_u247 = indexerFactory = this;
        boolean bl = false;
        $this$abis_u24lambda_u247.abiBasePath = basePath;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory abiEventNames(@NotNull List<String> eventNames) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter(eventNames, (String)"eventNames");
        IndexerFactory $this$abiEventNames_u24lambda_u248 = indexerFactory = this;
        boolean bl = false;
        $this$abiEventNames_u24lambda_u248.abiEventNames = eventNames;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory abiContracts(@NotNull List<String> abiContracts) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter(abiContracts, (String)"abiContracts");
        IndexerFactory $this$abiContracts_u24lambda_u249 = indexerFactory = this;
        boolean bl = false;
        $this$abiContracts_u24lambda_u249.abiContracts = abiContracts;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory businessEvents(@NotNull String basePath, @NotNull String abiBasePath) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)abiBasePath, (String)"abiBasePath");
        IndexerFactory $this$businessEvents_u24lambda_u2410 = indexerFactory = this;
        boolean bl = false;
        $this$businessEvents_u24lambda_u2410.businessEventBasePath = basePath;
        $this$businessEvents_u24lambda_u2410.businessEventAbiBasePath = abiBasePath;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory businessEventNames(@NotNull List<String> eventNames) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter(eventNames, (String)"eventNames");
        IndexerFactory $this$businessEventNames_u24lambda_u2411 = indexerFactory = this;
        boolean bl = false;
        $this$businessEventNames_u24lambda_u2411.businessEventNames = eventNames;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory businessEventContracts(@NotNull List<String> contracts) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter(contracts, (String)"contracts");
        IndexerFactory $this$businessEventContracts_u24lambda_u2412 = indexerFactory = this;
        boolean bl = false;
        $this$businessEventContracts_u24lambda_u2412.businessEventContracts = contracts;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory businessEventSubstitutionParams(@NotNull Map<String, String> substitutionParams) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter(substitutionParams, (String)"substitutionParams");
        IndexerFactory $this$businessEventSubstitutionParams_u24lambda_u2413 = indexerFactory = this;
        boolean bl = false;
        $this$businessEventSubstitutionParams_u24lambda_u2413.substitutionParams = substitutionParams;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory excludeVetTransfers() {
        IndexerFactory indexerFactory;
        IndexerFactory $this$excludeVetTransfers_u24lambda_u2414 = indexerFactory = this;
        boolean bl = false;
        $this$excludeVetTransfers_u24lambda_u2414.includeVetTransfers = false;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory pruner(@NotNull Pruner pruner) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter((Object)pruner, (String)"pruner");
        IndexerFactory $this$pruner_u24lambda_u2415 = indexerFactory = this;
        boolean bl = false;
        $this$pruner_u24lambda_u2415.pruner = pruner;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory prunerInterval(long interval) {
        IndexerFactory indexerFactory;
        IndexerFactory $this$prunerInterval_u24lambda_u2416 = indexerFactory = this;
        boolean bl = false;
        $this$prunerInterval_u24lambda_u2416.prunerInterval = interval;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory eventCriteriaSet(@NotNull List<EventCriteria> criteria) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
        IndexerFactory $this$eventCriteriaSet_u24lambda_u2417 = indexerFactory = this;
        boolean bl = false;
        $this$eventCriteriaSet_u24lambda_u2417.eventCriteriaSet = criteria;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory transferCriteriaSet(@NotNull List<TransferCriteria> criteria) {
        IndexerFactory indexerFactory;
        Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
        IndexerFactory $this$transferCriteriaSet_u24lambda_u2418 = indexerFactory = this;
        boolean bl = false;
        $this$transferCriteriaSet_u24lambda_u2418.transferCriteriaSet = criteria;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory syncLoggerInterval(long interval) {
        IndexerFactory indexerFactory;
        IndexerFactory $this$syncLoggerInterval_u24lambda_u2419 = indexerFactory = this;
        boolean bl = false;
        $this$syncLoggerInterval_u24lambda_u2419.syncLoggerInterval = interval;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory blockBatchSize(long size) {
        IndexerFactory indexerFactory;
        IndexerFactory $this$blockBatchSize_u24lambda_u2420 = indexerFactory = this;
        boolean bl = false;
        $this$blockBatchSize_u24lambda_u2420.blockBatchSize = size;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory logFetchLimit(long limit) {
        IndexerFactory indexerFactory;
        IndexerFactory $this$logFetchLimit_u24lambda_u2421 = indexerFactory = this;
        boolean bl = false;
        $this$logFetchLimit_u24lambda_u2421.logFetchLimit = limit;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory channelBatchSize(int size) {
        IndexerFactory indexerFactory;
        IndexerFactory $this$channelBatchSize_u24lambda_u2422 = indexerFactory = this;
        boolean bl = false;
        $this$channelBatchSize_u24lambda_u2422.channelBatchSize = size;
        return indexerFactory;
    }

    @NotNull
    public final IndexerFactory includeFullBlock() {
        IndexerFactory indexerFactory;
        IndexerFactory $this$includeFullBlock_u24lambda_u2423 = indexerFactory = this;
        boolean bl = false;
        $this$includeFullBlock_u24lambda_u2423.includeFullBlock = true;
        return indexerFactory;
    }
}

