/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.AbiEventProcessor;
import org.vechain.indexer.event.BusinessEventLoader;
import org.vechain.indexer.event.EventProcessor;
import org.vechain.indexer.event.model.business.BusinessEventDefinition;
import org.vechain.indexer.event.model.generic.AbiEventParameters;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.event.utils.BusinessEventUtils;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.EventLog;
import org.vechain.indexer.thor.model.TransferLog;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0006H\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006H\u0002J*\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010 \u001a\u00020\u000fH\u0002J$\u0010!\u001a\u00020\u00132\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010 \u001a\u00020\u000fH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/vechain/indexer/event/BusinessEventProcessor;", "Lorg/vechain/indexer/event/EventProcessor;", "businessEventBasePath", "", "abiBasePath", "businessEventNames", "", "businessEventContracts", "substitutionParams", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "logger", "Lorg/slf4j/Logger;", "businessEvents", "Lorg/vechain/indexer/event/model/business/BusinessEventDefinition;", "abiEventProcessor", "Lorg/vechain/indexer/event/AbiEventProcessor;", "processEvents", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "block", "Lorg/vechain/indexer/thor/model/Block;", "eventLogs", "Lorg/vechain/indexer/thor/model/EventLog;", "transferLogs", "Lorg/vechain/indexer/thor/model/TransferLog;", "processBusinessEvents", "events", "processTransactionForBusinessEvents", "txEvents", "checkAllCombinations", "group", "definition", "createBusinessEvent", "eventsForAlias", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nBusinessEventProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BusinessEventProcessor.kt\norg/vechain/indexer/event/BusinessEventProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,176:1\n1491#2:177\n1516#2,3:178\n1519#2,3:188\n1491#2:194\n1516#2,3:195\n1519#2,3:205\n1491#2:217\n1516#2,3:218\n1519#2,3:228\n1563#2:231\n1634#2,3:232\n384#3,7:181\n384#3,7:198\n384#3,7:221\n77#4:191\n97#4,2:192\n77#4:208\n97#4,5:209\n99#4,3:214\n*S KotlinDebug\n*F\n+ 1 BusinessEventProcessor.kt\norg/vechain/indexer/event/BusinessEventProcessor\n*L\n65#1:177\n65#1:178,3\n65#1:188,3\n68#1:194\n68#1:195,3\n68#1:205,3\n86#1:217\n86#1:218,3\n86#1:228,3\n112#1:231\n112#1:232,3\n65#1:181,7\n68#1:198,7\n86#1:221,7\n66#1:191\n66#1:192,2\n69#1:208\n69#1:209,5\n66#1:214,3\n*E\n"})
public class BusinessEventProcessor
implements EventProcessor {
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<BusinessEventDefinition> businessEvents;
    @NotNull
    private final AbiEventProcessor abiEventProcessor;

    public BusinessEventProcessor(@NotNull String businessEventBasePath, @NotNull String abiBasePath, @NotNull List<String> businessEventNames, @NotNull List<String> businessEventContracts, @NotNull Map<String, String> substitutionParams) {
        Intrinsics.checkNotNullParameter((Object)businessEventBasePath, (String)"businessEventBasePath");
        Intrinsics.checkNotNullParameter((Object)abiBasePath, (String)"abiBasePath");
        Intrinsics.checkNotNullParameter(businessEventNames, (String)"businessEventNames");
        Intrinsics.checkNotNullParameter(businessEventContracts, (String)"businessEventContracts");
        Intrinsics.checkNotNullParameter(substitutionParams, (String)"substitutionParams");
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.businessEvents = BusinessEventLoader.INSTANCE.loadBusinessEvents(businessEventBasePath, businessEventNames, substitutionParams);
        this.abiEventProcessor = new AbiEventProcessor(abiBasePath, BusinessEventUtils.INSTANCE.extractAbiEventNames(this.businessEvents), businessEventContracts, BusinessEventUtils.INSTANCE.containsVetTransferEvent(this.businessEvents));
    }

    @Override
    @NotNull
    public List<IndexedEvent> processEvents(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        List<IndexedEvent> events = this.abiEventProcessor.processEvents(block);
        return this.processBusinessEvents(events);
    }

    @Override
    @NotNull
    public List<IndexedEvent> processEvents(@NotNull List<EventLog> eventLogs, @NotNull List<TransferLog> transferLogs) {
        Intrinsics.checkNotNullParameter(eventLogs, (String)"eventLogs");
        Intrinsics.checkNotNullParameter(transferLogs, (String)"transferLogs");
        List<IndexedEvent> events = this.abiEventProcessor.processEvents(eventLogs, transferLogs);
        return this.processBusinessEvents(events);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexedEvent> processBusinessEvents(List<IndexedEvent> events) {
        void $this$flatMapTo$iv$iv;
        Object list$iv$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        boolean bl;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = events;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object t = iterator.next();
            IndexedEvent it = (IndexedEvent)t;
            bl = false;
            Long key$iv$iv = it.getBlockNumber();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Map $this$flatMap$iv = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Map.Entry entry : $this$flatMapTo$iv$iv.entrySet()) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            Object list$iv$iv2;
            void $this$groupByTo$iv$iv2;
            Map $this$groupBy$iv2;
            list$iv$iv = entry;
            bl = false;
            List blockEvents = (List)list$iv$iv.getValue();
            $this$getOrPut$iv$iv$iv = blockEvents;
            boolean $i$f$groupBy2 = false;
            value$iv$iv$iv = $this$groupBy$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object t : $this$groupByTo$iv$iv2) {
                Object object;
                IndexedEvent it = (IndexedEvent)t;
                boolean bl3 = false;
                String key$iv$iv = it.getTxId();
                Map $this$getOrPut$iv$iv$iv2 = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv2 == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv2;
                }
                list$iv$iv2 = (List)object;
                list$iv$iv2.add(t);
            }
            $this$groupBy$iv2 = destination$iv$iv2;
            boolean $i$f$flatMap2 = false;
            $this$groupByTo$iv$iv2 = $this$flatMap$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Map.Entry entry2 : $this$flatMapTo$iv$iv2.entrySet()) {
                list$iv$iv2 = entry2;
                boolean bl5 = false;
                List transactionEvents = (List)list$iv$iv2.getValue();
                Iterable list$iv$iv3 = this.processTransactionForBusinessEvents(transactionEvents);
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv3);
            }
            list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexedEvent> processTransactionForBusinessEvents(List<IndexedEvent> txEvents) {
        List remainingEvents = CollectionsKt.toMutableList((Collection)txEvents);
        List matchedBusinessEvents = new ArrayList();
        for (BusinessEventDefinition definition : this.businessEvents) {
            Map map;
            Object key$iv$iv;
            if (remainingEvents.isEmpty()) break;
            if (Intrinsics.areEqual((Object)definition.getSameClause(), (Object)true)) {
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = remainingEvents;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    IndexedEvent it = (IndexedEvent)element$iv$iv;
                    boolean bl = false;
                    key$iv$iv = (int)it.getClauseIndex();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                map = destination$iv$iv;
            } else {
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)0, (Object)remainingEvents));
            }
            Map groupedEvents = map;
            Iterator iterator = groupedEvents.entrySet().iterator();
            while (iterator.hasNext()) {
                List group = (List)iterator.next().getValue();
                if (group.isEmpty()) continue;
                List localGroup = CollectionsKt.toMutableList((Collection)group);
                boolean foundMatch = false;
                do {
                    void $this$mapTo$iv$iv;
                    foundMatch = false;
                    Map<String, IndexedEvent> eventsForAlias = Intrinsics.areEqual((Object)definition.getCheckAllCombinations(), (Object)true) ? this.checkAllCombinations(localGroup, definition) : BusinessEventUtils.INSTANCE.mapEventsToAliases(localGroup, definition.getEvents());
                    if (!(!eventsForAlias.isEmpty()) || !BusinessEventUtils.INSTANCE.validateRules(definition.getRules(), eventsForAlias)) continue;
                    Iterable $this$map$iv = eventsForAlias.values();
                    boolean $i$f$map = false;
                    key$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IndexedEvent indexedEvent = (IndexedEvent)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getId());
                    }
                    Set matchedEventIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    localGroup.removeIf(arg_0 -> BusinessEventProcessor.processTransactionForBusinessEvents$lambda$7(arg_0 -> BusinessEventProcessor.processTransactionForBusinessEvents$lambda$6(matchedEventIds, arg_0), arg_0));
                    remainingEvents.removeIf(arg_0 -> BusinessEventProcessor.processTransactionForBusinessEvents$lambda$9(arg_0 -> BusinessEventProcessor.processTransactionForBusinessEvents$lambda$8(matchedEventIds, arg_0), arg_0));
                    matchedBusinessEvents.add(this.createBusinessEvent(eventsForAlias, definition));
                    foundMatch = true;
                } while (foundMatch && !((Collection)localGroup).isEmpty());
            }
        }
        return matchedBusinessEvents;
    }

    private final Map<String, IndexedEvent> checkAllCombinations(List<IndexedEvent> group, BusinessEventDefinition definition) {
        Integer n = definition.getMaxAttempts();
        List<Map<String, IndexedEvent>> eventCombinations = BusinessEventUtils.INSTANCE.generateAllValidCombinations(group, definition.getEvents(), n != null ? n : 10);
        for (Map<String, IndexedEvent> eventsForAlias : eventCombinations) {
            if (!(!eventsForAlias.isEmpty()) || !BusinessEventUtils.INSTANCE.validateRules(definition.getRules(), eventsForAlias)) continue;
            return eventsForAlias;
        }
        return MapsKt.emptyMap();
    }

    private final IndexedEvent createBusinessEvent(Map<String, IndexedEvent> eventsForAlias, BusinessEventDefinition definition) {
        Map<String, Object> params = BusinessEventUtils.INSTANCE.extractParams(definition.getParamsDefinition(), eventsForAlias);
        IndexedEvent firstEvent = (IndexedEvent)CollectionsKt.first((Iterable)eventsForAlias.values());
        return new IndexedEvent(firstEvent.getId(), firstEvent.getBlockId(), firstEvent.getBlockNumber(), firstEvent.getBlockTimestamp(), firstEvent.getTxId(), firstEvent.getOrigin(), firstEvent.getPaid(), firstEvent.getGasUsed(), firstEvent.getGasPayer(), null, new AbiEventParameters(params, definition.getName()), null, definition.getName(), firstEvent.getClauseIndex(), null, 18944, null);
    }

    private static final boolean processTransactionForBusinessEvents$lambda$6(Set $matchedEventIds, IndexedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $matchedEventIds.contains(it.getId());
    }

    private static final boolean processTransactionForBusinessEvents$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processTransactionForBusinessEvents$lambda$8(Set $matchedEventIds, IndexedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $matchedEventIds.contains(it.getId());
    }

    private static final boolean processTransactionForBusinessEvents$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

