/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.vechain.indexer.event.model.business.BusinessEventDefinition;
import org.vechain.indexer.event.model.business.Condition;
import org.vechain.indexer.event.model.business.Event;
import org.vechain.indexer.event.model.business.ParamDefinition;
import org.vechain.indexer.event.model.business.Rule;
import org.vechain.indexer.event.model.enums.Operator;
import org.vechain.indexer.event.model.generic.AbiEventParameters;
import org.vechain.indexer.event.model.generic.IndexedEvent;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\tJ>\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\b\b\u0002\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J4\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tJ\u0014\u0010\u0019\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tJ\u001e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\tH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u001c\u0010!\u001a\u0004\u0018\u00010\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001f\u001a\u00020\u0006H\u0002\u00a8\u0006\""}, d2={"Lorg/vechain/indexer/event/utils/BusinessEventUtils;", "", "<init>", "()V", "mapEventsToAliases", "", "", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "events", "", "eventDefinitions", "Lorg/vechain/indexer/event/model/business/Event;", "generateAllValidCombinations", "maxAttempts", "", "validateRules", "", "rules", "Lorg/vechain/indexer/event/model/business/Rule;", "extractParams", "paramsDefinition", "Lorg/vechain/indexer/event/model/business/ParamDefinition;", "extractAbiEventNames", "businessEvents", "Lorg/vechain/indexer/event/model/business/BusinessEventDefinition;", "containsVetTransferEvent", "validateConditions", "event", "conditions", "Lorg/vechain/indexer/event/model/business/Condition;", "resolveOperandValue", "operand", "isStatic", "getEventValue", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nBusinessEventUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BusinessEventUtils.kt\norg/vechain/indexer/event/utils/BusinessEventUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n295#2,2:160\n1740#2,3:162\n1193#2,2:165\n1267#2,4:167\n1374#2:171\n1460#2,2:172\n1563#2:174\n1634#2,3:175\n1462#2,3:178\n774#2:181\n865#2,2:182\n1374#2:184\n1460#2,5:185\n1761#2,3:190\n1740#2,3:193\n*S KotlinDebug\n*F\n+ 1 BusinessEventUtils.kt\norg/vechain/indexer/event/utils/BusinessEventUtils\n*L\n19#1:160,2\n90#1:162,3\n107#1:165,2\n107#1:167,4\n114#1:171\n114#1:172,2\n114#1:174\n114#1:175,3\n114#1:178,3\n116#1:181\n116#1:182,2\n122#1:184\n122#1:185,5\n123#1:190,3\n130#1:193,3\n*E\n"})
public final class BusinessEventUtils {
    @NotNull
    public static final BusinessEventUtils INSTANCE = new BusinessEventUtils();

    private BusinessEventUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, IndexedEvent> mapEventsToAliases(@NotNull List<IndexedEvent> events, @NotNull List<Event> eventDefinitions) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(eventDefinitions, (String)"eventDefinitions");
        Set assignedEvents = new LinkedHashSet();
        Map mappedEvents = new LinkedHashMap();
        for (Event eventDefinition : eventDefinitions) {
            IndexedEvent indexedEvent;
            Object v0;
            block3: {
                void $this$firstOrNull$iv;
                Iterable iterable = events;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IndexedEvent it = (IndexedEvent)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getParams().getEventType(), (Object)eventDefinition.getName()) && INSTANCE.validateConditions(it, eventDefinition.getConditions()) && !assignedEvents.contains(it))) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((indexedEvent = (IndexedEvent)v0) == null) continue;
            IndexedEvent it = indexedEvent;
            boolean bl = false;
            mappedEvents.put(eventDefinition.getAlias(), it);
            assignedEvents.add(it);
        }
        if (mappedEvents.size() != eventDefinitions.size()) {
            return MapsKt.emptyMap();
        }
        return mappedEvents;
    }

    @NotNull
    public final List<Map<String, IndexedEvent>> generateAllValidCombinations(@NotNull List<IndexedEvent> events, @NotNull List<Event> eventDefinitions, int maxAttempts) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(eventDefinitions, (String)"eventDefinitions");
        List validCombinations = new ArrayList();
        Ref.IntRef attempts = new Ref.IntRef();
        BusinessEventUtils.generateAllValidCombinations$backtrack(attempts, maxAttempts, eventDefinitions, validCombinations, events, 0, 0, new boolean[events.size()], new LinkedHashMap());
        return validCombinations;
    }

    public static /* synthetic */ List generateAllValidCombinations$default(BusinessEventUtils businessEventUtils, List list, List list2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 10;
        }
        return businessEventUtils.generateAllValidCombinations(list, list2, n);
    }

    public final boolean validateRules(@NotNull List<Rule> rules, @NotNull Map<String, IndexedEvent> events) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$all$iv = rules;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Rule rule = (Rule)element$iv;
                    boolean bl2 = false;
                    Object object = INSTANCE.getEventValue(events.get(rule.getFirstEventName()), rule.getFirstEventProperty());
                    String firstValue = object != null ? object.toString() : null;
                    Object object2 = INSTANCE.getEventValue(events.get(rule.getSecondEventName()), rule.getSecondEventProperty());
                    String secondValue = object2 != null ? object2.toString() : null;
                    if (firstValue != null && secondValue != null && rule.getOperator().evaluate(firstValue, secondValue)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> extractParams(@NotNull List<ParamDefinition> paramsDefinition, @NotNull Map<String, IndexedEvent> events) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(paramsDefinition, (String)"paramsDefinition");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$associate$iv = paramsDefinition;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ParamDefinition param = (ParamDefinition)element$iv$iv;
            boolean bl = false;
            Object object = INSTANCE.getEventValue(events.get(param.getEventName()), param.getName());
            if (object == null) {
                object = "";
            }
            Object value = object;
            Pair pair = TuplesKt.to((Object)param.getBusinessEventName(), (Object)value);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> extractAbiEventNames(@NotNull List<BusinessEventDefinition> businessEvents) {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(businessEvents, (String)"businessEvents");
        Iterable $this$flatMap$iv = businessEvents;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            it = (BusinessEventDefinition)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = ((BusinessEventDefinition)it).getEvents();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void e;
                Event event = (Event)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(e.getName());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)it).length() > 0 && !StringsKt.equals((String)it, (String)"VET_TRANSFER", (boolean)false))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsVetTransferEvent(@NotNull List<BusinessEventDefinition> businessEvents) {
        boolean bl;
        block4: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(businessEvents, (String)"businessEvents");
            Iterable $this$flatMap$iv = businessEvents;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BusinessEventDefinition it = (BusinessEventDefinition)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it.getEvents();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Event e = (Event)element$iv;
                    boolean bl3 = false;
                    if (!StringsKt.equals((String)e.getName(), (String)"VET_TRANSFER", (boolean)false)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean validateConditions(IndexedEvent event, List<Condition> conditions) {
        boolean bl;
        block5: {
            Iterable $this$all$iv = conditions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String string;
                    Condition condition = (Condition)element$iv;
                    boolean bl2 = false;
                    String firstValue = INSTANCE.resolveOperandValue(condition.getFirstOperand(), condition.isFirstStatic(), event);
                    String secondValue = INSTANCE.resolveOperandValue(condition.getSecondOperand(), condition.isSecondStatic(), event);
                    Operator operator = condition.getOperator();
                    String string2 = firstValue;
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string = secondValue) == null) {
                        string = "";
                    }
                    if (operator.evaluate(string2, string)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String resolveOperandValue(String operand, boolean isStatic, IndexedEvent event) {
        String string;
        if (isStatic) {
            String string2 = operand.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            return string;
        } else {
            Object object = this.getEventValue(event, operand);
            Object object2 = object;
            if (object == null) return null;
            String string3 = object2.toString();
            object2 = string3;
            if (string3 == null) return null;
            String string4 = ((String)object2).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            object2 = string4;
            if (string4 == null) return null;
            string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
        }
        return string;
    }

    private final Object getEventValue(IndexedEvent event, String operand) {
        Object object = event;
        if (object == null || (object = ((IndexedEvent)object).getParams()) == null || (object = ((AbiEventParameters)object).getReturnValues()) == null || (object = object.get(operand)) == null) {
            IndexedEvent indexedEvent = event;
            object = indexedEvent != null ? indexedEvent.get(operand) : null;
        }
        return object;
    }

    private static final void generateAllValidCombinations$backtrack(Ref.IntRef attempts, int $maxAttempts, List<Event> $eventDefinitions, List<Map<String, IndexedEvent>> validCombinations, List<IndexedEvent> $events, int eventIndex, int aliasIndex, boolean[] used, Map<String, IndexedEvent> aliasMap) {
        if (attempts.element >= $maxAttempts) {
            return;
        }
        int n = attempts.element;
        attempts.element = n + 1;
        if (aliasIndex == $eventDefinitions.size()) {
            validCombinations.add(MapsKt.toMap(aliasMap));
            return;
        }
        Event eventDefinition = $eventDefinitions.get(aliasIndex);
        int n2 = $events.size();
        for (int i = eventIndex; i < n2; ++i) {
            IndexedEvent event;
            if (used[i] || !Intrinsics.areEqual((Object)(event = $events.get(i)).getParams().getEventType(), (Object)eventDefinition.getName())) continue;
            used[i] = true;
            aliasMap.put(eventDefinition.getAlias(), event);
            BusinessEventUtils.generateAllValidCombinations$backtrack(attempts, $maxAttempts, $eventDefinitions, validCombinations, $events, 0, aliasIndex + 1, used, aliasMap);
            aliasMap.remove(eventDefinition.getAlias());
            used[i] = false;
        }
    }
}

