/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.model.abi.AbiElement;
import org.vechain.indexer.event.model.abi.InputOutput;
import org.vechain.indexer.event.model.generic.AbiEventParameters;
import org.vechain.indexer.event.types.DecodedValue;
import org.vechain.indexer.event.types.Types;
import org.vechain.indexer.thor.model.TxEvent;
import org.vechain.indexer.utils.DataUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ@\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J$\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016J*\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u0016J&\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/vechain/indexer/event/utils/EventUtils;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getEventSignature", "", "canonicalName", "decodeEvent", "Lorg/vechain/indexer/event/model/generic/AbiEventParameters;", "event", "Lorg/vechain/indexer/thor/model/TxEvent;", "abiElement", "Lorg/vechain/indexer/event/model/abi/AbiElement;", "decodeType", "hexValue", "solidityType", "fullData", "startPosition", "", "components", "", "Lorg/vechain/indexer/event/model/abi/InputOutput;", "extractDataSegment", "data", "index", "findMatchingAbi", "topics", "configuredEvents", "isEventValid", "", "contractAddresses", "generateEventId", "txId", "outputIndex", "eventIndex", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nEventUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventUtils.kt\norg/vechain/indexer/event/utils/EventUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,192:1\n1#2:193\n774#3:194\n865#3,2:195\n1252#3,4:206\n295#3:212\n1788#3,4:213\n296#3:217\n1761#3,3:218\n1761#3,3:221\n506#4,7:197\n465#4:204\n415#4:205\n1310#5,2:210\n*S KotlinDebug\n*F\n+ 1 EventUtils.kt\norg/vechain/indexer/event/utils/EventUtils\n*L\n47#1:194\n47#1:195,2\n87#1:206,4\n151#1:212\n152#1:213,4\n151#1:217\n165#1:218,3\n169#1:221,3\n87#1:197,7\n87#1:204\n87#1:205\n108#1:210,2\n*E\n"})
public final class EventUtils {
    @NotNull
    public static final EventUtils INSTANCE = new EventUtils();
    @NotNull
    private static final Logger logger;

    private EventUtils() {
    }

    @NotNull
    public final String getEventSignature(@NotNull String canonicalName) {
        Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
        if (!(!StringsKt.isBlank((CharSequence)canonicalName))) {
            boolean $i$a$-require-EventUtils$getEventSignature$22 = false;
            String $i$a$-require-EventUtils$getEventSignature$22 = "Canonical name must not be blank.";
            throw new IllegalArgumentException($i$a$-require-EventUtils$getEventSignature$22.toString());
        }
        Keccak.Digest256 keccak = new Keccak.Digest256();
        byte[] byArray = canonicalName.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hash = keccak.digest(byArray);
        Intrinsics.checkNotNull((Object)hash);
        return ArraysKt.joinToString$default((byte[])hash, (CharSequence)"", null, null, (int)0, null, EventUtils::getEventSignature$lambda$1, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AbiEventParameters decodeEvent(@NotNull TxEvent event, @NotNull AbiElement abiElement) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        boolean bl;
        InputOutput it;
        Iterator<InputOutput> $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)abiElement, (String)"abiElement");
        Map decodedParameters = new LinkedHashMap();
        List<InputOutput> inputs = abiElement.getInputs();
        Iterable $this$filter$iv = inputs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            it = (InputOutput)t;
            bl = false;
            if (!it.getIndexed()) continue;
            destination$iv$iv.add(t);
        }
        List indexedInputs = (List)destination$iv$iv;
        if (indexedInputs.size() + 1 != event.getTopics().size()) {
            throw new IllegalArgumentException("Mismatch between ABI indexed inputs and event topics");
        }
        int topicIndex = 1;
        int dataOffset = 0;
        for (InputOutput input : inputs) {
            Object segment;
            try {
                Object object;
                if (input.getIndexed()) {
                    object = EventUtils.decodeType$default(this, event.getTopics().get(topicIndex++), input.getType(), null, 0, null, 28, null);
                } else {
                    segment = this.extractDataSegment(event.getData(), dataOffset++);
                    object = this.decodeType((String)segment, input.getType(), event.getData(), (dataOffset - 1) * 64, input.getComponents());
                }
                segment = object;
            }
            catch (Exception exception) {
                logger.warn("Failed to decode '" + input.getName() + "' (" + input.getType() + "): " + exception.getMessage());
                segment = input.getIndexed() ? event.getTopics().get(topicIndex - 1) : "0x";
            }
            Object decodedValue = segment;
            decodedParameters.put(input.getName(), decodedValue);
        }
        Map $this$filterValues$iv = decodedParameters;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = entry.getValue();
            bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filterValues$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean bl2 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Object v;
            void it2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl3 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl22 = false;
            Intrinsics.checkNotNull(it2.getValue(), (String)"null cannot be cast to non-null type kotlin.Any");
            map2.put(k, v);
        }
        String string = abiElement.getName();
        if (string == null) {
            string = "Unknown";
        }
        String string2 = string;
        Map map = destination$iv$iv2;
        return new AbiEventParameters(map, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final Object decodeType(String hexValue, String solidityType, String fullData, int startPosition, List<InputOutput> components) {
        Object t;
        Types types;
        Object object;
        block2: {
            Types types2;
            void $this$firstOrNull$iv;
            object = Types.values();
            boolean $i$f$firstOrNull = false;
            int n = ((void)$this$firstOrNull$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!it.isType(solidityType)) continue;
                types2 = element$iv;
                break block2;
            }
            types2 = types = null;
        }
        if (types == null || (object = types.decode(hexValue, Object.class, solidityType, fullData, startPosition, components)) == null || (t = ((DecodedValue)object).getActualValue()) == null) {
            throw new IllegalArgumentException("Unsupported Solidity type: " + solidityType);
        }
        return t;
    }

    static /* synthetic */ Object decodeType$default(EventUtils eventUtils, String string, String string2, String string3, int n, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            list = null;
        }
        return eventUtils.decodeType(string, string2, string3, n, list);
    }

    private final String extractDataSegment(String data, int index) {
        int offset = index * 64;
        String cleanData = DataUtils.INSTANCE.removePrefix(data);
        if (offset + 64 > cleanData.length()) {
            throw new IllegalArgumentException("Data segment out of bounds for index " + index);
        }
        String string = cleanData.substring(offset, offset + 64);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return DataUtils.INSTANCE.addPrefix(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final AbiElement findMatchingAbi(@NotNull List<String> topics, @NotNull List<AbiElement> configuredEvents) {
        Object element$iv;
        Object v0;
        boolean bl;
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        Intrinsics.checkNotNullParameter(configuredEvents, (String)"configuredEvents");
        if (topics.isEmpty()) {
            return null;
        }
        String eventSignature = DataUtils.INSTANCE.removePrefix(topics.get(0));
        Iterable $this$firstOrNull$iv = configuredEvents;
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator.next();
            AbiElement abi = (AbiElement)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)abi.getSignature(), (Object)eventSignature)) {
                int n;
                Iterable $this$count$iv = abi.getInputs();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv2 : $this$count$iv) {
                        InputOutput it = (InputOutput)element$iv2;
                        boolean bl3 = false;
                        if (!it.getIndexed() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                if (n + 1 == topics.size()) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = element$iv;
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEventValid(@NotNull TxEvent event, @NotNull List<AbiElement> configuredEvents, @NotNull List<String> contractAddresses) {
        Object element$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(configuredEvents, (String)"configuredEvents");
        Intrinsics.checkNotNullParameter(contractAddresses, (String)"contractAddresses");
        if (event.getTopics().isEmpty()) {
            return false;
        }
        String eventSignature = DataUtils.INSTANCE.removePrefix(event.getTopics().get(0));
        Iterable $this$any$iv = configuredEvents;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (AbiElement)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)((AbiElement)it).getSignature(), (Object)eventSignature));
        boolean bl = true;
        boolean matchesAbi = bl;
        if (!matchesAbi) {
            return false;
        }
        if (contractAddresses.isEmpty()) return true;
        $this$any$iv = contractAddresses;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl2 = false;
        } while (!StringsKt.equals((String)it, (String)event.getAddress(), (boolean)true));
        return true;
    }

    @NotNull
    public final String generateEventId(@NotNull String txId, int outputIndex, int eventIndex, @NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int eventHash = event.hashCode();
        return txId + "-" + outputIndex + "-" + eventIndex + "-" + eventHash;
    }

    private static final CharSequence getEventSignature$lambda$1(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    static {
        Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        EventUtils.logger = logger;
    }
}

