/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.BlockIndexer;
import org.vechain.indexer.Indexer;
import org.vechain.indexer.IndexerProcessor;
import org.vechain.indexer.Pruner;
import org.vechain.indexer.Status;
import org.vechain.indexer.event.CombinedEventProcessor;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.exception.BlockNotFoundException;
import org.vechain.indexer.exception.ReorgException;
import org.vechain.indexer.thor.client.ThorClient;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.BlockIdentifier;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u00109\u001a\u00020:2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\tH\u0004\u00a2\u0006\u0002\u0010<J\u0010\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020?H\u0016J\u000e\u0010@\u001a\u00020:H\u0096@\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020:H\u0014J\u000e\u0010C\u001a\u00020:H\u0094@\u00a2\u0006\u0002\u0010AJ\u000e\u0010D\u001a\u00020:H\u0084@\u00a2\u0006\u0002\u0010AJ\b\u0010E\u001a\u00020:H\u0002J\r\u0010F\u001a\u00020:H\u0000\u00a2\u0006\u0002\bGJ\b\u0010H\u001a\u00020:H\u0002J\u0016\u0010I\u001a\u00020:2\u0006\u0010J\u001a\u00020KH\u0084@\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020:H\u0004J\u000e\u0010N\u001a\u00020:H\u0084@\u00a2\u0006\u0002\u0010AJ\u0010\u0010O\u001a\u00020:H\u0080@\u00a2\u0006\u0004\bP\u0010AJ\n\u0010Q\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010R\u001a\u00020:2\u0006\u0010;\u001a\u00020\tH\u0016J \u0010S\u001a\u00020:2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020V0U2\b\u0010J\u001a\u0004\u0018\u00010KH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R$\u0010.\u001a\u00020\t2\u0006\u0010-\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u00101R$\u00103\u001a\u0002022\u0006\u0010-\u001a\u000202@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lorg/vechain/indexer/BlockIndexer;", "Lorg/vechain/indexer/Indexer;", "name", "", "thorClient", "Lorg/vechain/indexer/thor/client/ThorClient;", "processor", "Lorg/vechain/indexer/IndexerProcessor;", "startBlock", "", "syncLoggerInterval", "eventProcessor", "Lorg/vechain/indexer/event/CombinedEventProcessor;", "pruner", "Lorg/vechain/indexer/Pruner;", "prunerInterval", "<init>", "(Ljava/lang/String;Lorg/vechain/indexer/thor/client/ThorClient;Lorg/vechain/indexer/IndexerProcessor;JJLorg/vechain/indexer/event/CombinedEventProcessor;Lorg/vechain/indexer/Pruner;J)V", "getName", "()Ljava/lang/String;", "getThorClient", "()Lorg/vechain/indexer/thor/client/ThorClient;", "getStartBlock", "()J", "getEventProcessor", "()Lorg/vechain/indexer/event/CombinedEventProcessor;", "getPruner", "()Lorg/vechain/indexer/Pruner;", "previousBlock", "Lorg/vechain/indexer/thor/model/BlockIdentifier;", "getPreviousBlock", "()Lorg/vechain/indexer/thor/model/BlockIdentifier;", "setPreviousBlock", "(Lorg/vechain/indexer/thor/model/BlockIdentifier;)V", "prunerIntervalOffset", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "status", "Lorg/vechain/indexer/Status;", "getStatus", "()Lorg/vechain/indexer/Status;", "setStatus", "(Lorg/vechain/indexer/Status;)V", "value", "currentBlockNumber", "getCurrentBlockNumber", "setCurrentBlockNumber", "(J)V", "Ljava/time/LocalDateTime;", "timeLastProcessed", "getTimeLastProcessed", "()Ljava/time/LocalDateTime;", "setTimeLastProcessed$indexer_core", "(Ljava/time/LocalDateTime;)V", "backoffPeriod", "initialise", "", "blockNumber", "(Ljava/lang/Long;)V", "startInCoroutine", "scope", "Lkotlinx/coroutines/CoroutineScope;", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restart", "run", "runOnce", "handleFullySynced", "handleError", "handleError$indexer_core", "handleReorg", "postProcessBlock", "block", "Lorg/vechain/indexer/thor/model/Block;", "(Lorg/vechain/indexer/thor/model/Block;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runPruner", "ensureFullySynced", "backoffDelay", "backoffDelay$indexer_core", "getLastSyncedBlock", "rollback", "process", "matchedEvents", "", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nBlockIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockIndexer.kt\norg/vechain/indexer/BlockIndexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
public class BlockIndexer
implements Indexer {
    @NotNull
    private final String name;
    @NotNull
    private final ThorClient thorClient;
    @NotNull
    private final IndexerProcessor processor;
    private final long startBlock;
    private final long syncLoggerInterval;
    @Nullable
    private final CombinedEventProcessor eventProcessor;
    @Nullable
    private final Pruner pruner;
    private final long prunerInterval;
    @Nullable
    private BlockIdentifier previousBlock;
    private final long prunerIntervalOffset;
    @NotNull
    private final Logger logger;
    @NotNull
    private Status status;
    private long currentBlockNumber;
    @NotNull
    private LocalDateTime timeLastProcessed;
    private long backoffPeriod;

    public BlockIndexer(@NotNull String name, @NotNull ThorClient thorClient, @NotNull IndexerProcessor processor, long startBlock, long syncLoggerInterval, @Nullable CombinedEventProcessor eventProcessor, @Nullable Pruner pruner, long prunerInterval) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)thorClient, (String)"thorClient");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.name = name;
        this.thorClient = thorClient;
        this.processor = processor;
        this.startBlock = startBlock;
        this.syncLoggerInterval = syncLoggerInterval;
        this.eventProcessor = eventProcessor;
        this.pruner = pruner;
        this.prunerInterval = prunerInterval;
        this.prunerIntervalOffset = RangesKt.random((LongRange)RangesKt.until((int)0, (long)this.prunerInterval), (Random)((Random)Random.Default));
        Logger logger = LoggerFactory.getLogger((String)this.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.status = Status.SYNCING;
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        this.timeLastProcessed = localDateTime;
    }

    public /* synthetic */ BlockIndexer(String string, ThorClient thorClient, IndexerProcessor indexerProcessor, long l, long l2, CombinedEventProcessor combinedEventProcessor, Pruner pruner, long l3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            l2 = 1000L;
        }
        if ((n & 0x20) != 0) {
            combinedEventProcessor = null;
        }
        if ((n & 0x40) != 0) {
            pruner = null;
        }
        if ((n & 0x80) != 0) {
            l3 = 10000L;
        }
        this(string, thorClient, indexerProcessor, l, l2, combinedEventProcessor, pruner, l3);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    protected ThorClient getThorClient() {
        return this.thorClient;
    }

    protected final long getStartBlock() {
        return this.startBlock;
    }

    @Nullable
    protected CombinedEventProcessor getEventProcessor() {
        return this.eventProcessor;
    }

    @Override
    @Nullable
    public Pruner getPruner() {
        return this.pruner;
    }

    @Nullable
    protected final BlockIdentifier getPreviousBlock() {
        return this.previousBlock;
    }

    protected final void setPreviousBlock(@Nullable BlockIdentifier blockIdentifier) {
        this.previousBlock = blockIdentifier;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"<set-?>");
        this.status = status;
    }

    public final long getCurrentBlockNumber() {
        return this.currentBlockNumber;
    }

    protected final void setCurrentBlockNumber(long l) {
        this.currentBlockNumber = l;
    }

    @NotNull
    public final LocalDateTime getTimeLastProcessed() {
        return this.timeLastProcessed;
    }

    public final void setTimeLastProcessed$indexer_core(@NotNull LocalDateTime localDateTime) {
        Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"<set-?>");
        this.timeLastProcessed = localDateTime;
    }

    protected final void initialise(@Nullable Long blockNumber) {
        BlockIdentifier lastBlock;
        long l;
        Long l2 = blockNumber;
        if (l2 != null) {
            l = l2;
        } else {
            BlockIdentifier blockIdentifier = this.getLastSyncedBlock();
            Long l3 = blockIdentifier != null ? Long.valueOf(blockIdentifier.getNumber()) : null;
            l = l3 != null ? l3 : this.startBlock;
        }
        long lastSyncedBlockNumber = l;
        this.rollback(lastSyncedBlockNumber);
        this.currentBlockNumber = lastSyncedBlockNumber;
        this.setStatus(Status.SYNCING);
        BlockIdentifier blockIdentifier = lastBlock = this.getLastSyncedBlock();
        this.previousBlock = (blockIdentifier != null ? blockIdentifier.getNumber() == lastSyncedBlockNumber - 1L : false) ? lastBlock : null;
    }

    public static /* synthetic */ void initialise$default(BlockIndexer blockIndexer, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialise");
        }
        if ((n & 1) != 0) {
            l = null;
        }
        blockIndexer.initialise(l);
    }

    @Override
    public void startInCoroutine(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BlockIndexer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        this.L$0 = $this$launch;
                        this.label = 1;
                        Object object3 = this.this$0.start((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            this.this$0.getLogger().error("Error starting indexer " + $this$launch.getClass().getSimpleName() + ": ", (Throwable)e);
                            throw new Exception(e.getMessage(), e);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @Nullable
    public Object start(@NotNull Continuation<? super Unit> $completion) {
        return BlockIndexer.start$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object start$suspendImpl(BlockIndexer $this, Continuation<? super Unit> $completion) {
        BlockIndexer.initialise$default($this, null, 1, null);
        $this.logger.info("Starting @ Block: " + $this.currentBlockNumber);
        Object object = $this.run($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    protected void restart() {
        this.logger.info("\u26a0\ufe0f Restarting @ Block: " + this.currentBlockNumber + " with status " + this.getStatus());
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStatus().ordinal()]) {
            case 1: {
                this.initialise(this.currentBlockNumber);
                break;
            }
            case 2: {
                this.initialise(this.currentBlockNumber - 1L);
                break;
            }
            default: {
                BlockIndexer.initialise$default(this, null, 1, null);
            }
        }
        this.logger.info("\u2705 Successfully Restarted @ Block: " + this.currentBlockNumber + " with status " + this.getStatus());
    }

    @Nullable
    protected Object run(@NotNull Continuation<? super Unit> $completion) {
        return BlockIndexer.run$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object run$suspendImpl(BlockIndexer var0, Continuation<? super Unit> $completion) {
        if (!($completion instanceof run.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BlockIndexer.run$suspendImpl(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl13:
                // 2 sources

                while (true) {
                    $continuation.L$0 = $this;
                    $continuation.label = 1;
                    v0 = $this.runOnce((Continuation<? super Unit>)$continuation);
                    if (v0 != var4_4) continue;
                    return var4_4;
                }
            }
            case 1: {
                $this = (BlockIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** continue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object runOnce(@NotNull Continuation<? super Unit> $completion) {
        block28: {
            if (!($completion instanceof runOnce.1)) ** GOTO lbl-1000
            var7_2 = $completion;
            if ((var7_2.label & -2147483648) != 0) {
                var7_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ BlockIndexer this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runOnce((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = this.backoffDelay$indexer_core((Continuation<? super Unit>)$continuation);
                    ** if (v0 != var8_4) goto lbl18
lbl17:
                    // 1 sources

                    return var8_4;
lbl18:
                    // 1 sources

                    ** GOTO lbl24
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    if (this.getStatus() == Status.ERROR || this.getStatus() == Status.REORG) {
                        this.restart();
                    }
                    $continuation.label = 2;
                    v1 = this.getThorClient().getBlock(this.currentBlockNumber, (Continuation<? super Block>)$continuation);
                    ** if (v1 != var8_4) goto lbl30
lbl29:
                    // 1 sources

                    return var8_4;
lbl30:
                    // 1 sources

                    ** GOTO lbl36
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl36:
                    // 2 sources

                    block = (Block)v1;
                    if (this.currentBlockNumber > this.startBlock) {
                        v2 = this.previousBlock;
                        if (v2 != null && (v2 = v2.getId()) != null) {
                            it = v2;
                            $i$a$-let-BlockIndexer$runOnce$2 = false;
                            v3 = !Intrinsics.areEqual((Object)it, (Object)block.getParentID());
                        } else {
                            v3 = false;
                        }
                        if (v3) {
                            v4 = this.previousBlock;
                            if (v4 == null || (v4 = v4.getId()) == null) {
                                v4 = "null";
                            }
                            v5 = this.previousBlock;
                            message = "REORG @ Block " + this.currentBlockNumber + " previousBlock=(id=" + (String)v4 + " number=" + (v5 != null ? Boxing.boxLong((long)v5.getNumber()) : "null") + ")  parentID=" + block.getParentID();
                            this.logger.error(message);
                            throw new ReorgException(message);
                        }
                    }
                    if (this.logger.isTraceEnabled() || this.getStatus() != Status.SYNCING || this.currentBlockNumber % this.syncLoggerInterval == 0L) {
                        this.logger.info("(" + this.getStatus() + ") Processing Block  " + this.currentBlockNumber);
                    }
                    if ((v6 = this.getEventProcessor()) == null || (v6 = v6.processEvents(block)) == null) {
                        v6 = CollectionsKt.emptyList();
                    }
                    events = v6;
                    this.process(events, block);
                    $continuation.label = 3;
                    v7 = this.postProcessBlock(block, (Continuation<? super Unit>)$continuation);
                    ** if (v7 != var8_4) goto lbl63
lbl62:
                    // 1 sources

                    return var8_4;
lbl63:
                    // 1 sources

                    ** GOTO lbl69
                }
                case 3: {
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl69:
                        // 2 sources

                        this.runPruner();
                    }
                    catch (BlockNotFoundException block) {
                        this.logger.info("Block " + this.currentBlockNumber + " not found. Indexer may be fully synchronised.");
                        this.handleFullySynced();
                        $continuation.label = 4;
                        v8 = this.ensureFullySynced((Continuation<? super Unit>)$continuation);
                        if (v8 == var8_4) {
                            return var8_4;
                        }
                        break block28;
                    }
                }
                case 4: {
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
                    break block28;
                }
            }
            catch (ReorgException block) {
                this.handleReorg();
                break block28;
            }
            catch (Exception e) {
                this.logger.error("Error while processing block " + this.currentBlockNumber, (Throwable)e);
                this.handleError$indexer_core();
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleFullySynced() {
        this.backoffPeriod = 4000L;
        this.setStatus(Status.FULLY_SYNCED);
    }

    public final void handleError$indexer_core() {
        this.backoffPeriod = 10000L;
        this.setStatus(Status.ERROR);
    }

    private final void handleReorg() {
        this.backoffPeriod = 10000L;
        this.setStatus(Status.REORG);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object postProcessBlock(@NotNull Block var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof postProcessBlock.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.postProcessBlock(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (block.getNumber() != this.currentBlockNumber) {
                    throw new IllegalStateException("Block number mismatch: expected " + this.currentBlockNumber + ", got " + block.getNumber());
                }
                if (this.getStatus() == Status.FULLY_SYNCED && this.currentBlockNumber % (long)20 == 0L) {
                    $continuation.L$0 = block;
                    $continuation.label = 1;
                    v0 = this.ensureFullySynced((Continuation<? super Unit>)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                }
                ** GOTO lbl25
            }
            case 1: {
                block = (Block)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (this.getStatus() == Status.FULLY_SYNCED) {
                    currentEpoch = LocalDateTime.now(ZoneOffset.UTC).toInstant(ZoneOffset.UTC).toEpochMilli();
                    timeSinceLastBlock = Math.max(currentEpoch - block.getTimestamp() * (long)1000, 0L);
                    this.backoffPeriod = Math.max(0L, 10000L - timeSinceLastBlock) + (long)100;
                    this.logger.debug("Success @ Block " + this.currentBlockNumber + " (" + timeSinceLastBlock + " ms since mine)");
                }
                this.currentBlockNumber = block.getNumber() + 1L;
                this.previousBlock = new BlockIdentifier(block.getNumber(), block.getId());
                v1 = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"now(...)");
                this.timeLastProcessed = v1;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected final void runPruner() {
        block2: {
            if (this.getStatus() != Status.FULLY_SYNCED) {
                return;
            }
            Pruner pruner = this.getPruner();
            if (pruner == null) break block2;
            Pruner it = pruner;
            boolean bl = false;
            if (this.currentBlockNumber % this.prunerInterval == this.prunerIntervalOffset) {
                it.run(this.currentBlockNumber);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object ensureFullySynced(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof ensureFullySynced.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ BlockIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.ensureFullySynced((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getStatus() != Status.FULLY_SYNCED) ** GOTO lbl24
                $continuation.label = 1;
                v0 = this.getThorClient().getBestBlock((Continuation<? super Block>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                if ((latestBlock = (Block)v0).getNumber() > this.currentBlockNumber) {
                    this.logger.info(this.getName() + " - Changing status to SYNCING (indexerBlock=" + this.currentBlockNumber + ", latestBlock=" + latestBlock.getNumber() + ")");
                    this.setStatus(Status.SYNCING);
                }
lbl24:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object backoffDelay$indexer_core(@NotNull Continuation<? super Unit> $completion) {
        if (this.getStatus() != Status.SYNCING) {
            Object object = DelayKt.delay((long)this.backoffPeriod, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public BlockIdentifier getLastSyncedBlock() {
        return this.processor.getLastSyncedBlock();
    }

    @Override
    public void rollback(long blockNumber) {
        this.processor.rollback(blockNumber);
    }

    @Override
    public void process(@NotNull List<IndexedEvent> matchedEvents, @Nullable Block block) {
        Intrinsics.checkNotNullParameter(matchedEvents, (String)"matchedEvents");
        this.processor.process(matchedEvents, block);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.REORG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

