/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vechain.indexer.event.AbiEventProcessor;
import org.vechain.indexer.event.BusinessEventProcessor;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.EventLog;
import org.vechain.indexer.thor.model.TransferLog;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bJ*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0004R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/vechain/indexer/event/CombinedEventProcessor;", "", "abiEventProcessor", "Lorg/vechain/indexer/event/AbiEventProcessor;", "businessEventProcessor", "Lorg/vechain/indexer/event/BusinessEventProcessor;", "<init>", "(Lorg/vechain/indexer/event/AbiEventProcessor;Lorg/vechain/indexer/event/BusinessEventProcessor;)V", "hasAbis", "", "processEvents", "", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "block", "Lorg/vechain/indexer/thor/model/Block;", "eventLogs", "Lorg/vechain/indexer/thor/model/EventLog;", "transferLogs", "Lorg/vechain/indexer/thor/model/TransferLog;", "deduplicateEvents", "abiEvents", "businessEvents", "Companion", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nCombinedEventProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedEventProcessor.kt\norg/vechain/indexer/event/CombinedEventProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1208#2,2:137\n1236#2,4:139\n827#2:143\n855#2,2:144\n*S KotlinDebug\n*F\n+ 1 CombinedEventProcessor.kt\norg/vechain/indexer/event/CombinedEventProcessor\n*L\n129#1:137,2\n129#1:139,4\n130#1:143\n130#1:144,2\n*E\n"})
public class CombinedEventProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final AbiEventProcessor abiEventProcessor;
    @Nullable
    private final BusinessEventProcessor businessEventProcessor;

    protected CombinedEventProcessor(@Nullable AbiEventProcessor abiEventProcessor, @Nullable BusinessEventProcessor businessEventProcessor) {
        this.abiEventProcessor = abiEventProcessor;
        this.businessEventProcessor = businessEventProcessor;
    }

    public final boolean hasAbis() {
        return this.businessEventProcessor != null || this.abiEventProcessor != null && !((Collection)this.abiEventProcessor.getEventAbis()).isEmpty();
    }

    @NotNull
    public final List<IndexedEvent> processEvents(@NotNull Block block) {
        List<IndexedEvent> list;
        List<IndexedEvent> abiEvents;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Object object = this.abiEventProcessor;
        if (object == null || (object = ((AbiEventProcessor)object).processEvents(block)) == null) {
            object = abiEvents = CollectionsKt.emptyList();
        }
        if ((list = this.businessEventProcessor) == null || (list = ((BusinessEventProcessor)((Object)list)).processEvents(block)) == null) {
            list = CollectionsKt.emptyList();
        }
        List<IndexedEvent> businessEvents = list;
        return this.deduplicateEvents(abiEvents, businessEvents);
    }

    @NotNull
    public final List<IndexedEvent> processEvents(@NotNull List<EventLog> eventLogs, @NotNull List<TransferLog> transferLogs) {
        List<IndexedEvent> list;
        List<IndexedEvent> abiEvents;
        Intrinsics.checkNotNullParameter(eventLogs, (String)"eventLogs");
        Intrinsics.checkNotNullParameter(transferLogs, (String)"transferLogs");
        Object object = this.abiEventProcessor;
        if (object == null || (object = ((AbiEventProcessor)object).processEvents(eventLogs, transferLogs)) == null) {
            object = abiEvents = CollectionsKt.emptyList();
        }
        if ((list = this.businessEventProcessor) == null || (list = ((BusinessEventProcessor)((Object)list)).processEvents(eventLogs, transferLogs)) == null) {
            list = CollectionsKt.emptyList();
        }
        List<IndexedEvent> businessEvents = list;
        return this.deduplicateEvents(abiEvents, businessEvents);
    }

    public static /* synthetic */ List processEvents$default(CombinedEventProcessor combinedEventProcessor, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processEvents");
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return combinedEventProcessor.processEvents(list, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<IndexedEvent> deduplicateEvents(@NotNull List<IndexedEvent> abiEvents, @NotNull List<IndexedEvent> businessEvents) {
        void $this$filterNotTo$iv$iv;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(abiEvents, (String)"abiEvents");
        Intrinsics.checkNotNullParameter(businessEvents, (String)"businessEvents");
        if (businessEvents.isEmpty()) {
            return abiEvents;
        }
        if (abiEvents.isEmpty()) {
            return businessEvents;
        }
        Iterable $this$associateBy$iv = businessEvents;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            IndexedEvent indexedEvent = (IndexedEvent)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(TuplesKt.to((Object)it.getTxId(), (Object)it.getClauseIndex()), element$iv$iv);
        }
        Map businessEventMap = destination$iv$iv;
        Iterable $this$filterNot$iv = abiEvents;
        boolean $i$f$filterNot = false;
        Iterable capacity$iv22 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IndexedEvent event = (IndexedEvent)element$iv$iv;
            boolean bl = false;
            Pair key = TuplesKt.to((Object)event.getTxId(), (Object)event.getClauseIndex());
            if (businessEventMap.containsKey(key)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Iterable)businessEvents);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jx\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0012\u00a8\u0006\u0013"}, d2={"Lorg/vechain/indexer/event/CombinedEventProcessor$Companion;", "", "<init>", "()V", "create", "Lorg/vechain/indexer/event/CombinedEventProcessor;", "abiBasePath", "", "abiEventNames", "", "abiContracts", "includeVetTransfers", "", "businessEventPath", "businessEventAbiBasePath", "businessEventNames", "businessEventContracts", "substitutionParams", "", "indexer-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CombinedEventProcessor create(@Nullable String abiBasePath, @NotNull List<String> abiEventNames, @NotNull List<String> abiContracts, boolean includeVetTransfers, @Nullable String businessEventPath, @Nullable String businessEventAbiBasePath, @NotNull List<String> businessEventNames, @NotNull List<String> businessEventContracts, @NotNull Map<String, String> substitutionParams) {
            BusinessEventProcessor businessEventProcessor;
            Intrinsics.checkNotNullParameter(abiEventNames, (String)"abiEventNames");
            Intrinsics.checkNotNullParameter(abiContracts, (String)"abiContracts");
            Intrinsics.checkNotNullParameter(businessEventNames, (String)"businessEventNames");
            Intrinsics.checkNotNullParameter(businessEventContracts, (String)"businessEventContracts");
            Intrinsics.checkNotNullParameter(substitutionParams, (String)"substitutionParams");
            if (businessEventPath != null) {
                if (businessEventAbiBasePath == null) {
                    throw new IllegalArgumentException("Business event ABI path must be provided if business event path is set.");
                }
                businessEventProcessor = new BusinessEventProcessor(businessEventPath, businessEventAbiBasePath, businessEventNames, businessEventContracts, substitutionParams);
            } else {
                businessEventProcessor = null;
            }
            BusinessEventProcessor businessEventProcessor2 = businessEventProcessor;
            AbiEventProcessor abiEventProcessor = abiBasePath != null ? new AbiEventProcessor(abiBasePath, abiEventNames, abiContracts, includeVetTransfers) : null;
            return new CombinedEventProcessor(abiEventProcessor, businessEventProcessor2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

