/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.utils.FileUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\r0\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0014JD\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\r\"\u0004\b\u0000\u0010\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0014J=\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00122\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0014\u00a2\u0006\u0002\u0010\u0018J\"\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0014J\"\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/vechain/indexer/event/JsonLoader;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "loadAndFlatten", "", "E", "paths", "", "typeRef", "Lcom/fasterxml/jackson/core/type/TypeReference;", "substitutionParams", "", "load", "T", "path", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;Ljava/util/Map;)Ljava/lang/Object;", "readAndSubstituteJson", "substitutePlaceholders", "text", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nJsonLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLoader.kt\norg/vechain/indexer/event/JsonLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1374#2:98\n1460#2,5:99\n1#3:104\n*S KotlinDebug\n*F\n+ 1 JsonLoader.kt\norg/vechain/indexer/event/JsonLoader\n*L\n20#1:98\n20#1:99,5\n*E\n"})
public final class JsonLoader {
    @NotNull
    public static final JsonLoader INSTANCE = new JsonLoader();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final ObjectMapper objectMapper;

    private JsonLoader() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <E> List<E> loadAndFlatten(@NotNull List<String> paths, @NotNull TypeReference<List<E>> typeRef, @NotNull Map<String, String> substitutionParams) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter(substitutionParams, (String)"substitutionParams");
        Iterable $this$flatMap$iv = paths;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.load(it, typeRef, substitutionParams);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List loadAndFlatten$default(JsonLoader jsonLoader, List list, TypeReference typeReference, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return jsonLoader.loadAndFlatten(list, typeReference, map);
    }

    @NotNull
    public final <T> List<T> load(@NotNull List<String> paths, @NotNull TypeReference<T> typeRef, @NotNull Map<String, String> substitutionParams) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter(substitutionParams, (String)"substitutionParams");
        List results = new ArrayList();
        for (String path : paths) {
            results.add(this.load(path, typeRef, substitutionParams));
        }
        return results;
    }

    public static /* synthetic */ List load$default(JsonLoader jsonLoader, List list, TypeReference typeReference, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return jsonLoader.load(list, typeReference, (Map<String, String>)map);
    }

    public final <T> T load(@NotNull String path, @NotNull TypeReference<T> typeRef, @NotNull Map<String, String> substitutionParams) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter(substitutionParams, (String)"substitutionParams");
        String substitutedJson = this.readAndSubstituteJson(path, substitutionParams);
        try {
            object = objectMapper.readValue(substitutedJson, typeRef);
        }
        catch (Exception ex) {
            logger.error("\u274c Error parsing JSON file " + path + ": " + ex.getMessage());
            throw ex;
        }
        return (T)object;
    }

    public static /* synthetic */ Object load$default(JsonLoader jsonLoader, String string, TypeReference typeReference, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return jsonLoader.load(string, typeReference, (Map<String, String>)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readAndSubstituteJson(@NotNull String path, @NotNull Map<String, String> substitutionParams) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(substitutionParams, (String)"substitutionParams");
        InputStream inputStream2 = FileUtils.INSTANCE.getResourceAsStream(path);
        if (inputStream2 == null) {
            throw new IllegalStateException("Resource not found: " + path);
        }
        Closeable closeable = inputStream = inputStream2;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object originalJson = object2;
        String substitutedJson = this.substitutePlaceholders((String)originalJson, substitutionParams);
        if (StringsKt.contains$default((CharSequence)substitutedJson, (CharSequence)"${", (boolean)false, (int)2, null)) {
            throw new IllegalStateException("Not all placeholders were substituted in JSON file " + path + ". Please check the substitution parameters.");
        }
        return substitutedJson;
    }

    @NotNull
    public final String substitutePlaceholders(@NotNull String text, @NotNull Map<String, String> substitutionParams) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(substitutionParams, (String)"substitutionParams");
        Pattern regex = Pattern.compile("\\$\\{(\\w+)}");
        Matcher matcher = regex.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String key = matcher.group(1);
            String string = substitutionParams.get(key);
            if (string == null) {
                string = System.getenv(key);
            }
            Matcher matcher2 = (replacement = string) != null ? matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement)) : matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group(0)));
        }
        matcher.appendTail(sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        JsonLoader.logger = logger;
        objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
    }
}

