/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.utils;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/vechain/indexer/utils/FileScanner;", "", "<init>", "()V", "findFiles", "", "", "basePath", "suffix", "maxDepth", "", "relativeDepth", "base", "full", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nFileScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileScanner.kt\norg/vechain/indexer/utils/FileScanner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class FileScanner {
    @NotNull
    public static final FileScanner INSTANCE = new FileScanner();

    private FileScanner() {
    }

    @NotNull
    public final List<String> findFiles(@NotNull String basePath, @Nullable String suffix, int maxDepth) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = classLoader.getResources(basePath);
        List results = new ArrayList();
        while (resources.hasMoreElements()) {
            JarFile jarFile;
            URL url = resources.nextElement();
            String string = url.getProtocol();
            if (Intrinsics.areEqual((Object)string, (Object)"file")) {
                File baseDir = new File(url.toURI());
                if (!baseDir.isDirectory()) continue;
                SequencesKt.toCollection((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)baseDir).maxDepth(maxDepth + 1)), arg_0 -> FileScanner.findFiles$lambda$0(suffix, arg_0)), arg_0 -> FileScanner.findFiles$lambda$2(baseDir, basePath, arg_0)), (Collection)results);
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"jar")) continue;
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.JarURLConnection");
            JarURLConnection jarConnection = (JarURLConnection)uRLConnection;
            Intrinsics.checkNotNullExpressionValue((Object)jarConnection.getJarFile(), (String)"getJarFile(...)");
            String string2 = jarConnection.getEntryName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEntryName(...)");
            String entryPrefix = StringsKt.removeSuffix((String)string2, (CharSequence)"/") + "/";
            Enumeration<JarEntry> enumeration = jarFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            SequencesKt.toCollection((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), arg_0 -> FileScanner.findFiles$lambda$3(entryPrefix, arg_0)), arg_0 -> FileScanner.findFiles$lambda$4(entryPrefix, maxDepth, arg_0)), FileScanner::findFiles$lambda$5), (Collection)results);
        }
        return CollectionsKt.sorted((Iterable)results);
    }

    public static /* synthetic */ List findFiles$default(FileScanner fileScanner, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        return fileScanner.findFiles(string, string2, n);
    }

    private final int relativeDepth(String base, String full) {
        char[] cArray = new char[]{'/'};
        CharSequence charSequence = StringsKt.trim((String)base, (char[])cArray);
        cArray = new char[]{'/'};
        List baseParts = StringsKt.split$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'/'};
        CharSequence charSequence2 = StringsKt.trim((String)full, (char[])cArray2);
        cArray2 = new char[]{'/'};
        List fullParts = StringsKt.split$default((CharSequence)charSequence2, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        return RangesKt.coerceAtLeast((int)(fullParts.size() - baseParts.size()), (int)0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findFiles$lambda$0(String $suffix, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isFile()) return false;
        if ($suffix == null) return true;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith((String)string, (String)("." + $suffix), (boolean)true)) return false;
        return true;
    }

    private static final String findFiles$lambda$2(File $baseDir, String $basePath, File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String it = StringsKt.replace$default((String)((Object)$baseDir.toPath().relativize(file.toPath())).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        boolean bl = false;
        return $basePath + "/" + it;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findFiles$lambda$3(String $entryPrefix, JarEntry it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)$entryPrefix, (boolean)false, (int)2, null)) return false;
        String string2 = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)".json", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean findFiles$lambda$4(String $entryPrefix, int $maxDepth, JarEntry it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return INSTANCE.relativeDepth($entryPrefix, string) <= $maxDepth;
    }

    private static final String findFiles$lambda$5(JarEntry it) {
        return it.getName();
    }
}

