/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.BlockIndexer;
import org.vechain.indexer.Indexer;
import org.vechain.indexer.IndexerProcessor;
import org.vechain.indexer.IndexingResult;
import org.vechain.indexer.Pruner;
import org.vechain.indexer.Status;
import org.vechain.indexer.event.CombinedEventProcessor;
import org.vechain.indexer.exception.ReorgException;
import org.vechain.indexer.thor.client.ThorClient;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.BlockIdentifier;
import org.vechain.indexer.thor.model.Clause;
import org.vechain.indexer.thor.model.InspectionResult;
import org.vechain.indexer.utils.IndexerUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0016\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\t\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\n\u0010&\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010%H\u0004J\u0010\u00101\u001a\u00020(2\u0006\u00102\u001a\u000200H\u0004J\b\u00103\u001a\u000200H\u0016J\b\u00105\u001a\u00020\tH\u0016J\u0010\u00106\u001a\u00020(2\u0006\u0010)\u001a\u00020\tH\u0004J\b\u0010=\u001a\u00020(H\u0016J\b\u0010>\u001a\u00020\tH\u0014J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020\tH\u0014J\u0010\u0010A\u001a\u00020(2\u0006\u0010@\u001a\u00020\tH\u0014J\u0012\u0010B\u001a\u0004\u0018\u00010%2\u0006\u0010C\u001a\u00020\tH\u0014J\b\u0010D\u001a\u00020(H\u0014J\u0016\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0084@\u00a2\u0006\u0002\u0010IJ\b\u0010J\u001a\u00020(H\u0004J\u0016\u0010K\u001a\u00020(2\u0006\u0010G\u001a\u00020HH\u0096@\u00a2\u0006\u0002\u0010IJ\b\u0010L\u001a\u00020(H\u0014J\u0010\u0010M\u001a\u00020(2\u0006\u0010G\u001a\u00020HH\u0014J\u0016\u0010N\u001a\u00020(2\u0006\u0010G\u001a\u00020HH\u0094@\u00a2\u0006\u0002\u0010IJ\u0010\u0010O\u001a\u00020(2\u0006\u0010G\u001a\u00020HH\u0014J\u0010\u0010P\u001a\u00020(2\u0006\u0010G\u001a\u00020HH\u0004J\b\u0010Q\u001a\u00020(H\u0004J\b\u0010R\u001a\u00020SH\u0014J\b\u0010T\u001a\u00020(H\u0014J\n\u0010U\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010V\u001a\u00020(2\u0006\u0010@\u001a\u00020\tH\u0016J\u0010\u0010W\u001a\u00020(2\u0006\u0010X\u001a\u00020FH\u0016J\b\u0010Y\u001a\u00020(H\u0002J\b\u0010Z\u001a\u00020SH\u0014J\b\u0010[\u001a\u00020SH\u0014J\b\u0010\\\u001a\u00020\u0003H\u0014J\u0015\u0010]\u001a\u00020(2\u0006\u0010G\u001a\u00020HH\u0000\u00a2\u0006\u0002\b^J\b\u0010_\u001a\u00020SH\u0014J\u0010\u0010`\u001a\u00020S2\u0006\u0010G\u001a\u00020HH\u0014J\u0010\u0010a\u001a\u00020(2\u0006\u0010G\u001a\u00020HH\u0014J\u0010\u0010b\u001a\u00020\u00032\u0006\u0010G\u001a\u00020HH\u0014J\b\u0010c\u001a\u00020(H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020,X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00108\u001a\u0002072\u0006\u0010)\u001a\u000207@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006d"}, d2={"Lorg/vechain/indexer/BlockIndexer;", "Lorg/vechain/indexer/Indexer;", "name", "", "thorClient", "Lorg/vechain/indexer/thor/client/ThorClient;", "processor", "Lorg/vechain/indexer/IndexerProcessor;", "startBlock", "", "syncLoggerInterval", "eventProcessor", "Lorg/vechain/indexer/event/CombinedEventProcessor;", "inspectionClauses", "", "Lorg/vechain/indexer/thor/model/Clause;", "pruner", "Lorg/vechain/indexer/Pruner;", "prunerInterval", "dependsOn", "<init>", "(Ljava/lang/String;Lorg/vechain/indexer/thor/client/ThorClient;Lorg/vechain/indexer/IndexerProcessor;JJLorg/vechain/indexer/event/CombinedEventProcessor;Ljava/util/List;Lorg/vechain/indexer/Pruner;JLorg/vechain/indexer/Indexer;)V", "getName", "()Ljava/lang/String;", "getThorClient", "()Lorg/vechain/indexer/thor/client/ThorClient;", "getStartBlock", "()J", "getEventProcessor", "()Lorg/vechain/indexer/event/CombinedEventProcessor;", "getInspectionClauses", "()Ljava/util/List;", "getPruner", "()Lorg/vechain/indexer/Pruner;", "getDependsOn", "()Lorg/vechain/indexer/Indexer;", "previousBlock", "Lorg/vechain/indexer/thor/model/BlockIdentifier;", "getPreviousBlock", "setPreviousBlock", "", "value", "prunerIntervalOffset", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "status", "Lorg/vechain/indexer/Status;", "setStatus", "newStatus", "getStatus", "currentBlockNumber", "getCurrentBlockNumber", "setCurrentBlockNumber", "Ljava/time/LocalDateTime;", "timeLastProcessed", "getTimeLastProcessed", "()Ljava/time/LocalDateTime;", "setTimeLastProcessed$indexer_core", "(Ljava/time/LocalDateTime;)V", "initialise", "determineStartingBlock", "rollbackToSafeState", "blockNumber", "initializeState", "calculatePreviousBlock", "currentBlock", "logInitialization", "buildIndexingResult", "Lorg/vechain/indexer/IndexingResult;", "block", "Lorg/vechain/indexer/thor/model/Block;", "(Lorg/vechain/indexer/thor/model/Block;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkIfShuttingDown", "processBlock", "validateProcessingState", "validateBlockNumber", "processAndUpdateState", "updateBlockState", "updateSyncStatus", "runPruner", "shouldRunPruner", "", "executePruner", "getLastSyncedBlock", "rollback", "process", "entry", "logProcessingBlock", "shouldLogDebug", "shouldLogInfo", "buildLogMessage", "checkForReorg", "checkForReorg$indexer_core", "shouldCheckForReorg", "isReorgDetected", "handleReorg", "buildReorgMessage", "shutDown", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nBlockIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockIndexer.kt\norg/vechain/indexer/BlockIndexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
public class BlockIndexer
implements Indexer {
    @NotNull
    private final String name;
    @NotNull
    private final ThorClient thorClient;
    @NotNull
    private final IndexerProcessor processor;
    private final long startBlock;
    private final long syncLoggerInterval;
    @Nullable
    private final CombinedEventProcessor eventProcessor;
    @Nullable
    private final List<Clause> inspectionClauses;
    @Nullable
    private final Pruner pruner;
    private final long prunerInterval;
    @Nullable
    private final Indexer dependsOn;
    @Nullable
    private BlockIdentifier previousBlock;
    private final long prunerIntervalOffset;
    @NotNull
    private final Logger logger;
    @NotNull
    private Status status;
    private long currentBlockNumber;
    @NotNull
    private LocalDateTime timeLastProcessed;

    public BlockIndexer(@NotNull String name, @NotNull ThorClient thorClient, @NotNull IndexerProcessor processor, long startBlock, long syncLoggerInterval, @Nullable CombinedEventProcessor eventProcessor, @Nullable List<Clause> inspectionClauses, @Nullable Pruner pruner, long prunerInterval, @Nullable Indexer dependsOn) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)thorClient, (String)"thorClient");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.name = name;
        this.thorClient = thorClient;
        this.processor = processor;
        this.startBlock = startBlock;
        this.syncLoggerInterval = syncLoggerInterval;
        this.eventProcessor = eventProcessor;
        this.inspectionClauses = inspectionClauses;
        this.pruner = pruner;
        this.prunerInterval = prunerInterval;
        this.dependsOn = dependsOn;
        if (!(this.prunerInterval > 0L)) {
            boolean bl = false;
            String string = "prunerInterval must be > 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.prunerIntervalOffset = RangesKt.random((LongRange)RangesKt.until((int)0, (long)this.prunerInterval), (Random)((Random)Random.Default));
        Logger logger = LoggerFactory.getLogger((String)this.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.status = Status.NOT_INITIALISED;
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        this.timeLastProcessed = localDateTime;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    protected ThorClient getThorClient() {
        return this.thorClient;
    }

    protected final long getStartBlock() {
        return this.startBlock;
    }

    @Nullable
    protected final CombinedEventProcessor getEventProcessor() {
        return this.eventProcessor;
    }

    @Nullable
    protected final List<Clause> getInspectionClauses() {
        return this.inspectionClauses;
    }

    @Override
    @Nullable
    public Pruner getPruner() {
        return this.pruner;
    }

    @Override
    @Nullable
    public Indexer getDependsOn() {
        return this.dependsOn;
    }

    @Override
    @Nullable
    public BlockIdentifier getPreviousBlock() {
        return this.previousBlock;
    }

    protected final void setPreviousBlock(@Nullable BlockIdentifier value) {
        this.previousBlock = value;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final void setStatus(@NotNull Status newStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)newStatus), (String)"newStatus");
        this.status = newStatus;
    }

    @Override
    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @Override
    public long getCurrentBlockNumber() {
        return this.currentBlockNumber;
    }

    protected final void setCurrentBlockNumber(long value) {
        this.currentBlockNumber = value;
    }

    @NotNull
    public final LocalDateTime getTimeLastProcessed() {
        return this.timeLastProcessed;
    }

    public final void setTimeLastProcessed$indexer_core(@NotNull LocalDateTime localDateTime) {
        Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"<set-?>");
        this.timeLastProcessed = localDateTime;
    }

    @Override
    public void initialise() {
        long lastSyncedBlockNumber = this.determineStartingBlock();
        this.rollbackToSafeState(lastSyncedBlockNumber);
        this.initializeState(lastSyncedBlockNumber);
        this.logInitialization();
    }

    protected long determineStartingBlock() {
        BlockIdentifier blockIdentifier = this.getLastSyncedBlock();
        return blockIdentifier != null ? blockIdentifier.getNumber() : this.startBlock;
    }

    protected void rollbackToSafeState(long blockNumber) {
        this.rollback(blockNumber);
    }

    protected void initializeState(long blockNumber) {
        this.currentBlockNumber = blockNumber;
        this.previousBlock = this.calculatePreviousBlock(blockNumber);
        this.status = Status.INITIALISED;
    }

    @Nullable
    protected BlockIdentifier calculatePreviousBlock(long currentBlock) {
        BlockIdentifier lastBlock;
        BlockIdentifier blockIdentifier = lastBlock = this.getLastSyncedBlock();
        return (blockIdentifier != null ? blockIdentifier.getNumber() == currentBlock - 1L : false) ? lastBlock : null;
    }

    protected void logInitialization() {
        this.logger.info("Initialised @ Block: " + this.currentBlockNumber);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object buildIndexingResult(@NotNull Block var1_1, @NotNull Continuation<? super IndexingResult> $completion) {
        if (!($completion instanceof buildIndexingResult.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BlockIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.buildIndexingResult(null, (Continuation<? super IndexingResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.inspectionClauses;
                if (v0 == null) ** GOTO lbl31
                it = v0;
                $i$a$-let-BlockIndexer$buildIndexingResult$callResults$1 = false;
                $continuation.L$0 = block;
                $continuation.label = 1;
                v1 = this.getThorClient().inspectClauses(it, block.getId(), (Continuation<? super List<InspectionResult>>)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                $i$a$-let-BlockIndexer$buildIndexingResult$callResults$1 = false;
                block = (Block)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                v2 = (List)v1;
                v0 = v2;
                if (v2 != null) ** GOTO lbl32
lbl31:
                // 2 sources

                v0 = callResults = CollectionsKt.emptyList();
lbl32:
                // 2 sources

                if ((v3 = this.eventProcessor) == null || (v3 = v3.processEvents(block)) == null) {
                    v3 = CollectionsKt.emptyList();
                }
                events = v3;
                return new IndexingResult.Normal(block, events, callResults);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected final void checkIfShuttingDown() {
        if (this.status == Status.SHUT_DOWN) {
            throw new CancellationException("Indexer is shut down");
        }
    }

    @Override
    @Nullable
    public Object processBlock(@NotNull Block block, @NotNull Continuation<? super Unit> $completion) {
        return BlockIndexer.processBlock$suspendImpl(this, block, $completion);
    }

    static /* synthetic */ Object processBlock$suspendImpl(BlockIndexer $this, Block block, Continuation<? super Unit> $completion) {
        $this.validateProcessingState();
        $this.validateBlockNumber(block);
        $this.updateSyncStatus(block);
        $this.checkForReorg$indexer_core(block);
        Object object = $this.processAndUpdateState(block, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    protected void validateProcessingState() {
        this.checkIfShuttingDown();
        Status[] statusArray = new Status[]{Status.INITIALISED, Status.SYNCING, Status.FULLY_SYNCED};
        IndexerUtils.INSTANCE.ensureStatus(this.status, SetsKt.setOf((Object[])statusArray));
    }

    protected void validateBlockNumber(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (block.getNumber() != this.currentBlockNumber) {
            throw new IllegalStateException("Block number mismatch: expected " + this.currentBlockNumber + ", got " + block.getNumber());
        }
    }

    @Nullable
    protected Object processAndUpdateState(@NotNull Block block, @NotNull Continuation<? super Unit> $completion) {
        return BlockIndexer.processAndUpdateState$suspendImpl(this, block, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object processAndUpdateState$suspendImpl(BlockIndexer var0, Block var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof processAndUpdateState.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ BlockIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BlockIndexer.processAndUpdateState$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this.logProcessingBlock();
                var3_6 = $this;
                $continuation.L$0 = $this;
                $continuation.L$1 = block;
                $continuation.L$2 = var3_6;
                $continuation.label = 1;
                v0 = $this.buildIndexingResult(block, (Continuation<? super IndexingResult>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                var3_6 = (BlockIndexer)$continuation.L$2;
                block = (Block)$continuation.L$1;
                $this = (BlockIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                var3_6.process((IndexingResult)v0);
                $this.updateBlockState(block);
                $this.runPruner();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected void updateBlockState(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.currentBlockNumber = block.getNumber() + 1L;
        this.previousBlock = new BlockIdentifier(block.getNumber(), block.getId());
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        this.timeLastProcessed = localDateTime;
    }

    protected final void updateSyncStatus(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        LocalDateTime blockTime = LocalDateTime.ofEpochSecond(block.getTimestamp(), 0, ZoneOffset.UTC);
        LocalDateTime now = LocalDateTime.now(ZoneOffset.UTC);
        this.status = Duration.between(blockTime, now).toSeconds() < 15L ? Status.FULLY_SYNCED : Status.SYNCING;
    }

    protected final void runPruner() {
        if (!this.shouldRunPruner()) {
            return;
        }
        this.executePruner();
    }

    protected boolean shouldRunPruner() {
        if (this.getPruner() == null) {
            return false;
        }
        if (this.status != Status.FULLY_SYNCED) {
            return false;
        }
        return this.currentBlockNumber % this.prunerInterval == this.prunerIntervalOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePruner() {
        Pruner pruner = this.getPruner();
        if (pruner == null) {
            return;
        }
        Pruner prunerInstance = pruner;
        this.status = Status.PRUNING;
        try {
            prunerInstance.run(this.currentBlockNumber);
        }
        finally {
            this.status = Status.FULLY_SYNCED;
        }
    }

    @Override
    @Nullable
    public BlockIdentifier getLastSyncedBlock() {
        return this.processor.getLastSyncedBlock();
    }

    @Override
    public void rollback(long blockNumber) {
        this.processor.rollback(blockNumber);
    }

    @Override
    public void process(@NotNull IndexingResult entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.processor.process(entry);
    }

    private final void logProcessingBlock() {
        if (this.shouldLogDebug()) {
            this.logger.debug(this.buildLogMessage());
        } else if (this.shouldLogInfo()) {
            this.logger.info(this.buildLogMessage());
        }
    }

    protected boolean shouldLogDebug() {
        return this.logger.isDebugEnabled();
    }

    protected boolean shouldLogInfo() {
        return this.status == Status.FULLY_SYNCED || this.currentBlockNumber % this.syncLoggerInterval == 0L;
    }

    @NotNull
    protected String buildLogMessage() {
        return "(" + this.status + ") Processing Block  " + this.currentBlockNumber;
    }

    public final void checkForReorg$indexer_core(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (this.shouldCheckForReorg() && this.isReorgDetected(block)) {
            this.handleReorg(block);
        }
    }

    protected boolean shouldCheckForReorg() {
        return this.currentBlockNumber > this.startBlock && this.previousBlock != null;
    }

    protected boolean isReorgDetected(@NotNull Block block) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Object object = this.previousBlock;
        if (object != null && (object = ((BlockIdentifier)object).getId()) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = !Intrinsics.areEqual((Object)it, (Object)block.getParentID());
        } else {
            bl = false;
        }
        return bl;
    }

    protected void handleReorg(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String message = this.buildReorgMessage(block);
        this.logger.error(message);
        this.rollback(this.currentBlockNumber - 1L);
        throw new ReorgException(message);
    }

    @NotNull
    protected String buildReorgMessage(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Object object = this.previousBlock;
        if (object == null || (object = ((BlockIdentifier)object).getId()) == null) {
            object = "null";
        }
        BlockIdentifier blockIdentifier = this.previousBlock;
        return "REORG @ Block " + this.currentBlockNumber + " previousBlock=(id=" + (String)object + " number=" + (blockIdentifier != null ? Long.valueOf(blockIdentifier.getNumber()) : "null") + ") block=(parentID=" + block.getParentID() + " blockNumber=" + block.getNumber() + " id=" + block.getId() + ")";
    }

    @Override
    public void shutDown() {
        this.setStatus(Status.SHUT_DOWN);
        this.logger.info("Indexer Shut down");
    }

    @Override
    @Nullable
    public Object fastSync(@NotNull Continuation<? super Unit> $completion) {
        return Indexer.DefaultImpls.fastSync(this, $completion);
    }
}

