/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vechain.indexer.BlockIndexer;
import org.vechain.indexer.IndexerProcessor;
import org.vechain.indexer.IndexingResult;
import org.vechain.indexer.LogsIndexer;
import org.vechain.indexer.Pruner;
import org.vechain.indexer.Status;
import org.vechain.indexer.event.CombinedEventProcessor;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.thor.client.LogClient;
import org.vechain.indexer.thor.client.ThorClient;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.BlockIdentifier;
import org.vechain.indexer.thor.model.EventCriteria;
import org.vechain.indexer.thor.model.EventLog;
import org.vechain.indexer.thor.model.TransferCriteria;
import org.vechain.indexer.thor.model.TransferLog;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010\u0012\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\u0006\u0010\u0018\u001a\u00020\t\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000e\u0010!\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0080@\u00a2\u0006\u0004\b'\u0010(J\u0016\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0014J$\u0010-\u001a\u00020\f2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00102\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0010H\u0014J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020/0\u00102\u0006\u00103\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010+J\b\u00104\u001a\u00020\fH\u0014J\u001c\u00105\u001a\b\u0012\u0004\u0012\u0002010\u00102\u0006\u00103\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010+J\b\u00106\u001a\u00020\fH\u0014J2\u00107\u001a\u00020\"2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00102\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00102\u0006\u00103\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\"2\u0006\u00103\u001a\u00020\tH\u0014J \u0010:\u001a\u00020\"2\u0006\u0010;\u001a\u00020\t2\u0006\u00103\u001a\u00020\t2\u0006\u0010<\u001a\u00020=H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006>"}, d2={"Lorg/vechain/indexer/LogsIndexer;", "Lorg/vechain/indexer/BlockIndexer;", "name", "", "thorClient", "Lorg/vechain/indexer/thor/client/ThorClient;", "processor", "Lorg/vechain/indexer/IndexerProcessor;", "startBlock", "", "syncLoggerInterval", "excludeVetTransfers", "", "blockBatchSize", "logFetchLimit", "eventCriteriaSet", "", "Lorg/vechain/indexer/thor/model/EventCriteria;", "transferCriteriaSet", "Lorg/vechain/indexer/thor/model/TransferCriteria;", "eventProcessor", "Lorg/vechain/indexer/event/CombinedEventProcessor;", "pruner", "Lorg/vechain/indexer/Pruner;", "prunerInterval", "<init>", "(Ljava/lang/String;Lorg/vechain/indexer/thor/client/ThorClient;Lorg/vechain/indexer/IndexerProcessor;JJZJJLjava/util/List;Ljava/util/List;Lorg/vechain/indexer/event/CombinedEventProcessor;Lorg/vechain/indexer/Pruner;J)V", "getThorClient", "()Lorg/vechain/indexer/thor/client/ThorClient;", "logClient", "Lorg/vechain/indexer/thor/client/LogClient;", "getLogClient", "()Lorg/vechain/indexer/thor/client/LogClient;", "fastSync", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sync", "toBlock", "Lorg/vechain/indexer/thor/model/BlockIdentifier;", "sync$indexer_core", "(Lorg/vechain/indexer/thor/model/BlockIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processBatch", "toBlockNumber", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calculateBatchEndBlock", "hasNoLogs", "eventLogs", "Lorg/vechain/indexer/thor/model/EventLog;", "transferLogs", "Lorg/vechain/indexer/thor/model/TransferLog;", "fetchEventLogsIfNeeded", "batchEndBlock", "shouldFetchEventLogs", "fetchTransferLogsIfNeeded", "shouldFetchTransferLogs", "processAndIndexEvents", "(Ljava/util/List;Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateBlockNumberAndTime", "logSyncStatus", "currentBlockNumber", "status", "Lorg/vechain/indexer/Status;", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nLogsIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogsIndexer.kt\norg/vechain/indexer/LogsIndexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public class LogsIndexer
extends BlockIndexer {
    @NotNull
    private final ThorClient thorClient;
    private final boolean excludeVetTransfers;
    private final long blockBatchSize;
    private final long logFetchLimit;
    @Nullable
    private List<EventCriteria> eventCriteriaSet;
    @Nullable
    private List<TransferCriteria> transferCriteriaSet;
    @NotNull
    private final LogClient logClient;

    public LogsIndexer(@NotNull String name, @NotNull ThorClient thorClient, @NotNull IndexerProcessor processor, long startBlock, long syncLoggerInterval, boolean excludeVetTransfers, long blockBatchSize, long logFetchLimit, @Nullable List<EventCriteria> eventCriteriaSet, @Nullable List<TransferCriteria> transferCriteriaSet, @Nullable CombinedEventProcessor eventProcessor, @Nullable Pruner pruner, long prunerInterval) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)thorClient, (String)"thorClient");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        super(name, thorClient, processor, startBlock, syncLoggerInterval, eventProcessor, null, pruner, prunerInterval, null);
        this.thorClient = thorClient;
        this.excludeVetTransfers = excludeVetTransfers;
        this.blockBatchSize = blockBatchSize;
        this.logFetchLimit = logFetchLimit;
        this.eventCriteriaSet = eventCriteriaSet;
        this.transferCriteriaSet = transferCriteriaSet;
        if (!(this.blockBatchSize >= 1L)) {
            boolean $i$a$-require-LogsIndexer$32 = false;
            String $i$a$-require-LogsIndexer$32 = "blockBatchSize must be >= 1";
            throw new IllegalArgumentException($i$a$-require-LogsIndexer$32.toString());
        }
        if (!(this.logFetchLimit >= 1L)) {
            boolean bl = false;
            String string = "logFetchLimit must be >= 1";
            throw new IllegalArgumentException(string.toString());
        }
        this.logClient = new LogClient(this.getThorClient());
    }

    @Override
    @NotNull
    protected ThorClient getThorClient() {
        return this.thorClient;
    }

    @NotNull
    protected LogClient getLogClient() {
        return this.logClient;
    }

    @Override
    @Nullable
    public Object fastSync(@NotNull Continuation<? super Unit> $completion) {
        return LogsIndexer.fastSync$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object fastSync$suspendImpl(LogsIndexer var0, Continuation<? super Unit> $completion) {
        if (!($completion instanceof fastSync.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ LogsIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogsIndexer.fastSync$suspendImpl(this.this$0, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this.setStatus(Status.FAST_SYNCING);
                $this.getLogger().info("Starting fast sync from block " + $this.getCurrentBlockNumber());
                $continuation.L$0 = $this;
                $continuation.label = 1;
                v0 = $this.getThorClient().getFinalizedBlock((Continuation<? super Block>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                $this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                finalizedBlock = (Block)v0;
                if ($this.getCurrentBlockNumber() < finalizedBlock.getNumber()) {
                    $continuation.L$0 = $this;
                    $continuation.label = 2;
                    v1 = $this.sync$indexer_core(new BlockIdentifier(finalizedBlock.getNumber(), finalizedBlock.getId()), (Continuation<? super Unit>)$continuation);
                    if (v1 == var5_4) {
                        return var5_4;
                    }
                }
                ** GOTO lbl36
            }
            case 2: {
                $this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl36:
                // 2 sources

                $this.getLogger().info("Fast sync complete");
                $this.setStatus(Status.INITIALISED);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object sync$indexer_core(@NotNull BlockIdentifier var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof sync.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ LogsIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.sync$indexer_core(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 3 sources

                while (this.getCurrentBlockNumber() < toBlock.getNumber()) {
                    this.checkIfShuttingDown();
                    $continuation.L$0 = toBlock;
                    $continuation.label = 1;
                    v0 = this.processBatch(toBlock.getNumber(), (Continuation<? super Unit>)$continuation);
                    if (v0 != var5_5) continue;
                    return var5_5;
                }
                break;
            }
            case 1: {
                toBlock = (BlockIdentifier)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl12
            }
        }
        this.setPreviousBlock(toBlock);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object processBatch(long toBlockNumber, @NotNull Continuation<? super Unit> $completion) {
        return LogsIndexer.processBatch$suspendImpl(this, toBlockNumber, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object processBatch$suspendImpl(LogsIndexer var0, long var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof processBatch.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                Object L$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ LogsIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LogsIndexer.processBatch$suspendImpl(this.this$0, 0L, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                batchEndBlock = $this.calculateBatchEndBlock((long)toBlockNumber);
                $this.logSyncStatus($this.getCurrentBlockNumber(), batchEndBlock, $this.getStatus());
                $continuation.L$0 = $this;
                $continuation.J$0 = batchEndBlock;
                $continuation.label = 1;
                v0 = $this.fetchEventLogsIfNeeded(batchEndBlock, (Continuation<? super List<EventLog>>)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                batchEndBlock = $continuation.J$0;
                $this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                eventLogs = (List)v0;
                $continuation.L$0 = $this;
                $continuation.L$1 = eventLogs;
                $continuation.J$0 = batchEndBlock;
                $continuation.label = 2;
                v1 = $this.fetchTransferLogsIfNeeded(batchEndBlock, (Continuation<? super List<TransferLog>>)$continuation);
                if (v1 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl41
            }
            case 2: {
                batchEndBlock = $continuation.J$0;
                eventLogs = (List)$continuation.L$1;
                $this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 2 sources

                if ($this.hasNoLogs(eventLogs, transferLogs = (List)v1)) {
                    $this.updateBlockNumberAndTime(batchEndBlock);
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = $this;
                $continuation.L$1 = null;
                $continuation.J$0 = batchEndBlock;
                $continuation.label = 3;
                v2 = $this.processAndIndexEvents(eventLogs, transferLogs, batchEndBlock, (Continuation<? super Unit>)$continuation);
                if (v2 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl57
            }
            case 3: {
                batchEndBlock = $continuation.J$0;
                $this = (LogsIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl57:
                // 2 sources

                $this.updateBlockNumberAndTime(batchEndBlock);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected long calculateBatchEndBlock(long toBlockNumber) {
        return Math.min(this.getCurrentBlockNumber() + this.blockBatchSize - 1L, toBlockNumber);
    }

    protected boolean hasNoLogs(@NotNull List<EventLog> eventLogs, @NotNull List<TransferLog> transferLogs) {
        Intrinsics.checkNotNullParameter(eventLogs, (String)"eventLogs");
        Intrinsics.checkNotNullParameter(transferLogs, (String)"transferLogs");
        return eventLogs.isEmpty() && transferLogs.isEmpty();
    }

    @Nullable
    protected Object fetchEventLogsIfNeeded(long batchEndBlock, @NotNull Continuation<? super List<EventLog>> $completion) {
        return LogsIndexer.fetchEventLogsIfNeeded$suspendImpl(this, batchEndBlock, $completion);
    }

    static /* synthetic */ Object fetchEventLogsIfNeeded$suspendImpl(LogsIndexer $this, long batchEndBlock, Continuation<? super List<EventLog>> $completion) {
        if (!$this.shouldFetchEventLogs()) {
            return CollectionsKt.emptyList();
        }
        return $this.getLogClient().fetchEventLogs($this.getCurrentBlockNumber(), batchEndBlock, $this.logFetchLimit, $this.eventCriteriaSet, $completion);
    }

    protected boolean shouldFetchEventLogs() {
        CombinedEventProcessor combinedEventProcessor = this.getEventProcessor();
        return combinedEventProcessor != null ? combinedEventProcessor.hasAbis() : false;
    }

    @Nullable
    protected Object fetchTransferLogsIfNeeded(long batchEndBlock, @NotNull Continuation<? super List<TransferLog>> $completion) {
        return LogsIndexer.fetchTransferLogsIfNeeded$suspendImpl(this, batchEndBlock, $completion);
    }

    static /* synthetic */ Object fetchTransferLogsIfNeeded$suspendImpl(LogsIndexer $this, long batchEndBlock, Continuation<? super List<TransferLog>> $completion) {
        if (!$this.shouldFetchTransferLogs()) {
            return CollectionsKt.emptyList();
        }
        return $this.getLogClient().fetchTransfers($this.getCurrentBlockNumber(), batchEndBlock, $this.logFetchLimit, $this.transferCriteriaSet, $completion);
    }

    protected boolean shouldFetchTransferLogs() {
        return !this.excludeVetTransfers;
    }

    @Nullable
    protected Object processAndIndexEvents(@NotNull List<EventLog> eventLogs, @NotNull List<TransferLog> transferLogs, long batchEndBlock, @NotNull Continuation<? super Unit> $completion) {
        return LogsIndexer.processAndIndexEvents$suspendImpl(this, eventLogs, transferLogs, batchEndBlock, $completion);
    }

    static /* synthetic */ Object processAndIndexEvents$suspendImpl(LogsIndexer $this, List<EventLog> eventLogs, List<TransferLog> transferLogs, long batchEndBlock, Continuation<? super Unit> $completion) {
        List<IndexedEvent> indexedEvents;
        Object object = $this.getEventProcessor();
        if (object == null || (object = ((CombinedEventProcessor)object).processEvents(eventLogs, transferLogs)) == null) {
            object = CollectionsKt.emptyList();
        }
        if (!((Collection)(indexedEvents = object)).isEmpty()) {
            $this.process(new IndexingResult.EventsOnly(batchEndBlock, indexedEvents));
        }
        return Unit.INSTANCE;
    }

    protected void updateBlockNumberAndTime(long batchEndBlock) {
        this.setCurrentBlockNumber(batchEndBlock + 1L);
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        this.setTimeLastProcessed$indexer_core(localDateTime);
    }

    private final void logSyncStatus(long currentBlockNumber, long batchEndBlock, Status status) {
        this.getLogger().info("(" + status + ") Processing Blocks " + currentBlockNumber + " - " + batchEndBlock);
    }
}

