/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vechain.indexer.event.AbiLoader;
import org.vechain.indexer.event.EventProcessor;
import org.vechain.indexer.event.model.abi.AbiElement;
import org.vechain.indexer.event.model.generic.AbiEventParameters;
import org.vechain.indexer.event.model.generic.IndexedEvent;
import org.vechain.indexer.event.model.generic.RawEvent;
import org.vechain.indexer.event.utils.EventUtils;
import org.vechain.indexer.thor.model.Block;
import org.vechain.indexer.thor.model.EventLog;
import org.vechain.indexer.thor.model.Transaction;
import org.vechain.indexer.thor.model.TransferLog;
import org.vechain.indexer.thor.model.TxEvent;
import org.vechain.indexer.thor.model.TxOutputs;
import org.vechain.indexer.thor.model.TxTransfer;
import org.vechain.indexer.utils.DataUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005H\u0016J2\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0004J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0004J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005H\u0004J.\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0004R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/vechain/indexer/event/AbiEventProcessor;", "Lorg/vechain/indexer/event/EventProcessor;", "basePath", "", "eventNames", "", "contractAddresses", "includeVetTransfers", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Z)V", "logger", "Lorg/slf4j/Logger;", "eventAbis", "Lorg/vechain/indexer/event/model/abi/AbiElement;", "getEventAbis", "()Ljava/util/List;", "processEvents", "Lorg/vechain/indexer/event/model/generic/IndexedEvent;", "block", "Lorg/vechain/indexer/thor/model/Block;", "eventLogs", "Lorg/vechain/indexer/thor/model/EventLog;", "transferLogs", "Lorg/vechain/indexer/thor/model/TransferLog;", "decodeEvent", "event", "Lorg/vechain/indexer/thor/model/TxEvent;", "tx", "Lorg/vechain/indexer/thor/model/Transaction;", "outputIndex", "", "eventIndex", "decodeLogEvents", "logs", "decodeLogTransfers", "extractVetTransfers", "output", "Lorg/vechain/indexer/thor/model/TxOutputs;", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nAbiEventProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiEventProcessor.kt\norg/vechain/indexer/event/AbiEventProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1869#2:220\n1878#2,2:221\n1878#2,3:223\n1880#2:226\n1870#2:227\n1583#2,11:228\n1878#2,2:239\n1880#2:242\n1594#2:243\n1583#2,11:244\n1878#2,2:255\n1880#2:258\n1594#2:259\n1583#2,11:260\n1878#2,2:271\n1880#2:274\n1594#2:275\n1#3:241\n1#3:257\n1#3:273\n*S KotlinDebug\n*F\n+ 1 AbiEventProcessor.kt\norg/vechain/indexer/event/AbiEventProcessor\n*L\n28#1:220\n29#1:221,2\n30#1:223,3\n29#1:226\n28#1:227\n102#1:228,11\n102#1:239,2\n102#1:242\n102#1:243\n146#1:244,11\n146#1:255,2\n146#1:258\n146#1:259\n183#1:260,11\n183#1:271,2\n183#1:274\n183#1:275\n102#1:241\n146#1:257\n183#1:273\n*E\n"})
public class AbiEventProcessor
implements EventProcessor {
    @NotNull
    private final List<String> contractAddresses;
    private final boolean includeVetTransfers;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<AbiElement> eventAbis;

    public AbiEventProcessor(@NotNull String basePath, @NotNull List<String> eventNames, @NotNull List<String> contractAddresses, boolean includeVetTransfers) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter(eventNames, (String)"eventNames");
        Intrinsics.checkNotNullParameter(contractAddresses, (String)"contractAddresses");
        this.contractAddresses = contractAddresses;
        this.includeVetTransfers = includeVetTransfers;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.eventAbis = AbiLoader.loadEvents$default(AbiLoader.INSTANCE, basePath, eventNames, null, 4, null);
    }

    @NotNull
    public final List<AbiElement> getEventAbis() {
        return this.eventAbis;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IndexedEvent> processEvents(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        List events = new ArrayList();
        Iterable $this$forEach$iv = block.getTransactions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Transaction tx = (Transaction)element$iv;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv = tx.getOutputs();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void output;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TxOutputs txOutputs = (TxOutputs)item$iv;
                int outputIndex = n;
                boolean bl2 = false;
                Iterable $this$forEachIndexed$iv2 = output.getEvents();
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    IndexedEvent it;
                    void event;
                    int n2;
                    if ((n2 = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    TxEvent txEvent = (TxEvent)item$iv2;
                    int eventIndex = n2;
                    boolean bl3 = false;
                    if (!EventUtils.INSTANCE.isEventValid((TxEvent)event, this.eventAbis, this.contractAddresses)) continue;
                    if (this.decodeEvent((TxEvent)event, tx, block, outputIndex, eventIndex) == null) continue;
                    boolean bl4 = false;
                    events.add(it);
                }
                if (!this.includeVetTransfers) continue;
                events.addAll((Collection)this.extractVetTransfers((TxOutputs)output, tx, block, outputIndex));
            }
        }
        return events;
    }

    @Override
    @NotNull
    public List<IndexedEvent> processEvents(@NotNull List<EventLog> eventLogs, @NotNull List<TransferLog> transferLogs) {
        Intrinsics.checkNotNullParameter(eventLogs, (String)"eventLogs");
        Intrinsics.checkNotNullParameter(transferLogs, (String)"transferLogs");
        List<IndexedEvent> abiEvents = this.decodeLogEvents(eventLogs);
        List<IndexedEvent> vetTransfers = this.includeVetTransfers ? this.decodeLogTransfers(transferLogs) : CollectionsKt.emptyList();
        return CollectionsKt.plus((Collection)abiEvents, (Iterable)vetTransfers);
    }

    @Nullable
    protected final IndexedEvent decodeEvent(@NotNull TxEvent event, @NotNull Transaction tx, @NotNull Block block, int outputIndex, int eventIndex) {
        IndexedEvent indexedEvent;
        AbiElement matchingAbi;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        AbiElement abiElement = matchingAbi = EventUtils.INSTANCE.findMatchingAbi(event.getTopics(), this.eventAbis);
        if (abiElement != null) {
            IndexedEvent indexedEvent2;
            AbiElement abi = abiElement;
            boolean bl = false;
            try {
                AbiEventParameters parameters = EventUtils.INSTANCE.decodeEvent(event, abi);
                String string = EventUtils.INSTANCE.generateEventId(tx.getId(), outputIndex, eventIndex, event);
                String string2 = block.getId();
                long l = block.getNumber();
                long l2 = block.getTimestamp();
                String string3 = tx.getId();
                String string4 = tx.getOrigin();
                String string5 = tx.getGasPayer();
                long l3 = tx.getGasUsed();
                String string6 = tx.getPaid();
                RawEvent rawEvent = new RawEvent(event.getData(), event.getTopics());
                String string7 = event.getAddress();
                String string8 = parameters.getEventType();
                long l4 = outputIndex;
                String string9 = event.getTopics().get(0);
                indexedEvent2 = new IndexedEvent(string, string2, l, l2, string3, string4, string6, l3, string5, rawEvent, parameters, string7, string8, l4, string9);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.warn("Failed to decode event with ABI: " + abi.getName() + ", txId: " + tx.getId() + ". Skipping event.");
                indexedEvent2 = null;
            }
            indexedEvent = indexedEvent2;
        } else {
            indexedEvent = null;
        }
        return indexedEvent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<IndexedEvent> decodeLogEvents(@NotNull List<EventLog> logs) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        if (logs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapIndexedNotNull$iv = logs;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            IndexedEvent indexedEvent;
            void log;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            EventLog eventLog = (EventLog)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            TxEvent txEvent = new TxEvent(log.getAddress(), log.getTopics(), log.getData());
            if (!EventUtils.INSTANCE.isEventValid(txEvent, this.eventAbis, this.contractAddresses)) {
                indexedEvent = null;
            } else if (EventUtils.INSTANCE.findMatchingAbi(log.getTopics(), this.eventAbis) == null) {
                indexedEvent = null;
            } else {
                IndexedEvent indexedEvent2;
                AbiElement matchingAbi;
                try {
                    AbiEventParameters parameters = EventUtils.INSTANCE.decodeEvent(txEvent, matchingAbi);
                    indexedEvent2 = new IndexedEvent(EventUtils.INSTANCE.generateEventId(log.getMeta().getTxID(), log.getMeta().getClauseIndex(), i, txEvent), log.getMeta().getBlockID(), log.getMeta().getBlockNumber(), log.getMeta().getBlockTimestamp(), log.getMeta().getTxID(), log.getMeta().getTxOrigin(), null, null, null, new RawEvent(log.getData(), log.getTopics()), parameters, log.getAddress(), parameters.getEventType(), log.getMeta().getClauseIndex(), log.getTopics().get(0), 448, null);
                }
                catch (Exception exception) {
                    this.logger.warn("Failed to decode log event with ABI: " + matchingAbi.getName() + ", txId: " + log.getMeta().getTxID());
                    indexedEvent2 = null;
                }
                indexedEvent = indexedEvent2;
            }
            if (indexedEvent == null) continue;
            IndexedEvent it$iv$iv = indexedEvent;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<IndexedEvent> decodeLogTransfers(@NotNull List<TransferLog> logs) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        if (logs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapIndexedNotNull$iv = logs;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            IndexedEvent it$iv$iv;
            IndexedEvent indexedEvent;
            void log;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            TransferLog transferLog = (TransferLog)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            try {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"from", (Object)log.getSender()), TuplesKt.to((Object)"to", (Object)log.getRecipient()), TuplesKt.to((Object)"amount", (Object)DataUtils.INSTANCE.decodeQuantity(log.getAmount()))};
                AbiEventParameters parameters = new AbiEventParameters(MapsKt.mapOf((Pair[])pairArray), "VET_TRANSFER");
                indexedEvent = new IndexedEvent(EventUtils.INSTANCE.generateEventId(log.getMeta().getTxID(), log.getMeta().getClauseIndex(), i, parameters), log.getMeta().getBlockID(), log.getMeta().getBlockNumber(), log.getMeta().getBlockTimestamp(), log.getMeta().getTxID(), log.getMeta().getTxOrigin(), null, null, null, null, parameters, null, "VET_TRANSFER", log.getMeta().getClauseIndex(), null, 19392, null);
            }
            catch (Exception ex) {
                this.logger.warn("Failed to process VET transfer: " + log.getSender() + " -> " + log.getRecipient(), (Throwable)ex);
                indexedEvent = null;
            }
            if (indexedEvent == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<IndexedEvent> extractVetTransfers(@NotNull TxOutputs output, @NotNull Transaction tx, @NotNull Block block, int outputIndex) {
        void $this$mapIndexedNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Iterable $this$mapIndexedNotNull$iv = output.getTransfers();
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            IndexedEvent it$iv$iv;
            IndexedEvent indexedEvent;
            void transfer;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            TxTransfer txTransfer = (TxTransfer)element$iv$iv;
            int transferIndex = index$iv$iv;
            boolean bl2 = false;
            try {
                IndexedEvent indexedEvent2;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"from", (Object)transfer.getSender()), TuplesKt.to((Object)"to", (Object)transfer.getRecipient()), TuplesKt.to((Object)"amount", (Object)DataUtils.INSTANCE.decodeQuantity(transfer.getAmount()))};
                AbiEventParameters parameters = new AbiEventParameters(MapsKt.mapOf((Pair[])pairArray), "VET_TRANSFER");
                indexedEvent = indexedEvent2 = new IndexedEvent(EventUtils.INSTANCE.generateEventId(tx.getId(), outputIndex, transferIndex, transfer), block.getId(), block.getNumber(), block.getTimestamp(), tx.getId(), tx.getOrigin(), tx.getPaid(), tx.getGasUsed(), tx.getGasPayer(), null, parameters, null, "VET_TRANSFER", outputIndex, null, 18944, null);
            }
            catch (Exception ex) {
                this.logger.warn("Failed to process VET transfer: " + transfer.getSender() + " -> " + transfer.getRecipient(), (Throwable)ex);
                indexedEvent = null;
            }
            if (indexedEvent == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

