/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.utils;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/vechain/indexer/utils/DataUtils;", "", "<init>", "()V", "REGEX", "", "isValid", "", "hex", "addPrefix", "removePrefix", "decodeQuantity", "Ljava/math/BigInteger;", "hexStringToByteArray", "", "input", "indexer-core"})
public final class DataUtils {
    @NotNull
    public static final DataUtils INSTANCE = new DataUtils();
    @NotNull
    private static final String REGEX = "^(0x)?[0-9a-fA-F]+$";

    private DataUtils() {
    }

    private final boolean isValid(String hex) {
        CharSequence charSequence = hex;
        return new Regex(REGEX).matches(charSequence);
    }

    @NotNull
    public final String addPrefix(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        return StringsKt.startsWith$default((String)hex, (String)"0x", (boolean)false, (int)2, null) ? hex : "0x" + hex;
    }

    @NotNull
    public final String removePrefix(@NotNull String hex) {
        String string;
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        if (StringsKt.startsWith$default((String)hex, (String)"0x", (boolean)false, (int)2, null)) {
            String string2 = hex.substring(2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = hex;
        }
        return string;
    }

    @NotNull
    public final BigInteger decodeQuantity(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        String cleanHex = this.removePrefix(hex);
        if (!this.isValid(cleanHex)) {
            throw new IllegalArgumentException("Invalid hexadecimal input: " + hex);
        }
        return new BigInteger(cleanHex, 16);
    }

    @NotNull
    public final byte[] hexStringToByteArray(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String cleanInput = this.removePrefix(input);
        int len = cleanInput.length();
        if (len == 0) {
            return new byte[0];
        }
        byte[] data = null;
        int startIdx = 0;
        if (len % 2 != 0) {
            data = new byte[len / 2 + 1];
            data[0] = (byte)Character.digit(cleanInput.charAt(0), 16);
            startIdx = 1;
        } else {
            data = new byte[len / 2];
            startIdx = 0;
        }
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)startIdx, (int)len)), (int)2);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                data[(i + 1) / 2] = (byte)((Character.digit(cleanInput.charAt(i), 16) << 4) + Character.digit(cleanInput.charAt(i + 1), 16));
                if (i == n) break;
                i += n2;
            }
        }
        return data;
    }
}

