/*
 * Decompiled with CFR 0.152.
 */
package org.vechain.indexer.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vechain.indexer.Indexer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\t"}, d2={"Lorg/vechain/indexer/utils/IndexerOrderUtils;", "", "<init>", "()V", "topologicalOrder", "", "Lorg/vechain/indexer/Indexer;", "indexers", "VisitState", "indexer-core"})
@SourceDebugExtension(value={"SMAP\nIndexerOrderUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexerOrderUtils.kt\norg/vechain/indexer/utils/IndexerOrderUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1869#2,2:66\n*S KotlinDebug\n*F\n+ 1 IndexerOrderUtils.kt\norg/vechain/indexer/utils/IndexerOrderUtils\n*L\n54#1:66,2\n*E\n"})
public final class IndexerOrderUtils {
    @NotNull
    public static final IndexerOrderUtils INSTANCE = new IndexerOrderUtils();

    private IndexerOrderUtils() {
    }

    @NotNull
    public final List<List<Indexer>> topologicalOrder(@NotNull List<? extends Indexer> indexers) {
        Intrinsics.checkNotNullParameter(indexers, (String)"indexers");
        if (indexers.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Set indexerSet = CollectionsKt.toSet((Iterable)indexers);
        Map visitState = new LinkedHashMap();
        List ordered = new ArrayList();
        Iterable $this$forEach$iv = indexers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Indexer it = (Indexer)element$iv;
            boolean bl = false;
            IndexerOrderUtils.topologicalOrder$visit(visitState, indexerSet, ordered, it);
        }
        return CollectionsKt.listOf((Object)ordered);
    }

    private static final void topologicalOrder$visit(Map<Indexer, VisitState> visitState, Set<? extends Indexer> indexerSet, List<Indexer> ordered, Indexer indexer) {
        VisitState visitState2 = visitState.get(indexer);
        switch (visitState2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[visitState2.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                throw new IllegalStateException("Circular dependency detected involving indexer " + indexer.getName());
            }
            case -1: {
                visitState.put(indexer, VisitState.VISITING);
                Indexer dependency = indexer.getDependsOn();
                if (dependency != null) {
                    if (!indexerSet.contains(dependency)) {
                        boolean bl = false;
                        String string = "Dependency " + dependency.getName() + " for " + indexer.getName() + " is not part of the provided indexers";
                        throw new IllegalArgumentException(string.toString());
                    }
                    IndexerOrderUtils.topologicalOrder$visit(visitState, indexerSet, ordered, dependency);
                }
                visitState.put(indexer, VisitState.VISITED);
                ordered.add(indexer);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/vechain/indexer/utils/IndexerOrderUtils$VisitState;", "", "<init>", "(Ljava/lang/String;I)V", "VISITING", "VISITED", "indexer-core"})
    private static final class VisitState
    extends Enum<VisitState> {
        public static final /* enum */ VisitState VISITING = new VisitState();
        public static final /* enum */ VisitState VISITED = new VisitState();
        private static final /* synthetic */ VisitState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VisitState[] values() {
            return (VisitState[])$VALUES.clone();
        }

        public static VisitState valueOf(String value) {
            return Enum.valueOf(VisitState.class, value);
        }

        @NotNull
        public static EnumEntries<VisitState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = visitStateArray = new VisitState[]{VisitState.VISITING, VisitState.VISITED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VisitState.values().length];
            try {
                nArray[VisitState.VISITED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitState.VISITING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

